package cn.gtmap.onething.entity.bo.onematter.sjsl;

import cn.gtmap.onething.entity.bo.OnethingRequest;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSb;
import cn.gtmap.onething.entity.dto.onematter.sj.OmSjProject;
import cn.gtmap.onething.entity.dto.onematter.sj.OneMatterSjDTO;
import cn.gtmap.onething.entity.dto.onematter.sjsl.OneMatterSjSlDTO;
import cn.gtmap.onething.entity.dto.onematter.sl.OneMatterSlDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.HttpUtil;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月09日
 * @description 先调用单事项办件收件接口 再调用单事项办件受理接口
 */
@Data
public class DsxSjSl extends OnethingRequest<DsxSjSlResult> {
    public static final Logger log = Logger.getLogger(YjsSb.class);
    /**
     * 行政区划编码
     */
//    @NoEmpty(fieldExplain = "行政区划编码")
    private String areaNo;

    /**
     * 行政区划名称
     */
//    @NoEmpty(fieldExplain = "行政区划名称")
    private String areaName;

    //    @Valid
//    @NoEmpty(fieldExplain = "projectlist")
    private List<DsxSjSlProject> projectlist;

    @Override
    public DsxSjSlResult execute() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        String sjurl = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushProjectInfo";
        //初始化DTO
        OneMatterSjSlDTO oneMatterSjSlDTO = new OneMatterSjSlDTO(this);
        //先调用收件
        OneMatterSjDTO sjDTO = oneMatterSjSlDTO.getSjDTO();
        String sjResult = HttpUtil.sendPost(sjurl, this.getHeaders(), "单事项办件收件接口", JSON.toJSONString(sjDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO sjResultDTO = JSON.parseObject(sjResult, OnethingResultDTO.class);

        //再调用受理
        OneMatterSlDTO slDTO = oneMatterSjSlDTO.getSlDTO();
        String slurl = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushAcceptProjectInfo";
        String slResult = HttpUtil.sendPost(slurl, this.getHeaders(), "单事项办件受理接口", JSON.toJSONString(slDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO slResultDTO = JSON.parseObject(slResult, OnethingResultDTO.class);
        //入参中获取
        DsxSjSlResult dsxSjSlResult = new DsxSjSlResult();
        List<DsxSjSlProjectResult> resultList = new ArrayList<>();
        List<OmSjProject> projectlist = sjDTO.getData().getParams().getProjectlist();
        if (CollectionUtils.isNotEmpty(projectlist)) {
            for (OmSjProject omSjProject : projectlist) {
                DsxSjSlProjectResult dsxSjSlProjectResult = new DsxSjSlProjectResult(omSjProject);
                resultList.add(dsxSjSlProjectResult);
            }
        }
        dsxSjSlResult.setProjectList(resultList);
        dsxSjSlResult.setCode(sjResultDTO.getHead().getCode());
        dsxSjSlResult.setMsg(sjResultDTO.getHead().getMsg());
        dsxSjSlResult.setSlCode(slResultDTO.getHead().getCode());
        dsxSjSlResult.setSlMsg(slResultDTO.getHead().getMsg());
        dsxSjSlResult.setOnethingRequestParam(oneMatterSjSlDTO);
        List<OnethingResultDTO> onethingRequestParamList = new ArrayList<>();
        onethingRequestParamList.add(sjResultDTO);
        onethingRequestParamList.add(slResultDTO);
        dsxSjSlResult.setOnethingResultDTOList(onethingRequestParamList);
        log.info("单事项办件收件、受理接口-最终结果:" + JSON.toJSONString(dsxSjSlResult));
        return dsxSjSlResult;
    }

    public DsxSjSlResult executeSj() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        String sjurl = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushProjectInfo";
        //初始化DTO
        OneMatterSjSlDTO oneMatterSjSlDTO = new OneMatterSjSlDTO(this, "sj");
        //先调用收件
        OneMatterSjDTO sjDTO = oneMatterSjSlDTO.getSjDTO();
        String sjResult = HttpUtil.sendPost(sjurl, this.getHeaders(), "单事项办件收件接口", JSON.toJSONString(sjDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO sjResultDTO = JSON.parseObject(sjResult, OnethingResultDTO.class);

        //入参中获取
        DsxSjSlResult dsxSjSlResult = new DsxSjSlResult();
        List<DsxSjSlProjectResult> resultList = new ArrayList<>();
        List<OmSjProject> projectlist = sjDTO.getData().getParams().getProjectlist();
        if (CollectionUtils.isNotEmpty(projectlist)) {
            for (OmSjProject omSjProject : projectlist) {
                DsxSjSlProjectResult dsxSjSlProjectResult = new DsxSjSlProjectResult(omSjProject);
                resultList.add(dsxSjSlProjectResult);
            }
        }
        dsxSjSlResult.setProjectList(resultList);
        dsxSjSlResult.setCode(sjResultDTO.getHead().getCode());
        dsxSjSlResult.setMsg(sjResultDTO.getHead().getMsg());
        dsxSjSlResult.setOnethingRequestParam(oneMatterSjSlDTO);
        List<OnethingResultDTO> onethingRequestParamList = new ArrayList<>();
        onethingRequestParamList.add(sjResultDTO);
        dsxSjSlResult.setOnethingResultDTOList(onethingRequestParamList);
        log.info("单事项办件收件接口-最终结果:" + JSON.toJSONString(dsxSjSlResult));
        return dsxSjSlResult;
    }

    public DsxSjSlResult executeSl() {
        //验证必填字段
//        NoEmptyExecutor.validate(this).execute();
        String sjurl = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushProjectInfo";
        //初始化DTO
        OneMatterSjSlDTO oneMatterSjSlDTO = new OneMatterSjSlDTO(this, "sl");
        //再调用受理
        OneMatterSlDTO slDTO = oneMatterSjSlDTO.getSlDTO();
        String slurl = this.getOnethingConfig().getServiceAddress() + "/api/v1/pushAcceptProjectInfo";
        String slResult = HttpUtil.sendPost(slurl, this.getHeaders(), "单事项办件受理接口", JSON.toJSONString(slDTO), this.getConnectionTimeout(), this.getReadTimeout());
        OnethingResultDTO slResultDTO = JSON.parseObject(slResult, OnethingResultDTO.class);
        //入参中获取
        DsxSjSlResult dsxSjSlResult = new DsxSjSlResult();
        List<DsxSjSlProjectResult> resultList = new ArrayList<>();
        dsxSjSlResult.setProjectList(resultList);
        dsxSjSlResult.setSlCode(slResultDTO.getHead().getCode());
        dsxSjSlResult.setSlMsg(slResultDTO.getHead().getMsg());
        dsxSjSlResult.setOnethingRequestParam(oneMatterSjSlDTO);
        List<OnethingResultDTO> onethingRequestParamList = new ArrayList<>();
        onethingRequestParamList.add(slResultDTO);
        dsxSjSlResult.setOnethingResultDTOList(onethingRequestParamList);
        log.info("单事项办件受理接口-最终结果:" + JSON.toJSONString(dsxSjSlResult));
        return dsxSjSlResult;
    }
}
