package cn.gtmap.onething.demo;

import cn.gtmap.onething.entity.bo.onematter.bj.DsxBj;
import cn.gtmap.onething.entity.bo.onematter.bj.DsxBjResult;
import cn.gtmap.onething.entity.bo.onematter.bj.DsxBjResultInfoResult;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSl;
import cn.gtmap.onething.entity.bo.onematter.sjsl.DsxSjSlResult;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSp;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpProcessResult;
import cn.gtmap.onething.entity.bo.onematter.sp.DsxSpResult;
import cn.gtmap.onething.entity.bo.oneting.bj.YjsBj;
import cn.gtmap.onething.entity.bo.oneting.bj.YjsBjResult;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSb;
import cn.gtmap.onething.entity.bo.oneting.sb.YjsSbResult;
import cn.gtmap.onething.entity.bo.oneting.sl.YjsSl;
import cn.gtmap.onething.entity.bo.oneting.sl.YjsSlResult;
import cn.gtmap.onething.entity.bo.oneting.ys.YjsYs;
import cn.gtmap.onething.entity.bo.oneting.ys.YjsYsResult;
import cn.gtmap.onething.entity.dto.onematter.sjsl.OneMatterSjSlDTO;
import cn.gtmap.onething.entity.dto.onething.sb.OnethingSbDTO;
import cn.gtmap.onething.entity.dto.result.OnethingResultDTO;
import cn.gtmap.onething.util.PropertiesLoadUtil;
import com.gtis.config.AppConfig;

import java.util.List;

/**
 * @author jiangganzhi <jiangganzhi@gtmap.cn>
 * @date 2023年08月08日
 * @description
 */
public class OnethingDemo {
    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  加载一件事配置文件
    */
    public void loadProperties() {
        //通过路径配置文件父路径加载配置文件 当父路径下无onething配置文件时从类加载器上下文中获取配置项
        PropertiesLoadUtil.loadProperties("D:\\");
    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  一件事办件申报接口
     */
    public void yjsSb() {
        YjsSb yjsSb = new YjsSb();
        //超时设置根据具体情况设置
//        yjsSb.setConnectionTimeout(null);
//        yjsSb.setReadTimeout(null);
        //组织入参
        //调用接口
        YjsSbResult execute = yjsSb.execute();
        //获取调用入参
        OnethingSbDTO onethingRequestParam = execute.getOnethingRequestParam();
        //获取调用出参
        OnethingResultDTO onethingResultDTO = execute.getOnethingResultDTO();
        //获取结果
        String code = execute.getCode();
        String msg = execute.getMsg();
        //获取其他关键参数
        String applyInfoNo = execute.getApplyInfoNo();
        String jointCode = execute.getJointCode();

    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  一件事办件预审接口
     */
    public void yjsYs() {
        YjsYs yjsYs = new YjsYs();
        //组织入参
        //调用接口
        YjsYsResult execute1 = yjsYs.execute();
    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  一件事办件受理接口
     */
    public void yjsSl() {
        YjsSl yjsSl = new YjsSl();
        //组织入参
        //调用接口
        YjsSlResult execute2 = yjsSl.execute();

    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  一件事办件办结接口
     */
    public void yjsBj() {
        YjsBj yjsBj = new YjsBj();
        //组织入参
        //调用接口
        YjsBjResult execute3 = yjsBj.execute();
    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  先单事项办件收件接口再调用单事项办件受理接口
     */
    public void dsxSjSl() {
        DsxSjSl dsxSjSl = new DsxSjSl();
        //组织入参
        //调用接口
        DsxSjSlResult execute4 = dsxSjSl.execute();
        //获取调用入参
        OneMatterSjSlDTO onethingRequestParam1 = execute4.getOnethingRequestParam();
        //获取调用出参
        OnethingResultDTO onethingResultDTO1 = execute4.getOnethingResultDTO();
        //获取结果
        execute4.getMsg();
        execute4.getCode();
        execute4.getSlCode();
        execute4.getSlMsg();
        //获取其他关键参数
        execute4.getProjectList();
    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  单事项审批接口
     */
    public void dsxSp() {
        DsxSp dsxSp = new DsxSp();
        //组织入参
        //调用接口
        DsxSpResult execute = dsxSp.execute();
        //获取其他关键参数
        List<DsxSpProcessResult> processlist = execute.getProcesslist();
    }

    /**
     *@author jiangganzhi <jiangganzhi@gtmap.cn>
     *@date 2023/8/9
     *@descreption  单事项办件办结接口
     */
    public void dsxBj() {
        DsxBj dsxBj = new DsxBj();
        //组织入参
        //调用接口
        DsxBjResult execute = dsxBj.execute();
        //获取其他关键参数
        List<DsxBjResultInfoResult> resultinfo = execute.getResultinfo();
    }

}
