/*
 * Project:  onemap
 * Module:   onemap-server
 * File:     UserServiceImpl.java
 * Modifier: xyang
 * Modified: 2013-12-27 06:24:15
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.onemap.server.thirdparty.egov;

import cn.gtmap.onemap.model.Role;
import cn.gtmap.onemap.model.User;
import cn.gtmap.onemap.security.Constants;
import cn.gtmap.onemap.service.UserService;
import org.springframework.dao.DataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

import javax.sql.DataSource;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 13-11-19
 */
public class UserServiceImpl implements UserService {
    private JdbcTemplate jdbc;

    public void setDataSource(DataSource dataSource) {
        this.jdbc = new JdbcTemplate(dataSource);
    }

    @Override
    public User getUser(String userId) {
        if (Constants.USER_ADMIN_ID.equals(userId)) {
            return newAdmin();
        }
        try {
            return jdbc.queryForObject("select * from pf_user where user_id=?", RowMappers.USER, userId);
        } catch (DataAccessException e) {
            return null;
        }
    }

    @Override
    public User getUserByName(String userName) {
        try {
            return jdbc.queryForObject("select * from pf_user where login_name=?", RowMappers.USER, userName);
        } catch (DataAccessException e) {
            return null;
        }
    }

    @Override
    public Map<String, User> getUsers(Collection<String> userIds) {
        return Collections.emptyMap();
    }

    @Override
    public Page<User> findUsers(String keyword, Pageable request) {
        List<User> users = jdbc.query("select * from pf_user order by user_id desc", RowMappers.USER);
        final Map<String, User> userMap = new HashMap<String, User>(users.size());
        for (User user : users) {
            user.setRoles(new HashSet<Role>());
            userMap.put(user.getId(), user);
        }
        jdbc.query("select t1.*,t2.user_id from pf_role t1 inner join pf_user_role_rel t2 on t1.role_id = t2.role_id", new RowCallbackHandler() {
            @Override
            public void processRow(ResultSet rs) throws SQLException {
                String userId = rs.getString("USER_ID");
                Role role = RowMappers.ROLE.mapRow(rs, 0);
                User user = userMap.get(userId);
                if (user != null) {
                    user.getRoles().add(role);
                }
            }
        });
        return new PageImpl<User>(users);
    }

    @Override
    public User saveUser(User user) {
        return user;
    }

    @Override
    public void removeUser(String userId) {
    }

    @Override
    public Set<Role> getUserRoles(String userId) {
        return new HashSet<Role>(jdbc.query("select t1.* from pf_role t1 inner join pf_user_role_rel t2 on t1.role_id = t2.role_id where t2.user_id=?", RowMappers.ROLE, userId));
    }

    private User newAdmin() {
        User admin = new User();
        admin.setId(Constants.USER_ADMIN_ID);
        admin.setName(Constants.ADMIN);
        admin.setViewName("系统管理员");
        return admin;
    }
}
