/*
 * Project:  onemap
 * Module:   server
 * File:     PrivilegeAclDAO.java
 * Modifier: xyang
 * Modified: 2013-06-03 05:24:55
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.onemap.server.dao;

import cn.gtmap.onemap.model.PrivilegeAcl;
import cn.gtmap.onemap.model.PrivilegeAclKey;
import org.springframework.data.jpa.repository.JpaRepository;

import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-6-3
 */
public interface PrivilegeAclDAO extends JpaRepository<PrivilegeAcl, PrivilegeAclKey> {
    List<PrivilegeAcl> findByRoleId(String roleId);

    List<PrivilegeAcl> findByRoleIdAndPrivilegeId(String roleId, String privilegeId);
}
