/*
 * Project:  onemap
 * Module:   server
 * File:     LODInfo.java
 * Modifier: xyang
 * Modified: 2013-05-09 08:49:27
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.onemap.server.arcgis.tile;

/**
 * Represents a {@code LODInfo} (Level Of Detail Info) element in an ArcGIS tile cache config file.
 * <p>
 * XML representation:
 * <p/>
 * <pre>
 * <code>
 *       &lt;LODInfo xsi:type='typens:LODInfo'&gt;
 *         &lt;LevelID&gt;1&lt;/LevelID&gt;
 *         &lt;Scale&gt;6000000&lt;/Scale&gt;
 *         &lt;Resolution&gt;1587.5031750063501&lt;/Resolution&gt;
 *       &lt;/LODInfo&gt;
 * </code>
 * </pre>
 * <p/>
 * </p>
 *
 * @author Gabriel Roldan
 */
public class LODInfo {

    private int levelID;

    private double scale;

    private double resolution;

    public int getLevelID() {
        return levelID;
    }

    public double getScale() {
        return scale;
    }

    public double getResolution() {
        return resolution;
    }
}
