/*
 * Project:  onemap
 * Module:   server
 * File:     Constants.java
 * Modifier: xyang
 * Modified: 2013-05-28 02:51:16
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */

package cn.gtmap.onemap.server;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 13-4-9
 */
public class Constants {
    private Constants() {
    }

    public static final String CURRENT_VERSION = "1.0.0";

    public static final String MAP_SERVER = "MapServer";
    public static final String GEOMETRY_SERVER = "GeometryServer";
    public static final String ARCGISREST = "arcgisrest";
    public static final String TILE_INFO = "tileInfo";

    public static final String PROVIDER_ARCGIS_PROXY = "arcgisProxy";
    public static final String PROVIDER_LOCAL_TILE = "localTile";
    public static final String PROVIDER_INDEX = "index";
    public static final String PROVIDER_DATASOURCE = "datasource";

    public static final String DATASOURCE_ORACLE = "oracle";
    public static final String PROVIDER_ARCSDE = "arcsde";
    public static final String PROVIDER_SHARP = "sharp";

    public static final String LOCAL_TILE_PATH = "path";
    public static final String LOCAL_TILE_BOUND = "bound";
    public static final String ARCGIS_PROXY_URL = "url";
    public static final String INDEX_ID = "id";

    public static final char INDEX_SEPARATOR_CHAR = '_';
    public static final String INDEX_SEPARATOR = String.valueOf(INDEX_SEPARATOR_CHAR);
    public static final int PAGE_SIZE = 20;
}
