/*
 COPYRIGHT 2009 ESRI

 TRADE SECRETS: ESRI PROPRIETARY AND CONFIDENTIAL
 Unpublished material - all rights reserved under the
 Copyright Laws of the United States and applicable international
 laws, treaties, and conventions.

 For additional information, contact:
 Environmental Systems Research Institute, Inc.
 Attn: Contracts and Legal Services Department
 380 New York Street
 Redlands, California, 92373
 USA

 email: contracts@esri.com
 */
//>>built
define("esri/_coremap",["require","dojo/_base/kernel","dojo/_base/declare","dojo/_base/connect","dojo/_base/Deferred","dojo/_base/lang","dojo/_base/array","dojo/_base/event","dojo/_base/unload","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/sniff","dijit/registry","dojox/gfx/matrix","esri/kernel","esri/config","esri/lang","esri/Evented","esri/fx","esri/deferredUtils","esri/tileUtils","esri/geometry/Point","esri/geometry/ScreenPoint","esri/geometry/Extent","esri/geometry/Rect","esri/geometry/mathUtils","esri/geometry/scaleUtils","esri/geometry/screenUtils","esri/geometry/webMercatorUtils","esri/layers/GraphicsLayer","esri/layers/TileInfo","esri/layers/LOD","esri/layers/ArcGISTiledMapServiceLayer","esri/layers/OpenStreetMapLayer","esri/dijit/Popup","dojo/uacss"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,has,_10,_11,_12,_13,_14,_15,_16,_17,_18,_19,_1a,_1b,_1c,_1d,_1e,_1f,_20,_21,_22,LOD,_23,_24,_25){var _26=_1f.toMapPoint,_27=_1f.toScreenPoint,dc=_4.connect,ddc=_4.disconnect,dh=_6.hitch,ds=_f.set,iOf=_7.indexOf,_28=_6.mixin,uid=0,_29=_13.defaults.map,_2a=1000000,_2b=0.75,_2c=0.25,_2d=3,_2e=20,_2f=40;function _30(_31,_32){var _33=_31.lods;_33.sort(function(l1,l2){if(l1.scale>l2.scale){return -1;}else{if(l1.scale<l2.scale){return 1;}}return 0;});var _34=[];_33=_7.filter(_33,function(l){if(iOf(_34,l.scale)===-1){_34.push(l.scale);return true;}});var pl=(_32.lods=[]),l;_7.forEach(_33,function(lod,_35){l=(pl[_35]=new LOD(lod));l.level=_35;});_32.tileInfo=new _22(_28(_31,{lods:pl}));};var _36=_3([_15],{declaredClass:"esri._CoreMap",resizeDelay:300,invalidExtent:"Map does not have a valid extent.",invalidGeometry:"Geometry (wkid: ${geometry}) cannot be converted to spatial reference of the map (wkid: ${map})",unknownBasemap:"Unable to find basemap definition for: \"${basemapName}\". Try one of these: ${list}",invalidBasemap:"Unable to add basemap: \"${basemapName}\".",unknownLayerType:"Unknown basemap layer type: \"${type}\" found in basemap definition for: \"${basemapName}\".",constructor:function(_37,_38){this.registerConnectEvents({"basemap-change":["BasemapChange"],"extent-change":["ExtentChange","extent","delta","levelChange","lod"],"layer-add":["LayerAdd","layer"],"layer-add-result":["LayerAddResult","layer","error"],"layer-remove":["LayerRemove","layer"],"layer-reorder":["LayerReorder","layer","index"],"layer-resume":["LayerResume","layer"],"layer-suspend":["LayerSuspend","layer"],"layers-add-result":["LayersAddResult","layers"],"layers-removed":["LayersRemoved"],"layers-reordered":["LayersReordered","layerIds"],"load":["Load","map"],"pan":["Pan","extent","delta"],"pan-end":["PanEnd","extent","delta"],"pan-start":["PanStart","extent","screenPoint"],"reposition":["Reposition","x","y"],"resize":["Resize","extent","width","height"],"scale":["Scale","matrix","immediate"],"time-extent-change":["TimeExtentChange","timeExtent"],"unload":["Unload","map"],"update-end":["UpdateEnd","error"],"update-start":["UpdateStart"],"zoom":["Zoom","extent","zoomFactor","anchor"],"zoom-end":["ZoomEnd","extent","zoomFactor","anchor","level"],"zoom-start":["ZoomStart","extent","zoomFactor","anchor","level"]});_28(this,{_internalLayerIds:[],_layers:[],_layerDivs:[],_layerSize:0,_clickHandles:[],_connects:[]});_28(this,{_zoomAnimDiv:null,_zoomAnim:null,_layersDiv:null,_firstLayerId:null,_delta:null,_cursor:null,_ratioW:1,_ratioH:1,_params:null});_28(this,{cursor:null,layerIds:[],graphicsLayerIds:[],graphics:null,loaded:false});_28(this,{__panning:false,__zooming:false,__container:null,root:null,__LOD:null,__tileInfo:null,__visibleRect:null,__visibleDelta:null});this._rids=[];var _39=(this.container=_a.byId(_37));var id=(this.id=_b.get(_39,"id")||_10.getUniqueId(this.declaredClass));_c.add(_39,"map");var box=_e.getContentBox(_39),dac=_c.add,dcr=_d.create;this.position=new _1a(0,0);this._reposition();var _3a=(this.width=(box.w||_29.width));var _3b=(this.height=box.h||_29.height);if(box.w===0){ds(_39,"width",_3a+"px");}if(box.h===0){ds(_39,"height",_3b+"px");}var _3c=(this.root=dcr("div",{id:id+"_root",style:{width:_3a+"px",height:_3b+"px",direction:"ltr"}}));dac(_3c,"container");var _3d=(this.__container=dcr("div",{id:id+"_container"},_3c));ds(_3d,"position","absolute");dac(_3d,"container");_39.appendChild(_3c);var _3e=(this._params=_28({slider:true,nav:false,zoom:-1,minZoom:-1,maxZoom:-1,scale:-1,minScale:0,maxScale:0,showInfoWindowOnClick:true,displayGraphicsOnPan:true,wrapAround180:true,fitExtent:false},_38||{}));this.wrapAround180=_3e.wrapAround180;if(_14.isDefined(_3e.resizeDelay)){this.resizeDelay=_3e.resizeDelay;}if(_3e.lods){_30({rows:512,cols:512,dpi:96,format:"JPEG",compressionQuality:75,origin:{x:-180,y:90},spatialReference:{wkid:4326},lods:_3e.lods},_3e);this.__tileInfo=_3e.tileInfo;}var ext=(this.extent=_3e.extent);this._extentUtil({mapCenter:_3e.center,targetLevel:_3e.zoom,targetScale:_3e.scale});this.__visibleRect=new _1c(0,0,_3a,_3b);this.__visibleDelta=new _1c(0,0,_3a,_3b);var _3f=(this._layersDiv=dcr("div",{id:id+"_layers"}));dac(_3f,"layersDiv");_3d.appendChild(_3f);this._zoomAnimDiv=dcr("div",{style:{position:"absolute"}});if(_3e.infoWindow){this.infoWindow=_3e.infoWindow;}else{var iw=(this.infoWindow=new _25(_3e.popupOptions,dcr("div")));iw.startup();iw._ootb=true;ds(iw.domNode,"zIndex",_2f);}this._zoomStartHandler=dh(this,this._zoomStartHandler);this._zoomingHandler=dh(this,this._zoomingHandler);this._zoomEndHandler=dh(this,this._zoomEndHandler);this._panningHandler=dh(this,this._panningHandler);this._panEndHandler=dh(this,this._panEndHandler);this._endTranslate=dh(this,this._endTranslate);_9.addOnWindowUnload(this,this.destroy);},_cleanUp:function(){var iw=this.infoWindow;if(iw){if(iw._ootb&&iw.destroy){iw.destroy();}else{iw.unsetMap(this);}delete this.infoWindow;}var _40=this._connects,i;for(i=_40.length-1;i>=0;i--){ddc(_40[i]);delete _40[i];}ddc(this._tsTimeExtentChange_connect);this.setInfoWindowOnClick(false);_d.destroy(this.root);this.root=null;},_addLayer:function(_41,_42,_43){var id=(_41.id=_41.id||(_41 instanceof _21?_29.graphicsLayerNamePrefix:_29.layerNamePrefix)+(uid++));this._layers[id]=_41;var i,lyr;if(_42===this.layerIds||_42===this.graphicsLayerIds){i=this._layerSize;this._layerSize++;}_41._isRefLayer=(_43==="top");_43=(!_14.isDefined(_43)||_43<0||_43>_42.length||_43==="top")?_42.length:_43;if(i===0){this._firstLayerId=id;}if(!_41._isRefLayer){while((lyr=this.getLayer(_42[_43-1]))&&lyr._isRefLayer){_43--;}}_42.splice(_43,0,id);var _44=dh(this,this._addLayerHandler),_45=this,_46=this._connects,_47=function(){if(_41.loaded){if(_45._onLoadFix){_45._onLoadFix=false;setTimeout(function(){_44(_41);},0);}else{_44(_41);}}else{_45[id+"_addtoken_load"]=dc(_41,"onLoad",_45,"_addLayerHandler");_45[id+"_addtoken_err"]=dc(_41,"onError",_45,function(_48){_44(_41,_48,_42);});}};if(this.loaded||i===0||(_41.loaded&&iOf(this.graphicsLayerIds,id)===-1)){_47();}else{_46.push(dc(this,"onLoad",_47));}return _41;},_addLayerHandler:function(_49,_4a,_4b){var id=this.id,_4c=_49.id,_4d=iOf(_49 instanceof _21?this.graphicsLayerIds:this.layerIds,_4c),_4e=_4d,_4f=false,_50=this._params,_51,_52,_53,_54;ddc(this[_4c+"_addtoken_load"]);ddc(this[_4c+"_addtoken_err"]);if(_4a){delete this._layers[_4c];if(_4d!==-1){_4b.splice(_4d,1);this.onLayerAddResult(_49,_4a);}return;}if(_4d===-1){_4d=iOf(this._internalLayerIds,_4c);_4e=_2e+_4d;_4f=true;}if(_4c===this._firstLayerId){_52=_49.spatialReference;_53=(this.extent&&this.extent.spatialReference);if(_53&&!_53.equals(_52)&&(_49.tileInfo||!_49.url)){_53=null;}_51=(this.spatialReference=(_53||_52));this.wrapAround180=(this.wrapAround180&&_51&&_51._isWrappable())?true:false;if(_49.tileInfo){if(!this.__tileInfo){_30(_28({},_49.tileInfo),_50);this.__tileInfo=_50.tileInfo;}else{_54=this.__tileInfo.lods;this.__tileInfo=_28({},_49.tileInfo);this.__tileInfo.lods=_54;}}if(this.wrapAround180){var _55=this.__tileInfo,_56=_51._getInfo();if(!_55||Math.abs(_56.origin[0]-_55.origin.x)>_56.dx){this.wrapAround180=false;}if(this.wrapAround180&&_55){_18._addFrameInfo(_55,_56);}}_50.units=_49.units;_54=this.__tileInfo&&this.__tileInfo.lods;if(_54&&_54.length){var _57=_50.minScale,_58=_50.maxScale,_59=-1,_5a=-1,_5b=false,_5c=false,i;for(i=0;i<_54.length;i++){if(_57>0&&!_5b&&_57>=_54[i].scale){_59=_54[i].level;_5b=true;}if(_58>0&&!_5c&&_58>=_54[i].scale){_5a=(i>0)?_54[i-1].level:-1;_5c=true;}}if(_50.minZoom===-1){_50.minZoom=(_57===0)?_54[0].level:_59;}if(_50.maxZoom===-1){_50.maxZoom=(_58===0)?_54[_54.length-1].level:_5a;}for(i=0;i<_54.length;i++){if(_50.minZoom===_54[i].level){_50.minScale=_54[i].scale;}if(_50.maxZoom===_54[i].level){_50.maxScale=_54[i].scale;}}}else{_50.minZoom=_50.maxZoom=_50.zoom=-1;}}if(_49 instanceof _21){if(!this._gc){this._gc=new _21._GraphicsContainer();var gc=this._gc._setMap(this,this._layersDiv);gc.id=id+"_gc";}var _5d=_49._setMap(this,this._gc._surface);_5d.id=id+"_"+_4c;this._layerDivs[_4c]=_5d;this._reorderLayers(this.graphicsLayerIds);if(_50.showInfoWindowOnClick){this._clickHandles.push(dc(_49,"onClick",this,"_gClickHandler"));}}else{var _5e=_49._setMap(this,this._layersDiv,_4e,this.__LOD);_5e.id=id+"_"+_4c;this._layerDivs[_4c]=_5e;this._reorderLayers(this.layerIds);if(!_4f&&_49.declaredClass.indexOf("VETiledLayer")!==-1){this._onBingLayerAdd(_49);}}if(_4c===this._firstLayerId){this.graphics=new _21({id:id+"_graphics",displayOnPan:_50.displayGraphicsOnPan});this._addLayer(this.graphics,this._internalLayerIds,_2e);}if(_49===this.graphics){var _5f,_60=this._layers[this._firstLayerId],_61,_62=_50.zoom,_63=_50.scale,_64=_50.center,_65=_60.initialExtent||_60.fullExtent;this._firstLayerId=null;if(this.extent){this.extent=this._convertGeometry(this,this.extent);}if(!this.extent&&_65){if(_64){_64=this._convertGeometry(_65,_64);}if(_64){_65=_65.centerAt(_64);_64=null;}}_61=this.extent||_65;if(_61){if(_62>-1){_61=this.__getExtentForLevel(_62,null,_61).extent;}else{if(_63>0){_61=_1e.getExtentForScale(this,_63,_61);}}}if(!_61){console.log("Map: "+this.invalidExtent);return;}_5f=this._fixExtent(_61,_50.fitExtent);this.extent=_5f.extent;this.__LOD=_5f.lod;this.__setExtent(this.extent,null,null,_50.fitExtent);this.loaded=true;this.infoWindow.setMap(this);this.onLoad(this);}if(!_4f){this.onLayerAdd(_49);this.onLayerAddResult(_49);}ddc(this[_4c+"_addLayerHandler_connect"]);},_convertGeometry:function(_66,_67){var _68=_66&&_66.spatialReference,_69=_67&&_67.spatialReference;if(_68&&_69&&!_68.equals(_69)){if(_68._canProject(_69)){if(_68.isWebMercator()){_67=_20.geographicToWebMercator(_67);}else{if(_68.wkid===4326){_67=_20.webMercatorToGeographic(_67,true);}}}else{console.log("Map: "+_14.substitute({geometry:_69.wkid||_69.wkt,map:_68.wkid||_68.wkt},this.invalidGeometry));_67=null;}}return _67;},_reorderLayers:function(_6a){var _6b=this.onLayerReorder,djp=_d.place,_6c=this._layerDivs,_6d=this._layers,_6e=this._gc?this._gc._surface.getEventSource():null;if(_6a===this.graphicsLayerIds){_7.forEach(_6a,function(id,i){var _6f=_6c[id];if(_6f){djp(_6f.getEventSource(),_6e,i);_6b(_6d[id],i);}});}else{var g=this.graphics,gId=g?g.id:null,_70=this._layersDiv,_71;_7.forEach(_6a,function(id,i){_71=_6c[id];if(id!==gId&&_71){djp(_71,_70,i);_6b(_6d[id],i);}});if(_6e){_6e=(has("ie")<9)?_6e.parentNode:_6e;djp(_6e,_6e.parentNode,_6a.length);}}this.onLayersReordered([].concat(_6a));},_zoomStartHandler:function(){this.__zoomStart(this._zoomAnimDiv.startingExtent,this._zoomAnimDiv.anchor);},_zoomingHandler:function(_72){var rl=parseFloat(_72.left),rt=parseFloat(_72.top),_73=new _1b(rl,rt-parseFloat(_72.height),rl+parseFloat(_72.width),rt,this.spatialReference),_74=this.extent.getWidth()/_73.getWidth();this.__zoom(_73,_74,this._zoomAnimDiv.anchor);},_zoomEndHandler:function(){var _75=this._zoomAnimDiv,_76=_75.extent,_77=this.extent.getWidth()/_76.getWidth();var _78=_75.anchor,_79=_75.newLod,_7a=_75.levelChange;_75.extent=_75.anchor=_75.levelChange=_75.startingExtent=_75.newLod=this._delta=this._zoomAnim=null;this.__zoomEnd(_76,_77,_78,_79,_7a);},_panningHandler:function(_7b){if(isNaN(parseFloat(_7b.left))||isNaN(parseFloat(_7b.top))){var _7c=Math.round,_7d=this._panAnim.node;_7b.left=(-1*(this._delta.x-_7c(this.width/2)))+"px";_7b.top=(-1*(this._delta.y-_7c(this.height/2)))+"px";_f.set(_7d,"left",_7b.left);_f.set(_7d,"top",_7b.top);}var d=new _1a(parseFloat(_7b.left),parseFloat(_7b.top)),dm=this.toMap(d);this.onPan(this.extent.offset(dm.x,dm.y),d);},_panEndHandler:function(_7e){this.__panning=false;var _7f=Math.round,_80=new _1a(-_7f(parseFloat(_7e.style.left)),-_7f(parseFloat(_7e.style.top))),dx=_80.x,dy=_80.y,_81=this.__visibleRect,_82=this.__visibleDelta;_81.x+=-dx;_81.y+=-dy;_82.x+=-dx;_82.y+=-dy;ds(this._zoomAnimDiv,{left:"0px",top:"0px"});var _83=this.extent,rw=this._ratioW,rh=this._ratioH;_83=new _1b(_83.xmin+(dx/rw),_83.ymin-(dy/rh),_83.xmax+(dx/rw),_83.ymax-(dy/rh),this.spatialReference);_80.setX(-_80.x);_80.setY(-_80.y);this._delta=this._panAnim=null;this._updateExtent(_83);this.onPanEnd(_83,_80);this._fireExtChg([_83,_80,false,this.__LOD]);},_fixExtent:function(_84,fit){var _85=this._reshapeExtent(_84),_86=1+_2c;while(fit===true&&(_85.extent.getWidth()<_84.getWidth()||_85.extent.getHeight()<_84.getHeight())&&_85.lod.level>0&&_86<=_2d){_85=this._reshapeExtent(_84.expand(_86));_86+=_2c;}return _85;},_getFrameWidth:function(){var _87=-1,_88=this.spatialReference._getInfo();if(this.__LOD){var _89=this.__LOD._frameInfo;if(_89){_87=_89[3];}}else{if(_88){_87=Math.round((2*_88.valid[1])/(this.extent.getWidth()/this.width));}}return _87;},_reshapeExtent:function(_8a){var w=_8a.getWidth(),h=_8a.getHeight(),r=w/h,_8b=this.width/this.height,dw=0,dh=0;if(this.width>this.height){if(w>h){if(_8b>r){dw=(h*_8b)-w;}else{dh=(w/_8b)-h;}}else{if(w<h){dw=(h*_8b)-w;}else{dw=(h*_8b)-w;}}}else{if(this.width<this.height){if(w>h){dh=(w/_8b)-h;}else{if(w<h){if(_8b>r){dw=(h*_8b)-w;}else{dh=(w/_8b)-h;}}else{dh=(w/_8b)-h;}}}else{if(w<h){dw=h-w;}else{if(w>h){dh=(w/_8b)-h;}}}}if(dw){_8a.xmin-=dw/2;_8a.xmax+=dw/2;}if(dh){_8a.ymin-=dh/2;_8a.ymax+=dh/2;}return this._getAdjustedExtent(_8a);},_getAdjustedExtent:function(_8c){if(this.__tileInfo){return _18.getCandidateTileInfo(this,this.__tileInfo,_8c);}else{var _8d=_1e.getScale(this,_8c),_8e=this.getMinScale(),_8f=this.getMaxScale(),_90=!_8e||(_8d<=_8e),_91=!_8f||(_8d>=_8f);if(!_90){_8c=_1e.getExtentForScale(this,_8e,_8c);}else{if(!_91){_8c=_1e.getExtentForScale(this,_8f,_8c);}}return {extent:_8c};}},_gClickHandler:function(evt){var _92=evt.graphic,iw=this.infoWindow;if(_92._getEffInfoTemplate()&&iw){_8.stop(evt);var _93=_92.geometry,_94=(_93&&_93.type==="point")?_93:evt.mapPoint;iw.setTitle(_92.getTitle());iw.setContent(_92.getContent());iw.show(_94);}},_onBingLayerAdd:function(_95){this["__"+_95.id+"_vis_connect"]=_4.connect(_95,"onVisibilityChange",this,"_toggleBingLogo");this._toggleBingLogo(_95.visible);},_onBingLayerRemove:function(_96){_4.disconnect(this["__"+_96.id+"_vis_connect"]);delete this["__"+_96.id+"_vis_connect"];var _97=this.layerIds;var _98=_7.some(_97,function(_99){var _9a=this._layers[_99];return _9a&&_9a.visible&&_9a.declaredClass.indexOf("VETiledLayer")!==-1;},this);this._toggleBingLogo(_98);},_toggleBingLogo:function(_9b){if(_9b&&!this._bingLogo){var _9c={left:(this._mapParams&&this._mapParams.nav?"25px":"")};if(has("ie")===6){_9c.filter="progid:DXImageTransform.Microsoft.AlphaImageLoader(enabled='true', sizingMethod='crop', src='"+_1.toUrl("esri")+"/images/map/bing-logo-lg.png"+"')";}var _9d=this._bingLogo=_d.create("div",{style:_9c},this.root);_c.add(_9d,"bingLogo-lg");}else{if(!_9b&&this._bingLogo){_d.destroy(this._bingLogo);delete this._bingLogo;}}},__panStart:function(x,y){var _9e=this._zoomAnim,_9f=this._panAnim;if(_9e&&_9e._active){_9e.stop();_9e._fire("onEnd",[_9e.node]);}else{if(_9f&&_9f._active){_9f.stop();this._panAnim=null;var _a0=_9f.curve.getValue(_9f._getStep()),rl=Math.round(parseFloat(_a0.left)),rt=Math.round(parseFloat(_a0.top)),_a1=this.navigationManager._dragOrigin;this.__pan(rl,rt);if(_a1){_a1.x-=rl;_a1.y-=rt;}return;}}this.__panning=true;this.onPanStart(this.extent,new _1a(x,y));},__pan:function(dx,dy){var _a2=this.extent,rw=this._ratioW,rh=this._ratioH;this.onPan(new _1b(_a2.xmin-(dx/rw),_a2.ymin+(dy/rh),_a2.xmax-(dx/rw),_a2.ymax+(dy/rh),this.spatialReference),new _1a(dx,dy));},__panEnd:function(dx,dy){var _a3=this.__visibleRect,_a4=this.__visibleDelta;_a3.x+=dx;_a3.y+=dy;_a4.x+=dx;_a4.y+=dy;var d=new _1a(dx,dy),_a5=this.extent,rw=this._ratioW,rh=this._ratioH;_a5=new _1b(_a5.xmin-(dx/rw),_a5.ymin+(dy/rh),_a5.xmax-(dx/rw),_a5.ymax+(dy/rh),this.spatialReference);this.__panning=false;this._updateExtent(_a5);this.onPanEnd(_a5,d);this._fireExtChg([_a5,d,false,this.__LOD]);},__zoomStart:function(_a6,_a7){this.__zooming=true;this.onZoomStart(_a6,1,_a7,this.__LOD?this.__LOD.level:null);},__zoom:function(_a8,_a9,_aa){this.onZoom(_a8,_a9,_aa);},__zoomEnd:function(_ab,_ac,_ad,lod,_ae){ds(this._layersDiv,{left:"0px",top:"0px"});this._delta=new _1a(0,0);this.__visibleRect.x=(this.__visibleRect.y=0);_ab=new _1b(_ab);this.__LOD=lod;this._ratioW=this.width/_ab.getWidth();this._ratioH=this.height/_ab.getHeight();var _af=this._delta;this._delta=null;this.__zooming=false;this._updateExtent(_ab,_ae);this.onZoomEnd(_ab,_ac,_ad,lod?lod.level:null);this._fireExtChg([_ab,_af,_ae,lod]);},_extentUtil:function(_b0,pan,_b1,fit,_b2){var dfd=new _5(),_b3,_b4,_b5,_b6,_b7,_b8,_b9,_ba,dx,dy,_bb=this.width,_bc=this.height,_bd,_be,_bf;if(_b0){_b3=_b0.numLevels;_b4=_b0.targetLevel;_bd=_14.isDefined(_b4);_b5=_b0.factor;_b6=_b0.mapAnchor;_b7=_b0.screenAnchor;_b8=_b0.mapCenter;_be=_b0.levelOrFactor;_b9=_b0.targetScale;_ba=_14.isDefined(_b9)&&_b9>0;}if(pan){dx=pan.dx;dy=pan.dy;_b8=pan.mapCenter;}if(_6.isArray(_b8)){_b8=new _19(_b8);}var _c0=this._panAnim,_c1=this._stopAnim(),_c2=_c1?_c1.divExtent:this.extent,_c3=this.__tileInfo,_c4,_c5,ewd,eht,_c6=this._params;if(!this.loaded){if(_b1){if(_c2){_b1=this._convertGeometry(_c2,_b1);}if(_b1){this.extent=_b1;_c6.zoom=_c6.scale=-1;_c6.center=null;}}else{if(_b8||_bd||_ba){if(_b8){if(_c2){_b8=this._convertGeometry(_c2,_b8);if(_b8){this.extent=_c2.centerAt(_b8);_c6.center=null;}}else{_c6.center=_b8;}}if(_bd&&_b4>-1){_c6.zoom=_b4;_c6.scale=-1;}else{if(_ba){_c6.scale=_b9;_c6.zoom=-1;}}}}dfd.resolve();return dfd;}if(_b8){_b8=this._convertGeometry(this,_b8);if(!_b8){dfd.reject();return dfd;}}if(_b6){_b6=this._convertGeometry(this,_b6);if(!_b6){dfd.reject();return dfd;}}if(_b1){_b1=this._convertGeometry(this,_b1);if(!_b1){dfd.reject();return dfd;}}if(_c0&&_b6&&_b7){_b6=_26(this.extent,_bb,_bc,_b7);}if(_c1&&_b6&&_b7){_b6=_26(_c1.divExtent,_bb,_bc,_b7);}if(_bd){if(_c3){var _c7=this.getMinZoom(),_c8=this.getMaxZoom();if(_b4<_c7){_b4=_c7;}else{if(_b4>_c8){_b4=_c8;}}_b3=_b4-(_c1?_c1.level:this.getLevel());}else{_b3=_b4>0?-1:1;_bf=_be?_b4:null;}}if(_b1){}else{if(_14.isDefined(_b3)){var _c9;if(_c3){var _ca=_c1?_c1.level:this.getLevel();_c9=this.__getExtentForLevel(_ca+_b3,_b8,_c2).extent;}else{var _cb=_c1?_c1.end:this.extent;_c9=_cb.expand(_bf||(_b3>0?0.5*_b3:2*-_b3));if(_bf&&_b8){_c9=_c9.centerAt(_b8);}}if(_c9){if(_b8){_b1=_c9;}else{var _cc=_b6||_c2.getCenter(),_cd=_c2.ymax-((_c9.getHeight()-_c2.getHeight())*(_cc.y-_c2.ymax)/_c2.getHeight());_c4=_c2.xmin-((_c9.getWidth()-_c2.getWidth())*(_cc.x-_c2.xmin)/_c2.getWidth());_b1=new _1b(_c4,_cd-_c9.getHeight(),_c4+_c9.getWidth(),_cd,this.spatialReference);}}}else{if(_ba){_b1=_1e.getExtentForScale(this,_b9,_c2);}else{if(_14.isDefined(_b5)){_b1=_c2.expand(_b5);}else{if(dx||dy){if(_c1){var end=_c1.end,c1=end.getCenter(),c2=_27(end,_bb,_bc,c1);c2.x+=dx;c2.y+=dy;c2=_26(end,_bb,_bc,c2);_b1=end.offset(c2.x-c1.x,c2.y-c1.y);}else{var _ce=new _1a((_bb/2)+dx,(_bc/2)+dy),_cf=_26(_c2,_bb,_bc,_ce);ewd=_c2.getWidth();eht=_c2.getHeight();_c4=_cf.x-(ewd/2);_c5=_cf.y-(eht/2);_b1=new _1b(_c4,_c5,_c4+ewd,_c5+eht,this.spatialReference);}}}}}}if(!_b1){if(_b8){var ext=_c1?_c1.end:_c2;ewd=ext.getWidth();eht=ext.getHeight();_c4=_b8.x-(ewd/2);_c5=_b8.y-(eht/2);_b1=new _1b(_c4,_c5,_c4+ewd,_c5+eht,this.spatialReference);}else{if(_c1){_b1=_c1.end;}}}if(_b1){if(this._extentDfd&&this._extentDfd.fired===-1){this._extentDfd.reject();}this._extentDfd=dfd;this.__setExtent(_b1,null,_b7,fit,_c1,_b2);}else{dfd.reject();}return dfd;},__setExtent:function(_d0,_d1,_d2,fit,_d3,_d4){try{if(this._firstLayerId){this.extent=_d0;return;}var _d5=true,sr=this.spatialReference,ext=_d3?_d3.divExtent:this.extent,_d6=this._fixExtent(_d0,fit||false);_d0=_d6.extent;var _d7=_d0.getWidth(),_d8=_d0.getHeight(),_d9=Math.round;if(ext){var tw=_d9(ext.getWidth()*_2a),w=_d9(_d7*_2a),th=_d9(ext.getHeight()*_2a),h=_d9(_d8*_2a);_d5=(tw!==w)||(th!==h);}var _da,end,_db,_dc,_dd=_d3&&_d3.rect,_de=_d3&&_d3.divExtent;if(_29.zoomDuration&&_d5&&ext){_de=_de||new _1b(ext);_dd=_dd||{left:ext.xmin,top:ext.ymax,width:ext.getWidth(),height:ext.getHeight()};end={left:_d0.xmin,top:_d0.ymax,width:_d7,height:_d8};_db=_dd.width/end.width;_dc=_dd.height/end.height;var mtl=new _19(_d0.xmin,_d0.ymax,sr),mbl=new _19(_d0.xmin,_d0.ymin,sr),etl=new _19(this.extent.xmin,this.extent.ymax,sr),ebl=new _19(this.extent.xmin,this.extent.ymin,sr);_da=_1d.getLineIntersection(etl,mtl,ebl,mbl,sr);if(!_da&&!_d3){_d5=false;}}this._ratioW=this.width/_d7;this._ratioH=this.height/_d8;var _df=this._zoomAnimDiv;if(_d5){ds(this._layersDiv,{left:"0px",top:"0px"});_d1=new _1a(0,0);this.__visibleRect.x=(this.__visibleRect.y=0);if(_dd&&end){this._delta=_d1;_df.id="_zAD";_df.startingExtent=_de;_df.extent=_d0;_df.levelChange=_d5;_df.newLod=_d6.lod;if(_d2){_df.anchor=_d2;}else{if(!_da&&_d3){_df.anchor=_d3.anchor;}else{_df.anchor=_27(this.extent,this.width,this.height,_da);}}this._zoomAnim=_16.resize({node:_df,start:_dd,end:end,duration:_29.zoomDuration,rate:_29.zoomRate,beforeBegin:!_d3?this._zoomStartHandler:null,onAnimate:this._zoomingHandler,onEnd:this._zoomEndHandler}).play();this._fireOnScale(this.extent.getWidth()/_d0.getWidth(),_df.anchor);}else{this._updateExtent(_d0,_d5);this._fireExtChg([this.extent,_d1,_d5,(this.__LOD=_d6.lod)]);}}else{if(!this.__panning){if(this.loaded===false||_d4){this._updateExtent(_d0,_d5);this._fireExtChg([this.extent,_d1,_d5,(this.__LOD=_d6.lod)]);}else{this.__panning=true;_dd=new _1c(0,0,this.width,this.height,this.spatialReference).getCenter();_dd.x=_d9(_dd.x);_dd.y=_d9(_dd.y);this.onPanStart(this.extent,new _1a(0,0));var _e0=(this._delta=this.toScreen(_d0.getCenter()));this._panAnim=_16.slideTo({node:_df,left:_dd.x-_e0.x,top:_dd.y-_e0.y,duration:_29.panDuration,rate:_29.panRate,onAnimate:this._panningHandler,onEnd:this._panEndHandler});this._panAnim.play();}}}}catch(e){console.log(e.stack);console.error(e);}},_fireOnScale:function(_e1,_e2,_e3){if(this.navigationMode==="css-transforms"){var vd=this.__visibleDelta;this.onScale(_11.scaleAt(_e1,{x:-1*((this.width/2)-(_e2.x-vd.x)),y:-1*((this.height/2)-(_e2.y-vd.y))}),_e3);}},_stopAnim:function(){var _e4=this._zoomAnim,_e5=this._panAnim;if(_e4&&_e4._active){_e4.stop();var _e6=_e4.curve.getValue(_e4._getStep()),rl=parseFloat(_e6.left),rt=parseFloat(_e6.top),_e7=_e4.node;return {anchor:_e7.anchor,start:_e7.startingExtent,end:_e7.extent,level:_e7.newLod&&_e7.newLod.level,rect:_e6,divExtent:new _1b(rl,rt-parseFloat(_e6.height),rl+parseFloat(_e6.width),rt,this.spatialReference)};}else{if(_e5&&_e5._active){_e5.stop();_e5._fire("onEnd",[_e5.node]);}}},__getExtentForLevel:function(_e8,_e9,_ea){var ti=this.__tileInfo,_eb=ti&&ti.lods;_e8=_14.isDefined(_e8)?_e8:0;_ea=_ea||this.extent;_e9=_e9||(_ea&&_ea.getCenter());if(_eb){if(!_e9){console.log("Map: "+this.invalidExtent);return;}var _ec=this.getMinZoom(),_ed=this.getMaxZoom();if(_e8>_ed){_e8=_ed;}if(_e8<_ec){_e8=_ec;}var lod=_eb[_e8],_ee=this.width*lod.resolution/2,_ef=this.height*lod.resolution/2;return {extent:new _1b(_e9.x-_ee,_e9.y-_ef,_e9.x+_ee,_e9.y+_ef,_e9.spatialReference),lod:lod};}else{if(!_ea){console.log("Map: "+this.invalidExtent);return;}_e8=(!_e8||_e8<1)?1:_e8;return {extent:_ea.expand(_e8).centerAt(_e9)};}},_jobs:0,_incr:function(){if((++this._jobs)===1){this.updating=true;this.onUpdateStart();}},_decr:function(){var _f0=--this._jobs;if(!_f0){this.updating=false;this.onUpdateEnd();}else{if(_f0<0){this._jobs=0;}}},_fireEvent:function(_f1,_f2){if(this[_f1]){this[_f1].apply(this,_f2);}},_updateExtent:function(_f3,_f4){this.extent=_f3;if(_f4){this._setClipRect();}var _f5=this.spatialReference;if(_f5){if(_f5.isWebMercator()){this.geographicExtent=_20.webMercatorToGeographic(this._getAvailExtent(),true);}else{if(_f5.wkid===4326){this.geographicExtent=new _1b(this._getAvailExtent().toJson());}}}},_fireExtChg:function(_f6){this._fireEvent("onExtentChange",_f6);var dfd=this._extentDfd;if(dfd){delete this._extentDfd;dfd.resolve();}},onUpdateStart:function(){},onUpdateEnd:function(){},onLoad:function(){this._setClipRect();},onUnload:function(){},onExtentChange:function(a,b,_f7){},onTimeExtentChange:function(){},onLayerAdd:function(){},onLayerAddResult:function(){},onLayersAddResult:function(){},onLayerRemove:function(){},onLayersRemoved:function(){},onLayerReorder:function(){},onLayersReordered:function(){},onLayerSuspend:function(){},onLayerResume:function(){},onPanStart:function(){},onPan:function(){},onPanEnd:function(){},onScale:function(){},onZoomStart:function(){},onZoom:function(){},onZoomEnd:function(){},onResize:function(){this._setClipRect();},onReposition:function(){},destroy:function(){if(!this._destroyed){this.removeAllLayers();this._cleanUp();if(this._gc){this._gc._cleanUp();}this._destroyed=true;this.onUnload(this);}},setCursor:function(_f8){ds(this.__container,"cursor",(this.cursor=_f8));},setMapCursor:function(c){this.setCursor((this._cursor=c));},resetMapCursor:function(){this.setCursor(this._cursor);},setInfoWindow:function(_f9){var iw=this.infoWindow;if(iw){iw.unsetMap(this);}this.infoWindow=_f9;if(this.loaded&&_f9){_f9.setMap(this);}},setInfoWindowOnClick:function(_fa){var _fb=this._params;if(_fa){if(!_fb.showInfoWindowOnClick){var _fc=[this.graphics].concat(_7.map(this.graphicsLayerIds,this.getLayer,this));_7.map(_fc,function(_fd){if(_fd&&_fd.loaded){this._clickHandles.push(dc(_fd,"onClick",this,"_gClickHandler"));}},this);}}else{_7.forEach(this._clickHandles,ddc);this._clickHandles=[];}_fb.showInfoWindowOnClick=_fa;},getInfoWindowAnchor:function(pt){return (this.infoWindow&&this.infoWindow._getAnchor&&this.infoWindow._getAnchor(pt))||"upperright";},toScreen:function(pt,_fe){return _27(this.extent,this.width,this.height,pt,_fe);},toMap:function(pt){return _26(this.extent,this.width,this.height,pt);},addLayer:function(_ff,_100){if(_ff&&!this.getLayer(_ff.id)){this._addLayer(_ff,_ff instanceof _21?this.graphicsLayerIds:this.layerIds,_100);}return _ff;},addLayers:function(_101){var _102=[],_103=_101.length,_104,i,len=_101.length;var _105=function(_106,_107){if(_7.indexOf(_101,_106)!==-1){_103--;_102.push({"layer":_106,"success":!_107,"error":_107});if(!_103){_4.disconnect(_104);this.onLayersAddResult(_102);}}};_104=_4.connect(this,"onLayerAddResult",_105);for(i=0;i<len;i++){this.addLayer(_101[i]);}return this;},removeLayer:function(_108,_109){var id=_108.id,ids=_108 instanceof _21?this.graphicsLayerIds:this.layerIds,i=iOf(ids,id);if(i>=0){ids.splice(i,1);if(_108 instanceof _21){ddc(this["_gl_"+_108.id+"_click_connect"]);if(_108.loaded){_108._unsetMap(this,this._gc._surface);}}else{if(_108.loaded){_108._unsetMap(this,this._layersDiv);if(_108.declaredClass.indexOf("VETiledLayer")!==-1){this._onBingLayerRemove(_108);}}}delete this._layers[id];delete this._layerDivs[id];if(!_109){this._reorderLayers(ids);}this.onLayerRemove(_108);}},removeAllLayers:function(){var ids=this.layerIds,i;for(i=ids.length-1;i>=0;i--){this.removeLayer(this._layers[ids[i]],1);}ids=this.graphicsLayerIds;for(i=ids.length-1;i>=0;i--){this.removeLayer(this._layers[ids[i]],1);}this.onLayersRemoved();},reorderLayer:function(_10a,_10b){if(_6.isString(_10a)){_2.deprecated(this.declaredClass+": "+"Map.reorderLayer(/*String*/ id, /*Number*/ index) deprecated. Use Map.reorderLayer(/*Layer*/ layer, /*Number*/ index).",null,"v2.0");_10a=this.getLayer(_10a);}var id=_10a.id,i,ids=_10a instanceof _21?this.graphicsLayerIds:this.layerIds;if(_10b<0){_10b=0;}else{if(_10b>=ids.length){_10b=ids.length-1;}}i=iOf(ids,id);if(i===-1||i===_10b){return;}ids.splice(i,1);ids.splice(_10b,0,id);this._reorderLayers(ids);},getLayer:function(id){return this._layers[id];},setExtent:function(_10c,fit){_10c=new _1b(_10c.toJson());var _10d=_10c.getWidth(),_10e=_10c.getHeight(),dfd;if(_10d===0&&_10e===0){dfd=this.centerAt(new _19({x:_10c.xmin,y:_10c.ymin,spatialReference:_10c.spatialReference&&_10c.spatialReference.toJson()}));}else{dfd=this._extentUtil(null,null,_10c,fit);}return dfd;},centerAt:function(_10f){return this._extentUtil(null,{mapCenter:_10f});},centerAndZoom:function(_110,_111){return this._extentUtil({targetLevel:_111,mapCenter:_110,levelOrFactor:true});},getScale:function(){return this.__LOD?this.__LOD.scale:_1e.getScale(this);},getMinScale:function(){return this._params.minScale;},getMaxScale:function(){return this._params.maxScale;},setScale:function(_112){return this._extentUtil({targetScale:_112});},getLayersVisibleAtScale:function(_113){var _114=[];_113=_113||this.getScale();if(_113){_7.forEach(this.layerIds.concat(this.graphicsLayerIds),function(_115){_115=this.getLayer(_115);if(_115.isVisibleAtScale(_113)){_114.push(_115);}},this);}return _114;},getNumLevels:function(){var _116=this.getMinZoom(),_117=this.getMaxZoom();return ((_116===_117)&&_116<0)?0:(_117-_116+1);},getLevel:function(){return this.__LOD?this.__LOD.level:-1;},setLevel:function(_118){if(_118>-1){return this._extentUtil({targetLevel:_118});}},getZoom:function(){return this.getLevel();},setZoom:function(zoom){return this.setLevel(zoom);},getMinZoom:function(){return this._params.minZoom;},getMaxZoom:function(){return this._params.maxZoom;},setBasemap:function(_119){var _11a,_11b="Map.setBasemap: ";if(_6.isObject(_119)){_11a=_119;_119=_11a.title;}else{_11a=_29.basemaps&&_29.basemaps[_119];}if(_11a){if(this._basemapDfd&&this._basemapDfd.fired===-1){this._basemapDfd.cancel();}var _11c=[],_11d=[],_11e=0;_7.forEach(_11a.baseMapLayers||_11a.layers,function(_11f){var _120,_121={id:_11f.id,displayLevels:_11f.displayLevels,opacity:_14.isDefined(_11f.opacity)?_11f.opacity:null,visible:_14.isDefined(_11f.visibility)?_11f.visibility:null};if(_11f.type){switch(_11f.type){case "OpenStreetMap":_120=new _24(_121);break;default:console.log(_11b+_14.substitute({basemapName:_119,type:_11f.type},this.unknownLayerType));break;}}else{var url=_11f.url;if(window.location.protocol==="https:"&&((url.search(/^http\:\/\/server\.arcgisonline\.com/i)!==-1)||(url.search(/^http\:\/\/services\.arcgisonline\.com/i)!==-1)||(url.search(/^http\:\/\/.+\.arcgis\.com/i)!==-1))){url=url.replace(/http:/i,"https:");}_120=new _23(url,_121);}if(_120){_11c.push(_120);_11d.push(_11f);if(!_11f.isReference){_11e++;}}},this);if(!_11c.length||!_11e){console.log(_11b+_14.substitute({basemapName:_119},this.invalidBasemap));return;}var _122={basemapName:_119,infos:_11d,layers:_11c};if(!this.loaded){this._basemapLoaded(_122);return;}var self=this,dfd=new _5(_17._dfdCanceller),_123=function(_124){dfd._pendingLayers--;var idx=_7.indexOf(_122.layers,this);if(idx>-1){var _125=dfd._layerEvents[idx];if(_125){_4.disconnect(_125[0]);_4.disconnect(_125[1]);}}if(dfd._pendingLayers<=0){delete dfd._layerEvents;delete self._basemapDfd;dfd.callback(_122);}};this._basemapDfd=dfd;dfd._pendingLayers=0;dfd._layerEvents={};_7.forEach(_11c,function(_126,i){if(_126){dfd._pendingLayers++;if(_126.loaded){_123(_126);}else{dfd._layerEvents[i]=[_4.connect(_126,"onLoad",_126,_123),_4.connect(_126,"onError",_126,_123)];}}});dfd.addCallback(_6.hitch(this,this._basemapLoaded));}else{var _127=[],_128;for(_128 in _29.basemaps){_127.push(_128);}console.log(_11b+_14.substitute({basemapName:_119,list:_127.join(",")},this.unknownBasemap));}},_basemapLoaded:function(_129){var _12a=_129.layers,_12b=_129.infos,_12c=0,_12d=true;if(this.loaded){_7.forEach(_12a,function(_12e,i){if(_12e.loaded){if(!_12b[i].isReference){_12c++;}}});_12d=_12c;}if(_12d){this._removeBasemap();this._basemap=_129.basemapName;this.basemapLayerIds=this._addBasemap(_12a,_12b);this._fireEvent("onBasemapChange");}},_addBasemap:function(_12f,_130){var _131=[],ids=[],_132=0;_7.forEach(_12f,function(_133,i){if(_130[i].isReference){_131.push(_133);}else{this.addLayer(_133,_132++);ids.push(_133.id);}},this);if(_131.length){_7.forEach(_131,function(_134){this.addLayer(_134,"top");ids.push(_134.id);},this);}return ids;},_removeBasemap:function(){var ids=this.basemapLayerIds,_135;if(ids&&ids.length){_7.forEach(ids,function(id){_135=this.getLayer(id);if(_135){this.removeLayer(_135);}},this);}},getBasemap:function(){return this._basemap||"";},translate:function(dx,dy){dx=dx||0;dy=dy||0;if(!this._txTimer){this._tx=this._ty=0;var _136=this.toScreen(this.extent.getCenter());this.__panStart(_136.x,_136.y);}this._tx+=dx;this._ty+=dy;this.__pan(this._tx,this._ty);clearTimeout(this._txTimer);this._txTimer=setTimeout(this._endTranslate,150);},_endTranslate:function(){clearTimeout(this._txTimer);this._txTimer=null;var dx=this._tx,dy=this._ty;this._tx=this._ty=0;this.__panEnd(dx,dy);},setTimeExtent:function(_137){this.timeExtent=_137;var arg=_137?new _137.constructor(_137.toJson()):null;this.onTimeExtentChange(arg);},setTimeSlider:function(_138){if(this.timeSlider){ddc(this._tsTimeExtentChange_connect);this._tsTimeExtentChange_connect=null;this.timeSlider=null;}if(_138){this.timeSlider=_138;this.setTimeExtent(_138.getCurrentTimeExtent());this._tsTimeExtentChange_connect=dc(_138,"onTimeExtentChange",this,"setTimeExtent");}},resize:function(_139){var self=this,_13a=function(){clearTimeout(self._resizeT);self.reposition();self._resize();};clearTimeout(self._resizeT);if(_139===true){_13a();}else{self._resizeT=setTimeout(_13a,self.resizeDelay);}},_resize:function(){var w=this.width,h=this.height,box=_e.getContentBox(this.container);if(w===box.w&&h===box.h){return;}var _13b=this._zoomAnim||this._panAnim;if(_13b){_13b.stop();_13b._fire("onEnd",[_13b.node]);}ds(this.root,{width:(this.width=box.w)+"px",height:(this.height=box.h)+"px"});var wd=this.width,ht=this.height;if(this.attribution&&this.attribution.domNode){_f.set(this.attribution.domNode,"width",Math.floor(wd*this._mapParams.attributionWidth)+"px");}this.__visibleRect.update(this.__visibleRect.x,this.__visibleRect.y,wd,ht);this.__visibleDelta.update(this.__visibleDelta.x,this.__visibleDelta.y,wd,ht);var r=new _1c(this.extent),ne=(new _1c(r.x,r.y,r.width*(wd/w),r.height*(ht/h),this.spatialReference)).getExtent();this.onResize(ne,wd,ht);this._extentUtil(null,null,ne,null,true);},reposition:function(){this._reposition();this.onReposition(this.position.x,this.position.y);},_reposition:function(){var pos=_e.position(this.container,true),brdr=_e.getPadBorderExtents(this.container);this.position.update(pos.x+brdr.l,pos.y+brdr.t);},_setClipRect:function(){delete this._clip;var _13c=has("ie")?"rect(auto,auto,auto,auto)":null;if(this.wrapAround180){var _13d=this.width,_13e=this.height,_13f=this._getFrameWidth(),diff=_13d-_13f;if(diff>0){var left=diff/2;_13c="rect(0px,"+(left+_13f)+"px,"+_13e+"px,"+left+"px)";var _140=this.extent.getWidth(),_141=_140*(_13f/_13d);this._clip=[(_140-_141)/2,_141];}}ds(this.__container,"clip",_13c);},_getAvailExtent:function(){var _142=this.extent,clip=this._clip;if(clip){if(!_142._clip){var rect=new _1c(_142);rect.width=clip[1];rect.x=rect.x+clip[0];_142._clip=rect.getExtent();}return _142._clip;}return _142;},_fixedPan:function(dx,dy){return this._extentUtil(null,{dx:dx,dy:dy});},panUp:function(){return this._fixedPan(0,this.height*-_2b);},panUpperRight:function(){return this._fixedPan(this.width*_2b,this.height*-_2b);},panRight:function(){return this._fixedPan(this.width*_2b,0);},panLowerRight:function(){return this._fixedPan(this.width*_2b,this.height*_2b);},panDown:function(){return this._fixedPan(0,this.height*_2b);},panLowerLeft:function(){return this._fixedPan(this.width*-_2b,this.height*_2b);},panLeft:function(){return this._fixedPan(this.width*-_2b,0);},panUpperLeft:function(){return this._fixedPan(this.width*-_2b,this.height*-_2b);},enableSnapping:function(_143){_143=_143||{};if(_143.declaredClass==="esri.SnappingManager"){this.snappingManager=_143;}else{var _144=["esri/SnappingManager"],rid=uid++,self=this;this._rids&&this._rids.push(rid);_1(_144,function(_145){var idx=self._rids?_7.indexOf(self._rids,rid):-1;if(idx!==-1){self._rids.splice(idx,1);self.snappingManager=new _145(_6.mixin({map:self},_143));}});}return this.snappingManager;},disableSnapping:function(){if(this.snappingManager){this.snappingManager.destroy();}this.snappingManager=null;}});if(has("extend-esri")){_12._CoreMap=_36;}return _36;});