/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/gfx/decompose":function(){define("dojox/gfx/decompose",["./_base","dojo/_base/lang","./matrix"],function(g,_1,m){function eq(a,b){return Math.abs(a-b)<=0.000001*(Math.abs(a)+Math.abs(b));};function _2(r1,m1,r2,m2){if(!isFinite(r1)){return r2;}else{if(!isFinite(r2)){return r1;}}m1=Math.abs(m1);m2=Math.abs(m2);return (m1*r1+m2*r2)/(m1+m2);};function _3(_4){var M=new m.Matrix2D(_4);return _1.mixin(M,{dx:0,dy:0,xy:M.yx,yx:M.xy});};function _5(_6){return (_6.xx*_6.yy<0||_6.xy*_6.yx>0)?-1:1;};function _7(_8){var M=m.normalize(_8),b=-M.xx-M.yy,c=M.xx*M.yy-M.xy*M.yx,d=Math.sqrt(b*b-4*c),l1=-(b+(b<0?-d:d))/2,l2=c/l1,_9=M.xy/(l1-M.xx),_a=1,_b=M.xy/(l2-M.xx),_c=1;if(eq(l1,l2)){_9=1,_a=0,_b=0,_c=1;}if(!isFinite(_9)){_9=1,_a=(l1-M.xx)/M.xy;if(!isFinite(_a)){_9=(l1-M.yy)/M.yx,_a=1;if(!isFinite(_9)){_9=1,_a=M.yx/(l1-M.yy);}}}if(!isFinite(_b)){_b=1,_c=(l2-M.xx)/M.xy;if(!isFinite(_c)){_b=(l2-M.yy)/M.yx,_c=1;if(!isFinite(_b)){_b=1,_c=M.yx/(l2-M.yy);}}}var d1=Math.sqrt(_9*_9+_a*_a),d2=Math.sqrt(_b*_b+_c*_c);if(!isFinite(_9/=d1)){_9=0;}if(!isFinite(_a/=d1)){_a=0;}if(!isFinite(_b/=d2)){_b=0;}if(!isFinite(_c/=d2)){_c=0;}return {value1:l1,value2:l2,vector1:{x:_9,y:_a},vector2:{x:_b,y:_c}};};function _d(M,_e){var _f=_5(M),a=_e.angle1=(Math.atan2(M.yx,M.yy)+Math.atan2(-_f*M.xy,_f*M.xx))/2,cos=Math.cos(a),sin=Math.sin(a);_e.sx=_2(M.xx/cos,cos,-M.xy/sin,sin);_e.sy=_2(M.yy/cos,cos,M.yx/sin,sin);return _e;};function _10(M,_11){var _12=_5(M),a=_11.angle2=(Math.atan2(_12*M.yx,_12*M.xx)+Math.atan2(-M.xy,M.yy))/2,cos=Math.cos(a),sin=Math.sin(a);_11.sx=_2(M.xx/cos,cos,M.yx/sin,sin);_11.sy=_2(M.yy/cos,cos,-M.xy/sin,sin);return _11;};return g.decompose=function(_13){var M=m.normalize(_13),_14={dx:M.dx,dy:M.dy,sx:1,sy:1,angle1:0,angle2:0};if(eq(M.xy,0)&&eq(M.yx,0)){return _1.mixin(_14,{sx:M.xx,sy:M.yy});}if(eq(M.xx*M.yx,-M.xy*M.yy)){return _d(M,_14);}if(eq(M.xx*M.xy,-M.yx*M.yy)){return _10(M,_14);}var MT=_3(M),u=_7([M,MT]),v=_7([MT,M]),U=new m.Matrix2D({xx:u.vector1.x,xy:u.vector2.x,yx:u.vector1.y,yy:u.vector2.y}),VT=new m.Matrix2D({xx:v.vector1.x,xy:v.vector1.y,yx:v.vector2.x,yy:v.vector2.y}),S=new m.Matrix2D([m.invert(U),M,m.invert(VT)]);_d(VT,_14);S.xx*=_14.sx;S.yy*=_14.sy;_10(U,_14);S.xx*=_14.sx;S.yy*=_14.sy;return _1.mixin(_14,{sx:S.xx,sy:S.yy});};});},"dojox/gfx/shape":function(){define("dojox/gfx/shape",["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,_15,_16,_17,has,_18,arr,_19,_1a,_1b){var _1c=g.shape={};var _1d={};var _1e={};_1c.register=function(s){var t=s.declaredClass.split(".").pop();var i=t in _1d?++_1d[t]:((_1d[t]=0));var uid=t+i;_1e[uid]=s;return uid;};_1c.byId=function(id){return _1e[id];};_1c.dispose=function(s,_1f){if(_1f&&s.children){for(var i=0;i<s.children.length;++i){_1c.dispose(s.children[i],true);}}delete _1e[s.getUID()];};_1c.Shape=_16("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;var uid=_1c.register(this);this.getUID=function(){return uid;};},destroy:function(){_1c.dispose(this);},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_1b;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(_20){this.clip=_20;},getClip:function(){return this.clip;},setShape:function(_21){this.shape=g.makeParameters(this.shape,_21);this.bbox=null;return this;},setFill:function(_22){if(!_22){this.fillStyle=null;return this;}var f=null;if(typeof (_22)=="object"&&"type" in _22){switch(_22.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,_22);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_22);break;case "pattern":f=g.makeParameters(g.defaultPattern,_22);break;}}else{f=g.normalizeColor(_22);}this.fillStyle=f;return this;},setStroke:function(_23){if(!_23){this.strokeStyle=null;return this;}if(typeof _23=="string"||_15.isArray(_23)||_23 instanceof _1a){_23={color:_23};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_23);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_24){this.matrix=_1b.clone(_24?_1b.normalize(_24):_1b.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_25){return _25?this.setTransform([this.matrix,_25]):this;},applyLeftTransform:function(_26){return _26?this.setTransform([_26,this.matrix]):this;},applyTransform:function(_27){return _27?this.setTransform([this.matrix,_27]):this;},removeShape:function(_28){if(this.parent){this.parent.remove(this,_28);}return this;},_setParent:function(_29,_2a){this.parent=_29;return this._updateParentMatrix(_2a);},_updateParentMatrix:function(_2b){this.parentMatrix=_2b?_1b.clone(_2b):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_1b.multiply(p.matrix,m);}p=p.parent;}return m;}});_1c._eventsProcessing={connect:function(_2c,_2d,_2e){return _18.connect(this.getEventSource(),_2c,_1c.fixCallback(this,g.fixTarget,_2d,_2e));},disconnect:function(_2f){_18.disconnect(_2f);}};_1c.fixCallback=function(_30,_31,_32,_33){if(!_33){_33=_32;_32=null;}if(_15.isString(_33)){_32=_32||_17.global;if(!_32[_33]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_33,"\"] is null (scope=\"",_32,"\")"].join(""));}return function(e){return _31(e,_30)?_32[_33].apply(_32,arguments||[]):undefined;};}return !_32?function(e){return _31(e,_30)?_33.apply(_32,arguments):undefined;}:function(e){return _31(e,_30)?_33.apply(_32,arguments||[]):undefined;};};_15.extend(_1c.Shape,_1c._eventsProcessing);_1c.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(_34){var _35=_34.getParent();if(_35){_35.remove(_34,true);}this.children.push(_34);return _34._setParent(this,this._getRealMatrix());},remove:function(_36,_37){for(var i=0;i<this.children.length;++i){if(this.children[i]==_36){if(_37){}else{_36.parent=null;_36.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_38){var _39;for(var i=0;i<this.children.length;++i){_39=this.children[i];_39.parent=null;_39.parentMatrix=null;if(_38){_39.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _3a=null;arr.forEach(this.children,function(_3b){var bb=_3b.getBoundingBox();if(bb){var ct=_3b.getTransform();if(ct){bb=_1b.multiplyRectangle(ct,bb);}if(_3a){_3a.x=Math.min(_3a.x,bb.x);_3a.y=Math.min(_3a.y,bb.y);_3a.endX=Math.max(_3a.endX,bb.x+bb.width);_3a.endY=Math.max(_3a.endY,bb.y+bb.height);}else{_3a={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_3a){_3a.width=_3a.endX-_3a.x;_3a.height=_3a.endY-_3a.y;}return _3a;}return null;},_moveChildToFront:function(_3c){for(var i=0;i<this.children.length;++i){if(this.children[i]==_3c){this.children.splice(i,1);this.children.push(_3c);break;}}return this;},_moveChildToBack:function(_3d){for(var i=0;i<this.children.length;++i){if(this.children[i]==_3d){this.children.splice(i,1);this.children.unshift(_3d);break;}}return this;}};_1c.Surface=_16("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_19.destroy);this._nodes=[];arr.forEach(this._events,_18.disconnect);this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_19.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_3e){},whenLoaded:function(_3f,_40){var f=_15.hitch(_3f,_40);if(this.isLoaded){f(this);}else{var h=_18.connect(this,"onLoad",function(_41){_18.disconnect(h);f(_41);});}}});_15.extend(_1c.Surface,_1c._eventsProcessing);_1c.Rect=_16("dojox.gfx.shape.Rect",_1c.Shape,{constructor:function(_42){this.shape=g.getDefault("Rect");this.rawNode=_42;},getBoundingBox:function(){return this.shape;}});_1c.Ellipse=_16("dojox.gfx.shape.Ellipse",_1c.Shape,{constructor:function(_43){this.shape=g.getDefault("Ellipse");this.rawNode=_43;},getBoundingBox:function(){if(!this.bbox){var _44=this.shape;this.bbox={x:_44.cx-_44.rx,y:_44.cy-_44.ry,width:2*_44.rx,height:2*_44.ry};}return this.bbox;}});_1c.Circle=_16("dojox.gfx.shape.Circle",_1c.Shape,{constructor:function(_45){this.shape=g.getDefault("Circle");this.rawNode=_45;},getBoundingBox:function(){if(!this.bbox){var _46=this.shape;this.bbox={x:_46.cx-_46.r,y:_46.cy-_46.r,width:2*_46.r,height:2*_46.r};}return this.bbox;}});_1c.Line=_16("dojox.gfx.shape.Line",_1c.Shape,{constructor:function(_47){this.shape=g.getDefault("Line");this.rawNode=_47;},getBoundingBox:function(){if(!this.bbox){var _48=this.shape;this.bbox={x:Math.min(_48.x1,_48.x2),y:Math.min(_48.y1,_48.y2),width:Math.abs(_48.x2-_48.x1),height:Math.abs(_48.y2-_48.y1)};}return this.bbox;}});_1c.Polyline=_16("dojox.gfx.shape.Polyline",_1c.Shape,{constructor:function(_49){this.shape=g.getDefault("Polyline");this.rawNode=_49;},setShape:function(_4a,_4b){if(_4a&&_4a instanceof Array){this.inherited(arguments,[{points:_4a}]);if(_4b&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_4a]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _4c=[];for(var i=0;i<l;i+=2){_4c.push({x:p[i],y:p[i+1]});}this.shape.points=_4c;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var _4d={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(_4d.l>t.x){_4d.l=t.x;}if(_4d.r<t.x){_4d.r=t.x;}if(_4d.t>t.y){_4d.t=t.y;}if(_4d.b<t.y){_4d.b=t.y;}}this.bbox={x:_4d.l,y:_4d.t,width:_4d.r-_4d.l,height:_4d.b-_4d.t};}return this.bbox;}});_1c.Image=_16("dojox.gfx.shape.Image",_1c.Shape,{constructor:function(_4e){this.shape=g.getDefault("Image");this.rawNode=_4e;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_1c.Text=_16(_1c.Shape,{constructor:function(_4f){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_4f;},getFont:function(){return this.fontStyle;},setFont:function(_50){this.fontStyle=typeof _50=="string"?g.splitFontString(_50):g.makeParameters(g.defaultFont,_50);this._setFont();return this;}});_1c.Creator={createShape:function(_51){switch(_51.type){case g.defaultPath.type:return this.createPath(_51);case g.defaultRect.type:return this.createRect(_51);case g.defaultCircle.type:return this.createCircle(_51);case g.defaultEllipse.type:return this.createEllipse(_51);case g.defaultLine.type:return this.createLine(_51);case g.defaultPolyline.type:return this.createPolyline(_51);case g.defaultImage.type:return this.createImage(_51);case g.defaultText.type:return this.createText(_51);case g.defaultTextPath.type:return this.createTextPath(_51);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(_52){return this.createObject(g.Rect,_52);},createEllipse:function(_53){return this.createObject(g.Ellipse,_53);},createCircle:function(_54){return this.createObject(g.Circle,_54);},createLine:function(_55){return this.createObject(g.Line,_55);},createPolyline:function(_56){return this.createObject(g.Polyline,_56);},createImage:function(_57){return this.createObject(g.Image,_57);},createText:function(_58){return this.createObject(g.Text,_58);},createPath:function(_59){return this.createObject(g.Path,_59);},createTextPath:function(_5a){return this.createObject(g.TextPath,{}).setText(_5a);},createObject:function(_5b,_5c){return null;}};return _1c;});},"dojox/gfx/arc":function(){define(["./_base","dojo/_base/lang","./matrix"],function(g,_5d,m){var _5e=2*Math.PI,pi4=Math.PI/4,pi8=Math.PI/8,_5f=pi4+pi8,_60=_61(pi8);function _61(_62){var _63=Math.cos(_62),_64=Math.sin(_62),p2={x:_63+(4/3)*(1-_63),y:_64-(4/3)*_63*(1-_63)/_64};return {s:{x:_63,y:-_64},c1:{x:p2.x,y:-p2.y},c2:p2,e:{x:_63,y:_64}};};var arc=g.arc={unitArcAsBezier:_61,curvePI4:_60,arcAsBezier:function(_65,rx,ry,_66,_67,_68,x,y){_67=Boolean(_67);_68=Boolean(_68);var _69=m._degToRad(_66),rx2=rx*rx,ry2=ry*ry,pa=m.multiplyPoint(m.rotate(-_69),{x:(_65.x-x)/2,y:(_65.y-y)/2}),_6a=pa.x*pa.x,_6b=pa.y*pa.y,c1=Math.sqrt((rx2*ry2-rx2*_6b-ry2*_6a)/(rx2*_6b+ry2*_6a));if(isNaN(c1)){c1=0;}var ca={x:c1*rx*pa.y/ry,y:-c1*ry*pa.x/rx};if(_67==_68){ca={x:-ca.x,y:-ca.y};}var c=m.multiplyPoint([m.translate((_65.x+x)/2,(_65.y+y)/2),m.rotate(_69)],ca);var _6c=m.normalize([m.translate(c.x,c.y),m.rotate(_69),m.scale(rx,ry)]);var _6d=m.invert(_6c),sp=m.multiplyPoint(_6d,_65),ep=m.multiplyPoint(_6d,x,y),_6e=Math.atan2(sp.y,sp.x),_6f=Math.atan2(ep.y,ep.x),_70=_6e-_6f;if(_68){_70=-_70;}if(_70<0){_70+=_5e;}else{if(_70>_5e){_70-=_5e;}}var _71=pi8,_72=_60,_73=_68?_71:-_71,_74=[];for(var _75=_70;_75>0;_75-=pi4){if(_75<_5f){_71=_75/2;_72=_61(_71);_73=_68?_71:-_71;_75=0;}var c2,e,M=m.normalize([_6c,m.rotate(_6e+_73)]);if(_68){c1=m.multiplyPoint(M,_72.c1);c2=m.multiplyPoint(M,_72.c2);e=m.multiplyPoint(M,_72.e);}else{c1=m.multiplyPoint(M,_72.c2);c2=m.multiplyPoint(M,_72.c1);e=m.multiplyPoint(M,_72.s);}_74.push([c1.x,c1.y,c2.x,c2.y,e.x,e.y]);_6e+=2*_73;}return _74;}};return arc;});},"dojox/gfx/path":function(){define("dojox/gfx/path",["./_base","dojo/_base/lang","dojo/_base/declare","./matrix","./shape"],function(g,_76,_77,_78,_79){var _7a=_77("dojox.gfx.path.Path",_79.Shape,{constructor:function(_7b){this.shape=_76.clone(g.defaultPath);this.segments=[];this.tbbox=null;this.absolute=true;this.last={};this.rawNode=_7b;this.segmented=false;},setAbsoluteMode:function(_7c){this._confirmSegmented();this.absolute=typeof _7c=="string"?(_7c=="absolute"):_7c;return this;},getAbsoluteMode:function(){this._confirmSegmented();return this.absolute;},getBoundingBox:function(){this._confirmSegmented();return (this.bbox&&("l" in this.bbox))?{x:this.bbox.l,y:this.bbox.t,width:this.bbox.r-this.bbox.l,height:this.bbox.b-this.bbox.t}:null;},_getRealBBox:function(){this._confirmSegmented();if(this.tbbox){return this.tbbox;}var _7d=this.bbox,_78=this._getRealMatrix();this.bbox=null;for(var i=0,len=this.segments.length;i<len;++i){this._updateWithSegment(this.segments[i],_78);}var t=this.bbox;this.bbox=_7d;this.tbbox=t?[{x:t.l,y:t.t},{x:t.r,y:t.t},{x:t.r,y:t.b},{x:t.l,y:t.b}]:null;return this.tbbox;},getLastPosition:function(){this._confirmSegmented();return "x" in this.last?this.last:null;},_applyTransform:function(){this.tbbox=null;return this.inherited(arguments);},_updateBBox:function(x,y,m){if(m){var t=_78.multiplyPoint(m,x,y);x=t.x;y=t.y;}if(this.bbox&&("l" in this.bbox)){if(this.bbox.l>x){this.bbox.l=x;}if(this.bbox.r<x){this.bbox.r=x;}if(this.bbox.t>y){this.bbox.t=y;}if(this.bbox.b<y){this.bbox.b=y;}}else{this.bbox={l:x,b:y,r:x,t:y};}},_updateWithSegment:function(_7e,_7f){var n=_7e.args,l=n.length,i;switch(_7e.action){case "M":case "L":case "C":case "S":case "Q":case "T":for(i=0;i<l;i+=2){this._updateBBox(n[i],n[i+1],_7f);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "H":for(i=0;i<l;++i){this._updateBBox(n[i],this.last.y,_7f);}this.last.x=n[l-1];this.absolute=true;break;case "V":for(i=0;i<l;++i){this._updateBBox(this.last.x,n[i],_7f);}this.last.y=n[l-1];this.absolute=true;break;case "m":var _80=0;if(!("x" in this.last)){this._updateBBox(this.last.x=n[0],this.last.y=n[1],_7f);_80=2;}for(i=_80;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_7f);}this.absolute=false;break;case "l":case "t":for(i=0;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_7f);}this.absolute=false;break;case "h":for(i=0;i<l;++i){this._updateBBox(this.last.x+=n[i],this.last.y,_7f);}this.absolute=false;break;case "v":for(i=0;i<l;++i){this._updateBBox(this.last.x,this.last.y+=n[i],_7f);}this.absolute=false;break;case "c":for(i=0;i<l;i+=6){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_7f);this._updateBBox(this.last.x+n[i+2],this.last.y+n[i+3],_7f);this._updateBBox(this.last.x+=n[i+4],this.last.y+=n[i+5],_7f);}this.absolute=false;break;case "s":case "q":for(i=0;i<l;i+=4){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_7f);this._updateBBox(this.last.x+=n[i+2],this.last.y+=n[i+3],_7f);}this.absolute=false;break;case "A":for(i=0;i<l;i+=7){this._updateBBox(n[i+5],n[i+6],_7f);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "a":for(i=0;i<l;i+=7){this._updateBBox(this.last.x+=n[i+5],this.last.y+=n[i+6],_7f);}this.absolute=false;break;}var _81=[_7e.action];for(i=0;i<l;++i){_81.push(g.formatNumber(n[i],true));}if(typeof this.shape.path=="string"){this.shape.path+=_81.join("");}else{Array.prototype.push.apply(this.shape.path,_81);}},_validSegments:{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7,z:0},_pushSegment:function(_82,_83){this.tbbox=null;var _84=this._validSegments[_82.toLowerCase()],_85;if(typeof _84=="number"){if(_84){if(_83.length>=_84){_85={action:_82,args:_83.slice(0,_83.length-_83.length%_84)};this.segments.push(_85);this._updateWithSegment(_85);}}else{_85={action:_82,args:[]};this.segments.push(_85);this._updateWithSegment(_85);}}},_collectArgs:function(_86,_87){for(var i=0;i<_87.length;++i){var t=_87[i];if(typeof t=="boolean"){_86.push(t?1:0);}else{if(typeof t=="number"){_86.push(t);}else{if(t instanceof Array){this._collectArgs(_86,t);}else{if("x" in t&&"y" in t){_86.push(t.x,t.y);}}}}}},moveTo:function(){this._confirmSegmented();var _88=[];this._collectArgs(_88,arguments);this._pushSegment(this.absolute?"M":"m",_88);return this;},lineTo:function(){this._confirmSegmented();var _89=[];this._collectArgs(_89,arguments);this._pushSegment(this.absolute?"L":"l",_89);return this;},hLineTo:function(){this._confirmSegmented();var _8a=[];this._collectArgs(_8a,arguments);this._pushSegment(this.absolute?"H":"h",_8a);return this;},vLineTo:function(){this._confirmSegmented();var _8b=[];this._collectArgs(_8b,arguments);this._pushSegment(this.absolute?"V":"v",_8b);return this;},curveTo:function(){this._confirmSegmented();var _8c=[];this._collectArgs(_8c,arguments);this._pushSegment(this.absolute?"C":"c",_8c);return this;},smoothCurveTo:function(){this._confirmSegmented();var _8d=[];this._collectArgs(_8d,arguments);this._pushSegment(this.absolute?"S":"s",_8d);return this;},qCurveTo:function(){this._confirmSegmented();var _8e=[];this._collectArgs(_8e,arguments);this._pushSegment(this.absolute?"Q":"q",_8e);return this;},qSmoothCurveTo:function(){this._confirmSegmented();var _8f=[];this._collectArgs(_8f,arguments);this._pushSegment(this.absolute?"T":"t",_8f);return this;},arcTo:function(){this._confirmSegmented();var _90=[];this._collectArgs(_90,arguments);this._pushSegment(this.absolute?"A":"a",_90);return this;},closePath:function(){this._confirmSegmented();this._pushSegment("Z",[]);return this;},_confirmSegmented:function(){if(!this.segmented){var _91=this.shape.path;this.shape.path=[];this._setPath(_91);this.shape.path=this.shape.path.join("");this.segmented=true;}},_setPath:function(_92){var p=_76.isArray(_92)?_92:_92.match(g.pathSvgRegExp);this.segments=[];this.absolute=true;this.bbox={};this.last={};if(!p){return;}var _93="",_94=[],l=p.length;for(var i=0;i<l;++i){var t=p[i],x=parseFloat(t);if(isNaN(x)){if(_93){this._pushSegment(_93,_94);}_94=[];_93=t;}else{_94.push(x);}}this._pushSegment(_93,_94);},setShape:function(_95){this.inherited(arguments,[typeof _95=="string"?{path:_95}:_95]);this.segmented=false;this.segments=[];if(!g.lazyPathSegmentation){this._confirmSegmented();}return this;},_2PI:Math.PI*2});var _96=_77("dojox.gfx.path.TextPath",_7a,{constructor:function(_97){if(!("text" in this)){this.text=_76.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=_76.clone(g.defaultFont);}},getText:function(){return this.text;},setText:function(_98){this.text=g.makeParameters(this.text,typeof _98=="string"?{text:_98}:_98);this._setText();return this;},getFont:function(){return this.fontStyle;},setFont:function(_99){this.fontStyle=typeof _99=="string"?g.splitFontString(_99):g.makeParameters(g.defaultFont,_99);this._setFont();return this;}});return g.path={Path:_7a,TextPath:_96};});},"*noref":1}});define("dojox/gfx/canvas",["./_base","dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/window","dojo/dom-geometry","dojo/dom","./_base","./shape","./path","./arc","./matrix","./decompose"],function(g,_9a,arr,_9b,win,_9c,dom,_9d,gs,_9e,ga,m,_9f){var _a0=g.canvas={};var _a1=null,mp=m.multiplyPoint,pi=Math.PI,_a2=2*pi,_a3=pi/2,_a4=_9a.extend;_a0.Shape=_9b("dojox.gfx.canvas.Shape",gs.Shape,{_render:function(ctx){ctx.save();this._renderTransform(ctx);this._renderClip(ctx);this._renderShape(ctx);this._renderFill(ctx,true);this._renderStroke(ctx,true);ctx.restore();},_renderClip:function(ctx){if(this.canvasClip){this.canvasClip.render(ctx);ctx.clip();}},_renderTransform:function(ctx){if("canvasTransform" in this){var t=this.canvasTransform;ctx.translate(t.dx,t.dy);ctx.rotate(t.angle2);ctx.scale(t.sx,t.sy);ctx.rotate(t.angle1);}},_renderShape:function(ctx){},_renderFill:function(ctx,_a5){if("canvasFill" in this){var fs=this.fillStyle;if("canvasFillImage" in this){var w=fs.width,h=fs.height,iw=this.canvasFillImage.width,ih=this.canvasFillImage.height,sx=w==iw?1:w/iw,sy=h==ih?1:h/ih,s=Math.min(sx,sy),dx=(w-s*iw)/2,dy=(h-s*ih)/2;_a1.width=w;_a1.height=h;var _a6=_a1.getContext("2d");_a6.clearRect(0,0,w,h);_a6.drawImage(this.canvasFillImage,0,0,iw,ih,dx,dy,s*iw,s*ih);this.canvasFill=ctx.createPattern(_a1,"repeat");delete this.canvasFillImage;}ctx.fillStyle=this.canvasFill;if(_a5){if(fs.type==="pattern"&&(fs.x!==0||fs.y!==0)){ctx.translate(fs.x,fs.y);}ctx.fill();}}else{ctx.fillStyle="rgba(0,0,0,0.0)";}},_renderStroke:function(ctx,_a7){var s=this.strokeStyle;if(s){ctx.strokeStyle=s.color.toString();ctx.lineWidth=s.width;ctx.lineCap=s.cap;if(typeof s.join=="number"){ctx.lineJoin="miter";ctx.miterLimit=s.join;}else{ctx.lineJoin=s.join;}if(_a7){ctx.stroke();}}else{if(!_a7){ctx.strokeStyle="rgba(0,0,0,0.0)";}}},getEventSource:function(){return null;},connect:function(){},disconnect:function(){},canvasClip:null,setClip:function(_a8){this.inherited(arguments);var _a9=_a8?"width" in _a8?"rect":"cx" in _a8?"ellipse":"points" in _a8?"polyline":"d" in _a8?"path":null:null;if(_a8&&!_a9){return this;}this.canvasClip=_a8?_aa(_a9,_a8):null;this.surface.makeDirty();return this;}});var _aa=function(_ab,_ac){switch(_ab){case "ellipse":return {canvasEllipse:_ad(_ac),render:function(ctx){return _a0.Ellipse.prototype._renderShape.call(this,ctx);}};case "rect":return {shape:_9a.delegate(_ac,{r:0}),render:function(ctx){return _a0.Rect.prototype._renderShape.call(this,ctx);}};case "path":return {canvasPath:_ae(_ac),render:function(ctx){this.canvasPath._renderShape(ctx);}};case "polyline":return {canvasPolyline:_ac.points,render:function(ctx){return _a0.Polyline.prototype._renderShape.call(this,ctx);}};}return null;};var _ae=function(geo){var p=new dojox.gfx.canvas.Path();p.canvasPath=[];p._setPath(geo.d);return p;};var _af=function(_b0,_b1,_b2){var old=_b0.prototype[_b1];_b0.prototype[_b1]=_b2?function(){this.surface.makeDirty();old.apply(this,arguments);_b2.call(this);return this;}:function(){this.surface.makeDirty();return old.apply(this,arguments);};};_af(_a0.Shape,"setTransform",function(){if(this.matrix){this.canvasTransform=g.decompose(this.matrix);}else{delete this.canvasTransform;}});_af(_a0.Shape,"setFill",function(){var fs=this.fillStyle,f;if(fs){if(typeof (fs)=="object"&&"type" in fs){var ctx=this.surface.rawNode.getContext("2d");switch(fs.type){case "linear":case "radial":f=fs.type=="linear"?ctx.createLinearGradient(fs.x1,fs.y1,fs.x2,fs.y2):ctx.createRadialGradient(fs.cx,fs.cy,0,fs.cx,fs.cy,fs.r);arr.forEach(fs.colors,function(_b3){f.addColorStop(_b3.offset,g.normalizeColor(_b3.color).toString());});break;case "pattern":if(!_a1){_a1=document.createElement("canvas");}var img=new Image();this.surface.downloadImage(img,fs.src);this.canvasFillImage=img;}}else{f=fs.toString();}this.canvasFill=f;}else{delete this.canvasFill;}});_af(_a0.Shape,"setStroke");_af(_a0.Shape,"setShape");_a0.Group=_9b("dojox.gfx.canvas.Group",_a0.Shape,{constructor:function(){gs.Container._init.call(this);},_render:function(ctx){ctx.save();this._renderTransform(ctx);this._renderClip(ctx);for(var i=0;i<this.children.length;++i){this.children[i]._render(ctx);}ctx.restore();},destroy:function(){this.clear(true);_a0.Shape.prototype.destroy.apply(this,arguments);}});_a0.Rect=_9b("dojox.gfx.canvas.Rect",[_a0.Shape,gs.Rect],{_renderShape:function(ctx){var s=this.shape,r=Math.min(s.r,s.height/2,s.width/2),xl=s.x,xr=xl+s.width,yt=s.y,yb=yt+s.height,xl2=xl+r,xr2=xr-r,yt2=yt+r,yb2=yb-r;ctx.beginPath();ctx.moveTo(xl2,yt);if(r){ctx.arc(xr2,yt2,r,-_a3,0,false);ctx.arc(xr2,yb2,r,0,_a3,false);ctx.arc(xl2,yb2,r,_a3,pi,false);ctx.arc(xl2,yt2,r,pi,pi+_a3,false);}else{ctx.lineTo(xr2,yt);ctx.lineTo(xr,yb2);ctx.lineTo(xl2,yb);ctx.lineTo(xl,yt2);}ctx.closePath();}});var _b4=[];(function(){var u=ga.curvePI4;_b4.push(u.s,u.c1,u.c2,u.e);for(var a=45;a<360;a+=45){var r=m.rotateg(a);_b4.push(mp(r,u.c1),mp(r,u.c2),mp(r,u.e));}})();var _ad=function(s){var t,c1,c2,r=[],M=m.normalize([m.translate(s.cx,s.cy),m.scale(s.rx,s.ry)]);t=mp(M,_b4[0]);r.push([t.x,t.y]);for(var i=1;i<_b4.length;i+=3){c1=mp(M,_b4[i]);c2=mp(M,_b4[i+1]);t=mp(M,_b4[i+2]);r.push([c1.x,c1.y,c2.x,c2.y,t.x,t.y]);}return r;};_a0.Ellipse=_9b("dojox.gfx.canvas.Ellipse",[_a0.Shape,gs.Ellipse],{setShape:function(){this.inherited(arguments);this.canvasEllipse=_ad(this.shape);return this;},_renderShape:function(ctx){var r=this.canvasEllipse;ctx.beginPath();ctx.moveTo.apply(ctx,r[0]);for(var i=1;i<r.length;++i){ctx.bezierCurveTo.apply(ctx,r[i]);}ctx.closePath();}});_a0.Circle=_9b("dojox.gfx.canvas.Circle",[_a0.Shape,gs.Circle],{_renderShape:function(ctx){var s=this.shape;ctx.beginPath();ctx.arc(s.cx,s.cy,s.r,0,_a2,1);}});_a0.Line=_9b("dojox.gfx.canvas.Line",[_a0.Shape,gs.Line],{_renderShape:function(ctx){var s=this.shape;ctx.beginPath();ctx.moveTo(s.x1,s.y1);ctx.lineTo(s.x2,s.y2);}});_a0.Polyline=_9b("dojox.gfx.canvas.Polyline",[_a0.Shape,gs.Polyline],{setShape:function(){this.inherited(arguments);var p=this.shape.points,f=p[0],r,c,i;this.bbox=null;this._normalizePoints();if(p.length){if(typeof f=="number"){r=p;}else{r=[];for(i=0;i<p.length;++i){c=p[i];r.push(c.x,c.y);}}}else{r=[];}this.canvasPolyline=r;return this;},_renderShape:function(ctx){var p=this.canvasPolyline;if(p.length){ctx.beginPath();ctx.moveTo(p[0],p[1]);for(var i=2;i<p.length;i+=2){ctx.lineTo(p[i],p[i+1]);}}}});_a0.Image=_9b("dojox.gfx.canvas.Image",[_a0.Shape,gs.Image],{setShape:function(){this.inherited(arguments);var img=new Image();this.surface.downloadImage(img,this.shape.src);this.canvasImage=img;return this;},_renderShape:function(ctx){var s=this.shape;ctx.drawImage(this.canvasImage,s.x,s.y,s.width,s.height);}});_a0.Text=_9b("dojox.gfx.canvas.Text",[_a0.Shape,gs.Text],{_setFont:function(){if(this.fontStyle){this.canvasFont=g.makeFontString(this.fontStyle);}else{delete this.canvasFont;}},getTextWidth:function(){var s=this.shape,w=0,ctx;if(s.text&&s.text.length>0){ctx=this.surface.rawNode.getContext("2d");ctx.save();this._renderTransform(ctx);this._renderFill(ctx,false);this._renderStroke(ctx,false);if(this.canvasFont){ctx.font=this.canvasFont;}w=ctx.measureText(s.text).width;ctx.restore();}return w;},_render:function(ctx){ctx.save();this._renderTransform(ctx);this._renderFill(ctx,false);this._renderStroke(ctx,false);this._renderShape(ctx);ctx.restore();},_renderShape:function(ctx){var ta,s=this.shape;if(!s.text||s.text.length==0){return;}ta=s.align==="middle"?"center":s.align;ctx.textAlign=ta;if(this.canvasFont){ctx.font=this.canvasFont;}if(this.canvasFill){ctx.fillText(s.text,s.x,s.y);}if(this.strokeStyle){ctx.beginPath();ctx.strokeText(s.text,s.x,s.y);ctx.closePath();}}});_af(_a0.Text,"setFont");if(win.global.CanvasRenderingContext2D){var _b5=win.doc.createElement("canvas").getContext("2d");if(_b5&&typeof _b5.fillText!="function"){_a0.Text.extend({getTextWidth:function(){return 0;},_renderShape:function(){}});}}var _b6={M:"_moveToA",m:"_moveToR",L:"_lineToA",l:"_lineToR",H:"_hLineToA",h:"_hLineToR",V:"_vLineToA",v:"_vLineToR",C:"_curveToA",c:"_curveToR",S:"_smoothCurveToA",s:"_smoothCurveToR",Q:"_qCurveToA",q:"_qCurveToR",T:"_qSmoothCurveToA",t:"_qSmoothCurveToR",A:"_arcTo",a:"_arcTo",Z:"_closePath",z:"_closePath"};_a0.Path=_9b("dojox.gfx.canvas.Path",[_a0.Shape,_9e.Path],{constructor:function(){this.lastControl={};},setShape:function(){this.canvasPath=[];return this.inherited(arguments);},_updateWithSegment:function(_b7){var _b8=_9a.clone(this.last);this[_b6[_b7.action]](this.canvasPath,_b7.action,_b7.args);this.last=_b8;this.inherited(arguments);},_renderShape:function(ctx){var r=this.canvasPath;ctx.beginPath();for(var i=0;i<r.length;i+=2){ctx[r[i]].apply(ctx,r[i+1]);}},_moveToA:function(_b9,_ba,_bb){_b9.push("moveTo",[_bb[0],_bb[1]]);for(var i=2;i<_bb.length;i+=2){_b9.push("lineTo",[_bb[i],_bb[i+1]]);}this.last.x=_bb[_bb.length-2];this.last.y=_bb[_bb.length-1];this.lastControl={};},_moveToR:function(_bc,_bd,_be){if("x" in this.last){_bc.push("moveTo",[this.last.x+=_be[0],this.last.y+=_be[1]]);}else{_bc.push("moveTo",[this.last.x=_be[0],this.last.y=_be[1]]);}for(var i=2;i<_be.length;i+=2){_bc.push("lineTo",[this.last.x+=_be[i],this.last.y+=_be[i+1]]);}this.lastControl={};},_lineToA:function(_bf,_c0,_c1){for(var i=0;i<_c1.length;i+=2){_bf.push("lineTo",[_c1[i],_c1[i+1]]);}this.last.x=_c1[_c1.length-2];this.last.y=_c1[_c1.length-1];this.lastControl={};},_lineToR:function(_c2,_c3,_c4){for(var i=0;i<_c4.length;i+=2){_c2.push("lineTo",[this.last.x+=_c4[i],this.last.y+=_c4[i+1]]);}this.lastControl={};},_hLineToA:function(_c5,_c6,_c7){for(var i=0;i<_c7.length;++i){_c5.push("lineTo",[_c7[i],this.last.y]);}this.last.x=_c7[_c7.length-1];this.lastControl={};},_hLineToR:function(_c8,_c9,_ca){for(var i=0;i<_ca.length;++i){_c8.push("lineTo",[this.last.x+=_ca[i],this.last.y]);}this.lastControl={};},_vLineToA:function(_cb,_cc,_cd){for(var i=0;i<_cd.length;++i){_cb.push("lineTo",[this.last.x,_cd[i]]);}this.last.y=_cd[_cd.length-1];this.lastControl={};},_vLineToR:function(_ce,_cf,_d0){for(var i=0;i<_d0.length;++i){_ce.push("lineTo",[this.last.x,this.last.y+=_d0[i]]);}this.lastControl={};},_curveToA:function(_d1,_d2,_d3){for(var i=0;i<_d3.length;i+=6){_d1.push("bezierCurveTo",_d3.slice(i,i+6));}this.last.x=_d3[_d3.length-2];this.last.y=_d3[_d3.length-1];this.lastControl.x=_d3[_d3.length-4];this.lastControl.y=_d3[_d3.length-3];this.lastControl.type="C";},_curveToR:function(_d4,_d5,_d6){for(var i=0;i<_d6.length;i+=6){_d4.push("bezierCurveTo",[this.last.x+_d6[i],this.last.y+_d6[i+1],this.lastControl.x=this.last.x+_d6[i+2],this.lastControl.y=this.last.y+_d6[i+3],this.last.x+_d6[i+4],this.last.y+_d6[i+5]]);this.last.x+=_d6[i+4];this.last.y+=_d6[i+5];}this.lastControl.type="C";},_smoothCurveToA:function(_d7,_d8,_d9){for(var i=0;i<_d9.length;i+=4){var _da=this.lastControl.type=="C";_d7.push("bezierCurveTo",[_da?2*this.last.x-this.lastControl.x:this.last.x,_da?2*this.last.y-this.lastControl.y:this.last.y,_d9[i],_d9[i+1],_d9[i+2],_d9[i+3]]);this.lastControl.x=_d9[i];this.lastControl.y=_d9[i+1];this.lastControl.type="C";}this.last.x=_d9[_d9.length-2];this.last.y=_d9[_d9.length-1];},_smoothCurveToR:function(_db,_dc,_dd){for(var i=0;i<_dd.length;i+=4){var _de=this.lastControl.type=="C";_db.push("bezierCurveTo",[_de?2*this.last.x-this.lastControl.x:this.last.x,_de?2*this.last.y-this.lastControl.y:this.last.y,this.last.x+_dd[i],this.last.y+_dd[i+1],this.last.x+_dd[i+2],this.last.y+_dd[i+3]]);this.lastControl.x=this.last.x+_dd[i];this.lastControl.y=this.last.y+_dd[i+1];this.lastControl.type="C";this.last.x+=_dd[i+2];this.last.y+=_dd[i+3];}},_qCurveToA:function(_df,_e0,_e1){for(var i=0;i<_e1.length;i+=4){_df.push("quadraticCurveTo",_e1.slice(i,i+4));}this.last.x=_e1[_e1.length-2];this.last.y=_e1[_e1.length-1];this.lastControl.x=_e1[_e1.length-4];this.lastControl.y=_e1[_e1.length-3];this.lastControl.type="Q";},_qCurveToR:function(_e2,_e3,_e4){for(var i=0;i<_e4.length;i+=4){_e2.push("quadraticCurveTo",[this.lastControl.x=this.last.x+_e4[i],this.lastControl.y=this.last.y+_e4[i+1],this.last.x+_e4[i+2],this.last.y+_e4[i+3]]);this.last.x+=_e4[i+2];this.last.y+=_e4[i+3];}this.lastControl.type="Q";},_qSmoothCurveToA:function(_e5,_e6,_e7){for(var i=0;i<_e7.length;i+=2){var _e8=this.lastControl.type=="Q";_e5.push("quadraticCurveTo",[this.lastControl.x=_e8?2*this.last.x-this.lastControl.x:this.last.x,this.lastControl.y=_e8?2*this.last.y-this.lastControl.y:this.last.y,_e7[i],_e7[i+1]]);this.lastControl.type="Q";}this.last.x=_e7[_e7.length-2];this.last.y=_e7[_e7.length-1];},_qSmoothCurveToR:function(_e9,_ea,_eb){for(var i=0;i<_eb.length;i+=2){var _ec=this.lastControl.type=="Q";_e9.push("quadraticCurveTo",[this.lastControl.x=_ec?2*this.last.x-this.lastControl.x:this.last.x,this.lastControl.y=_ec?2*this.last.y-this.lastControl.y:this.last.y,this.last.x+_eb[i],this.last.y+_eb[i+1]]);this.lastControl.type="Q";this.last.x+=_eb[i];this.last.y+=_eb[i+1];}},_arcTo:function(_ed,_ee,_ef){var _f0=_ee=="a";for(var i=0;i<_ef.length;i+=7){var x1=_ef[i+5],y1=_ef[i+6];if(_f0){x1+=this.last.x;y1+=this.last.y;}var _f1=ga.arcAsBezier(this.last,_ef[i],_ef[i+1],_ef[i+2],_ef[i+3]?1:0,_ef[i+4]?1:0,x1,y1);arr.forEach(_f1,function(p){_ed.push("bezierCurveTo",p);});this.last.x=x1;this.last.y=y1;}this.lastControl={};},_closePath:function(_f2,_f3,_f4){_f2.push("closePath",[]);this.lastControl={};}});arr.forEach(["moveTo","lineTo","hLineTo","vLineTo","curveTo","smoothCurveTo","qCurveTo","qSmoothCurveTo","arcTo","closePath"],function(_f5){_af(_a0.Path,_f5);});_a0.TextPath=_9b("dojox.gfx.canvas.TextPath",[_a0.Shape,_9e.TextPath],{_renderShape:function(ctx){var s=this.shape;},_setText:function(){},_setFont:function(){}});_a0.Surface=_9b("dojox.gfx.canvas.Surface",gs.Surface,{constructor:function(){gs.Container._init.call(this);this.pendingImageCount=0;this.makeDirty();},destroy:function(){gs.Container.clear.call(this,true);this.inherited(arguments);},setDimensions:function(_f6,_f7){this.width=g.normalizedLength(_f6);this.height=g.normalizedLength(_f7);if(!this.rawNode){return this;}var _f8=false;if(this.rawNode.width!=this.width){this.rawNode.width=this.width;_f8=true;}if(this.rawNode.height!=this.height){this.rawNode.height=this.height;_f8=true;}if(_f8){this.makeDirty();}return this;},getDimensions:function(){return this.rawNode?{width:this.rawNode.width,height:this.rawNode.height}:null;},_render:function(_f9){if(!_f9&&this.pendingImageCount){return;}var ctx=this.rawNode.getContext("2d");ctx.clearRect(0,0,this.rawNode.width,this.rawNode.height);this.render(ctx);if("pendingRender" in this){clearTimeout(this.pendingRender);delete this.pendingRender;}},render:function(ctx){ctx.save();for(var i=0;i<this.children.length;++i){this.children[i]._render(ctx);}ctx.restore();},makeDirty:function(){if(!this.pendingImagesCount&&!("pendingRender" in this)){this.pendingRender=setTimeout(_9a.hitch(this,this._render),0);}},downloadImage:function(img,url){var _fa=_9a.hitch(this,this.onImageLoad);if(!this.pendingImageCount++&&"pendingRender" in this){clearTimeout(this.pendingRender);delete this.pendingRender;}img.onload=_fa;img.onerror=_fa;img.onabort=_fa;img.src=url;},onImageLoad:function(){if(!--this.pendingImageCount){this.onImagesLoaded();this._render();}},onImagesLoaded:function(){},getEventSource:function(){return null;},connect:function(){},disconnect:function(){}});_a0.createSurface=function(_fb,_fc,_fd){if(!_fc&&!_fd){var pos=_9c.position(_fb);_fc=_fc||pos.w;_fd=_fd||pos.h;}if(typeof _fc=="number"){_fc=_fc+"px";}if(typeof _fd=="number"){_fd=_fd+"px";}var s=new _a0.Surface(),p=dom.byId(_fb),c=p.ownerDocument.createElement("canvas");c.width=g.normalizedLength(_fc);c.height=g.normalizedLength(_fd);p.appendChild(c);s.rawNode=c;s._parent=p;s.surface=s;return s;};var C=gs.Container,_fe={add:function(_ff){this.surface.makeDirty();return C.add.apply(this,arguments);},remove:function(_100,_101){this.surface.makeDirty();return C.remove.apply(this,arguments);},clear:function(){this.surface.makeDirty();return C.clear.apply(this,arguments);},getBoundingBox:C.getBoundingBox,_moveChildToFront:function(_102){this.surface.makeDirty();return C._moveChildToFront.apply(this,arguments);},_moveChildToBack:function(_103){this.surface.makeDirty();return C._moveChildToBack.apply(this,arguments);}};var _104={createObject:function(_105,_106){var _107=new _105();_107.surface=this.surface;_107.setShape(_106);this.add(_107);return _107;}};_a4(_a0.Group,_fe);_a4(_a0.Group,gs.Creator);_a4(_a0.Group,_104);_a4(_a0.Surface,_fe);_a4(_a0.Surface,gs.Creator);_a4(_a0.Surface,_104);_a0.fixTarget=function(_108,_109){return true;};return _a0;});