/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.spring;

import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

public class BaseController
extends BaseLogger {
    protected final String RESULT = "result";

    @ExceptionHandler(value={JSONMessageException.class})
    @ResponseBody
    public Map<String, ?> handlerJSONException(Exception e, HttpServletRequest request) {
        this.logger.error(e.getLocalizedMessage());
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", e.getLocalizedMessage());
        return result;
    }

    protected void sendFile(File file, HttpServletResponse response) throws IOException {
        if (file == null || response == null) {
            return;
        }
        if (file.exists()) {
            response.setDateHeader("Last-Modified", file.lastModified());
            response.setContentLength((int)file.length());
            FileCopyUtils.copy((InputStream)new FileInputStream(file), (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "request file not found");
        }
    }

    protected void sendFile(InputStream inputStream, HttpServletResponse response, String fileName) throws IOException {
        if (inputStream == null || response == null) {
            return;
        }
        if (inputStream.available() > 0) {
            response.addHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.setDateHeader("Last-Modified", new Date().getTime());
            response.setContentLength(inputStream.available());
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        } else {
            response.sendError(404, "request file not found");
        }
    }

    protected Map<String, Object> result(Object value) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", value);
        return result;
    }

    protected void error(String info, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("success", false);
        result.put("msg", info);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    protected void result(Object value, HttpServletResponse response) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", value);
        try {
            response.getWriter().write(JSON.toJSONString(result));
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }
}

