/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.Constant;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.GISService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.SDEManager;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GISManagerImpl
extends BaseLogger
implements GISManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private GISService service;
    @Autowired
    private SDEManager sdeManager;
    @Autowired
    private GeometryService geometryService;

    @PostConstruct
    private void initSpatialEngine() {
        try {
            Constant.SpatialType type = Constant.SpatialType.valueOf((String)((String)AppPropertyUtils.getAppEnv((String)"spatial.engine")));
            this.service.initialize(type);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("spatialengine.init.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public GISService getGISService() {
        return this.service;
    }

    public SDEManager getSdeManager() {
        return this.sdeManager;
    }

    public GeometryService getGeoService() {
        return this.geometryService;
    }
}

