/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.DocumentServiceImpl;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.Assert;

public class DocumentServiceImpl
extends BaseLogger
implements DocumentService {
    private static final String START_MARK = "[$]";
    private String location;

    public List<List> readExcel(InputStream inputStream) {
        Assert.notNull((Object)inputStream, (String)this.getMessage("doc.is.not.null", new Object[0]));
        ArrayList<List> content = new ArrayList<List>();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheetAt(0);
            ArrayList<Object> item = null;
            for (Row row : sheet) {
                item = new ArrayList<Object>();
                for (Cell cell : row) {
                    switch (cell.getCellType()) {
                        case 1: {
                            item.add(cell.getStringCellValue());
                            break;
                        }
                        case 4: {
                            item.add(cell.getBooleanCellValue());
                            break;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                item.add(cell.getDateCellValue());
                                break;
                            }
                            item.add(cell.getNumericCellValue());
                            break;
                        }
                        case 2: {
                            item.add(cell.getCellFormula());
                            break;
                        }
                    }
                }
                content.add(item);
            }
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.read.excle.error", new Object[]{e.getLocalizedMessage()}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.excle.format.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public Document writeExcel(Map<String, List> data, String tplName) {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            for (Map.Entry<String, List> entry : data.entrySet()) {
                String sheetName = entry.getKey();
                List values = entry.getValue();
                Sheet sheet = workbook.getSheet(sheetName);
                if (this.isNull((Object)sheet)) {
                    throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[]{sheetName}));
                }
                int rowIndex = -1;
                CellStyle cellStyle = null;
                for (Row row : sheet) {
                    Cell start = row.getCell(0);
                    if (this.isNull((Object)start) || !START_MARK.equals(start.getStringCellValue())) continue;
                    rowIndex = start.getRowIndex();
                    cellStyle = start.getCellStyle();
                    break;
                }
                if (rowIndex == -1) {
                    throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
                }
                Row row = null;
                Cell cell = null;
                for (int i = 0; i < values.size(); ++i) {
                    row = sheet.createRow(i + rowIndex);
                    List columns = (List)values.get(i);
                    for (int cIndex = 0; cIndex < columns.size(); ++cIndex) {
                        cell = row.createCell(cIndex);
                        cell.setCellStyle(cellStyle);
                        Object value = columns.get(cIndex);
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                            continue;
                        }
                        cell.setCellValue(String.valueOf(value));
                    }
                }
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.write((OutputStream)out);
                document.setContent(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return document;
    }

    public Document writeExcel(List<Map> data) throws Exception {
        Document document = new Document(Tag.result.name(), Document.Type.xlsx);
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (Map item : data) {
            String sheetName = this.isNull(item.get(Tag.name.name())) ? "Sheet" + data.indexOf(item) : String.valueOf(item.get(Tag.name.name()));
            Sheet sheet = workbook.createSheet(sheetName);
            Row row = sheet.createRow(0);
            List header = (List)item.get(Tag.header.name());
            for (int i = 0; i < header.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue((String)header.get(i));
            }
            List values = (List)item.get(Tag.data.name());
            for (int rowIndex = 0; rowIndex < values.size(); ++rowIndex) {
                row = sheet.createRow(rowIndex + 1);
                List value = (List)values.get(rowIndex);
                for (int colIndex = 0; colIndex < value.size(); ++colIndex) {
                    Cell cell = row.createCell(colIndex);
                    cell.setCellValue(String.valueOf(value.get(colIndex)));
                }
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            document.setContent(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
        }
        return document;
    }

    public Document writeExcelGZQFX(List<Map> data, String tplName) throws Exception {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            Sheet sheet = workbook.getSheetAt(0);
            if (this.isNull((Object)sheet)) {
                throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[0]));
            }
            CellStyle cellStyle = null;
            int rowIndex = -1;
            for (Row row : sheet) {
                Cell start = row.getCell(0);
                if (this.isNull((Object)start) || !START_MARK.equals(start.getStringCellValue())) continue;
                rowIndex = start.getRowIndex();
                cellStyle = start.getCellStyle();
                break;
            }
            for (Map map : data) {
                String gzqType = String.valueOf(map.get("type"));
                List values = (List)map.get("value");
                if (rowIndex == -1) {
                    throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
                }
                Row row = null;
                Cell cell = null;
                int mergeStartRowIndex = rowIndex;
                for (int i = 0; i < values.size(); ++i) {
                    row = sheet.createRow(i + rowIndex);
                    List columns = (List)values.get(i);
                    cell = row.createCell(0);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(gzqType);
                    for (int cIndex = 0; cIndex < columns.size(); ++cIndex) {
                        cell = row.createCell(cIndex);
                        cell.setCellStyle(cellStyle);
                        Object value = columns.get(cIndex);
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                            continue;
                        }
                        cell.setCellValue(String.valueOf(value));
                    }
                }
                sheet.addMergedRegion(new CellRangeAddress(mergeStartRowIndex, rowIndex += values.size(), 0, 0));
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.write((OutputStream)out);
                document.setContent(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Document> readZip(InputStream inputStream) throws Exception {
        assert (inputStream != null) : this.getMessage("doc.zip.is.notnull", new Object[0]);
        ArrayList<Document> documents = new ArrayList<Document>();
        ZipInputStream zip = new ZipInputStream(inputStream);
        ZipEntry entry = null;
        ByteArrayOutputStream bos = null;
        try {
            inputStream.mark(inputStream.available());
            while ((entry = zip.getNextEntry()) != null) {
                this.logger.debug(" zip entity name : {} ", (Object)entry.getName());
                try {
                    Document document = Document.getDocByName((String)entry.getName());
                    bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zip, (OutputStream)bos);
                    documents.add(document.setContent(bos.toByteArray()));
                    zip.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(this.getMessage("doc.zip.entity.error", new Object[]{entry.getName(), e.getLocalizedMessage()}));
                    return documents;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.zip.error", new Object[]{e.getLocalizedMessage()}));
        }
        finally {
            inputStream.reset();
        }
    }

    public List<Document> readZipFile(File file) {
        assert (file != null) : this.getMessage("doc.zip.is.notnull", new Object[0]);
        ArrayList<Document> documents = new ArrayList<Document>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String entryName = entry.getName().trim();
                if (!entryName.endsWith(".txt") && !entryName.endsWith(".xml")) continue;
                Document document = Document.getDocByName((String)entry.getName());
                InputStream inputStream = null;
                try {
                    inputStream = zipFile.getInputStream(entry);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
                    document.setContent(bos.toByteArray());
                    documents.add(document);
                }
                catch (IOException e) {
                    throw new RuntimeException(this.getMessage("doc.zip.entity.error", new Object[]{entry.getName(), e.getLocalizedMessage()}));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.zip.error", new Object[]{e.getLocalizedMessage()}));
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return documents;
    }

    public List<Document> readArchive(InputStream inputStream) {
        return null;
    }

    private InputStream getExcel(Document doc) throws IOException {
        try {
            return this.getDocResorce(doc.getFileName()).getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.not.found", new Object[]{doc.getFileName()}));
        }
    }

    private Resource getDocResorce(String docName) throws MalformedURLException {
        return new UrlResource(this.location.concat(docName));
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

