/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.dao.DbInfoDao;
import cn.gtmap.onemap.platform.dao.FwqInfoDao;
import cn.gtmap.onemap.platform.dao.MetaDataDao;
import cn.gtmap.onemap.platform.dao.SJGLDao;
import cn.gtmap.onemap.platform.dao.TableSpaceDao;
import cn.gtmap.onemap.platform.dao.YGJCDao;
import cn.gtmap.onemap.platform.dao.YSJDao;
import cn.gtmap.onemap.platform.entity.DbInfo;
import cn.gtmap.onemap.platform.entity.FwqInfo;
import cn.gtmap.onemap.platform.entity.MetaData;
import cn.gtmap.onemap.platform.entity.TableSpaceInfo;
import cn.gtmap.onemap.platform.entity.YGJC;
import cn.gtmap.onemap.platform.entity.YSJ;
import cn.gtmap.onemap.platform.service.DbResService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DbResServiceImpl
extends BaseLogger
implements DbResService {
    @Autowired
    private MetaDataDao metaDataDao;
    @Autowired
    private FwqInfoDao fwqInfoDao;
    @Autowired
    private DbInfoDao dbInfoDao;
    @Autowired
    private SJGLDao sjglDao;
    @Autowired
    private YSJDao ysjDao;
    @Autowired
    private YGJCDao ygjcDao;
    @Autowired
    private TableSpaceDao tableSpaceDao;

    public List<MetaData> getMetaDataByBkjmc(String bkjmc) {
        List list = this.metaDataDao.findByBkjmc(bkjmc);
        return list;
    }

    public List<MetaData> getMetaDataAll() {
        return this.metaDataDao.getAll();
    }

    public MetaData getMetaDataById(String id) {
        return this.metaDataDao.findById(id);
    }

    public List<FwqInfo> getFwqInfoAll() {
        return this.fwqInfoDao.findAll();
    }

    public String getIpdzByID(String id) {
        return this.fwqInfoDao.findById(id).getIpdz();
    }

    public List<TableSpaceInfo> getTableSpaceAll() {
        return this.tableSpaceDao.findAllOrderByBkjmc();
    }

    public List<YGJC> getYgjcAll() {
        return this.ygjcDao.getAllOrderByLX();
    }

    public List<YGJC> getYgjcByNfAndLx(String nf, String lx) {
        return this.ygjcDao.findByNfAndLx(nf, lx);
    }

    public List<FwqInfo> getFwqInfoByLx(String lx) {
        return this.fwqInfoDao.findByLx(lx);
    }

    public List<String> getFwqLx() {
        return this.fwqInfoDao.getFwqLx();
    }

    public List<DbInfo> getDbInfoByFid(String fid) {
        return this.dbInfoDao.findByFid(fid);
    }

    public List<Object> getDbUsername() {
        return this.metaDataDao.getUsername();
    }

    public String getYwlxByUsername(String username) {
        return this.metaDataDao.getYwlxByUsername(username);
    }

    public String getCapacityByUserName(String username) {
        return this.metaDataDao.getCapacityByUserName(username);
    }

    public List<MetaData> getMetaDataBySlbm(String slbm) {
        return this.metaDataDao.findBySjkslbmOrderByYwlxAsc(slbm);
    }

    public List<MetaData> getMetaDataByIpbm(String ipbm) {
        return this.metaDataDao.getByIpbm(ipbm);
    }

    public String getYwlxmc(String ywlx) {
        return this.sjglDao.getYwlxmcByYwlx(ywlx);
    }

    public List<Object> getSjzsByNdAndYwlx(String nd, String ywlx) {
        if (StringUtils.isBlank((String)nd)) {
            return this.sjglDao.getSjzsByYwlx(ywlx);
        }
        return this.sjglDao.getSjzsByNdAndYwlx(nd, ywlx);
    }

    public long getSumByNdAndYwlx(String nd, String ywlx) {
        if (StringUtils.isBlank((String)nd)) {
            return this.sjglDao.getSumByYwlx(ywlx);
        }
        return this.sjglDao.getSumByNdAndYwlx(nd, ywlx);
    }

    public long getXzqByNdAndYwlx(String nd, String ywlx) {
        if (StringUtils.isBlank((String)nd)) {
            return this.sjglDao.getXzqByYwlx(ywlx);
        }
        return this.sjglDao.getXzqByNdAndYwlx(nd, ywlx);
    }

    public int getDataIndex(String ywlx, List<HashMap> list) {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                HashMap map = list.get(i);
                if (!map.get("ywlx").equals(ywlx)) continue;
                return i;
            }
        }
        return -1;
    }

    public List<YSJ> getMetaInfo(String id) {
        return this.ysjDao.findByFaid(id);
    }

    public List<YGJC> getYgjcByFwqbm(String fwqbm) {
        return this.ygjcDao.findByFwqbm(fwqbm);
    }

    public List<YGJC> getYgjcByLxAndFwqbm(String lx, String fwqbm) {
        return this.ygjcDao.findByLxAndFwqbm(lx, fwqbm);
    }

    public List<String> getYgjcNf(String lx, String fwqbm) {
        return this.ygjcDao.getYgjcNf(lx, fwqbm);
    }

    public List<String> getYgjcLxByFwqbm(String fwqbm) {
        return this.ygjcDao.getYgjcLxByFwqbm(fwqbm);
    }

    public String getWjdxByLx(String lx) {
        return this.ygjcDao.getWjdxByLx(lx);
    }

    public String getWjdxBylxAndNf(String lx, String nf) {
        return this.ygjcDao.getWjdxByLxAndNf(lx, nf);
    }

    public List<Object> getDbCapacity() {
        return this.tableSpaceDao.getDbCapacity();
    }
}

