/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.dao.BMarkDao;
import cn.gtmap.onemap.platform.entity.BMark;
import cn.gtmap.onemap.platform.service.BMarkService;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.impl.BMarkServiceImpl;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public class BMarkServiceImpl
extends BaseLogger
implements BMarkService {
    private static final String OBJECTID = "OBJECTID";
    private static final String NAME = "name";
    private GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();
    @Autowired
    private BMarkDao bMarkDao;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private GISManager gisManager;
    @Autowired
    private GeometryService geometryService;
    private Map config;

    public List<BMark> findAll() {
        return this.bMarkDao.findAll();
    }

    public BMark find(String id) {
        return (BMark)this.bMarkDao.findOne((Serializable)((Object)id));
    }

    public BMark insert(BMark bMark) {
        Assert.notNull((Object)bMark, (String)this.getMessage("bm.insert.null", new Object[0]));
        return (BMark)this.bMarkDao.save((Object)bMark);
    }

    public List<BMark> insert(List<BMark> bMarks) {
        ArrayList<BMark> result = new ArrayList<BMark>();
        for (BMark bMark : bMarks) {
            result.add(this.insert(bMark));
        }
        return result;
    }

    @Transactional
    public boolean insert(String id, List coords, String type) {
        if (this.isNull((Object)id)) {
            throw new RuntimeException(this.getMessage("bm.insert.id.null", new Object[0]));
        }
        if (this.isNull((Object)type)) {
            throw new RuntimeException(this.getMessage("bm.insert.type.null", new Object[0]));
        }
        BMark bMark = new BMark();
        bMark.setProId(id);
        Geometry geo = this.parseCoords2Geo(coords);
        TopologyValidationError validationError = this.geometryService.validGeometry(geo);
        if (!this.isNull((Object)validationError)) {
            throw new RuntimeException(this.getMessage("bm.tp.check.error", new Object[]{validationError.getMessage()}));
        }
        bMark.setCoordinate(geo.toText());
        this.insert2Layer(this.insert(bMark), this.getLayerName(type), this.getLayerProId(type), this.getDataSource(type));
        return true;
    }

    public List getCoordsByFile(InputStream inputStream, BMarkService.Type type) {
        try {
            switch (1.$SwitchMap$cn$gtmap$onemap$platform$service$BMarkService$Type[type.ordinal()]) {
                case 1: 
                case 2: {
                    return this.getCoordsByExcel(this.documentService.readExcel(inputStream));
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bm.parse.coords.error", new Object[]{e.getLocalizedMessage()}));
        }
        throw new RuntimeException(this.getMessage("bm.parse.not.support", new Object[0]));
    }

    public List query(String key, String type) {
        String title = this.getLayerTitleField(type);
        List temp = this.gisManager.getGISService().query(this.getLayerName(type), title.concat(" like '%".concat(key).concat("%'")), null, false, this.getDataSource(type));
        ArrayList results = new ArrayList();
        for (Map entry : temp) {
            HashMap item = new HashMap();
            item.put(OBJECTID, entry.get(OBJECTID));
            item.put(NAME, entry.get(title));
            results.add(item);
        }
        return results;
    }

    private List getCoordsByExcel(List<List> excel) {
        ArrayList coords = new ArrayList();
        ArrayList polygons = new ArrayList();
        ArrayList<List> polygon = null;
        boolean begin = false;
        for (List row : excel) {
            if (row.size() == 0) continue;
            if (row.size() == 1) {
                String desc = (String)row.get(0);
                if (CoordsTag.begin.getLabel().equals(desc)) {
                    begin = true;
                    continue;
                }
                if (begin && StringUtils.isNotBlank((String)desc) && desc.lastIndexOf(CoordsTag.start.getLabel()) == desc.length() - 1) {
                    polygon = new ArrayList<List>();
                    polygons.add(polygon);
                    continue;
                }
            }
            if (!begin) continue;
            polygon.add(row);
        }
        ArrayList<Map> coord = null;
        for (int i = 0; i < polygons.size(); ++i) {
            List p = (List)polygons.get(i);
            for (List r : p) {
                String s = StringUtils.trim((String)String.valueOf(r.get(0)));
                if (CoordsTag.point.getLabel().equals(s)) {
                    coord = new ArrayList<Map>();
                    continue;
                }
                if (coord == null) continue;
                coord.add(this.list2Map(r));
            }
            if (this.isNull(coord)) continue;
            coords.add(coord);
        }
        return coords;
    }

    private Map list2Map(List value) {
        if (value.size() != 4) {
            return null;
        }
        HashMap map = new HashMap();
        map.put(Pnt.no, value.get(0));
        map.put(Pnt.rno, value.get(1));
        map.put(Pnt.x, value.get(3));
        map.put(Pnt.y, value.get(2));
        return map;
    }

    private void insert2Layer(BMark bMark, String layerName, String proId, String dataSource) {
        Assert.notNull((Object)bMark, (String)this.getMessage("bm.insert.null", new Object[0]));
        HashMap<String, String> columns = new HashMap<String, String>();
        columns.put(proId, bMark.getProId());
        columns.put("SHAPE", bMark.getCoordinate());
        this.gisManager.getGISService().insert(layerName, columns, dataSource);
    }

    private Geometry parseCoords2Geo(List coords) {
        if (this.isNull((Object)coords)) {
            throw new RuntimeException(this.getMessage("bm.insert.coords.null", new Object[0]));
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object coord : coords) {
            polygons.add(this.createPolygon((JSONArray)coord));
        }
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return this.factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private Polygon createPolygon(JSONArray array) {
        LinkedHashMap rings = new LinkedHashMap();
        for (Object object : array) {
            JSONObject _o = (JSONObject)object;
            int rno = Integer.parseInt(String.valueOf(_o.get((Object)Pnt.rno.name())));
            if (rings.containsKey(rno)) {
                ((List)rings.get(rno)).add(new Coordinate(Double.valueOf(String.valueOf(_o.get((Object)Pnt.x.name()))).doubleValue(), Double.valueOf(String.valueOf(_o.get((Object)Pnt.y.name()))).doubleValue()));
                continue;
            }
            ArrayList<Coordinate> p = new ArrayList<Coordinate>();
            p.add(new Coordinate(Double.valueOf(String.valueOf(_o.get((Object)Pnt.x.name()))).doubleValue(), Double.valueOf(String.valueOf(_o.get((Object)Pnt.y.name()))).doubleValue()));
            rings.put(rno, p);
        }
        LinearRing shell = null;
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Map.Entry entry : rings.entrySet()) {
            if (this.isNull(shell)) {
                shell = this.factory.createLinearRing(((List)entry.getValue()).toArray(new Coordinate[0]));
                continue;
            }
            holes.add(this.factory.createLinearRing(((List)entry.getValue()).toArray(new Coordinate[0])));
        }
        return this.factory.createPolygon(shell, holes.toArray(new LinearRing[0]));
    }

    @Deprecated
    private List line2List(JSONObject value) {
        Coordinate c = new Coordinate();
        ArrayList<Object> _r = new ArrayList<Object>();
        _r.add(value.get((Object)Pnt.x.name()));
        _r.add(value.get((Object)Pnt.y.name()));
        return _r;
    }

    public void setConfig(Resource path) {
        try {
            this.config = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(this.getMessage("bm.config.not.found", new Object[0]));
        }
    }

    private String getLayerProId(String type) {
        if (!this.config.containsKey(type)) {
            throw new RuntimeException(this.getMessage("bm.config.type.not.found", new Object[]{type}));
        }
        return (String)((JSONObject)this.config.get(type)).get((Object)"idField");
    }

    private String getLayerName(String type) {
        if (!this.config.containsKey(type)) {
            throw new RuntimeException(this.getMessage("bm.config.type.not.found", new Object[]{type}));
        }
        return (String)((JSONObject)this.config.get(type)).get((Object)"layerName");
    }

    private String getLayerTitleField(String type) {
        if (!this.config.containsKey(type)) {
            throw new RuntimeException(this.getMessage("bm.config.type.not.found", new Object[]{type}));
        }
        return (String)((JSONObject)this.config.get(type)).get((Object)"titleField");
    }

    private String getDataSource(String type) {
        if (!this.config.containsKey(type)) {
            throw new RuntimeException(this.getMessage("bm.config.type.not.found", new Object[]{type}));
        }
        return (String)((JSONObject)this.config.get(type)).get((Object)"dataSource");
    }
}

