/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.dao.impl;

import cn.gtmap.onemap.platform.dao.TplDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.event.DictException;
import cn.gtmap.onemap.platform.event.TemplateException;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TplDaoImpl
extends BaseLogger
implements TplDao {
    private static final String TPL_LOCATION = "/tpls/";
    private static final String TPL_SUFFIX = ".tpl";
    private static final String DEFAULT_TPL = "base.tpl";
    private static final String WIDGETS_TPL = "widgets.tpl";
    private static final String SEARCH_TPL = "search.json";
    @Autowired
    private TemplateService templateService;

    public List<String> getTplNames() {
        try {
            List names = this.templateService.listTplNames(TPL_LOCATION);
            ArrayList<String> values = new ArrayList<String>(names.size());
            for (String name : names) {
                if (!StringUtils.endsWith((String)name, (String)TPL_SUFFIX)) continue;
                values.add(name.substring(0, name.lastIndexOf(TPL_SUFFIX)));
            }
            return values;
        }
        catch (IOException e) {
            throw new TemplateException(TPL_LOCATION, TemplateException.Type.FOLDER_LIST_ERROR, e.getLocalizedMessage());
        }
    }

    public Configuration getConfiguration(String tplName) {
        return (Configuration)JSON.parseObject((String)this.getTplContent(tplName), Configuration.class);
    }

    public Configuration saveConfiguration(String tplName, Configuration configuration) {
        this.templateService.modify(this.getTplRealName(tplName), JSON.toJSONString((Object)configuration, (boolean)true));
        return configuration;
    }

    public Configuration createTpl(String tplName) {
        Configuration configuration = this.newBlankTpl();
        this.templateService.createTpl(this.getTplRealName(tplName), JSON.toJSONString((Object)configuration, (boolean)true));
        return configuration;
    }

    public void deleteTpl(String tplName) {
        this.templateService.deleteTpl(this.getTplRealName(tplName));
    }

    public List<Service> getAllServices(String tplName) {
        return this.getConfiguration(tplName).getMap().getOperationalLayers();
    }

    public List<Service> saveAllServices(String tplName, List<Service> services) {
        Configuration configuration = this.getConfiguration(tplName);
        Collections.sort(services);
        configuration.getMap().setOperationalLayers(services);
        this.saveConfiguration(tplName, configuration);
        return services;
    }

    public Service saveOrUpateService(String tplName, Service service) {
        List services = this.getAllServices(tplName);
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            Service item = (Service)iterator.next();
            if (!item.getId().equals(service.getId())) continue;
            iterator.remove();
            break;
        }
        services.add(service);
        this.saveAllServices(tplName, services);
        return service;
    }

    public void deleteServices(String tplName, String[] serviceIds) {
        List services = this.getAllServices(tplName);
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            Service item = (Service)iterator.next();
            if (!ArrayUtils.contains((Object[])serviceIds, (Object)item.getId())) continue;
            iterator.remove();
        }
        this.saveAllServices(tplName, services);
    }

    public List<Service> getServicesByIds(String tplName, String[] serviceIds) {
        ArrayList<Service> results = new ArrayList<Service>();
        for (Service service : this.getAllServices(tplName)) {
            if (!ArrayUtils.contains((Object[])serviceIds, (Object)service.getId())) continue;
            results.add(service);
        }
        return results;
    }

    public Dict getDictById(String tplName, String dictId) {
        for (Dict dict : this.getConfiguration(tplName).getDicts()) {
            if (!dict.getId().equals(dictId)) continue;
            return dict;
        }
        return null;
    }

    private List<Dict> saveAllDicts(String tplName, List<Dict> dicts) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.setDicts(dicts);
        this.saveConfiguration(tplName, configuration);
        return dicts;
    }

    public Dict saveOrUpdateDict(String tplName, Dict dict) {
        List dicts = this.getConfiguration(tplName).getDicts();
        Iterator iterator = dicts.iterator();
        while (iterator.hasNext()) {
            Dict item = (Dict)iterator.next();
            if (!item.getId().equals(dict.getId())) continue;
            iterator.remove();
            break;
        }
        dicts.add(dict);
        this.saveAllDicts(tplName, dicts);
        return dict;
    }

    public void deleteDicts(String tplName, String[] dictIds) {
        List dicts = this.getConfiguration(tplName).getDicts();
        Iterator iterator = dicts.iterator();
        while (iterator.hasNext()) {
            Dict item = (Dict)iterator.next();
            if (!ArrayUtils.contains((Object[])dictIds, (Object)item.getId())) continue;
            iterator.remove();
            break;
        }
        this.saveAllDicts(tplName, dicts);
    }

    public void deleteDict(String tplName, String id) {
        List dicts = this.getConfiguration(tplName).getDicts();
        Iterator iterator = dicts.iterator();
        while (iterator.hasNext()) {
            Dict item = (Dict)iterator.next();
            if (!id.equals(item.getId())) continue;
            iterator.remove();
            break;
        }
        this.saveAllDicts(tplName, dicts);
    }

    public Dict getDictByName(String tplName, String dictName) {
        for (Dict dict : this.getConfiguration(tplName).getDicts()) {
            if (!dict.getName().equals(dictName)) continue;
            return dict;
        }
        throw new DictException(DictException.ExceptionType.DICT_NOT_FOUND, dictName, null);
    }

    public List<Service> saveBaseLayers(String tplName, List<Service> services) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.getMap().setBaseLayers(services);
        this.saveConfiguration(tplName, configuration);
        return services;
    }

    public void deleteBaseLayer(String tplName, String[] serviceIds) {
        Configuration configuration = this.getConfiguration(tplName);
        List baseLayers = configuration.getMap().getBaseLayers();
        Iterator iterator = baseLayers.iterator();
        while (iterator.hasNext()) {
            Service item = (Service)iterator.next();
            if (!ArrayUtils.contains((Object[])serviceIds, (Object)item.getId())) continue;
            iterator.remove();
            break;
        }
        configuration.getMap().setBaseLayers(baseLayers);
        this.saveConfiguration(tplName, configuration);
    }

    public Configuration.Widget saveOrUpdateDockWidget(String tplName, Configuration.Widget widget) {
        Configuration configuration = this.getConfiguration(tplName);
        List widgets = configuration.getWidgets();
        configuration.setWidgets(this.addOrUpdateWidgets(widgets, widget));
        this.saveConfiguration(tplName, configuration);
        return widget;
    }

    public void deleteDockWidget(String tplName, Configuration.Widget widget) {
        Configuration configuration = this.getConfiguration(tplName);
        List widgets = configuration.getWidgets();
        Iterator iterator = widgets.iterator();
        while (iterator.hasNext()) {
            Configuration.Widget item = (Configuration.Widget)iterator.next();
            if (this.isNull((Object)item.getId()) || !item.getId().equals(widget.getId())) continue;
            iterator.remove();
            break;
        }
        configuration.setWidgets(widgets);
        this.saveConfiguration(tplName, configuration);
    }

    public Configuration.Widget saveOrUpdateWidget(String tplName, Configuration.Widget widget) {
        Configuration configuration = this.getConfiguration(tplName);
        List widgets = configuration.getWidgetContainer().getWidgets();
        configuration.getWidgetContainer().setWidgets(this.addOrUpdateWidgets(widgets, widget));
        this.saveConfiguration(tplName, configuration);
        return widget;
    }

    public void deleteWidget(String tplName, Configuration.Widget widget) {
        if (this.isNull((Object)widget)) {
            return;
        }
        Configuration configuration = this.getConfiguration(tplName);
        List widgets = configuration.getWidgetContainer().getWidgets();
        Iterator iterator = widgets.iterator();
        while (iterator.hasNext()) {
            Configuration.Widget item = (Configuration.Widget)iterator.next();
            if (this.isNull((Object)item.getId()) || !item.getId().equals(widget.getId())) continue;
            iterator.remove();
            break;
        }
        configuration.getWidgetContainer().setWidgets(widgets);
        this.saveConfiguration(tplName, configuration);
    }

    public Configuration.WidgetsGroup saveOrUpdateWidgetGroup(String tplName, Configuration.WidgetsGroup widgetsGroup, Configuration.Widget widget) {
        Configuration configuration = this.getConfiguration(tplName);
        boolean contains = false;
        for (Configuration.WidgetsGroup itemGroup : configuration.getWidgetContainer().getWidgetsGroup()) {
            if (!itemGroup.getId().equals(widgetsGroup.getId())) continue;
            if (!this.isNull((Object)widget)) {
                itemGroup.setWidgets(this.addOrUpdateWidgets(itemGroup.getWidgets(), widget));
            } else {
                itemGroup.setIcon(widgetsGroup.getIcon());
                itemGroup.setLabel(widgetsGroup.getLabel());
                itemGroup.setType(widgetsGroup.getType());
                itemGroup.setUrl(widgetsGroup.getUrl());
                itemGroup.setWeight(widgetsGroup.getWeight());
                itemGroup.setWidgets(widgetsGroup.getWidgets());
            }
            contains = true;
            break;
        }
        if (!contains) {
            if (!this.isNull((Object)widget)) {
                widgetsGroup.setWidgets(this.addOrUpdateWidgets(widgetsGroup.getWidgets(), widget));
            }
            configuration.getWidgetContainer().getWidgetsGroup().add(widgetsGroup);
        }
        Collections.sort(configuration.getWidgetContainer().getWidgetsGroup());
        this.saveConfiguration(tplName, configuration);
        return widgetsGroup;
    }

    public void deleteWidgetsGroup(String tplName, Configuration.WidgetsGroup widgetsGroup, Configuration.Widget widget) {
        if (this.isNull((Object)widgetsGroup)) {
            return;
        }
        Configuration configuration = this.getConfiguration(tplName);
        List widgetsGroups = configuration.getWidgetContainer().getWidgetsGroup();
        if (this.isNull((Object)widget)) {
            Iterator iterator = widgetsGroups.iterator();
            while (iterator.hasNext()) {
                Configuration.WidgetsGroup item = (Configuration.WidgetsGroup)iterator.next();
                if (this.isNull((Object)item.getId()) || !item.getId().equals(widgetsGroup.getId())) continue;
                iterator.remove();
                break;
            }
            configuration.getWidgetContainer().setWidgetsGroup(widgetsGroups);
        } else {
            boolean contains = false;
            for (Configuration.WidgetsGroup itemGroup : widgetsGroups) {
                List widgets = itemGroup.getWidgets();
                Iterator iterator = widgets.iterator();
                while (iterator.hasNext()) {
                    Configuration.Widget itemWidget = (Configuration.Widget)iterator.next();
                    if (this.isNull((Object)itemWidget.getId()) || !itemWidget.getId().equals(widget.getId())) continue;
                    iterator.remove();
                    contains = true;
                    break;
                }
                if (!contains) continue;
                itemGroup.setWidgets(widgets);
                break;
            }
            configuration.getWidgetContainer().setWidgetsGroup(widgetsGroups);
        }
        Collections.sort(configuration.getWidgetContainer().getWidgetsGroup());
        this.saveConfiguration(tplName, configuration);
    }

    public Map updateMapInitExtent(String tplName, Map extent) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.getMap().setInitExtent(extent);
        if (configuration.getMap().getDefaultScale() > 0.0) {
            configuration.getMap().setDefaultScale(0.0);
        }
        this.saveConfiguration(tplName, configuration);
        return extent;
    }

    public double updateDefaultScale(String tplName, double scale) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.getMap().setDefaultScale(scale);
        if (!this.isNull((Object)configuration.getMap().getInitExtent())) {
            configuration.getMap().setInitExtent(null);
        }
        this.saveConfiguration(tplName, configuration);
        return scale;
    }

    public List updateMapLods(String tplName, List lods) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.getMap().setLods(lods);
        this.saveConfiguration(tplName, configuration);
        return lods;
    }

    public Configuration updateGlobalConfiguration(String tplName, Configuration configuration) {
        Configuration config = this.getConfiguration(tplName);
        config.setName(configuration.getName());
        config.setTitle(configuration.getTitle());
        config.setDefaultYear(configuration.getDefaultYear());
        config.setDefaultRegionCode(configuration.getDefaultRegionCode());
        config.setCoordinateVisible(configuration.isCoordinateVisible());
        config.setLogo(configuration.getLogo());
        config.setLogoVisible(configuration.isLogoVisible());
        config.setGeometryService(configuration.getGeometryService());
        config.setPrintService(configuration.getPrintService());
        config.setDescription(configuration.getDescription());
        config.setDicts(configuration.getDicts());
        config.getMap().setLods(configuration.getMap().getLods());
        return this.saveConfiguration(tplName, config);
    }

    public List<Configuration.Widget> getCommonWidgets() {
        Map map = (Map)JSON.parseObject((String)this.templateService.getTemplate(WIDGETS_TPL), Map.class);
        List list = (List)map.get("commonWidgets");
        return list;
    }

    public void deleteCommonWidget(String id) {
        List widgets = this.getCommonWidgets();
        Iterator iterator = widgets.iterator();
        while (iterator.hasNext()) {
            Configuration.Widget item = (Configuration.Widget)iterator.next();
            if (this.isNull((Object)item.getId()) || !item.getId().equals(id)) continue;
            iterator.remove();
            break;
        }
        Collections.sort(widgets);
        this.saveCommonWidgets(widgets);
    }

    public Configuration.Widget insertCommonWidget(Configuration.Widget widget) {
        List widgets = this.getCommonWidgets();
        this.saveCommonWidgets(this.addOrUpdateWidgets(widgets, widget));
        return widget;
    }

    public List<Configuration.Widget> getPublicWidgets() {
        Map map = (Map)JSON.parseObject((String)this.templateService.getTemplate(WIDGETS_TPL), Map.class);
        List list = JSON.parseArray((String)JSON.toJSONString(map.get("publicWidgets")), Configuration.Widget.class);
        return list;
    }

    public void deletePublicWidgets(String id) {
        List widgets = this.getPublicWidgets();
        Iterator iterator = widgets.iterator();
        while (iterator.hasNext()) {
            Configuration.Widget item = (Configuration.Widget)iterator.next();
            if (this.isNull((Object)item.getId()) || !item.getId().equals(id)) continue;
            iterator.remove();
            break;
        }
        Collections.sort(widgets);
        this.savePublicWidgets(widgets);
    }

    public Configuration.Widget insertPublicWidgets(Configuration.Widget widget) {
        List widgets = this.getPublicWidgets();
        this.savePublicWidgets(this.addOrUpdateWidgets(widgets, widget));
        return widget;
    }

    public Map getSearchConfig() {
        return (Map)JSON.parseObject((String)this.templateService.getTemplate(SEARCH_TPL), Map.class);
    }

    public void updateSearchConfig(String content) {
        this.templateService.modify(SEARCH_TPL, content);
    }

    public List<Configuration.Widget> saveCommonWidgets(List<Configuration.Widget> widgets) {
        Map map = (Map)JSON.parseObject((String)this.templateService.getTemplate(WIDGETS_TPL), Map.class);
        map.put("commonWidgets", widgets);
        this.templateService.modify(WIDGETS_TPL, JSON.toJSONString((Object)map, (boolean)true));
        return this.getCommonWidgets();
    }

    public List<Configuration.Widget> savePublicWidgets(List<Configuration.Widget> widgets) {
        Map map = (Map)JSON.parseObject((String)this.templateService.getTemplate(WIDGETS_TPL), Map.class);
        map.put("publicWidgets", widgets);
        this.templateService.modify(WIDGETS_TPL, JSON.toJSONString((Object)map, (boolean)true));
        return this.getPublicWidgets();
    }

    private List<Configuration.Widget> addOrUpdateWidgets(List<Configuration.Widget> widgets, Configuration.Widget widget) {
        if (this.isNull((Object)widget)) {
            return widgets;
        }
        if (this.isNull(widgets)) {
            widgets = new ArrayList<Configuration.Widget>();
        }
        Iterator<Configuration.Widget> iterator = widgets.iterator();
        while (iterator.hasNext()) {
            Configuration.Widget item = iterator.next();
            if (this.isNull((Object)item.getId()) || !item.getId().equals(widget.getId())) continue;
            iterator.remove();
            break;
        }
        widgets.add(widget);
        Collections.sort(widgets);
        return widgets;
    }

    private Configuration newBlankTpl() {
        return (Configuration)JSON.parseObject((String)this.templateService.getTemplate(DEFAULT_TPL), Configuration.class);
    }

    private String getTplRealName(String tplName) {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("template.name.not.null", new Object[0]));
        }
        return TPL_LOCATION.concat(tplName.contains(TPL_SUFFIX) ? tplName : tplName.concat(TPL_SUFFIX));
    }

    private String getTplContent(String tplName) {
        return this.templateService.getTemplate(this.getTplRealName(tplName));
    }
}

