/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal;

import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.model.Service;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/portal"})
public class PageController
extends BaseController {
    @Autowired
    private TplTypeService tplTypeService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private MapService mapService;

    @RequestMapping(method={RequestMethod.GET})
    public String home(Model model, MapQuery mapQuery) {
        PageRequest pageable = new PageRequest(0, 7);
        Page maps = this.metadataService.findMaps(SecHelper.getUserId(), mapQuery, (Pageable)pageable);
        model.addAttribute("tpls", (Object)this.mapService.getTplsByCount(3));
        model.addAttribute("maps", (Object)maps.getContent());
        model.addAttribute("omsurl", (Object)System.getProperty("oms.url"));
        return "portal/home";
    }

    @RequestMapping(value={"/{document}/{page}"})
    public String index(@PathVariable(value="document") String doc, @PathVariable(value="page") String page) {
        return "portal/" + doc + "/" + page;
    }

    @RequestMapping(value={"/login"})
    public String login(@RequestParam(value="next", required=false) String next) {
        if (next != null) {
            return "redirect:" + next;
        }
        return "portal/login";
    }

    @RequestMapping(value={"/api/{name}"})
    public String api(@PathVariable(value="name") String name) {
        return "portal/api/" + name;
    }

    @RequestMapping(value={"/service/{id}"}, method={RequestMethod.GET})
    public String serviceView(@PathVariable String id, Model model) {
        String serviceUrl = "";
        String serviceType = "";
        model.addAttribute("id", (Object)id);
        model.addAttribute("map", (Object)this.metadataService.getMap(id));
        model.addAttribute("layers", (Object)this.metadataService.getLayers(id));
        Map types = this.metadataService.getServices(id);
        if (types != null) {
            if (types.containsKey(ServiceType.ARCGIS_TILE)) {
                Service service = (Service)types.get(ServiceType.ARCGIS_TILE);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_TILE.getValue();
            } else if (types.containsKey(ServiceType.ARCGIS_REST)) {
                Service service = (Service)types.get(ServiceType.ARCGIS_REST);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_REST.getValue();
            } else {
                Iterator i$ = types.keySet().iterator();
                if (i$.hasNext()) {
                    ServiceType temp = (ServiceType)i$.next();
                    serviceUrl = ((Service)types.get(temp)).getUrl();
                    serviceType = temp.getValue();
                }
            }
        }
        model.addAttribute("serviceUrl", (Object)serviceUrl);
        model.addAttribute("serviceType", (Object)serviceType);
        return "portal/service/service_overview";
    }

    @RequestMapping(value={"/map/{mapId}"}, method={RequestMethod.GET})
    public String map(@PathVariable String mapId, Model model) {
        model.addAttribute("map", (Object)this.metadataService.getMap(mapId));
        return "portal/map";
    }

    @RequestMapping(value={"/tpls"}, method={RequestMethod.GET})
    public String tplList(Model model, @RequestParam(value="typeId", required=false) String typeId) {
        model.addAttribute("types", (Object)this.tplTypeService.queryAllTplType());
        if (StringUtils.isEmpty((String)typeId)) {
            model.addAttribute("tpls", (Object)this.tplTypeService.getTplByType(null));
        } else {
            model.addAttribute("tpls", (Object)this.tplTypeService.getTplByType(typeId));
            model.addAttribute("selectedType", (Object)this.tplTypeService.getTplType(typeId));
        }
        return "portal/tpls";
    }
}

