/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal;

import cn.gtmap.onemap.model.Layer;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Function;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.service.MetadataService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/portal"})
public class FuncConfigController {
    @Autowired
    private MapService mapService;
    @Autowired
    private MetadataService metadataService;

    @RequestMapping(value={"/{tpl}/{serviceId}/savefunction"}, method={RequestMethod.POST})
    @ResponseBody
    public String saveFunc(@PathVariable(value="tpl") String tpl, @PathVariable String serviceId, Function func, RedirectAttributes ra) {
        this.mapService.saveFunction(func, serviceId, tpl);
        return "success";
    }

    @RequestMapping(value={"/{tpl}/function/{view}/{serviceId}"})
    public String queryFunc(@PathVariable(value="tpl") String tpl, @PathVariable String view, @PathVariable String serviceId, Model model) {
        Configuration cg = this.mapService.getConfigByTpl(tpl);
        model.addAttribute("tplName", (Object)cg.getName());
        model.addAttribute("config", (Object)cg);
        model.addAttribute("service", (Object)this.mapService.getService(serviceId, tpl));
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("view", (Object)view);
        List layers = this.metadataService.getLayers(serviceId);
        ArrayList<String> layerIds = new ArrayList<String>();
        for (Layer temp : layers) {
            layerIds.add(temp.getId());
        }
        model.addAttribute("layers", (Object)layers);
        model.addAttribute("fieldsMap", (Object)this.metadataService.batchGetFields(layerIds));
        Function.Type type = Enum.valueOf(Function.Type.class, view.trim().toUpperCase());
        Function function = this.mapService.getFunctionByType(serviceId, type.getId(), tpl);
        model.addAttribute("type", (Object)type.getId());
        if (function == null) {
            model.addAttribute("function", (Object)new Function());
        } else {
            model.addAttribute("function", (Object)function);
        }
        return "portal/service/func-config/" + view + "_function";
    }
}

