define([
        'gtmap/service/city'
        , 'gtmap/service/glass'
        , 'gtmap/service/identify'
        , 'gtmap/service/layer'
        , 'gtmap/service/location'
        , 'gtmap/service/measurement'
        , 'gtmap/service/print'
        , 'gtmap/service/search'
        , 'dojo/text!gtmap/template/lefttree.html'
      ] , 

function() {
  var rendered = 0, 
      $serviceTree = $('#mapTypesTree'), 
      args = arguments, 
      serviceTreeTpl = arguments[arguments.length - 1];

  return {
    bindHandler : function() {
      for (var i = 0; i < args.length - 1; i++) {
        for (var k in args[i] ) {
          $('[data-gtmap-service*=' + k + ']').each(function() {
            var self = $(this)
				, serviceDesc = self.attr('data-gtmap-service');

            if (serviceDesc.search(/,/) !== -1) {
              var subDescArray = serviceDesc.split(',');
              for (var j = 0; j < subDescArray.length; j++) {
                if (subDescArray[j].indexOf(k) !== -1) {
                  serviceDesc = subDescArray[j];
                  break;
                }
              }
            }

            if (serviceDesc.search(/\(/) !== -1) {
              var jqSelectorString = serviceDesc.substring(serviceDesc.indexOf('(') + 1, serviceDesc.indexOf(')'));
              self.delegate(jqSelectorString, 'click', args[i][k]);
            } else {
              self.click(args[i][k]);
            }
          });
        }
      }
	  
	  args[3].syncMaps(); // 同步地图拖动
    },

    loadSingleServiceTree : function(service) {
      $serviceTree.append(_.template( serviceTreeTpl )(service));
      rendered++;
      if (rendered == services.length) {
        $serviceTree.listtree();
      }
    }, 
	
	loadGroupTree : function(){
		$.get( templateInfomation.fetchServiceUrl, function( msg ){
			$serviceTree.append( _.template( serviceTreeTpl )( { target : msg } ) );
			$serviceTree.listtree();
			$.infopane.setText('完成!');
			$.infopane.hide();
		}, 'json');
	},
	
	loadLayers : function(){
		var layers = templateInfomation.config.map.operationalLayers;
		layers = _.sortBy(layers, function(layer){
			return 0 - layer.index;
		});
		_.each(layers, function(layer){
			var service = new esri.layers.ArcGISDynamicMapServiceLayer( layer.url, { visiable : layer.visiable, id : layer.id, opacity : layer.alpha } );
				service.customAttributes = {
					name : layer.name ,
					alias : layer.alias
				}
			map.addLayer(service);
		});
	}
  }

});