$(document).ready(function() {
	// Avoid `console` errors in browsers that lack a console.
	(function() {
	    var method;
	    var noop = function () {};
	    var methods = [
	        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
	        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
	        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
	        'timeStamp', 'trace', 'warn'
	    ];
	    var length = methods.length;
	    var console = (window.console = window.console || {});
	
	    while (length--) {
	        method = methods[length];
	
	        // Only stub undefined methods.
	        if (!console[method]) {
	            console[method] = noop;
	        }
	    }
	}());
	// loading / pagin
	!function(glbl, $) {
		glbl.ui = {};

		var LoadingWin = function(text) {
			this.$elem = $(this.tmpl);
			this.setText(text);
			$('body').append(this.$elem);
			this.$loading = this.$elem.find('._gtis_ui_loading');
			this.$cover = this.$elem.find('._gtis_ui_cover');
			return this;
		};

		LoadingWin.prototype = {
			tmpl : "<div id='_GTIS_UI_LOADING_WIN'><div class='_gtis_ui_loading'></div><div class='_gtis_ui_cover'></div></div>",

			setText : function(text) {
				$(this.$loading).html(text + '...');
			},

			show : function(text) {
				if (text)
					this.setText(text);
				this.$cover.css('display', 'block');
				this.$loading.fadeIn();
				var loading = this.$loading, wid = loading.width();
				loading.css('margin-left', '-' + wid + 'px');
			},

			hide : function() {
				var self = this;
				this.$loading.fadeOut('fast', function() {
					self.$cover.css('display', 'none');
				});
			}
		};
		glbl.ui.loading = new LoadingWin();

		/*! pagin 0.2 */
		function refreshPagin(page, size, count, pre) {
			
			Array.prototype.contains = function ( needle ) {
			   for (i in this) {
				   if (this[i] == needle) return true;
			   }
			   return false;
			}
			
			var maxnum = 5
				, pagin = $('#J_PAGIN')
				, pagePre = 'page.page'
				, sizePre = 'page.size'
				, prev = pagin.children('.prev')
				, next = pagin.children('.next')
				, href = location.href
				, prefix = '?';

			if (!pre) {
				if (href.indexOf('?') > -1 && href.indexOf(pagePre) == -1) {
					prefix = href + '&';
				} else if (href.indexOf(pagePre) > -1) {
					prefix = href.substring(0, href.indexOf(pagePre));
				} else {
					prefix = '?';
				}
			} else {
				prefix = pre;
			}

			var total = Math.ceil(count / size);

			if (page == 1) {
				prev.addClass('disabled');
			}
			if (page == total) {
				next.addClass('disabled');
			}

			pagin.children('span').children().remove();
			for ( i = 1; i <= total; i++) {
				var a = $('<a />').attr({
					'href' : prefix + pagePre + '=' + i + '&' + sizePre + '=' + size + ''
				}).html(i);
				pagin.children('span').append(a);
				if (i == page) {
					a.addClass('active');
					a.attr('href', '#');
				}
			}

			prev.attr({
				'href' : prefix + pagePre + '=' + (page - 1) + '&' + sizePre + '=' + size + ''
			});
			next.attr({
				'href' : prefix + pagePre + '=' + (page + 1) + '&' + sizePre + '=' + size + ''
			});

			function simplify(page) {
				var items = pagin.children('span').children('a')
					, active = pagin.children('span').children('.active')
					, aIndex
					, disNum = []
					, max = 20;
				if( items.length > max ){
					// get active index
					aIndex = active.index() + 1;
					
					items.each(function(i, link){
						if( disNum.length >= max ) return false;
						
						i = i+1;
						
						if( i===aIndex || i===aIndex-1 || i===aIndex+1 || i===1 || i===2 || i===items.length-1 || i===items.length ){
							disNum.push(i);
							return;
						}
					})
					
					for( var i=aIndex-2; i>2 ; i-- ){
						if( disNum.length >= max ) break;
						disNum.contains(i) || disNum.push(i);
					}
					
					for( var i=aIndex+2; i<items.length-1 ; i++ ){
						if( disNum.length >= max ) break;
						disNum.contains(i) || disNum.push(i);
					}
					
					disNum.sort(function(a, b){
						return a > b;
					});
					
					items.each(function(i, link){
						i = i+1;
						disNum.contains(i) || $(this).remove();
					});
					
					items = pagin.children('span').children('a');
					
					for( var i = 1; i < disNum.length ; i++ ){
						if( disNum[i] - disNum[i-1] > 1){
							$(items[i-1]).after('<strong> ... </strong>');
						}
					}
				}
			}
			simplify(page);
			pagin.find('a').addClass('j_pagin_link');
		}
		glbl.refreshPagin = refreshPagin;
	}(window, jQuery);
	
	// focus
	!function(){
			var Focus = function(elem, opt){
				var elem = $(elem)
					, oriPos = elem.css('position')
					, div = $("<div style='position:absolute;width:100%;height:100%;top:0;left:0'></div>");
				elem.css('position','relative');
			 	div.css({'background-color': opt.color,'opacity':opt.opacity});
			 	elem.append(div);
			 	setTimeout(function(){
			 			div.fadeOut(opt.duration, function(){
			 			div.remove();
			 			elem.css('position', oriPos);
			 		});
			 	},500);
			}
			
			var defaults = {
				color: "#F23E48",
				opacity: ".8",
				duration : 500
			}
			
		$.fn.focusresult = function(options){
			var opts = $.extend({}, options, defaults);
			new Focus(this, opts);
			return this;
		}
			
	}();
	
	// 表单转对象
	$.fn.serializeObject = function(){
			var html_transfer = function(str){
				str = str.replace(/\n|\t|\r/g , '');
				str = str.replace(/"/g ,'\\"')
						 .replace(/'/g ,'\\"')
						 .replace(/‘/g ,'\\"')
						 .replace(/’/g ,'\\"')
						 .replace(/“/g ,'\\"')
						 .replace(/”/g ,'\\"');
				return str;
			}
			
		    var o = {};
		    var a = this.serializeArray();
			
		    var back = {}, p;
		    $.each(a, function() {
				this.value = html_transfer(this.value);
				console.log(this.name + "  " + this.value);
		        if( this.name.indexOf('.') > -1){
		        	var nArray = this.name.split('.');
		        	for(i = 0 ; i < nArray.length ; i++){
		        		if ( i == 0){
		        			if( back[nArray[i]] ){
		        				back[nArray[i]] = $.extend({}, back[nArray[i]]);
		        			} else {
		        				back[nArray[i]] = {};
		        			}
		        			p = back[nArray[i]];
		        		} else if ( i==(nArray.length-1) ) {
		        			p[nArray[i]] = this.value || '';
		        		} else {
		        			if( p[nArray[i]] ){
		        				p[nArray[i]] = $.extend({}, p[nArray[i]]);
		        			} else {
		        				p[nArray[i]] = {};
		        			}
		        			p = p[nArray[i]];
		        		}
		        	}
		        	if( o[nArray[0]] ){
		        		o[nArray[0]] = $.extend({}, o[nArray[0]], back[nArray[0]]);
		        	} else {
		        		o[nArray[0]] = back[nArray[0]];
		        	}
		        	return;
		        }
		        if (o[this.name] !== undefined) {
		            if (!o[this.name].push) {
		                o[this.name] = [o[this.name]];
		            }
		            o[this.name].push(this.value || '');
		        } else {
		            o[this.name] = this.value || '';
		        }
		    });
			
		    return o;
		};
	// 右上角删除
	! function(){
			var LinkRemove = function( opts ){
				this.opts = opts;
				
			}
			LinkRemove.prototype = {
				render : function( url ){
					var back = $(this.opts.tpl);
					url && back.attr('href',url);
					back.attr('data-ask',this.opts.ask);
					return back;
				}
			}
			
			var defaults = {
				tpl : "<a class='_linkremove j_btn_del remove hide'>×</a>",
				ask : "确定执行删除操作吗？",
				url : ""
			}
			
			$.fn.bindRemoveLink = function( opts ){
				return this.each(function(){
					var self = $(this);
					var options = $.extend({}, defaults, opts);
					self.css('position','relative');
					$link = new LinkRemove(options).render(self.attr('url'));
					self.append( $link );
					self.hover(function(){
						$(this).children('._linkremove').css('display','block');
					},function(){
						$(this).children('._linkremove').css('display','none');
					});
				});
				
			}
		}();
	
	// 通用模块
	! function() {
		// stop default link behavior
		$(document).on('click', '[href="#"],.disabled', function(e) {
			e.preventDefault();
		});
		/*
		 * 如果从后台重定向到某一个页面，可能带有Hint信息, 下面这个闭包的作用就是把Hint优雅的隐藏
		 *
		 * @notice: Hint信息的容器ID为 J_ALERT
		 */
		! function() {
			var alerts = $("#J_ALERT");
			alerts.fadeIn(500, function() {
				setTimeout(function() {
					alerts.fadeOut();
				}, 4000);
			});
		}();
		var loading = ui.loading;
		/*
		 * @name:	AJAX提交表单函数
		 *
		 * @params:	要提交的表单 ID, 触发表单提交的按钮 ID, 触发的事件类型， 回调函数， 等待提交时显示的字符
		 */
		function ajaxSubmit(formId, triggerId, eventType, callback, waitText) {
			$('#' + triggerId).live(eventType, function() {
				var form = $("#" + formId);
				if (!form.attr('action')) {
					console.log(form.attr('id') + '的action没有设定');
					return;
				}

				if (!form.validationEngine('validate')) {// 为form进行validationEngine插件验证，如果验证失败退出
					return;
				}

				loading.setText(waitText);
				loading.show();
				$.ajax({
					url : form.attr('action'),
					type : form.attr('method') || 'get',
					data : form.serialize(),
					success : function(msg) {
						callback(msg);
						beforeRemove();
						loading.hide();
					}
				})
			});
		}window.ajaxSubmit = ajaxSubmit;
		/*
		 * ajax提交表单插件
		 * 
		 */
		$.fn.ajaxSubmit = function( opts ){
			var form = $(this);
			if (!form.attr('action')) {
				console.log(form.attr('id') + '的action没有设定');
				return;
			}
			
			if (!form.validationEngine('validate')) {// 为form进行validationEngine插件验证，如果验证失败退出
				return;
			}
			
			$.ajax({
					url : form.attr('action'),
					type : form.attr('method') || 'get',
					data : form.serialize(),
					success : function(msg) {
						opts.callback(msg);
					}
			});
		};
		/*
		 * @name: 删除前的confirm
		 */
		function beforeRemove(){
			$('.j_btn_del,.j_ask').click(function(){
				var ask = $(this).attr('data-ask') || '确定执行删除操作吗？'
				return window.confirm(ask);
			});
		}window.beforeRemove = beforeRemove;
		beforeRemove();
		/*
		 * @name:	AJAX删除函数
		 *
		 * @params:	传入数据列表的ID，触发事件句柄，回调
		 * @notice:	需要将 ajax 请求 url 写在 href 上, 然后触发删除事件的按钮添加一个 .j_btn_del class
		 */
		function ajaxRemove(containerId, eventType, callback) {
			$('#' + containerId).delegate('.j_btn_del', eventType, function() {
				loading.setText('正在删除');
				loading.show();
				$.get($(this).attr('href'), function(msg) {
					loading.hide();
					callback(msg);
					beforeRemove();
				});
				return false;
			});
		}window.ajaxRemove = ajaxRemove;
		/*
		 * @name: 将导航设置为当前状态
		 *
		 * @param: idx:选中的位置
		 */
		function selectNavGuide(idx, id) {
			var ctnId = id || 'J_NAV_GUIDE';
			
			$('#'+ctnId).children('li').each(function(i) {
				if (idx === i) {
					$(this).removeClass('active').addClass('active').children('a').attr('href', '#');
				} else {
					$(this).removeClass('active');
				}
			})
		}window.selectNavGuide = selectNavGuide;
		/*!
		 * @name: ajax4data
		 * @author: ray zhang
		 * @datetime: 2013-06-19 14:31
		 * @version: 1.1
		 *
		 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
		 *
		 * change-log：
		 * 1.0			init
		 * 1.1			可以在class中指定调用什么方法显示数据 比如append数据 <a href="#" class="j_ajax4data" data-result-ctn="#J_ID(append)" >btn</a>
		 */
		function ajax4Data() {
			$(document).delegate('.j_ajax_for_data, .j_ajax4data', 'click', function() {
				var url = $(this).attr('url') || $(this).attr('href')
				, sCtn = $(this).attr('data-result-ctn') || $(this).attr('gtdata-result')
				, method , ctn, pre = "";

				if (!sCtn) {
					alert('没有设定存放结果的容器选择符');
					return false;
				} else if (sCtn.search(/\(/) !== -1) {
					method = sCtn.substring(sCtn.indexOf('(') + 1, sCtn.indexOf(')'));
					sCtn = sCtn.substring(0, sCtn.indexOf('('));
				} else {
					method = 'html';
				}
				ctn = $(sCtn);
				loading.show('正在请求数据');
				
				if( url ){
					if( url.indexOf('?') > -1 ){
						pre = "&d="
					}else{
						pre = "?d="
					}
					$.get(url + pre + new Date(), function(msg) {
						ctn[method](msg);
						ctn.find('form').validationEngine();
						loading.hide();
					});
				}
				return false;
			});
		}ajax4Data();
	}();
	
	//form validate
	! function(exports) {

		// 全局 ValidationEngine参数覆盖
		var _V_SET = {
	    	onFieldFailure : function(ui, info){
	    		if( ui ){
	    			ui.parent().parent().removeClass('success').addClass('error');
	    			var infos = info.replace(/\<br\/\>/g,"@").split('@');
	    			ui.next('.help-inline').html(infos[0]);
	    		}
	    	},
	    	onFieldSuccess : function(ui){
	    		if( ui ){
	    			ui.parent().parent().removeClass('error');
	    			ui.next('.help-inline').html('');
	    		}
	    	},
	    	showPrompts : false
	    }
	    $.validationEngine.defaults = $.extend({}, $.validationEngine.defaults, _V_SET);
		
		$('.j_validation_form').validationEngine();
		
	}(window);

});