/*
 COPYRIGHT 2009 ESRI

 TRADE SECRETS: ESRI PROPRIETARY AND CONFIDENTIAL
 Unpublished material - all rights reserved under the
 Copyright Laws of the United States and applicable international
 laws, treaties, and conventions.

 For additional information, contact:
 Environmental Systems Research Institute, Inc.
 Attn: Contracts and Legal Services Department
 380 New York Street
 Redlands, California, 92373
 USA

 email: contracts@esri.com
 */
//>>built
define("esri/SnappingManager",["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array","dojo/_base/Color","dojo/_base/Deferred","dojo/has","dojo/keys","esri/kernel","esri/graphic","esri/geometry/ScreenPoint","esri/geometry/Extent","esri/symbols/SimpleMarkerSymbol","esri/symbols/SimpleLineSymbol","esri/tasks/query"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f){var _10=_1(null,{declaredClass:"esri.SnappingManager",constructor:function(_11){_11=_11||{};if(!_11.map){console.error("map is not specified for SnappingManager");}this.map=_11.map;this.tolerance=_11.tolerance||15;this.layerInfos=[];if(_11.layerInfos){this.layerInfos=_11.layerInfos;}else{var i;for(i=0;i<this.map.graphicsLayerIds.length;i++){var _12=this.map.getLayer(this.map.graphicsLayerIds[i]);this.layerInfos.push({"layer":_12});}this.layerInfos.push({"layer":this.map.graphics});}if(_11.snapPointSymbol){this.snapPointSymbol=_11.snapPointSymbol;}else{this.snapPointSymbol=new _d(_d.STYLE_CROSS,15,new _e(_e.STYLE_SOLID,new _5([0,255,255]),1),new _5([0,255,0,0]));}if(_11.alwaysSnap){this.alwaysSnap=_11.alwaysSnap;}else{this.alwaysSnap=false;}if(_11.snapKey){this.snapKey=_11.snapKey;}else{this.snapKey=_8.copyKey;}this._SelectionLyrQuery=new _f();this._SelectionLyrQuery.spatialRelationship=_f.SPATIAL_REL_INTERSECTS;this._snappingGraphic=new _a();this.setLayerInfos(this.layerInfos);this._currentGraphicOption={snapToPoint:true,snapToVertex:true,snapToEdge:true};this._snappingCallback=_3.hitch(this,this._snappingCallback);},getSnappingPoint:function(_13){var _14=this.layers,_15=this.tolerance,map=this.map,_16=this.layerOptions,_17=map.toMap(_13.offset(-_15,_15)),_18=map.toMap(_13.offset(_15,-_15)),_19=new _c(_17.x,_17.y,_18.x,_18.y,map.spatialReference),_1a=new _f();_1a.geometry=_19;_1a.spatialRelationship=_f.SPATIAL_REL_INTERSECTS;var _1b=[],_1c=[],_1d,_1e=this._extractPointsAndLines,_1f=new _6(),_20=0,_21,_22=_19.xmin,_23=_19.xmax;_4.forEach(_14,function(_24,idx){if(_24.visible&&_24.loaded&&_24.declaredClass==="esri.layers.FeatureLayer"&&_24.mode!==_24.constructor.MODE_SELECTION){_20++;}});if(map.spatialReference._isWrappable()){_22=_c.prototype._normalizeX(_19.xmin,map.spatialReference._getInfo()).x;_23=_c.prototype._normalizeX(_19.xmax,map.spatialReference._getInfo()).x;}var _25=new _c(_22,_19.ymin,_23,_19.ymax,map.spatialReference);_4.forEach(_14,function(_26,idx){if(_26.declaredClass==="esri.layers.GraphicsLayer"&&_26.visible){var _27=[];_4.forEach(_26.graphics,function(_28){if(_28){if(_28.visible&&_25.intersects(_28.geometry)){_27.push(_28);}}});var _29=_1e(_27,_16[idx]);_1b=_1b.concat(_29[0]);_1c=_1c.concat(_29[1]);}});var _2a=_3.hitch(this,function(_2b){_20--;if(_2b instanceof Error){var msg="getSnappingPoint: query features failed";console.log(msg);}else{var _2c=_1e(_2b.features,_16[_21]);_1b=_1b.concat(_2c[0]);_1c=_1c.concat(_2c[1]);}if(!_20){_1d=this._getSnappingPoint(_1b,_1c,_13);_1f.callback(_1d);}});var _2d=false;_4.forEach(_14,function(_2e,idx){if(_2e.visible&&_2e.loaded){_21=idx;if((_2e.declaredClass==="esri.layers.FeatureLayer")&&_2e.mode!==_2e.constructor.MODE_SELECTION){_2d=true;_2e.queryFeatures(_1a,_2a,_2a);}}});if(!_2d){_1d=this._getSnappingPoint(_1b,_1c,_13);_1f.callback(_1d);}return _1f;},setLayerInfos:function(_2f){this.layers=[];this.layerOptions=[];var i;for(i=0;i<_2f.length;i++){this.layers.push(_2f[i].layer);this.layerOptions.push({snapToPoint:true,snapToVertex:true,snapToEdge:true});if(_2f[i].snapToPoint===false){this.layerOptions[i].snapToPoint=_2f[i].snapToPoint;}if(_2f[i].snapToVertex===false){this.layerOptions[i].snapToVertex=_2f[i].snapToVertex;}if(_2f[i].snapToEdge===false){this.layerOptions[i].snapToEdge=_2f[i].snapToEdge;}}this._featurePtsFromSelectionLayer=[];this._featureLinesFromSelectionLayer=[];this._selectionLayers=[];this._selectionLayerOptions=[];_4.forEach(this.layers,function(_30,idx){if(_30.declaredClass==="esri.layers.FeatureLayer"&&_30.mode===_30.constructor.MODE_SELECTION){this._selectionLayers.push(_30);this._selectionLayerOptions.push(this.layerOptions[idx]);}},this);this.layerInfos=_2f;},destroy:function(){_2.disconnect(this._onExtentChangeConnect);this._killOffSnapping();this._featurePtsFromSelectionLayer=this._featureLinesFromSelectionLayer=this._currentFeaturePts=this._currentFeatureLines=this.layers=this.map=null;},_startSelectionLayerQuery:function(){_2.disconnect(this._onExtentChangeConnect);this._mapExtentChangeHandler(this._selectionLayers,this._selectionLayerOptions,this.map.extent);this._onExtentChangeConnect=_2.connect(this.map,"onExtentChange",_3.hitch(this,"_mapExtentChangeHandler",this._selectionLayers,this._selectionLayerOptions));},_stopSelectionLayerQuery:function(){_2.disconnect(this._onExtentChangeConnect);},_mapExtentChangeHandler:function(_31,_32,_33){this._featurePtsFromSelectionLayer=[];this._featureLinesFromSelectionLayer=[];var _34;this._SelectionLyrQuery.geometry=_33;var _35=_3.hitch(this,function(_36){if(_36 instanceof Error){var msg="getSnappingPoint: query features failed";console.log(msg);}else{var _37=this._extractPointsAndLines(_36.features,_32[_34]);this._featurePtsFromSelectionLayer=this._featurePtsFromSelectionLayer.concat(_37[0]);this._featureLinesFromSelectionLayer=this._featureLinesFromSelectionLayer.concat(_37[1]);}});_4.forEach(_31,function(_38,idx){if(_38.visible&&_38.loaded){_34=idx;_38.queryFeatures(this._SelectionLyrQuery,_35,_35);}},this);},_extractPointsAndLines:function(_39,_3a){var _3b=[],_3c=[];var i,j;_4.forEach(_39,function(_3d,idx){if(_3d.visible&&_3d.geometry){if(_3d.geometry.type==="point"&&_3a.snapToPoint){_3b.push(_3d.geometry);}else{if(_3d.geometry.type==="polyline"){for(i=0;i<_3d.geometry.paths.length;i++){_3c.push("lineStart");for(j=0;j<_3d.geometry.paths[i].length;j++){var _3e=_3d.geometry.getPoint(i,j);if(_3a.snapToVertex){_3b.push(_3e);}if(_3a.snapToEdge){_3c.push(_3e);}}_3c.push("lineEnd");}}else{if(_3d.geometry.type==="polygon"){for(i=0;i<_3d.geometry.rings.length;i++){_3c.push("lineStart");for(j=0;j<_3d.geometry.rings[i].length;j++){var _3f=_3d.geometry.getPoint(i,j);if(_3a.snapToVertex){_3b.push(_3f);}if(_3a.snapToEdge){_3c.push(_3f);}}_3c.push("lineEnd");}}}}}});return [_3b,_3c];},_getSnappingPoint:function(_40,_41,_42){var _43,_44,_45=this.tolerance;var map=this.map;var _46=this.map._getFrameWidth();_40=_40.concat(this._featurePtsFromSelectionLayer);_41=_41.concat(this._featureLinesFromSelectionLayer);if(this._currentGraphic){var _47=this._extractPointsAndLines([this._currentGraphic],this._currentGraphicOption);_40=_40.concat(_47[0]);_41=_41.concat(_47[1]);}var _48,_49;_4.forEach(_40,function(pt,idx){var _4a=map.toScreen(pt,true);if(_46!==-1){_4a.x=_4a.x%_46;if(_4a.x<0){_4a.x+=_46;}if(map.width>_46){var _4b=(map.width-_46)/2;while(_4a.x<_4b){_4a.x+=_46;}}}_43=Math.sqrt((_4a.x-_42.x)*(_4a.x-_42.x)+(_4a.y-_42.y)*(_4a.y-_42.y));if(_43<=_45){_45=_43;_48=_4a.x;_49=_4a.y;}});if(_48){var _4c=new _b(_48,_49);_4c=map.toMap(_4c);_44=_4c;}else{var _4d,_4e,i,j;_45=this.tolerance;for(i=0;i<_41.length;i++){if(_41[i]==="lineStart"){for(j=i+1;j<_41.length;j++){if(_41[j+1]!=="lineEnd"&&_41[j+1]!=="lineStart"&&_41[j]!=="lineEnd"&&_41[j]!=="lineStart"){var _4f=map.toScreen(_41[j],true),_50=map.toScreen(_41[j+1],true),_51=(_4f.x>=_50.x)?_4f:_50,_52=(_4f.x>=_50.x)?_50:_4f;if(_46!==-1){_51.x=_51.x%_46;if(_51.x<0){_51.x+=_46;}_52.x=_52.x%_46;if(_52.x<0){_52.x+=_46;}if(_52.x>_51.x){_52.x-=_46;}}var x1=_51.x,y1=_51.y,x2=_52.x,y2=_52.y;var _53,_54,_55,_56,_57,_58;if(x1===x2){_53=x1;_54=_42.y;_55=_56=x1;_57=(y1<=y2)?y1:y2;_58=(y1<=y2)?y2:y1;}else{if(y1===y2){_53=_42.x;_54=y1;_55=(x1<=x2)?x1:x2;_56=(x1<=x2)?x2:x1;_57=_58=y1;}else{var a=(y2-y1)/(x2-x1),b=(y1*x2-x1*y2)/(x2-x1),_59=(x1-x2)/(y2-y1),_5a=(_42.y*y2-_42.y*y1-_42.x*x1+_42.x*x2)/(y2-y1);_53=(b-_5a)/(_59-a);_54=a*_53+b;_55=(x1<=x2)?x1:x2;_56=(x1<=x2)?x2:x1;_57=(y1<=y2)?y1:y2;_58=(y1<=y2)?y2:y1;}}if(_53>=_55&&_53<=_56&&_54>=_57&&_54<=_58){var _5b=Math.sqrt((_42.x-_53)*(_42.x-_53)+(_42.y-_54)*(_42.y-_54));if(_5b<=_45){_45=_5b;_4d=_53;_4e=_54;}}else{var _5c=Math.sqrt((x1-_42.x)*(x1-_42.x)+(y1-_42.y)*(y1-_42.y));var _5d=Math.sqrt((x2-_42.x)*(x2-_42.x)+(y2-_42.y)*(y2-_42.y));var _5e;if(_5c<=_5d){_5e=_5c;_53=x1;_54=y1;}else{_5e=_5d;_53=x2;_54=y2;}if(_5e<=_45){_45=_5e;_4d=_53;_4e=_54;}}}if(_41[j]==="lineEnd"){i=j;break;}}}}if(_4d){var _5f=new _b(_4d,_4e);_5f=map.toMap(_5f);_44=_5f;}}return _44;},_setGraphic:function(_60){this._currentGraphic=_60;},_addSnappingPointGraphic:function(){var map=this.map;var _61=this.snapPointSymbol;this._snappingGraphic.setSymbol(_61);map.graphics.add(this._snappingGraphic);},_setUpSnapping:function(){var map=this.map;this._onSnapKeyDown_connect=_2.connect(map,"onKeyDown",this,"_onSnapKeyDownHandler");this._onSnapKeyUp_connect=_2.connect(map,"onKeyUp",this,"_onSnapKeyUpHandler");this._onSnappingMouseMove_connect=_2.connect(map,"onMouseMove",this,"_onSnappingMouseMoveHandler");this._onSnappingMouseDrag_connect=_2.connect(map,"onMouseDrag",this,"_onSnappingMouseMoveHandler");if(this.alwaysSnap){this._activateSnapping();}},_killOffSnapping:function(){_2.disconnect(this._onSnapKeyDown_connect);_2.disconnect(this._onSnapKeyUp_connect);_2.disconnect(this._onSnappingMouseMove_connect);_2.disconnect(this._onSnappingMouseDrag_connect);this._deactivateSnapping();},_onSnapKeyDownHandler:function(evt){if(evt.keyCode===this.snapKey){_2.disconnect(this._onSnapKeyDown_connect);if(this.alwaysSnap){this._deactivateSnapping();}else{this._activateSnapping();}}},_activateSnapping:function(){this._snappingActive=true;this._addSnappingPointGraphic();if(this._currentLocation){this._onSnappingMouseMoveHandler(this._currentLocation);}},_onSnapKeyUpHandler:function(evt){if(evt.keyCode===this.snapKey){this._onSnapKeyDown_connect=_2.connect(this.map,"onKeyDown",this,"_onSnapKeyDownHandler");if(this.alwaysSnap){this._activateSnapping();}else{this._deactivateSnapping();}}},_deactivateSnapping:function(){this._snappingActive=false;this._snappingPoint=null;this.map.graphics.remove(this._snappingGraphic);this._snappingGraphic.setGeometry(null);},_onSnappingMouseMoveHandler:function(evt){this._currentLocation=evt;this._snappingPoint=null;if(this._snappingActive){this._snappingGraphic.hide();var _62=this.getSnappingPoint(evt.screenPoint);_62.addCallback(this._snappingCallback);}},_snappingCallback:function(_63){this._snappingPoint=_63;if(_63){this._snappingGraphic.show();this._snappingGraphic.setGeometry(_63);}}});if(_7("extend-esri")){_9.SnappingManager=_10;}return _10;});