/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/gfx/path":function(){define("dojox/gfx/path",["./_base","dojo/_base/lang","dojo/_base/declare","./matrix","./shape"],function(g,_1,_2,_3,_4){var _5=_2("dojox.gfx.path.Path",_4.Shape,{constructor:function(_6){this.shape=_1.clone(g.defaultPath);this.segments=[];this.tbbox=null;this.absolute=true;this.last={};this.rawNode=_6;this.segmented=false;},setAbsoluteMode:function(_7){this._confirmSegmented();this.absolute=typeof _7=="string"?(_7=="absolute"):_7;return this;},getAbsoluteMode:function(){this._confirmSegmented();return this.absolute;},getBoundingBox:function(){this._confirmSegmented();return (this.bbox&&("l" in this.bbox))?{x:this.bbox.l,y:this.bbox.t,width:this.bbox.r-this.bbox.l,height:this.bbox.b-this.bbox.t}:null;},_getRealBBox:function(){this._confirmSegmented();if(this.tbbox){return this.tbbox;}var _8=this.bbox,_3=this._getRealMatrix();this.bbox=null;for(var i=0,_9=this.segments.length;i<_9;++i){this._updateWithSegment(this.segments[i],_3);}var t=this.bbox;this.bbox=_8;this.tbbox=t?[{x:t.l,y:t.t},{x:t.r,y:t.t},{x:t.r,y:t.b},{x:t.l,y:t.b}]:null;return this.tbbox;},getLastPosition:function(){this._confirmSegmented();return "x" in this.last?this.last:null;},_applyTransform:function(){this.tbbox=null;return this.inherited(arguments);},_updateBBox:function(x,y,m){if(m){var t=_3.multiplyPoint(m,x,y);x=t.x;y=t.y;}if(this.bbox&&("l" in this.bbox)){if(this.bbox.l>x){this.bbox.l=x;}if(this.bbox.r<x){this.bbox.r=x;}if(this.bbox.t>y){this.bbox.t=y;}if(this.bbox.b<y){this.bbox.b=y;}}else{this.bbox={l:x,b:y,r:x,t:y};}},_updateWithSegment:function(_a,_b){var n=_a.args,l=n.length,i;switch(_a.action){case "M":case "L":case "C":case "S":case "Q":case "T":for(i=0;i<l;i+=2){this._updateBBox(n[i],n[i+1],_b);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "H":for(i=0;i<l;++i){this._updateBBox(n[i],this.last.y,_b);}this.last.x=n[l-1];this.absolute=true;break;case "V":for(i=0;i<l;++i){this._updateBBox(this.last.x,n[i],_b);}this.last.y=n[l-1];this.absolute=true;break;case "m":var _c=0;if(!("x" in this.last)){this._updateBBox(this.last.x=n[0],this.last.y=n[1],_b);_c=2;}for(i=_c;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_b);}this.absolute=false;break;case "l":case "t":for(i=0;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_b);}this.absolute=false;break;case "h":for(i=0;i<l;++i){this._updateBBox(this.last.x+=n[i],this.last.y,_b);}this.absolute=false;break;case "v":for(i=0;i<l;++i){this._updateBBox(this.last.x,this.last.y+=n[i],_b);}this.absolute=false;break;case "c":for(i=0;i<l;i+=6){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_b);this._updateBBox(this.last.x+n[i+2],this.last.y+n[i+3],_b);this._updateBBox(this.last.x+=n[i+4],this.last.y+=n[i+5],_b);}this.absolute=false;break;case "s":case "q":for(i=0;i<l;i+=4){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_b);this._updateBBox(this.last.x+=n[i+2],this.last.y+=n[i+3],_b);}this.absolute=false;break;case "A":for(i=0;i<l;i+=7){this._updateBBox(n[i+5],n[i+6],_b);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "a":for(i=0;i<l;i+=7){this._updateBBox(this.last.x+=n[i+5],this.last.y+=n[i+6],_b);}this.absolute=false;break;}var _d=[_a.action];for(i=0;i<l;++i){_d.push(g.formatNumber(n[i],true));}if(typeof this.shape.path=="string"){this.shape.path+=_d.join("");}else{Array.prototype.push.apply(this.shape.path,_d);}},_validSegments:{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7,z:0},_pushSegment:function(_e,_f){this.tbbox=null;var _10=this._validSegments[_e.toLowerCase()],_11;if(typeof _10=="number"){if(_10){if(_f.length>=_10){_11={action:_e,args:_f.slice(0,_f.length-_f.length%_10)};this.segments.push(_11);this._updateWithSegment(_11);}}else{_11={action:_e,args:[]};this.segments.push(_11);this._updateWithSegment(_11);}}},_collectArgs:function(_12,_13){for(var i=0;i<_13.length;++i){var t=_13[i];if(typeof t=="boolean"){_12.push(t?1:0);}else{if(typeof t=="number"){_12.push(t);}else{if(t instanceof Array){this._collectArgs(_12,t);}else{if("x" in t&&"y" in t){_12.push(t.x,t.y);}}}}}},moveTo:function(){this._confirmSegmented();var _14=[];this._collectArgs(_14,arguments);this._pushSegment(this.absolute?"M":"m",_14);return this;},lineTo:function(){this._confirmSegmented();var _15=[];this._collectArgs(_15,arguments);this._pushSegment(this.absolute?"L":"l",_15);return this;},hLineTo:function(){this._confirmSegmented();var _16=[];this._collectArgs(_16,arguments);this._pushSegment(this.absolute?"H":"h",_16);return this;},vLineTo:function(){this._confirmSegmented();var _17=[];this._collectArgs(_17,arguments);this._pushSegment(this.absolute?"V":"v",_17);return this;},curveTo:function(){this._confirmSegmented();var _18=[];this._collectArgs(_18,arguments);this._pushSegment(this.absolute?"C":"c",_18);return this;},smoothCurveTo:function(){this._confirmSegmented();var _19=[];this._collectArgs(_19,arguments);this._pushSegment(this.absolute?"S":"s",_19);return this;},qCurveTo:function(){this._confirmSegmented();var _1a=[];this._collectArgs(_1a,arguments);this._pushSegment(this.absolute?"Q":"q",_1a);return this;},qSmoothCurveTo:function(){this._confirmSegmented();var _1b=[];this._collectArgs(_1b,arguments);this._pushSegment(this.absolute?"T":"t",_1b);return this;},arcTo:function(){this._confirmSegmented();var _1c=[];this._collectArgs(_1c,arguments);this._pushSegment(this.absolute?"A":"a",_1c);return this;},closePath:function(){this._confirmSegmented();this._pushSegment("Z",[]);return this;},_confirmSegmented:function(){if(!this.segmented){var _1d=this.shape.path;this.shape.path=[];this._setPath(_1d);this.shape.path=this.shape.path.join("");this.segmented=true;}},_setPath:function(_1e){var p=_1.isArray(_1e)?_1e:_1e.match(g.pathSvgRegExp);this.segments=[];this.absolute=true;this.bbox={};this.last={};if(!p){return;}var _1f="",_20=[],l=p.length;for(var i=0;i<l;++i){var t=p[i],x=parseFloat(t);if(isNaN(x)){if(_1f){this._pushSegment(_1f,_20);}_20=[];_1f=t;}else{_20.push(x);}}this._pushSegment(_1f,_20);},setShape:function(_21){this.inherited(arguments,[typeof _21=="string"?{path:_21}:_21]);this.segmented=false;this.segments=[];if(!g.lazyPathSegmentation){this._confirmSegmented();}return this;},_2PI:Math.PI*2});var _22=_2("dojox.gfx.path.TextPath",_5,{constructor:function(_23){if(!("text" in this)){this.text=_1.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=_1.clone(g.defaultFont);}},getText:function(){return this.text;},setText:function(_24){this.text=g.makeParameters(this.text,typeof _24=="string"?{text:_24}:_24);this._setText();return this;},getFont:function(){return this.fontStyle;},setFont:function(_25){this.fontStyle=typeof _25=="string"?g.splitFontString(_25):g.makeParameters(g.defaultFont,_25);this._setFont();return this;}});return g.path={Path:_5,TextPath:_22};});},"dojox/gfx/shape":function(){define("dojox/gfx/shape",["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,_26,_27,_28,has,_29,arr,_2a,_2b,_2c){var _2d=g.shape={};var _2e={};var _2f={};_2d.register=function(s){var t=s.declaredClass.split(".").pop();var i=t in _2e?++_2e[t]:((_2e[t]=0));var uid=t+i;_2f[uid]=s;return uid;};_2d.byId=function(id){return _2f[id];};_2d.dispose=function(s,_30){if(_30&&s.children){for(var i=0;i<s.children.length;++i){_2d.dispose(s.children[i],true);}}delete _2f[s.getUID()];};_2d.Shape=_27("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;var uid=_2d.register(this);this.getUID=function(){return uid;};},destroy:function(){_2d.dispose(this);},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_2c;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(_31){this.clip=_31;},getClip:function(){return this.clip;},setShape:function(_32){this.shape=g.makeParameters(this.shape,_32);this.bbox=null;return this;},setFill:function(_33){if(!_33){this.fillStyle=null;return this;}var f=null;if(typeof (_33)=="object"&&"type" in _33){switch(_33.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,_33);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_33);break;case "pattern":f=g.makeParameters(g.defaultPattern,_33);break;}}else{f=g.normalizeColor(_33);}this.fillStyle=f;return this;},setStroke:function(_34){if(!_34){this.strokeStyle=null;return this;}if(typeof _34=="string"||_26.isArray(_34)||_34 instanceof _2b){_34={color:_34};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_34);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_35){this.matrix=_2c.clone(_35?_2c.normalize(_35):_2c.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_36){return _36?this.setTransform([this.matrix,_36]):this;},applyLeftTransform:function(_37){return _37?this.setTransform([_37,this.matrix]):this;},applyTransform:function(_38){return _38?this.setTransform([this.matrix,_38]):this;},removeShape:function(_39){if(this.parent){this.parent.remove(this,_39);}return this;},_setParent:function(_3a,_3b){this.parent=_3a;return this._updateParentMatrix(_3b);},_updateParentMatrix:function(_3c){this.parentMatrix=_3c?_2c.clone(_3c):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_2c.multiply(p.matrix,m);}p=p.parent;}return m;}});_2d._eventsProcessing={connect:function(_3d,_3e,_3f){return _29.connect(this.getEventSource(),_3d,_2d.fixCallback(this,g.fixTarget,_3e,_3f));},disconnect:function(_40){_29.disconnect(_40);}};_2d.fixCallback=function(_41,_42,_43,_44){if(!_44){_44=_43;_43=null;}if(_26.isString(_44)){_43=_43||_28.global;if(!_43[_44]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_44,"\"] is null (scope=\"",_43,"\")"].join(""));}return function(e){return _42(e,_41)?_43[_44].apply(_43,arguments||[]):undefined;};}return !_43?function(e){return _42(e,_41)?_44.apply(_43,arguments):undefined;}:function(e){return _42(e,_41)?_44.apply(_43,arguments||[]):undefined;};};_26.extend(_2d.Shape,_2d._eventsProcessing);_2d.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(_45){var _46=_45.getParent();if(_46){_46.remove(_45,true);}this.children.push(_45);return _45._setParent(this,this._getRealMatrix());},remove:function(_47,_48){for(var i=0;i<this.children.length;++i){if(this.children[i]==_47){if(_48){}else{_47.parent=null;_47.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_49){var _4a;for(var i=0;i<this.children.length;++i){_4a=this.children[i];_4a.parent=null;_4a.parentMatrix=null;if(_49){_4a.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _4b=null;arr.forEach(this.children,function(_4c){var bb=_4c.getBoundingBox();if(bb){var ct=_4c.getTransform();if(ct){bb=_2c.multiplyRectangle(ct,bb);}if(_4b){_4b.x=Math.min(_4b.x,bb.x);_4b.y=Math.min(_4b.y,bb.y);_4b.endX=Math.max(_4b.endX,bb.x+bb.width);_4b.endY=Math.max(_4b.endY,bb.y+bb.height);}else{_4b={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_4b){_4b.width=_4b.endX-_4b.x;_4b.height=_4b.endY-_4b.y;}return _4b;}return null;},_moveChildToFront:function(_4d){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4d){this.children.splice(i,1);this.children.push(_4d);break;}}return this;},_moveChildToBack:function(_4e){for(var i=0;i<this.children.length;++i){if(this.children[i]==_4e){this.children.splice(i,1);this.children.unshift(_4e);break;}}return this;}};_2d.Surface=_27("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){arr.forEach(this._nodes,_2a.destroy);this._nodes=[];arr.forEach(this._events,_29.disconnect);this._events=[];this.rawNode=null;if(has("ie")){while(this._parent.lastChild){_2a.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_4f){},whenLoaded:function(_50,_51){var f=_26.hitch(_50,_51);if(this.isLoaded){f(this);}else{var h=_29.connect(this,"onLoad",function(_52){_29.disconnect(h);f(_52);});}}});_26.extend(_2d.Surface,_2d._eventsProcessing);_2d.Rect=_27("dojox.gfx.shape.Rect",_2d.Shape,{constructor:function(_53){this.shape=g.getDefault("Rect");this.rawNode=_53;},getBoundingBox:function(){return this.shape;}});_2d.Ellipse=_27("dojox.gfx.shape.Ellipse",_2d.Shape,{constructor:function(_54){this.shape=g.getDefault("Ellipse");this.rawNode=_54;},getBoundingBox:function(){if(!this.bbox){var _55=this.shape;this.bbox={x:_55.cx-_55.rx,y:_55.cy-_55.ry,width:2*_55.rx,height:2*_55.ry};}return this.bbox;}});_2d.Circle=_27("dojox.gfx.shape.Circle",_2d.Shape,{constructor:function(_56){this.shape=g.getDefault("Circle");this.rawNode=_56;},getBoundingBox:function(){if(!this.bbox){var _57=this.shape;this.bbox={x:_57.cx-_57.r,y:_57.cy-_57.r,width:2*_57.r,height:2*_57.r};}return this.bbox;}});_2d.Line=_27("dojox.gfx.shape.Line",_2d.Shape,{constructor:function(_58){this.shape=g.getDefault("Line");this.rawNode=_58;},getBoundingBox:function(){if(!this.bbox){var _59=this.shape;this.bbox={x:Math.min(_59.x1,_59.x2),y:Math.min(_59.y1,_59.y2),width:Math.abs(_59.x2-_59.x1),height:Math.abs(_59.y2-_59.y1)};}return this.bbox;}});_2d.Polyline=_27("dojox.gfx.shape.Polyline",_2d.Shape,{constructor:function(_5a){this.shape=g.getDefault("Polyline");this.rawNode=_5a;},setShape:function(_5b,_5c){if(_5b&&_5b instanceof Array){this.inherited(arguments,[{points:_5b}]);if(_5c&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_5b]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _5d=[];for(var i=0;i<l;i+=2){_5d.push({x:p[i],y:p[i+1]});}this.shape.points=_5d;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var _5e={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(_5e.l>t.x){_5e.l=t.x;}if(_5e.r<t.x){_5e.r=t.x;}if(_5e.t>t.y){_5e.t=t.y;}if(_5e.b<t.y){_5e.b=t.y;}}this.bbox={x:_5e.l,y:_5e.t,width:_5e.r-_5e.l,height:_5e.b-_5e.t};}return this.bbox;}});_2d.Image=_27("dojox.gfx.shape.Image",_2d.Shape,{constructor:function(_5f){this.shape=g.getDefault("Image");this.rawNode=_5f;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_2d.Text=_27(_2d.Shape,{constructor:function(_60){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_60;},getFont:function(){return this.fontStyle;},setFont:function(_61){this.fontStyle=typeof _61=="string"?g.splitFontString(_61):g.makeParameters(g.defaultFont,_61);this._setFont();return this;}});_2d.Creator={createShape:function(_62){switch(_62.type){case g.defaultPath.type:return this.createPath(_62);case g.defaultRect.type:return this.createRect(_62);case g.defaultCircle.type:return this.createCircle(_62);case g.defaultEllipse.type:return this.createEllipse(_62);case g.defaultLine.type:return this.createLine(_62);case g.defaultPolyline.type:return this.createPolyline(_62);case g.defaultImage.type:return this.createImage(_62);case g.defaultText.type:return this.createText(_62);case g.defaultTextPath.type:return this.createTextPath(_62);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(_63){return this.createObject(g.Rect,_63);},createEllipse:function(_64){return this.createObject(g.Ellipse,_64);},createCircle:function(_65){return this.createObject(g.Circle,_65);},createLine:function(_66){return this.createObject(g.Line,_66);},createPolyline:function(_67){return this.createObject(g.Polyline,_67);},createImage:function(_68){return this.createObject(g.Image,_68);},createText:function(_69){return this.createObject(g.Text,_69);},createPath:function(_6a){return this.createObject(g.Path,_6a);},createTextPath:function(_6b){return this.createObject(g.TextPath,{}).setText(_6b);},createObject:function(_6c,_6d){return null;}};return _2d;});},"*noref":1}});define("dojox/gfx/svg",["dojo/_base/lang","dojo/_base/sniff","dojo/_base/window","dojo/dom","dojo/_base/declare","dojo/_base/array","dojo/dom-geometry","dojo/dom-attr","dojo/_base/Color","./_base","./shape","./path"],function(_6e,has,win,dom,_6f,arr,_70,_71,_72,g,gs,_73){var svg=g.svg={};svg.useSvgWeb=(typeof window.svgweb!="undefined");var _74=navigator.userAgent,_75=has("ios"),_76=has("android"),_77=has("chrome")||(_76&&_76>=4)?"auto":"optimizeLegibility";function _78(ns,_79){if(win.doc.createElementNS){return win.doc.createElementNS(ns,_79);}else{return win.doc.createElement(_79);}};function _7a(_7b,ns,_7c,_7d){if(_7b.setAttributeNS){return _7b.setAttributeNS(ns,_7c,_7d);}else{return _7b.setAttribute(_7c,_7d);}};function _7e(_7f){if(svg.useSvgWeb){return win.doc.createTextNode(_7f,true);}else{return win.doc.createTextNode(_7f);}};function _80(){if(svg.useSvgWeb){return win.doc.createDocumentFragment(true);}else{return win.doc.createDocumentFragment();}};svg.xmlns={xlink:"http://www.w3.org/1999/xlink",svg:"http://www.w3.org/2000/svg"};svg.getRef=function(_81){if(!_81||_81=="none"){return null;}if(_81.match(/^url\(#.+\)$/)){return dom.byId(_81.slice(5,-1));}if(_81.match(/^#dojoUnique\d+$/)){return dom.byId(_81.slice(1));}return null;};svg.dasharray={solid:"none",shortdash:[4,1],shortdot:[1,1],shortdashdot:[4,1,1,1],shortdashdotdot:[4,1,1,1,1,1],dot:[1,3],dash:[4,3],longdash:[8,3],dashdot:[4,3,1,3],longdashdot:[8,3,1,3],longdashdotdot:[8,3,1,3,1,3]};var _82=0;svg.Shape=_6f("dojox.gfx.svg.Shape",gs.Shape,{destroy:function(){if(this.fillStyle&&"type" in this.fillStyle){var _83=this.rawNode.getAttribute("fill"),ref=svg.getRef(_83);if(ref){ref.parentNode.removeChild(ref);}}if(this.clip){var _84=this.rawNode.getAttribute("clip-path");if(_84){var _85=dom.byId(_84.match(/gfx_clip[\d]+/)[0]);_85&&_85.parentNode.removeChild(_85);}}this.rawNode=null;gs.Shape.prototype.destroy.apply(this,arguments);},setFill:function(_86){if(!_86){this.fillStyle=null;this.rawNode.setAttribute("fill","none");this.rawNode.setAttribute("fill-opacity",0);return this;}var f;var _87=function(x){this.setAttribute(x,f[x].toFixed(8));};if(typeof (_86)=="object"&&"type" in _86){switch(_86.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,_86);var _88=this._setFillObject(f,"linearGradient");arr.forEach(["x1","y1","x2","y2"],_87,_88);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_86);var _89=this._setFillObject(f,"radialGradient");arr.forEach(["cx","cy","r"],_87,_89);break;case "pattern":f=g.makeParameters(g.defaultPattern,_86);var _8a=this._setFillObject(f,"pattern");arr.forEach(["x","y","width","height"],_87,_8a);break;}this.fillStyle=f;return this;}f=g.normalizeColor(_86);this.fillStyle=f;this.rawNode.setAttribute("fill",f.toCss());this.rawNode.setAttribute("fill-opacity",f.a);this.rawNode.setAttribute("fill-rule","evenodd");return this;},setStroke:function(_8b){var rn=this.rawNode;if(!_8b){this.strokeStyle=null;rn.setAttribute("stroke","none");rn.setAttribute("stroke-opacity",0);return this;}if(typeof _8b=="string"||_6e.isArray(_8b)||_8b instanceof _72){_8b={color:_8b};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_8b);s.color=g.normalizeColor(s.color);if(s){rn.setAttribute("stroke",s.color.toCss());rn.setAttribute("stroke-opacity",s.color.a);rn.setAttribute("stroke-width",s.width);rn.setAttribute("stroke-linecap",s.cap);if(typeof s.join=="number"){rn.setAttribute("stroke-linejoin","miter");rn.setAttribute("stroke-miterlimit",s.join);}else{rn.setAttribute("stroke-linejoin",s.join);}var da=s.style.toLowerCase();if(da in svg.dasharray){da=svg.dasharray[da];}if(da instanceof Array){da=_6e._toArray(da);for(var i=0;i<da.length;++i){da[i]*=s.width;}if(s.cap!="butt"){for(var i=0;i<da.length;i+=2){da[i]-=s.width;if(da[i]<1){da[i]=1;}}for(var i=1;i<da.length;i+=2){da[i]+=s.width;}}da=da.join(",");}rn.setAttribute("stroke-dasharray",da);rn.setAttribute("dojoGfxStrokeStyle",s.style);}return this;},_getParentSurface:function(){var _8c=this.parent;for(;_8c&&!(_8c instanceof g.Surface);_8c=_8c.parent){}return _8c;},_setFillObject:function(f,_8d){var _8e=svg.xmlns.svg;this.fillStyle=f;var _8f=this._getParentSurface(),_90=_8f.defNode,_91=this.rawNode.getAttribute("fill"),ref=svg.getRef(_91);if(ref){_91=ref;if(_91.tagName.toLowerCase()!=_8d.toLowerCase()){var id=_91.id;_91.parentNode.removeChild(_91);_91=_78(_8e,_8d);_91.setAttribute("id",id);_90.appendChild(_91);}else{while(_91.childNodes.length){_91.removeChild(_91.lastChild);}}}else{_91=_78(_8e,_8d);_91.setAttribute("id",g._base._getUniqueId());_90.appendChild(_91);}if(_8d=="pattern"){_91.setAttribute("patternUnits","userSpaceOnUse");var img=_78(_8e,"image");img.setAttribute("x",0);img.setAttribute("y",0);img.setAttribute("width",f.width.toFixed(8));img.setAttribute("height",f.height.toFixed(8));_7a(img,svg.xmlns.xlink,"xlink:href",f.src);_91.appendChild(img);}else{_91.setAttribute("gradientUnits","userSpaceOnUse");for(var i=0;i<f.colors.length;++i){var c=f.colors[i],t=_78(_8e,"stop"),cc=c.color=g.normalizeColor(c.color);t.setAttribute("offset",c.offset.toFixed(8));t.setAttribute("stop-color",cc.toCss());t.setAttribute("stop-opacity",cc.a);_91.appendChild(t);}}this.rawNode.setAttribute("fill","url(#"+_91.getAttribute("id")+")");this.rawNode.removeAttribute("fill-opacity");this.rawNode.setAttribute("fill-rule","evenodd");return _91;},_applyTransform:function(){var _92=this.matrix;if(_92){var tm=this.matrix;this.rawNode.setAttribute("transform","matrix("+tm.xx.toFixed(8)+","+tm.yx.toFixed(8)+","+tm.xy.toFixed(8)+","+tm.yy.toFixed(8)+","+tm.dx.toFixed(8)+","+tm.dy.toFixed(8)+")");}else{this.rawNode.removeAttribute("transform");}return this;},setRawNode:function(_93){var r=this.rawNode=_93;if(this.shape.type!="image"){r.setAttribute("fill","none");}r.setAttribute("fill-opacity",0);r.setAttribute("stroke","none");r.setAttribute("stroke-opacity",0);r.setAttribute("stroke-width",1);r.setAttribute("stroke-linecap","butt");r.setAttribute("stroke-linejoin","miter");r.setAttribute("stroke-miterlimit",4);r.__gfxObject__=this.getUID();},setShape:function(_94){this.shape=g.makeParameters(this.shape,_94);for(var i in this.shape){if(i!="type"){this.rawNode.setAttribute(i,this.shape[i]);}}this.bbox=null;return this;},_moveToFront:function(){this.rawNode.parentNode.appendChild(this.rawNode);return this;},_moveToBack:function(){this.rawNode.parentNode.insertBefore(this.rawNode,this.rawNode.parentNode.firstChild);return this;},setClip:function(_95){this.inherited(arguments);var _96=_95?"width" in _95?"rect":"cx" in _95?"ellipse":"points" in _95?"polyline":"d" in _95?"path":null:null;if(_95&&!_96){return this;}if(_96==="polyline"){_95=_6e.clone(_95);_95.points=_95.points.join(",");}var _97,_98,_99=_71.get(this.rawNode,"clip-path");if(_99){_97=dom.byId(_99.match(/gfx_clip[\d]+/)[0]);if(_97){_97.removeChild(_97.childNodes[0]);}}if(_95){if(_97){_98=_78(svg.xmlns.svg,_96);_97.appendChild(_98);}else{var _9a=++_82;var _9b="gfx_clip"+_9a;var _9c="url(#"+_9b+")";this.rawNode.setAttribute("clip-path",_9c);_97=_78(svg.xmlns.svg,"clipPath");_98=_78(svg.xmlns.svg,_96);_97.appendChild(_98);this.rawNode.parentNode.appendChild(_97);_71.set(_97,"id",_9b);}_71.set(_98,_95);}else{this.rawNode.removeAttribute("clip-path");if(_97){_97.parentNode.removeChild(_97);}}return this;},_removeClipNode:function(){var _9d,_9e=_71.get(this.rawNode,"clip-path");if(_9e){_9d=dom.byId(_9e.match(/gfx_clip[\d]+/)[0]);if(_9d){_9d.parentNode.removeChild(_9d);}}return _9d;}});svg.Group=_6f("dojox.gfx.svg.Group",svg.Shape,{constructor:function(){gs.Container._init.call(this);},setRawNode:function(_9f){this.rawNode=_9f;this.rawNode.__gfxObject__=this.getUID();},destroy:function(){this.clear(true);svg.Shape.prototype.destroy.apply(this,arguments);}});svg.Group.nodeType="g";svg.Rect=_6f("dojox.gfx.svg.Rect",[svg.Shape,gs.Rect],{setShape:function(_a0){this.shape=g.makeParameters(this.shape,_a0);this.bbox=null;for(var i in this.shape){if(i!="type"&&i!="r"){this.rawNode.setAttribute(i,this.shape[i]);}}if(this.shape.r!=null){this.rawNode.setAttribute("ry",this.shape.r);this.rawNode.setAttribute("rx",this.shape.r);}return this;}});svg.Rect.nodeType="rect";svg.Ellipse=_6f("dojox.gfx.svg.Ellipse",[svg.Shape,gs.Ellipse],{});svg.Ellipse.nodeType="ellipse";svg.Circle=_6f("dojox.gfx.svg.Circle",[svg.Shape,gs.Circle],{});svg.Circle.nodeType="circle";svg.Line=_6f("dojox.gfx.svg.Line",[svg.Shape,gs.Line],{});svg.Line.nodeType="line";svg.Polyline=_6f("dojox.gfx.svg.Polyline",[svg.Shape,gs.Polyline],{setShape:function(_a1,_a2){if(_a1&&_a1 instanceof Array){this.shape=g.makeParameters(this.shape,{points:_a1});if(_a2&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.shape=g.makeParameters(this.shape,_a1);}this.bbox=null;this._normalizePoints();var _a3=[],p=this.shape.points;for(var i=0;i<p.length;++i){_a3.push(p[i].x.toFixed(8),p[i].y.toFixed(8));}this.rawNode.setAttribute("points",_a3.join(" "));return this;}});svg.Polyline.nodeType="polyline";svg.Image=_6f("dojox.gfx.svg.Image",[svg.Shape,gs.Image],{setShape:function(_a4){this.shape=g.makeParameters(this.shape,_a4);this.bbox=null;var _a5=this.rawNode;for(var i in this.shape){if(i!="type"&&i!="src"){_a5.setAttribute(i,this.shape[i]);}}_a5.setAttribute("preserveAspectRatio","none");_7a(_a5,svg.xmlns.xlink,"xlink:href",this.shape.src);_a5.__gfxObject__=this.getUID();return this;}});svg.Image.nodeType="image";svg.Text=_6f("dojox.gfx.svg.Text",[svg.Shape,gs.Text],{setShape:function(_a6){this.shape=g.makeParameters(this.shape,_a6);this.bbox=null;var r=this.rawNode,s=this.shape;r.setAttribute("x",s.x);r.setAttribute("y",s.y);r.setAttribute("text-anchor",s.align);r.setAttribute("text-decoration",s.decoration);r.setAttribute("rotate",s.rotated?90:0);r.setAttribute("kerning",s.kerning?"auto":0);r.setAttribute("text-rendering",_77);if(r.firstChild){r.firstChild.nodeValue=s.text;}else{r.appendChild(_7e(s.text));}return this;},getTextWidth:function(){var _a7=this.rawNode,_a8=_a7.parentNode,_a9=_a7.cloneNode(true);_a9.style.visibility="hidden";var _aa=0,_ab=_a9.firstChild.nodeValue;_a8.appendChild(_a9);if(_ab!=""){while(!_aa){if(_a9.getBBox){_aa=parseInt(_a9.getBBox().width);}else{_aa=68;}}}_a8.removeChild(_a9);return _aa;}});svg.Text.nodeType="text";svg.Path=_6f("dojox.gfx.svg.Path",[svg.Shape,_73.Path],{_updateWithSegment:function(_ac){this.inherited(arguments);if(typeof (this.shape.path)=="string"){this.rawNode.setAttribute("d",this.shape.path);}},setShape:function(_ad){this.inherited(arguments);if(this.shape.path){this.rawNode.setAttribute("d",this.shape.path);}else{this.rawNode.removeAttribute("d");}return this;}});svg.Path.nodeType="path";svg.TextPath=_6f("dojox.gfx.svg.TextPath",[svg.Shape,_73.TextPath],{_updateWithSegment:function(_ae){this.inherited(arguments);this._setTextPath();},setShape:function(_af){this.inherited(arguments);this._setTextPath();return this;},_setTextPath:function(){if(typeof this.shape.path!="string"){return;}var r=this.rawNode;if(!r.firstChild){var tp=_78(svg.xmlns.svg,"textPath"),tx=_7e("");tp.appendChild(tx);r.appendChild(tp);}var ref=r.firstChild.getAttributeNS(svg.xmlns.xlink,"href"),_b0=ref&&svg.getRef(ref);if(!_b0){var _b1=this._getParentSurface();if(_b1){var _b2=_b1.defNode;_b0=_78(svg.xmlns.svg,"path");var id=g._base._getUniqueId();_b0.setAttribute("id",id);_b2.appendChild(_b0);_7a(r.firstChild,svg.xmlns.xlink,"xlink:href","#"+id);}}if(_b0){_b0.setAttribute("d",this.shape.path);}},_setText:function(){var r=this.rawNode;if(!r.firstChild){var tp=_78(svg.xmlns.svg,"textPath"),tx=_7e("");tp.appendChild(tx);r.appendChild(tp);}r=r.firstChild;var t=this.text;r.setAttribute("alignment-baseline","middle");switch(t.align){case "middle":r.setAttribute("text-anchor","middle");r.setAttribute("startOffset","50%");break;case "end":r.setAttribute("text-anchor","end");r.setAttribute("startOffset","100%");break;default:r.setAttribute("text-anchor","start");r.setAttribute("startOffset","0%");break;}r.setAttribute("baseline-shift","0.5ex");r.setAttribute("text-decoration",t.decoration);r.setAttribute("rotate",t.rotated?90:0);r.setAttribute("kerning",t.kerning?"auto":0);r.firstChild.data=t.text;}});svg.TextPath.nodeType="text";var _b3=(function(){var _b4=/WebKit\/(\d*)/.exec(_74);return _b4?_b4[1]:0;})()>534;svg.Surface=_6f("dojox.gfx.svg.Surface",gs.Surface,{constructor:function(){gs.Container._init.call(this);},destroy:function(){gs.Container.clear.call(this,true);this.defNode=null;this.inherited(arguments);},setDimensions:function(_b5,_b6){if(!this.rawNode){return this;}this.rawNode.setAttribute("width",_b5);this.rawNode.setAttribute("height",_b6);if(_b3){this.rawNode.style.width=_b5;this.rawNode.style.height=_b6;}return this;},getDimensions:function(){var t=this.rawNode?{width:g.normalizedLength(this.rawNode.getAttribute("width")),height:g.normalizedLength(this.rawNode.getAttribute("height"))}:null;return t;}});svg.createSurface=function(_b7,_b8,_b9){var s=new svg.Surface();s.rawNode=_78(svg.xmlns.svg,"svg");s.rawNode.setAttribute("overflow","hidden");if(_b8){s.rawNode.setAttribute("width",_b8);}if(_b9){s.rawNode.setAttribute("height",_b9);}var _ba=_78(svg.xmlns.svg,"defs");s.rawNode.appendChild(_ba);s.defNode=_ba;s._parent=dom.byId(_b7);s._parent.appendChild(s.rawNode);return s;};var _bb={_setFont:function(){var f=this.fontStyle;this.rawNode.setAttribute("font-style",f.style);this.rawNode.setAttribute("font-variant",f.variant);this.rawNode.setAttribute("font-weight",f.weight);this.rawNode.setAttribute("font-size",f.size);this.rawNode.setAttribute("font-family",f.family);}};var C=gs.Container,_bc={openBatch:function(){this.fragment=_80();},closeBatch:function(){if(this.fragment){this.rawNode.appendChild(this.fragment);delete this.fragment;}},add:function(_bd){if(this!=_bd.getParent()){if(this.fragment){this.fragment.appendChild(_bd.rawNode);}else{this.rawNode.appendChild(_bd.rawNode);}C.add.apply(this,arguments);_bd.setClip(_bd.clip);}return this;},remove:function(_be,_bf){if(this==_be.getParent()){if(this.rawNode==_be.rawNode.parentNode){this.rawNode.removeChild(_be.rawNode);}if(this.fragment&&this.fragment==_be.rawNode.parentNode){this.fragment.removeChild(_be.rawNode);}_be._removeClipNode();C.remove.apply(this,arguments);}return this;},clear:function(){var r=this.rawNode;while(r.lastChild){r.removeChild(r.lastChild);}var _c0=this.defNode;if(_c0){while(_c0.lastChild){_c0.removeChild(_c0.lastChild);}r.appendChild(_c0);}return C.clear.apply(this,arguments);},getBoundingBox:C.getBoundingBox,_moveChildToFront:C._moveChildToFront,_moveChildToBack:C._moveChildToBack};var _c1={createObject:function(_c2,_c3){if(!this.rawNode){return null;}var _c4=new _c2(),_c5=_78(svg.xmlns.svg,_c2.nodeType);_c4.setRawNode(_c5);_c4.setShape(_c3);this.add(_c4);return _c4;}};_6e.extend(svg.Text,_bb);_6e.extend(svg.TextPath,_bb);_6e.extend(svg.Group,_bc);_6e.extend(svg.Group,gs.Creator);_6e.extend(svg.Group,_c1);_6e.extend(svg.Surface,_bc);_6e.extend(svg.Surface,gs.Creator);_6e.extend(svg.Surface,_c1);svg.fixTarget=function(_c6,_c7){if(!_c6.gfxTarget){if(_75&&_c6.target.wholeText){_c6.gfxTarget=gs.byId(_c6.target.parentElement.__gfxObject__);}else{_c6.gfxTarget=gs.byId(_c6.target.__gfxObject__);}}return true;};if(svg.useSvgWeb){svg.createSurface=function(_c8,_c9,_ca){var s=new svg.Surface();if(!_c9||!_ca){var pos=_70.position(_c8);_c9=_c9||pos.w;_ca=_ca||pos.h;}_c8=dom.byId(_c8);var id=_c8.id?_c8.id+"_svgweb":g._base._getUniqueId();var _cb=_78(svg.xmlns.svg,"svg");_cb.id=id;_cb.setAttribute("width",_c9);_cb.setAttribute("height",_ca);svgweb.appendChild(_cb,_c8);_cb.addEventListener("SVGLoad",function(){s.rawNode=this;s.isLoaded=true;var _cc=_78(svg.xmlns.svg,"defs");s.rawNode.appendChild(_cc);s.defNode=_cc;if(s.onLoad){s.onLoad(s);}},false);s.isLoaded=false;return s;};svg.Surface.extend({destroy:function(){var _cd=this.rawNode;svgweb.removeChild(_cd,_cd.parentNode);}});var _ce={connect:function(_cf,_d0,_d1){if(_cf.substring(0,2)==="on"){_cf=_cf.substring(2);}if(arguments.length==2){_d1=_d0;}else{_d1=_6e.hitch(_d0,_d1);}this.getEventSource().addEventListener(_cf,_d1,false);return [this,_cf,_d1];},disconnect:function(_d2){this.getEventSource().removeEventListener(_d2[1],_d2[2],false);delete _d2[0];}};_6e.extend(svg.Shape,_ce);_6e.extend(svg.Surface,_ce);}return svg;});