<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <title>${env.getEnv('local.title')}国土资源“一张图”-信息门户子系统</title>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/bootstrap/bootstrap.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/font/css/font-awesome.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/gridtree/gridtree.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/loading/loading.css"/>

    <link rel="stylesheet" href="<@com.rootPath/>/static/css/hack.css"/>
    <style>
        table tr td {
            border: 1px solid #ddd;
            padding: 5px 10px;
            height: 50px;
        }

        table tr th {
            border: 1px solid #ddd;
            padding: 10px;
            max-height: 60px;
            min-width: 80px;
        }

        table {
            background-color: transparent;
            border: 1px solid #ddd;
            table-layout: auto;
            border-collapse: collapse;
            margin-left: auto;
            margin-right: auto;
            margin-bottom: 15px;
            width:100%;
        }
        .large {
            min-height: 572px;
            border: 1px solid #ddd;
            border-radius: 4px;
            overflow: hidden;
            word-break: break-all;
        }

        .detailPanel{
            display: none;
            padding: 10px;
        }
        h5{
            font-weight: normal;
            color:#188074;
            margin-left: 10px;
        }

    </style>
</head>
<body>
<div id="hearder" class="navbar navbar-inverse">
    <div class="navbar-inner">
        <div class="container">
            <a href="<@com.rootPath/>/portal2" class="brand" style="background: url(${path_omp}/resources/img${env.getEnv('local.path')}/logo2.png) 0 0 no-repeat;">${env.getEnv('local.title')}国土资源“一张图”信息门户</a>

            <div class="pull-right">
                <div class="small-nav">
                    <ul class="nav nav-pills">
                        <li><a href="${path_omp}">主页</a></li>
                    <#if env.getEnv('main.level')='provincial'>
                        <li><a href="http://172.18.2.70/homepages/singleLogin.jsp?license=${ctx.getToken()!}" target="_blank">政务管理平台</a></li></#if>
                        <li><a href="#">帮助</a></li>
                    <#if env.getEnv('main.level')='provincial'>
                        <li><a href="#" data-ask="确定退出系统吗?" class="i_quit">&nbsp;退出</a></li>
                    <#else>
                        <li><a href="${path_oms}/logout?url=${path_omp}" data-ask="确定退出系统吗?" class="j_ask"><i class="icon icon-signout"></i>&nbsp;退出</a></li>
                    </#if>
                    </ul>
                </div>
                <div class="main-nav">
                    <ul class="nav nav-pills">
                        <li><a href="<@com.rootPath/>/portal2/onemap/YZT" target="_self">一张图</a></li>
                        <li><a href="<@com.rootPath/>/portal2/tpl/index" target="_self">专题图</a></li>
                        <li><a href="<@com.rootPath/>/portal2/statistic" target="_self">统计图表</a></li>
                        <li><a href="<@com.rootPath/>/portal2/rescenter/db" target="_self">资源中心</a></li>
                        <li><a href="<@com.rootPath/>/portal2/api/index" target="_self">地图API</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="container" style="width: 80%;">
    <div>
        <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;土地利用现状分析结果展示</h3>
    </div>
    <div style="float:right;"><input type="button" value="导出excel" onclick="exportExcel()" style="color:#188074;"/></div>
    <div class="row" style="margin-bottom: 15px;">
        <div>
            <ul class="nav nav-tabs">
                <li class="active"><a href="#tab1" data-toggle="tab">一级分类</a></li>
                <li><a href="#tab2" data-toggle="tab">二级分类</a></li>
            </ul>
        </div>
        <div class="tab-content">
             <div id="tab1" class="tab-pane fade in active">
                 <#if (result?size>0)>
                 <table>
                     <tr>
                         <th>行政区</th>
                         <th>合计</th>
                     <#assign info=result[0].categoryA>
                     <#list info as infoItem>
                         <th>${infoItem["dlmc"]!}(${infoItem["dlbm"]!})</th>
                     </#list>
                     </tr>
                 <#list result as xzq>
                     <tr>
                         <td>${xzq["xzqdm"]!}</td>
                         <td>${xzq["sumArea"]!?string("0.##")}</td>
                         <#assign areaInfo=xzq.categoryA>
                         <#list areaInfo as item>
                             <td>${item["area"]!?string("0.##")}</td>
                         </#list>
                     </tr>
                 </#list>
                 </table>
                     <#else ><h5>该分类下无分析结果</h5>
                 </#if>
             </div>
            <div id="tab2" class="tab-pane fade">
            <#if (result?size>0)>
                <table>
               <tr>
                   <th rowspan="2">行政区</th>
                   <th rowspan="2">合计</th>
                   <th rowspan="2">耕地(01)</th>
                   <th colspan="3">其中</th>
                   <th rowspan="2">园地(02)</th>
                   <th colspan="3">其中</th>
                   <th rowspan="2">林地(03)</th>
                   <th colspan="3">其中</th>
                   <th rowspan="2">草地(04)</th>
                   <th colspan="3">其中</th>
                   <th rowspan="2">城镇村及工矿用地(20)</th>
                   <th colspan="5">其中</th>
                   <th rowspan="2">交通运输用地(10)</th>
                   <th colspan="6">其中</th>
                   <th rowspan="2">水域及水利设施用地(11)</th>
                   <th colspan="9">其中</th>
                   <th rowspan="2">其他用地</th>
                   <th colspan="6">其中</th>
               </tr>
               <tr>
                   <th>水田(011)</th>
                   <th>水浇地(012)</th>
                   <th>旱地(013)</th>
                   <th>果园(021)</th>
                   <th>茶园(022)</th>
                   <th>其他园地(023)</th>
                   <th>有林地(031)</th>
                   <th>灌木林地(032)</th>
                   <th>其他林地(033)</th>
                   <th>天然牧草地(041)</th>
                   <th>人工牧草地(042)</th>
                   <th>其他草地(043)</th>
                   <th>城市(201)</th>
                   <th>建制镇(202)</th>
                   <th>村庄(203)</th>
                   <th>采矿用地(204)</th>
                   <th>风景名胜及特殊用地(205)</th>
                   <th>铁路用地(101)</th>
                   <th>公路用地(102)</th>
                   <th>农村道路(104)</th>
                   <th>机场用地(105)</th>
                   <th>港口码头用地(106)</th>
                   <th>管道运输用地(107)</th>
                   <th>河流水面(111)</th>
                   <th>湖泊水面(112)</th>
                   <th>水库水面(113)</th>
                   <th>坑塘水面(114)</th>
                   <th>沿海滩涂(115)</th>
                   <th>内陆滩涂(116)</th>
                   <th>水渠(117)</th>
                   <th>水工建筑用地(118)</th>
                   <th>冰川及永久积雪(119)</th>
                   <th>设施农用地(122)</th>
                   <th>田坎(123)</th>
                   <th>盐碱地(124)</th>
                   <th>沼泽地(125)</th>
                   <th>沙地(126)</th>
                   <th>裸地(127)</th>
               </tr>
                    <#list result as xzq>
                    <#assign item=xzq.categoryB>
                        <tr>
                            <td>${xzq["xzqdm"]!}</td>
                            <td>${xzq["sumArea"]!?string("0.##")}</td>
                            <td>${item["01"]!?string("0.##")}</td>
                            <td><#if item["011"]??> ${item["011"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["012"]??>${item["012"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["013"]??>${item["013"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["02"]!?string("0.##")}</td>
                            <td><#if item["021"]??>${item["021"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["022"]??>${item["022"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["023"]??>${item["023"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["03"]!?string("0.##")}</td>
                            <td><#if item["031"]??>${item["031"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["032"]??>${item["032"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["033"]??>${item["033"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["04"]!?string("0.##")}</td>
                            <td><#if item["041"]??>${item["041"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["042"]??>${item["042"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["043"]??>${item["043"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["20"]!?string("0.##")}</td>
                            <td><#if item["201"]??>${item["201"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["202"]??>${item["202"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["203"]??>${item["203"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["204"]??>${item["204"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["205"]??>${item["205"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["10"]!?string("0.##")}</td>
                            <td><#if item["101"]??>${item["101"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["102"]??>${item["102"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["104"]??>${item["104"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["105"]??>${item["105"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["106"]??>${item["106"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["107"]??>${item["107"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["11"]!?string("0.##")}</td>
                            <td><#if item["111"]??>${item["111"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["112"]??>${item["112"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["113"]??>${item["113"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["114"]??>${item["114"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["115"]??>${item["115"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["116"]??>${item["116"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["117"]??>${item["117"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["118"]??>${item["118"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["119"]??>${item["119"]!?string("0.##")}<#else >0</#if></td>
                            <td>${item["12"]!?string("0.##")}</td>
                            <td><#if item["122"]??>${item["122"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["123"]??>${item["123"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["124"]??>${item["124"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["125"]??>${item["125"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["126"]??>${item["126"]!?string("0.##")}<#else >0</#if></td>
                            <td><#if item["127"]??>${item["127"]!?string("0.##")}<#else >0</#if></td>
                        </tr>
                    </#list>
                </table>
            <#else ><h5>该分类下无分析结果</h5></#if>
            </div>
        </div>
    </div>
    <div style="float: right;"><h5>单位:平方米</h5></div>
</div>
<script src="<@com.rootPath/>/js/jquery/jquery_1.9.0.js"></script>
<script src="<@com.rootPath/>/static/js/lib/bootstrap.js"></script>
<script src="<@com.rootPath/>/static/js/plugins.js"></script>
<script type="text/javascript">
    var data = '${resultStr}';
    $(document).ready(function () {
        $('.toggle').click(function () {
            if ($('.toggle').hasClass('icon-double-angle-down'))
                $('.toggle').addClass('icon-double-angle-right').removeClass('icon-double-angle-down');
            else
                $('.toggle').addClass('icon-double-angle-down').removeClass('icon-double-angle-right');
            $('.detailPanel').slideToggle("slow");
        });
    });

    /**
     * 导出分析结果至excel
     */
    function exportExcel(){

        var fileName = "tdlyxz_analysis.xlsx";
        var officeVersion = '${env.getEnv("office.plugin.version")!}';
        if(officeVersion=='old')
            fileName = "tdlyxz_analysis.xls";
        openPostWindow("<@com.rootPath/>/geometryService/export/excel",data,"tdlyxz_analysis.xlsx");
    }


    function openPostWindow(url, data,fileName)
    {
        if(data=="")
        {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method="post";
        tempForm.action=url;
        var hideInput1 = document.createElement("input");
        hideInput1.type="hidden";
        hideInput1.name= "data"
        hideInput1.value= data;
        var hideInput2 = document.createElement("input");
        hideInput2.type="hidden";
        hideInput2.name= "fileName"
        hideInput2.value= fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }

</script>
</body>
</html>