<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8"/>
    <title>${env.getEnv('local.title')}国土资源“一张图”-信息门户子系统</title>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/bootstrap/bootstrap.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/font/css/font-awesome.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/gridtree/gridtree.css"/>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/loading/loading.css"/>

    <link rel="stylesheet" href="<@com.rootPath/>/static/css/hack.css"/>
    <style>
        table tr td {
            border: 1px solid #ddd;
            padding: 5px 10px;

        }

        table tr th {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: center;
            vertical-align: middle;
            min-width: 60px;
        }

        table {
            background-color: transparent;
            border: 1px solid #ddd;
            table-layout: auto;
            border-collapse: collapse;
        }

        .tab-content {
            padding: 20px;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 5px 5px;
        }

    </style>
</head>
<#macro getSequence str>
    <#if str?index_of(",") gt 0>
        <#assign sequence=str?split(",")/>
    <ul class="ul inline">
        <#list sequence as item>
        <li>${item!}</li>
     </#list>
    </ul>
    <#else >${str!}</#if>
</#macro>
<body>
<div class="container" style="width: 85%;">
    <div>
        <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;${year!}
            年国家遥感监测图斑核查情况一览表</h3>
    </div>
    <div style="float:right;"><input type="button" value="导出excel" onclick="exportExcel()" style="color:#188074;"/>
    </div>
    <div style="margin: 20px auto;">
        <div class="tab-content">
            <table>
                <tr>
                    <th rowspan="3">序号</th>
                    <th rowspan="3">图斑编号</th>
                    <th rowspan="3">图斑类型</th>
                    <th rowspan="3">标识码</th>
                    <th rowspan="3">所在乡镇名称</th>
                    <th rowspan="3">项目名称</th>
                    <th rowspan="3">建设单位</th>
                    <th colspan="2">监测情况</th>
                    <th colspan="6">土地利用现状核查情况</th>
                    <th colspan="3">土地利用总体规划情况</th>
                    <th colspan="6">现场核查情况</th>
                    <th rowspan="3">批次名称</th>
                    <th rowspan="3">农转用批文</th>
                    <th rowspan="3">供地编号</th>
                    <th rowspan="3">处置意见</th>
                    <th rowspan="3">现场取证照片（超链接）</th>
                    <th rowspan="3">备注</th>
                </tr>
                <tr>
                    <th rowspan="2">面积</th>
                    <th rowspan="2">耕地面积</th>
                    <th colspan="2">报批情况</th>
                    <th colspan="2">供地情况</th>
                    <th colspan="2">未批已建</th>
                    <th rowspan="2">允许建设区</th>
                    <th rowspan="2">基本农田</th>
                    <th rowspan="2">一般 农田区</th>
                    <th rowspan="2">图斑建设状况与类型</th>
                    <th colspan="2">未批已建</th>
                    <th colspan="3">不变更为建设用地</th>
                </tr>
                <tr>
                    <th>面积</th>
                    <th>耕地面积</th>
                    <th>已供面积</th>
                    <th>未供面积</th>
                    <th>面积</th>
                    <th>耕地面积</th>
                    <th>面积</th>
                    <th>耕地面积</th>
                    <th>面积</th>
                    <th>耕地面积</th>
                    <th>原因类型</th>
                </tr>
            <#if result??>
                <#list result as item>
                    <tr>
                        <td>${item_index+1}</td>
                        <td>${item.OG_PRO_JCBH!}</td>
                        <td>${item.OG_PRO_TBLX!}</td>
                        <td>${item.OG_PRO_BSM!}</td>
                        <td>${item.OG_PRO_XZMC!}</td>
                        <td>${item.OG_PRO_XMMC!}</td>
                        <td>${item.OG_PRO_JSDW!}</td>
                        <td>${item.OG_PRO_JCMJ!}</td>
                        <td>${item.JC_GD_AREA!}</td>

                        <td>${item.BP_AREA!}</td>
                        <td>${item.BP_GD_AREA!}</td>
                        <td>${item.YG_AREA!}</td>
                        <td>${item.WG_AREA!}</td>
                        <td>${item.WPYJ_AREA!}</td>
                        <td>${item.WPYJ_GD_AREA!}</td>
                        <td>${item.YXJSQ_AREA!}</td>
                        <td>${item.JBNT_AREA!}</td>
                        <td>${item.YBNTQ_AREA!}</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td style="min-width: 70px;"><@getSequence item.PCMC/></td>
                        <td style="min-width: 120px;"><@getSequence item.NZYPW/></td>
                        <td style="min-width: 70px;"><@getSequence item.GDBH/></td>
                        <td></td>
                        <td></td>
                        <td></td>
                    </tr>
                </#list>
            <#else >
                <div style="text-align: center"><h4>无分析结果</h4></div>
            </#if>
            </table>
        </div>
    </div>
</div>
<script src="<@com.rootPath/>/js/jquery/jquery_1.9.0.js"></script>
<script src="<@com.rootPath/>/js/portal/lib/bootstrap.js"></script>
<script src="<@com.rootPath/>/static/js/plugins.js"></script>
<script type="text/javascript">
    /**
     * 导出excel
     */
    function exportExcel() {
        var fileName = "jctb_result.xlsx";
        var officeVersion = '${env.getEnv("office.plugin.version")!}';
        if (officeVersion == 'old')
            fileName = "jctb_result.xls";
        openPostWindow("<@com.rootPath/>/geometryService/export/excel/jctb", '${excelData}', fileName);
    }
    function openPostWindow(url, data, fileName) {
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        var hideInput3 = document.createElement("input");
        hideInput3.type = "hidden";
        hideInput3.name = "year"
        hideInput3.value = '${year!}';
        tempForm.appendChild(hideInput1);
        tempForm.appendChild(hideInput2);
        tempForm.appendChild(hideInput3);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</body>
</html>