<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>国土资源“一张图”-信息门户子系统</title>
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/bootstrap/bootstrap.css" />
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/font/css/font-awesome.css" />
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/gridtree/gridtree.css" />
    <link rel="stylesheet" href="<@com.rootPath/>/static/css/plugins/loading/loading.css" />

    <link rel="stylesheet" href="<@com.rootPath/>/static/css/hack.css" />
    <style>
        table tr td{
            border: 1px solid #ddd;
            padding: 5px 10px;
        }
        table tr th{
            border: 1px solid #ddd;
            padding: 10px;
        }
        table {
            background-color: transparent;
            border: 1px solid #ddd;
            table-layout: auto;
            border-collapse: collapse;
        }
        .tab-content{
            padding:20px;
            border: 1px solid #ddd;
            border-top: none;
            border-radius: 0 0 5px 5px;
        }
        .nav-tabs{
            margin-bottom: 0px;
        }
        .detailPanel{
            display:none;
            padding: 10px;
        }

    </style>
</head>
<body>
<div id="hearder" class="navbar navbar-inverse">
    <div class="navbar-inner">
        <div class="container">
            <a href="<@com.rootPath/>/portal2" class="brand" style="background: url(${path_omp}/resources/img${env.getEnv('local.path')}/logo2.png) 0 0 no-repeat;">${env.getEnv('local.title')}国土资源“一张图”信息门户</a>
            <div class="pull-right">
                <div class="small-nav">
                    <ul class="nav nav-pills">
                        <li><a href="${path_omp}">主页</a></li>
                    <#if env.getEnv('main.level')='provincial'>
                        <li><a href="http://172.18.2.70/homepages/singleLogin.jsp?license=${ctx.getToken()!}" target="_blank">政务管理平台</a></li></#if>
                        <li><a href="#">帮助</a></li>
                    <#if env.getEnv('main.level')='provincial'>
                        <li><a href="#" data-ask="确定退出系统吗?" class="i_quit">&nbsp;退出</a></li>
                    <#else>
                        <li><a href="${path_oms}/logout?url=${path_omp}" data-ask="确定退出系统吗?" class="j_ask"><i class="icon icon-signout"></i>&nbsp;退出</a></li>
                    </#if>
                    </ul>
                </div>
                <div class="main-nav">
                    <ul class="nav nav-pills">
                        <li><a href="<@com.rootPath/>/portal2/onemap/11">一张图</a></li>
                        <li><a href="<@com.rootPath/>/portal2/tpl/index">专题图</a></li>
                        <li><a href="#">统计报表</a></li>
                        <li><a href="<@com.rootPath/>/portal2/rescenter/db">资源中心</a></li>
                        <li><a href="<@com.rootPath/>/portal2/api/index">地图API</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
${content!}
<script src="<@com.rootPath/>/js/jquery/jquery_1.9.0.js"></script>
<script src="<@com.rootPath/>/js/portal/lib/bootstrap.js"></script>
<script src="<@com.rootPath/>/static/js/plugins.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
        $('.toggle').click(function(){
            if ($('.toggle').hasClass('icon-double-angle-down'))
                $('.toggle').addClass('icon-double-angle-right').removeClass('icon-double-angle-down');
            else
                $('.toggle').addClass('icon-double-angle-down').removeClass('icon-double-angle-right');
            $('.detailPanel').slideToggle("slow");
        });
    });
    /**
     * 导出excel
     */
    function exportExcel(){

    <#--openPostWindow("<@com.rootPath/>/geometryService/export/excel",'${excelData}',null);-->
    }
    function openPostWindow(url, data,fileName)
    {
        if(data=="")
        {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method="post";
        tempForm.action=url;
        var hideInput1 = document.createElement("input");
        hideInput1.type="hidden";
        hideInput1.name= "data"
        hideInput1.value= data;
        var hideInput2 = document.createElement("input");
        hideInput2.type="hidden";
        hideInput2.name= "fileName"
        hideInput2.value= fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</body>
</html>