/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.event.TemplateException;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class TemplateServiceImpl
extends BaseLogger
implements TemplateService {
    private final String UTF_8 = "utf-8";
    private String location;
    private Configuration cfg;

    private void init() {
        this.cfg = new Configuration();
        this.cfg.setEncoding(Locale.getDefault(), "utf-8");
        this.cfg.setTemplateUpdateDelay(60);
        try {
            this.cfg.setDirectoryForTemplateLoading(this.getTplResource("").getFile());
        }
        catch (IOException e) {
            this.logger.error(" tpls path not exsit : [{}] ", (Object)e.getLocalizedMessage());
        }
    }

    public String getTemplate(String tplName) {
        return this.getTplContent(tplName, null);
    }

    public String getTemplate(String tplName, String encoding) {
        return this.getTplContent(tplName, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplate(Object value, String tplName) throws IOException, TemplateException {
        Template tpl = this.cfg.getTemplate(tplName, "utf-8");
        StringWriter writer = new StringWriter();
        try {
            tpl.process(value, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTemplate(Object value, String tplName, String encoding) throws IOException, TemplateException {
        Template tpl = this.cfg.getTemplate(tplName, encoding == null ? "utf-8" : encoding);
        StringWriter writer = new StringWriter();
        try {
            tpl.process(value, (Writer)writer);
            String string = writer.toString();
            return string;
        }
        finally {
            writer.close();
        }
    }

    public String modify(String tplName, String content) throws cn.gtmap.onemap.platform.event.TemplateException {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.getTplResource(tplName).getFile());
            IOUtils.write((String)content, (OutputStream)outputStream, (String)"utf-8");
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(tplName, TemplateException.Type.TPL_WRITE_ERROR, e.getLocalizedMessage());
        }
        return content;
    }

    public String[] getFileNames(String folder) {
        String[] names = null;
        try {
            UrlResource resource = new UrlResource(this.location.concat(folder));
            File[] files = resource.getFile().listFiles();
            names = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                names[i] = files[i].getName();
            }
        }
        catch (Exception e) {
            return null;
        }
        return names;
    }

    public List<String> listTplNames(String folder) {
        ArrayList<String> names = null;
        try {
            names = new ArrayList<String>();
            for (File file : this.getTplResource(folder).getFile().listFiles()) {
                names.add(file.getName());
            }
        }
        catch (IOException e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(folder, TemplateException.Type.FOLDER_LIST_ERROR, e.getLocalizedMessage());
        }
        return names;
    }

    public String createTpl(String tplName, String content) {
        try {
            if (this.getTplResource(tplName).getFile().exists()) {
                throw new cn.gtmap.onemap.platform.event.TemplateException(tplName, TemplateException.Type.TPL_EXIST, null);
            }
        }
        catch (IOException e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(tplName, TemplateException.Type.TPL_CREATE_ERROR, e.getLocalizedMessage());
        }
        return this.modify(tplName, content);
    }

    public void deleteTpl(String tpl) {
        try {
            FileUtils.forceDelete((File)this.getTplResource(tpl).getFile());
        }
        catch (Exception e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(tpl, TemplateException.Type.TPL_DELETE_ERROR, e.getLocalizedMessage());
        }
    }

    private String getTplContent(String tplName, String encoding) {
        if (StringUtils.isBlank((String)tplName)) {
            throw new RuntimeException(this.getMessage("template.name.not.null", new Object[0]));
        }
        try {
            return IOUtils.toString((URI)this.getTplResource(tplName).getURI(), (String)(encoding == null ? "utf-8" : encoding));
        }
        catch (IOException e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(tplName, TemplateException.Type.TPL_NOT_EXIST, e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new cn.gtmap.onemap.platform.event.TemplateException(tplName, TemplateException.Type.TPL_READ_ERROR, e.getLocalizedMessage());
        }
    }

    private Resource getTplResource(String tplName) throws MalformedURLException {
        return new UrlResource(this.location.concat(tplName));
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

