/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.core.support.jpa.Filter;
import cn.gtmap.onemap.model.Layer;
import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.model.Region;
import cn.gtmap.onemap.model.Service;
import cn.gtmap.onemap.model.ServiceProvider;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.dao.GTPLDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Function;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.event.ConfigException;
import cn.gtmap.onemap.platform.event.DictException;
import cn.gtmap.onemap.platform.event.DictItemException;
import cn.gtmap.onemap.platform.event.FunctionException;
import cn.gtmap.onemap.platform.event.ServiceException;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.service.MetadataService;
import cn.gtmap.onemap.service.RegionService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.config.AppConfig;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;

@org.springframework.stereotype.Service
public class MapServiceFileImpl
extends BaseLogger
implements MapService {
    private static final String PROVIDER_ARCGIS_PROXY = "arcgisProxy";
    @Autowired
    private GTPLDao gtplDao;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private RegionService regionService;
    @Autowired
    private GeometryService geometryService;

    public cn.gtmap.onemap.platform.entity.Service getService(String serviceId, String tpl) {
        List services = this.gtplDao.getServiceByKey("id", serviceId, tpl);
        if (services.size() != 1) {
            return null;
        }
        return (cn.gtmap.onemap.platform.entity.Service)services.get(0);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getServices(String xzdm, String tpl) {
        return this.gtplDao.getServiceByKey("xzdm", xzdm, tpl);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getServices(String[] serviceIds, String tpl) {
        ArrayList<cn.gtmap.onemap.platform.entity.Service> services = new ArrayList<cn.gtmap.onemap.platform.entity.Service>();
        for (String id : serviceIds) {
            cn.gtmap.onemap.platform.entity.Service service = this.getService(id, tpl);
            if (service == null) continue;
            services.add(service);
        }
        return services;
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getServices(String xzdm, String[] serviceIds, String tpl) {
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("xzdm", xzdm);
        condition.put("serviceIds", serviceIds);
        return this.getServices(condition, tpl);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getServices(java.util.Map<String, ?> condition, String tpl) {
        return this.gtplDao.getServices(condition, tpl);
    }

    public List<Function> getFunctions(String serviceId, String tpl) {
        if (StringUtils.isBlank((String)serviceId)) {
            return null;
        }
        Configuration cg = this.gtplDao.getConfigByTpl(tpl);
        List functionList = null;
        cn.gtmap.onemap.platform.entity.Service tempService = null;
        for (cn.gtmap.onemap.platform.entity.Service service : cg.getMap().getOperationalLayers()) {
            if (!serviceId.equals(service.getId())) continue;
            tempService = service;
            break;
        }
        try {
            if (tempService != null) {
                functionList = tempService.getFunctions();
                if (functionList == null) {
                    return null;
                }
                for (Function function : functionList) {
                    JSONArray layers = function.getConfigLayers();
                    for (int i = 0; i < layers.size(); ++i) {
                        JSONObject obj = (JSONObject)layers.get(i);
                        obj.put("serviceUrl", (Object)(tempService.getUrl() + "/" + obj.get((Object)"layerIndex")));
                    }
                    function.setConfig(layers.toString());
                }
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u76f8\u5173\u529f\u80fd\u51fa\u73b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        return functionList;
    }

    public Function getFunctionByType(String serviceId, int type, String tpl) {
        try {
            cn.gtmap.onemap.platform.entity.Service service = this.gtplDao.getServiceById(serviceId, tpl);
            List functions = service.getFunctions();
            if (functions != null) {
                for (Function function : functions) {
                    if (type != function.getType()) continue;
                    return function;
                }
            }
        }
        catch (Exception e) {
            throw new FunctionException(FunctionException.ExceptionType.GET_FUNCTION, e.getLocalizedMessage());
        }
        return null;
    }

    public String saveFunction(Function function, String serviceId, String tpl) {
        try {
            this.gtplDao.saveFunction(tpl, serviceId, function);
        }
        catch (Exception e) {
            throw new FunctionException(FunctionException.ExceptionType.INSERT_FUNCTION, e.getLocalizedMessage());
        }
        return null;
    }

    public String updateFunction(String tpl, String serviceId, String type, Function function) {
        return "";
    }

    public Configuration getConfig(String tpl) throws RuntimeException {
        try {
            Configuration configuration = this.gtplDao.getConfigByTpl(tpl);
            java.util.Map labelsMap = this.getLabelsMap(configuration);
            List widgetsGroups = configuration.getWidgetContainer().getWidgetsGroup();
            Configuration.WidgetsGroup identifyTemp = null;
            Object identifyWidget = null;
            Configuration.Widget locationWidget = null;
            Object toolGroupTemp = null;
            List serviceList = configuration.getMap().getOperationalLayers();
            for (Configuration.WidgetsGroup widgetsGroup : widgetsGroups) {
                int type = widgetsGroup.getType();
                if (type == Function.Type.IDENTIFY.getId()) {
                    Configuration.Widget widget = this.getWidget(widgetsGroup, serviceList);
                    configuration.getWidgetContainer().getWidgets().add(widget);
                    identifyTemp = widgetsGroup;
                    continue;
                }
                if (type == Function.Type.TOOLS.getId() || type == Function.Type.STATISTIC.getId()) continue;
                ArrayList labels = (ArrayList)labelsMap.get(type);
                List widgets = this.getWidgets(type, labels, serviceList, widgetsGroup.getUrl());
                if (widgetsGroup.getWidgets() == null) {
                    widgetsGroup.setWidgets(widgets);
                    continue;
                }
                widgetsGroup.getWidgets().addAll(widgets);
            }
            configuration.getMap().setOperationalLayers(serviceList);
            if (identifyTemp != null) {
                configuration.getWidgetContainer().getWidgetsGroup().remove(identifyTemp);
            }
            for (Configuration.Widget widget : configuration.getWidgets()) {
                if (!"\u5b9a\u4f4d".equals(widget.getLabel())) continue;
                widget.setConfig(this.getLocationConfig(serviceList));
                locationWidget = widget;
            }
            JSONObject js = new JSONObject();
            if (configuration.getDefaultYear().equals("current")) {
                configuration.setDefaultYear(String.valueOf(Calendar.getInstance().get(1)));
            }
            js = (JSONObject)JSON.toJSON((Object)configuration);
            js.remove((Object)"dicts");
            JSONObject map = (JSONObject)js.get((Object)"map");
            JSONArray temp = (JSONArray)map.get((Object)"operationalLayers");
            for (int i = 0; i < temp.size(); ++i) {
                JSONObject jsonObject = (JSONObject)temp.get(i);
                jsonObject.remove((Object)"functions");
            }
            return (Configuration)JSON.parseObject((String)js.toJSONString(), Configuration.class);
        }
        catch (Exception ex) {
            throw new ConfigException(ConfigException.ExceptionType.REQUEST_MAP_CONFIG, ex.getLocalizedMessage());
        }
    }

    public Configuration getConfigByTpl(String tpl) {
        return this.gtplDao.getConfigByTpl(tpl);
    }

    private java.util.Map<Integer, ArrayList<String>> getLabels(Configuration configuration) {
        HashMap<Integer, ArrayList<String>> map = new HashMap<Integer, ArrayList<String>>();
        List serviceList = configuration.getMap().getOperationalLayers();
        for (int i = 1; i < 6; ++i) {
            ArrayList<String> list = new ArrayList<String>();
            for (cn.gtmap.onemap.platform.entity.Service service : serviceList) {
                List functions = service.getFunctions();
                if (functions == null) continue;
                for (Function function : functions) {
                    if (function.getType() != i) continue;
                    JSONArray array = (JSONArray)((JSONObject)JSONArray.parse((String)function.getConfig())).get((Object)"layers");
                    for (int y = 0; y < array.size(); ++y) {
                        try {
                            JSONObject jsonObject = (JSONObject)array.get(y);
                            String showLabel = jsonObject.get((Object)"showLabel").toString();
                            if (list.contains(showLabel)) continue;
                            list.add(showLabel);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
            }
            map.put(i, list);
        }
        return map;
    }

    public String saveConfig(Configuration configuration, String tpl) {
        this.gtplDao.saveConfig(configuration, tpl);
        return "\u4fdd\u5b58\u914d\u7f6e\u6210\u529f";
    }

    public java.util.Map<String, Object> getRegionCodeList(String regionCode, String tpl, String year) {
        Dict dict = this.gtplDao.getRegionCodeDict(regionCode, tpl, year);
        HashMap<String, Object> region = new HashMap<String, Object>();
        List items = dict.getDictItems();
        ArrayList<java.util.Map> subRegion = null;
        if (items != null) {
            subRegion = new ArrayList<java.util.Map>();
            for (Item item : items) {
                java.util.Map thirdRegion = this.itemToMap(item);
                Dict tempDict = this.gtplDao.getRegionCodeDict(item.getName(), tpl, year);
                if (tempDict != null) {
                    List thirdRegions = tempDict.getDictItems();
                    thirdRegion.put("children", this.itemList2MapList(thirdRegions));
                }
                subRegion.add(thirdRegion);
            }
        }
        region.put("id", dict.getId());
        region.put("name", regionCode);
        region.put("title", dict.getTitle());
        region.put("children", subRegion);
        return region;
    }

    public java.util.Map<String, Object> getRegion(String regionCode, String tpl, String year) {
        Dict dict = this.gtplDao.getRegionCodeDict(regionCode, tpl, year);
        HashMap<String, Object> region = new HashMap<String, Object>();
        List items = dict.getDictItems();
        ArrayList<java.util.Map> child = new ArrayList<java.util.Map>();
        for (Item item : items) {
            child.add(this.itemToMap(item));
        }
        region.put("id", dict.getId());
        region.put("name", regionCode);
        region.put("title", dict.getTitle());
        region.put("value", dict.getValue());
        region.put("children", child);
        return region;
    }

    @Cacheable(value={"regionCache"}, key="#regionCode + #sr")
    public java.util.Map<String, Object> getRegion2(String regionCode, String sr) {
        Region region = this.regionService.getRegion(regionCode);
        if (region == null) {
            throw new RuntimeException(this.getMessage("region.code.not.set", new Object[0]));
        }
        java.util.Map result = this.regionToMap(region, sr);
        ArrayList<java.util.Map> child = new ArrayList<java.util.Map>();
        Page regions = this.regionService.findRegion(Collections.singletonList(new Filter("parent.id", Filter.Operator.EQ, (Object)regionCode)), null);
        if (regions != null && regions.hasContent()) {
            for (Region item : regions.getContent()) {
                child.add(this.regionToMap(item, sr));
            }
            result.put("children", child);
        }
        return result;
    }

    public String getRegionShape(String regionItemId, String tpl) {
        return null;
    }

    public JSONArray getAllService(String tpl) {
        List serviceList = this.gtplDao.getConfigByTpl(tpl).getMap().getOperationalLayers();
        JSONArray services = (JSONArray)JSON.toJSON((Object)serviceList);
        return services;
    }

    @Cacheable(value={"serviceCache"}, key="#tpl")
    public List getServicesClassify(String tpl) {
        List groups = this.metadataService.getChildrenMapGroups(null, true);
        List serviceList = this.gtplDao.getConfigByTpl(tpl).getMap().getOperationalLayers();
        Collections.sort(serviceList);
        return this.attachService2Group(groups, serviceList);
    }

    private List<java.util.Map<String, Object>> attachService2Group(List<MapGroup> groups, List<cn.gtmap.onemap.platform.entity.Service> services) {
        ArrayList<java.util.Map<String, Object>> list = new ArrayList<java.util.Map<String, Object>>();
        for (MapGroup group : groups) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", group.getId());
            item.put("name", group.getName());
            item.put("visible", false);
            ArrayList children = new ArrayList();
            List service = this.getServiceByGroup(group.getId(), services);
            if (service.size() > 0) {
                children.addAll(service);
            }
            if (group.getChildren() != null && group.getChildren().size() > 0) {
                children.addAll(this.attachService2Group(group.getChildren(), services));
            }
            item.put("children", children.size() > 0 ? children : null);
            list.add(item);
        }
        return list;
    }

    private List<cn.gtmap.onemap.platform.entity.Service> getServiceByGroup(String groupId, List<cn.gtmap.onemap.platform.entity.Service> services) {
        ArrayList<cn.gtmap.onemap.platform.entity.Service> serviceList = new ArrayList<cn.gtmap.onemap.platform.entity.Service>();
        for (cn.gtmap.onemap.platform.entity.Service service : services) {
            service.setFunctions(null);
            if (!groupId.equals(service.getGroup())) continue;
            serviceList.add(service);
        }
        return serviceList;
    }

    public String insertServices(List<cn.gtmap.onemap.platform.entity.Service> modifyServices, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List serviceList = cg.getMap().getOperationalLayers();
            int size = serviceList.size();
            for (cn.gtmap.onemap.platform.entity.Service service : modifyServices) {
                service.setIndex(size);
                if (this.gtplDao.getServiceById(service.getId(), tpl) == null) {
                    serviceList.add(service);
                    cg.getMap().setOperationalLayers(serviceList);
                    this.gtplDao.saveConfig(cg, tpl);
                } else {
                    this.updateService(service, tpl);
                }
                ++size;
            }
        }
        catch (Exception e) {
            throw new ServiceException(ServiceException.ExceptionType.INSERT_SERVICE, e.getLocalizedMessage());
        }
        return "";
    }

    public String updateService(cn.gtmap.onemap.platform.entity.Service service, String tpl) {
        try {
            this.gtplDao.updateService(tpl, service);
            return tpl;
        }
        catch (Exception e) {
            throw new ServiceException(ServiceException.ExceptionType.UPDATE_SERVICE, e.getLocalizedMessage());
        }
    }

    public void deleteService(String serviceId, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List services = cg.getMap().getOperationalLayers();
            for (cn.gtmap.onemap.platform.entity.Service service : services) {
                if (!serviceId.equals(service.getId())) continue;
                services.remove(service);
                break;
            }
            cg.getMap().setOperationalLayers(services);
            this.gtplDao.saveConfig(cg, tpl);
        }
        catch (Exception e) {
            throw new ServiceException(ServiceException.ExceptionType.DELETE_SERVICE, e.getLocalizedMessage());
        }
    }

    public void saveLegendConfig(String tpl, String serviceId, String legendVisible) {
        try {
            Configuration cg = this.getConfigByTpl(tpl);
            List widgets = cg.getWidgetContainer().getWidgets();
            for (Configuration.Widget widget : widgets) {
                if (!widget.getLabel().equals("\u56fe\u4f8b")) continue;
                ArrayList newLegendIds = new ArrayList();
                java.util.Map legendConfig = widget.getConfig();
                if (legendConfig.isEmpty()) {
                    if (legendVisible.equals("true")) {
                        HashMap<String, String> map1 = new HashMap<String, String>();
                        map1.put("serviceId", serviceId);
                        newLegendIds.add(map1);
                        legendConfig.put("serviceIds", newLegendIds);
                    }
                } else {
                    List serviceIdMaps = (List)legendConfig.get("serviceIds");
                    boolean isHas = false;
                    for (java.util.Map map : serviceIdMaps) {
                        if (!serviceId.equals(map.get("serviceId"))) continue;
                        isHas = true;
                        if (!legendVisible.equals("false")) continue;
                        serviceIdMaps.remove(map);
                        break;
                    }
                    if (!isHas && legendVisible.equals("true")) {
                        HashMap<String, String> map1 = new HashMap<String, String>();
                        map1.put("serviceId", serviceId);
                        serviceIdMaps.add(map1);
                    }
                }
                this.saveConfig(cg, tpl);
                break;
            }
        }
        catch (Exception e) {
            throw new ConfigException(ConfigException.ExceptionType.SAVE_SERVICE_LEGEND_CONFIG, e.getLocalizedMessage());
        }
    }

    public JSONArray getAllDicts(String tpl) {
        List dictList = this.gtplDao.getConfigByTpl(tpl).getDicts();
        JSONArray dicts = (JSONArray)JSON.toJSON((Object)dictList);
        return dicts;
    }

    public Dict getDict(String dictId, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            if (dicts.size() < 1) {
                return null;
            }
            for (Dict dict : dicts) {
                if (!dictId.equals(dict.getId())) continue;
                return dict;
            }
        }
        catch (Exception e) {
            throw new DictException(DictException.ExceptionType.GET_DICT, tpl, e.getLocalizedMessage());
        }
        return null;
    }

    public void insertDict(Dict dict, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            dicts.add(dict);
            cg.setDicts(dicts);
            this.gtplDao.saveConfig(cg, tpl);
        }
        catch (Exception e) {
            throw new DictException(DictException.ExceptionType.INSERT_DICT, dict.getName(), e.getLocalizedMessage());
        }
    }

    public void updateDict(Dict dict, String tpl) {
        try {
            String dictId = dict.getId();
            this.deleteDict(dictId, tpl);
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            dicts.add(dict);
            cg.setDicts(dicts);
            this.gtplDao.saveConfig(cg, tpl);
        }
        catch (Exception e) {
            throw new DictException(DictException.ExceptionType.UPDATE_DICT, dict.getName(), e.getLocalizedMessage());
        }
    }

    public void deleteDict(String dictId, String tpl) {
        String dictName = "";
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            for (Dict dict : dicts) {
                if (!dictId.equals(dict.getId())) continue;
                dictName = dict.getName();
                dicts.remove(dict);
                cg.setDicts(dicts);
                this.gtplDao.saveConfig(cg, tpl);
                break;
            }
        }
        catch (Exception e) {
            throw new DictException(DictException.ExceptionType.DELETE_DICT, dictName, e.getLocalizedMessage());
        }
    }

    private java.util.Map<String, Object> itemToMap(Item item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", item.getId());
        map.put("name", item.getName());
        map.put("title", item.getTitle());
        map.put("value", item.getValue());
        map.put("children", null);
        return map;
    }

    private java.util.Map<String, Object> regionToMap(Region region, String sr) {
        String geometry;
        block6: {
            geometry = "";
            try {
                if (StringUtils.isNotBlank((String)sr)) {
                    CoordinateReferenceSystem toCrs = this.geometryService.parseUndefineSR(sr);
                    if (!StringUtils.isNotBlank((String)region.getGeometry())) break block6;
                    try {
                        Object geoFeature = this.geometryService.readUnTypeGeoJSON(region.getGeometry());
                        if (geoFeature instanceof SimpleFeature) {
                            SimpleFeature feature = (SimpleFeature)geoFeature;
                            CoordinateReferenceSystem crs = feature.getFeatureType().getCoordinateReferenceSystem();
                            Geometry geo = this.geometryService.project((Geometry)feature.getDefaultGeometry(), crs, toCrs);
                            geometry = geo.toText();
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        this.logger.info("\u89e3\u6790GeoJSON\u884c\u653f\u533a\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
                    }
                    break block6;
                }
                geometry = region.getGeometry();
            }
            catch (Exception e) {
                this.logger.info("\u89e3\u6790\u7a7a\u95f4\u53c2\u8003\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", region.getId());
        map.put("name", region.getId());
        map.put("title", region.getName());
        map.put("value", geometry);
        map.put("children", null);
        return map;
    }

    private List<java.util.Map> itemList2MapList(List<Item> items) {
        if (items == null) {
            return null;
        }
        ArrayList<java.util.Map> maps = new ArrayList<java.util.Map>();
        for (Item item : items) {
            maps.add(this.itemToMap(item));
        }
        return maps;
    }

    public String modifyServices(List<cn.gtmap.onemap.platform.entity.Service> services, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            cg.getMap().setOperationalLayers(services);
            this.gtplDao.saveConfig(cg, tpl);
            return tpl;
        }
        catch (Exception e) {
            throw new ServiceException(ServiceException.ExceptionType.MODIFY_SERVICES, e.getLocalizedMessage());
        }
    }

    public String modifyDicts(List<Dict> dicts, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            cg.setDicts(dicts);
            this.gtplDao.saveConfig(cg, tpl);
            return tpl;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("modify.dicts.error", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    public List<Item> getAllDictItems(String dictId, String tpl) {
        Dict dict = this.gtplDao.getDictById(dictId, tpl);
        List itemList = dict.getDictItems();
        return itemList;
    }

    public Item getDictItem(String dictId, String dictItemId, String tpl) {
        return this.gtplDao.getDictItemById(dictId, dictItemId, tpl);
    }

    public String insertDictItem(String dictId, Item item, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            for (Dict dict : dicts) {
                if (!dictId.equals(dict.getId())) continue;
                List items = dict.getDictItems();
                if (this.gtplDao.getDictItemById(dictId, item.getId(), tpl) == null) {
                    items.add(item);
                    dict.setDictItems(items);
                    continue;
                }
                this.updateDictItem(dictId, item, tpl);
            }
            cg.setDicts(dicts);
            this.gtplDao.saveConfig(cg, tpl);
        }
        catch (Exception e) {
            throw new DictItemException(DictItemException.ExceptionType.INSERT_ITEM, item.getName(), e.getLocalizedMessage());
        }
        return "";
    }

    public String updateDictItem(String dictId, Item item, String tpl) {
        try {
            Configuration cg = this.gtplDao.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            for (Dict dict : dicts) {
                if (!dictId.equals(dict.getId())) continue;
                ArrayList<Item> items = dict.getDictItems();
                if (items == null) {
                    items = new ArrayList<Item>();
                    items.add(item);
                    dict.setDictItems(items);
                    continue;
                }
                Iterator i$ = items.iterator();
                if (!i$.hasNext()) continue;
                Item item1 = (Item)i$.next();
                if (item.getId().equals(item1.getId())) {
                    items.remove(item1);
                    items.add(item);
                    dict.setDictItems(items);
                    continue;
                }
                items.add(item);
                dict.setDictItems(items);
            }
            cg.setDicts(dicts);
            this.gtplDao.saveConfig(cg, tpl);
        }
        catch (Exception e) {
            throw new DictItemException(DictItemException.ExceptionType.UPDATE_ITEM, item.getName(), e.getLocalizedMessage());
        }
        return "";
    }

    public String deleteDictItem(String dictId, String dictItemId, String tpl) {
        block4: {
            String dictItemName = "";
            try {
                Configuration cg = this.gtplDao.getConfigByTpl(tpl);
                List dicts = cg.getDicts();
                for (Dict dict : dicts) {
                    if (!dictId.equals(dict.getId())) continue;
                    List items = dict.getDictItems();
                    for (Item item : items) {
                        if (!dictItemId.equals(item.getId())) continue;
                        dictItemName = item.getName();
                        items.remove(item);
                        dict.setDictItems(items);
                        cg.setDicts(dicts);
                        this.gtplDao.saveConfig(cg, tpl);
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new DictItemException(DictItemException.ExceptionType.DELETE_ITEM, dictItemName, e.getLocalizedMessage());
            }
        }
        return "";
    }

    public String modifyDictItems(String dictId, List<Item> items, String tpl) {
        return null;
    }

    public String modifyGlobal(Configuration globelConfig, String tpl) {
        try {
            Configuration configuration = this.gtplDao.getConfigByTpl(tpl);
            configuration.setLogoVisible(globelConfig.isLogoVisible());
            configuration.setCoordinateVisible(globelConfig.isCoordinateVisible());
            configuration.setPrintService(globelConfig.getPrintService());
            configuration.setDescription(globelConfig.getDescription());
            configuration.setTypeId(globelConfig.getTypeId());
            configuration.getMap().setBaseLayers(globelConfig.getMap().getBaseLayers());
            this.gtplDao.saveConfig(configuration, tpl);
            return tpl;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("modify.global.error", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    public java.util.Map getAGSRealPath(List<String> ids) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id : ids) {
            try {
                ServiceProvider sp = (ServiceProvider)this.metadataService.getServiceProviders(id, PROVIDER_ARCGIS_PROXY).get(0);
                result.put(id, sp.getAttribute("url"));
            }
            catch (Exception e) {
                result.put(id, null);
            }
        }
        return result;
    }

    @CacheEvict(value={"serviceCache"}, key="#tpl")
    public boolean clearServiceCache(String tpl) {
        return true;
    }

    @CacheEvict(value={"regionCache"}, allEntries=true)
    public boolean clearRegionCache() {
        return true;
    }

    public String createTplFile(String tplName, String tplAlias, String description) {
        return this.gtplDao.createNewTpl(tplName, tplAlias, description);
    }

    public String deleteTpl(String tpl) {
        this.gtplDao.deleteTpl(tpl);
        return tpl;
    }

    public List<HashMap<String, Object>> getFilterMaps(Page<Map> mapPage, String tpl) {
        try {
            List allMapList = mapPage.getContent();
            ArrayList<HashMap<String, Object>> back = new ArrayList<HashMap<String, Object>>();
            JSONArray services = this.getAllService(tpl);
            for (Map map : allMapList) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("map", map);
                for (Object temp : services) {
                    String tname = ((JSONObject)temp).getString("name");
                    if (tname.equals(map.getName())) {
                        m.put("isBind", true);
                        break;
                    }
                    m.put("isBind", false);
                }
                back.add(m);
            }
            return back;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("map.filter.error", new Object[]{e.getMessage()}));
            return null;
        }
    }

    public cn.gtmap.onemap.platform.entity.Service mapToService(Map map) {
        cn.gtmap.onemap.platform.entity.Service service;
        block8: {
            Iterator i$;
            service = new cn.gtmap.onemap.platform.entity.Service();
            service.setId(map.getId());
            if (map.getGroup() != null) {
                service.setGroup(map.getGroup().getId());
            } else {
                service.setGroup("default");
            }
            if (map.getMaxScale() != null) {
                service.setMaxRefScale(map.getMaxScale());
            } else {
                service.setMaxRefScale(Double.valueOf(0.0));
            }
            if (map.getMinScale() != null) {
                service.setMinRefScale(map.getMinScale());
            } else {
                service.setMinRefScale(Double.valueOf(0.0));
            }
            service.setName(map.getName());
            service.setAlias(map.getAlias());
            if (map.getYear() == null) {
                service.setYear(Calendar.getInstance().get(1));
            } else {
                service.setYear(Integer.valueOf(map.getYear()).intValue());
            }
            service.setVisible(true);
            service.setAlpha(new Float(1.0));
            service.setXzdm(map.getRegionCode());
            service.setCategory("default");
            java.util.Map types = this.metadataService.getServices(map.getId());
            if (types == null || !(i$ = types.keySet().iterator()).hasNext()) break block8;
            ServiceType temp = (ServiceType)i$.next();
            service.setType(temp.getValue());
            service.setUrl(((Service)types.get(temp)).getUrl());
        }
        return this.setMaxMinExtent(service, map.getExtent().getXmin(), map.getExtent().getYmin(), map.getExtent().getXmax(), map.getExtent().getYmax());
    }

    public List<HashMap<String, Object>> getFilterLayers(List<Layer> layers, String tpl, String serviceId, int type) {
        try {
            ArrayList<HashMap<String, Object>> needLayers = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Boolean> hashMap = null;
            List functions = this.gtplDao.getServiceById(serviceId, tpl).getFunctions();
            for (Function function : functions) {
                if (type != function.getType()) continue;
                block3: for (Layer layer : layers) {
                    hashMap = new HashMap<String, Boolean>();
                    hashMap.put("isBind", false);
                    hashMap.put("layer", (Boolean)layer);
                    needLayers.add(hashMap);
                    for (Object object : function.getConfigLayers()) {
                        if (!layer.getAlias().equals(((JSONObject)object).get((Object)"alias"))) continue;
                        hashMap.put("isBind", true);
                        continue block3;
                    }
                }
            }
            return needLayers;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("map.filter.error", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    public void mapUpdateService(String tpl) {
        Configuration cg = this.gtplDao.getConfigByTpl(tpl);
        List services = cg.getMap().getOperationalLayers();
        for (cn.gtmap.onemap.platform.entity.Service service : services) {
            Map map = this.metadataService.getMap(service.getId());
            if (map.getGroup() != null) {
                service.setGroup(map.getGroup().getName());
            } else {
                service.setGroup("");
            }
            if (map.getMaxScale() != 0.0) {
                service.setMaxRefScale(map.getMaxScale());
            } else {
                service.setMaxRefScale(Double.valueOf(0.0));
            }
            if (map.getMinScale() != 0.0) {
                service.setMinRefScale(map.getMinScale());
            } else {
                service.setMinRefScale(Double.valueOf(0.0));
            }
            if (map.getExtent().getXmax() != 0.0) {
                service.setXMaxExtent(Double.valueOf(map.getExtent().getXmax()));
            } else {
                service.setXMaxExtent(Double.valueOf(0.0));
            }
            service.setName(map.getName());
        }
    }

    public cn.gtmap.onemap.platform.entity.Service setMaxMinExtent(cn.gtmap.onemap.platform.entity.Service service, double xMin, double yMin, double xMax, double yMax) {
        if (xMax != 0.0) {
            service.setXMaxExtent(Double.valueOf(xMax));
        } else {
            service.setXMaxExtent(Double.valueOf(0.0));
        }
        if (yMax != 0.0) {
            service.setYMaxExtent(Double.valueOf(yMax));
        } else {
            service.setYMaxExtent(Double.valueOf(0.0));
        }
        if (xMin != 0.0) {
            service.setXMinExtent(Double.valueOf(xMin));
        } else {
            service.setXMinExtent(Double.valueOf(0.0));
        }
        if (yMin != 0.0) {
            service.setYMinExtent(Double.valueOf(yMin));
        } else {
            service.setYMinExtent(Double.valueOf(0.0));
        }
        return service;
    }

    public List<HashMap<String, Object>> getTplsByCount(int count) {
        List tpls = new ArrayList();
        tpls = this.gtplDao.getAllTpl();
        if (tpls != null) {
            if (count < 1) {
                return tpls;
            }
            if (count < tpls.size()) {
                return tpls.subList(0, count);
            }
            return tpls;
        }
        return null;
    }

    private List<Configuration.Widget> getWidgets(int type, ArrayList<String> labels, List<cn.gtmap.onemap.platform.entity.Service> serviceList, String url) {
        ArrayList<Configuration.Widget> widgets = new ArrayList<Configuration.Widget>();
        try {
            for (String label : labels) {
                Configuration.Widget widget = new Configuration.Widget();
                JSONObject config = null;
                ArrayList<String> urls = new ArrayList<String>();
                for (cn.gtmap.onemap.platform.entity.Service service : serviceList) {
                    List functions = service.getFunctions();
                    if (functions == null) continue;
                    for (Function function : functions) {
                        if (type != function.getType()) continue;
                        JSONArray array = (JSONArray)((JSONObject)JSONArray.parse((String)function.getConfig())).get((Object)"layers");
                        for (int i = 0; i < array.size(); ++i) {
                            JSONObject obj = (JSONObject)array.get(i);
                            String showLabel = obj.get((Object)"showLabel").toString();
                            if (label.equals(showLabel)) {
                                urls.add(service.getUrl() + "/" + obj.get((Object)"layerIndex"));
                            }
                            if (config != null || !label.equals(showLabel)) continue;
                            JSONObject tempJs = (JSONObject)array.get(i);
                            if (tempJs.containsKey((Object)"titleField")) {
                                String titleField = ((JSONObject)tempJs.get((Object)"titleField")).get((Object)"name").toString();
                                tempJs.put("titleField", (Object)titleField);
                            }
                            config = tempJs;
                        }
                        widget.setUrl(url);
                    }
                }
                widget.setLabel(label);
                config.put("layerUrls", (Object)urls.toArray());
                widget.setConfig(config);
                widgets.add(widget);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u6839\u636eshowLabel\u751f\u6210WidgetGroup\u914d\u7f6e\u65f6\u5f02\u5e38");
        }
        return widgets;
    }

    private Configuration.Widget getWidget(Configuration.WidgetsGroup widgetsGroup, List<cn.gtmap.onemap.platform.entity.Service> serviceList) {
        Configuration.Widget widget = new Configuration.Widget();
        ArrayList<JSONObject> layers = new ArrayList<JSONObject>();
        try {
            widget.setUrl(widgetsGroup.getUrl());
            widget.setIcon(widgetsGroup.getIcon());
            widget.setLabel(widgetsGroup.getLabel());
            widget.setOpen(false);
            for (cn.gtmap.onemap.platform.entity.Service service : serviceList) {
                List functions = service.getFunctions();
                if (functions == null) continue;
                for (Function function : functions) {
                    if (function.getType() != Function.Type.IDENTIFY.getId()) continue;
                    JSONObject layer = new JSONObject();
                    layer.put("url", (Object)service.getUrl());
                    JSONArray layerReturn = new JSONArray();
                    JSONArray array = (JSONArray)((JSONObject)JSONArray.parse((String)function.getConfig())).get((Object)"layers");
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject returnFields = new JSONObject();
                        returnFields.put("layerName", ((JSONObject)array.get(i)).get((Object)"alias"));
                        returnFields.put("returnFields", ((JSONObject)array.get(i)).get((Object)"returnFields"));
                        returnFields.put("link", ((JSONObject)array.get(i)).get((Object)"link"));
                        if (((JSONObject)array.get(i)).containsKey((Object)"titleField")) {
                            returnFields.put("titleField", (Object)((JSONObject)((JSONObject)array.get(i)).get((Object)"titleField")).get((Object)"alias").toString());
                        }
                        returnFields.put("type", ((JSONObject)array.get(i)).get((Object)"type"));
                        returnFields.put("html", ((JSONObject)array.get(i)).get((Object)"html"));
                        layerReturn.add((Object)returnFields);
                    }
                    layer.put("layer", (Object)layerReturn);
                    layers.add(layer);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u751f\u6210Identify Widget\u65f6\u5f02\u5e38");
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("layers", layers.toArray());
        widget.setConfig(map);
        return widget;
    }

    private java.util.Map getLocationConfig(List<cn.gtmap.onemap.platform.entity.Service> serviceList) {
        ArrayList<JSONObject> layers = new ArrayList<JSONObject>();
        try {
            for (cn.gtmap.onemap.platform.entity.Service service : serviceList) {
                List functions = service.getFunctions();
                if (functions == null) continue;
                for (Function function : functions) {
                    if (function.getType() != Function.Type.LOCATION.getId()) continue;
                    JSONArray array = (JSONArray)((JSONObject)JSONArray.parse((String)function.getConfig())).get((Object)"layers");
                    for (int i = 0; i < array.size(); ++i) {
                        JSONObject jb = (JSONObject)array.get(0);
                        jb.put("url", (Object)service.getUrl());
                        if (jb.containsKey((Object)"titleField")) {
                            String titleField = ((JSONObject)jb.get((Object)"titleField")).get((Object)"name").toString();
                            jb.put("titleField", (Object)titleField);
                        }
                        layers.add(jb);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210Location Widget\u65f6\u5f02\u5e38");
        }
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        map.put("layers", layers.toArray());
        return map;
    }

    private java.util.Map<Integer, ArrayList<String>> getLabelsMap(Configuration configuration) {
        HashMap<Integer, ArrayList<String>> map = new HashMap<Integer, ArrayList<String>>();
        List serviceList = configuration.getMap().getOperationalLayers();
        try {
            for (Function.Type type : Function.Type.values()) {
                int id = type.getId();
                if (type.equals((Object)Function.Type.IDENTIFY) || type.equals((Object)Function.Type.LOCATION)) continue;
                ArrayList<String> list = new ArrayList<String>();
                for (cn.gtmap.onemap.platform.entity.Service service : serviceList) {
                    List functions = service.getFunctions();
                    if (functions == null) continue;
                    for (Function function : functions) {
                        if (function.getType() != id) continue;
                        JSONArray array = (JSONArray)((JSONObject)JSONArray.parse((String)function.getConfig())).get((Object)"layers");
                        for (int y = 0; y < array.size(); ++y) {
                            JSONObject jsonObject = (JSONObject)array.get(y);
                            String showLabel = jsonObject.get((Object)"showLabel").toString();
                            if (list.contains(showLabel)) continue;
                            list.add(showLabel);
                        }
                    }
                }
                map.put(id, list);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("\u83b7\u53d6showLabel\u5217\u8868\u5f02\u5e38");
        }
        return map;
    }

    private List<cn.gtmap.onemap.platform.entity.Service> filterServiceByYear(List<cn.gtmap.onemap.platform.entity.Service> services) {
        String configYear = AppConfig.getProperty((String)"default.year");
        if (configYear.equals("current")) {
            int currentYear = Calendar.getInstance().get(1);
            ArrayList<cn.gtmap.onemap.platform.entity.Service> serviceArrayList = new ArrayList<cn.gtmap.onemap.platform.entity.Service>();
            for (cn.gtmap.onemap.platform.entity.Service service : services) {
                if (service.getYear() != currentYear) continue;
                serviceArrayList.add(service);
            }
            return serviceArrayList;
        }
        return services;
    }
}

