/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.Constant;
import cn.gtmap.onemap.platform.dao.SpatialDao;
import cn.gtmap.onemap.platform.dao.impl.ArcSDEDaoImpl;
import cn.gtmap.onemap.platform.dao.impl.OracleSpatialDaoImpl;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import cn.gtmap.onemap.platform.service.GISService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GISServiceImpl;
import cn.gtmap.onemap.platform.support.spring.ApplicationContextHelper;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import cn.gtmap.onemap.platform.utils.EnumUtils;
import cn.gtmap.onemap.platform.utils.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class GISServiceImpl
extends BaseLogger
implements GISService {
    private final String SE_SHAPE_FIELD = "SHAPE";
    private final String SE_SHAPE_AREA = "SHAPE_AREA";
    private final String OG_PRO_PERFIX = "OG_PRO_";
    private final String SEARCH_LAYERS = "layers";
    private final String EXPORT_TYPE_GH = "gh";
    private final String EXPORT_TYPE_XZ = "xz";
    private static final String LAYER_MIDDLE_FIX_E = "_E_";
    private static final String LAYER_MIDDLE_FIX_H = "_H_";
    private SpatialDao spatialDao;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private AgsGeoemtryService agsGeoemtryService;
    @Autowired
    private MapService mapService;
    @Autowired
    private WebMapService webMapService;
    private Map searchConfig;
    private Map exportConfig;
    private String createDateField;
    private final double ACRES_CONV = 0.0015;

    public void setSearchConfig(Resource path) {
        try {
            this.searchConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" search config can't found ");
        }
    }

    public void setExportConfig(Resource path) {
        try {
            this.exportConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" export config can't found ");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void initialize(Constant.SpatialType type) {
        switch (1.$SwitchMap$cn$gtmap$onemap$platform$Constant$SpatialType[type.ordinal()]) {
            case 1: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(ArcSDEDaoImpl.class);
                break;
            }
            case 2: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(OracleSpatialDaoImpl.class);
            }
        }
        this.createDateField = this.isNull(AppPropertyUtils.getAppEnv((String)"insert.createDate.field")) ? null : String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.createDate.field")).trim();
    }

    public List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)where, (String)this.getMessage("query.where.notnull", new Object[0]));
        List result = null;
        try {
            result = this.spatialDao.query(layerName, where, columns, returnGeometry, dataSource);
        }
        catch (Exception e) {
            this.logger.info(this.getMessage("query.result.null", new Object[0]), (Object)e.getLocalizedMessage());
        }
        return result;
    }

    public List<?> query(String layerName, String wkt, String[] columns, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)wkt, (String)this.getMessage("query.geometry.notnull", new Object[0]));
        return this.spatialDao.query(layerName, wkt, columns, dataSource);
    }

    public List<?> query(String layerName, Geometry geometry, String[] columns, String dataSource) {
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> query(String layerName, SimpleFeature feature, String[] columns, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null && !sourceCRS.equals(layerCRS)) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> intersect(String layerName, String wktPlygon, String[] returnFields, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        return this.spatialDao.intersect(layerName, wktPlygon, returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Polygon polygon, String[] returnFields, String dataSource) {
        return this.intersect(layerName, polygon.toText(), returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Geometry geometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        ArrayList result = new ArrayList();
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    result.addAll(this.intersect(layerName, geo.toText(), outFields, dataSource));
                    this.addGeoProperty2List(result, geo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            result.addAll(this.intersect(layerName, geometry.toText(), outFields, dataSource));
            this.addGeoProperty2List(result, geometry);
        }
        if (sourceCRS != null) {
            for (Map item : result) {
                Geometry geo = this.geometryService.readWKT((String)item.get("SHAPE"));
                item.put("SHAPE", this.geometryService.project(geo, layerCRS, sourceCRS).toText());
            }
        }
        return result;
    }

    public List<?> intersect(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem sourceCRS = null;
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    List queryResults = this.query(layerName, geo, outFields, dataSource);
                    if (layerCRS instanceof GeographicCRS) {
                        if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                            sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        geo = this.geometryService.project(geo, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            if (this.isNull((Object)sourceCRS)) {
                                sourceCRS = layerCRS;
                            }
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geo.toText(), sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geo);
                            this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            List queryResults = this.query(layerName, geometry, outFields, dataSource);
            if (layerCRS instanceof GeographicCRS) {
                if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                    sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                geometry = this.geometryService.project(geometry, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                }
                Geometry geometryResult = null;
                try {
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                    geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geometry);
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                results.add(result);
            }
        }
        return results;
    }

    public List<?> intersectByGeoJSON(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCRS = null;
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
            results = this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            results = this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            FeatureCollection collection = (FeatureCollection)geo;
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                results.addAll(this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> intersect4(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.bufferIntersect(layerName, geometry, layerCrs, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> bufferIntersect(String layerName, Geometry sourceGeometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (sourceGeometry instanceof GeometryCollection) {
            for (int i = 0; i < sourceGeometry.getNumGeometries(); ++i) {
                try {
                    Geometry beforeGeo = sourceGeometry.getGeometryN(i);
                    Geometry afterGeometry = null;
                    afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(beforeGeo, sourceCRS, layerCRS) : beforeGeo;
                    Geometry tmpGeo = afterGeometry.buffer(0.002);
                    List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
                    CoordinateReferenceSystem tmpProjectedCRS = null;
                    if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                        if (queryResults.size() > 0) {
                            tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        beforeGeo = this.geometryService.project(beforeGeo, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), beforeGeo.toText(), sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                            geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(beforeGeo);
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            Geometry afterGeometry = null;
            afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(sourceGeometry, sourceCRS, layerCRS) : sourceGeometry;
            Geometry tmpGeo = afterGeometry.buffer(0.002);
            List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
            CoordinateReferenceSystem tmpProjectedCRS = null;
            if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                if (queryResults.size() > 0) {
                    tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                sourceGeometry = this.geometryService.project(sourceGeometry, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                }
                Geometry geometryResult = null;
                try {
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), sourceGeometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                    geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(sourceGeometry);
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                results.add(result);
            }
        }
        return results;
    }

    private List<?> intersectBySimpleFeature(String layerName, SimpleFeature feature, String[] outField, String dataSource) {
        CoordinateReferenceSystem sourceCRS = null;
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (!geometry.isValid()) {
            geometry = this.createValidGeometry(geometry);
        }
        this.setFeaturePros2Geo(feature, geometry);
        try {
            sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            return this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        }
        catch (Exception e) {
            this.logger.error("intersect analysis - feature json crs not define [{}]", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public List<?> intersect2(String layerName, String geoJson, String[] outField, String dataSource) {
        List results = this.intersectByGeoJSON(layerName, geoJson, outField, dataSource);
        return results;
    }

    public List<?> intersect3(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.intersect(layerName, geometry, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
            }
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                    geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
                }
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature));
            }
        }
        return results;
    }

    private Geometry createValidGeometry(Geometry geometry) {
        try {
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                GeometryFactory factory = geometry.getFactory();
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                Polygon exteriorPolygon = new Polygon((LinearRing)polygon.getExteriorRing(), null, factory);
                polygons.add(exteriorPolygon);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
                    Polygon interiorPolygon = new Polygon(interiorRing, null, factory);
                    polygons.add(interiorPolygon);
                }
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                ArrayList excludePolygons = new ArrayList();
                for (Polygon temp : polygons) {
                    if (excludePolygons.contains(temp = this.getPolygonWithHoles(polygons, excludePolygons, temp))) continue;
                    newPolygons.add(temp);
                }
                return new MultiPolygon(newPolygons.toArray(new Polygon[0]), factory);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
                for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                    if (!polygon.isValid()) {
                        MultiPolygon tempMultiPolygon = (MultiPolygon)this.createValidGeometry((Geometry)polygon);
                        for (int k = 0; k < tempMultiPolygon.getNumGeometries(); ++k) {
                            polygonList.add((Polygon)tempMultiPolygon.getGeometryN(k));
                        }
                        continue;
                    }
                    polygonList.add(polygon);
                }
                return new MultiPolygon(polygonList.toArray(new Polygon[0]), multiPolygon.getFactory());
            }
            this.logger.info("geometryType has not been supported yet");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private Polygon getPolygonWithHoles(List<Polygon> srcPolygons, List<Polygon> excludePolygons, Polygon polygon) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Polygon item : srcPolygons) {
            if (polygon.equals((Geometry)item) || excludePolygons.contains(polygon) || !polygon.contains((Geometry)item)) continue;
            holes.add((LinearRing)item.getExteriorRing());
            excludePolygons.add(item);
        }
        if (holes.size() > 0) {
            return new Polygon((LinearRing)polygon.getExteriorRing(), holes.toArray(new LinearRing[0]), polygon.getFactory());
        }
        return polygon;
    }

    private List addFeaturePros2List(List<Map> value, SimpleFeature feature) {
        for (Map item : value) {
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry")) continue;
                item.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
        }
        return value;
    }

    public String insert(String layerName, Map<String, Object> columns, String dataSource) {
        LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
        if (!this.isNull((Object)layerRegion.getRegionField())) {
            boolean contains = false;
            for (Map.Entry<String, Object> entry : columns.entrySet()) {
                if (!layerRegion.getRegionField().equalsIgnoreCase(entry.getKey()) || !this.geometryService.containsRegionValue(String.valueOf(entry.getValue()))) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new RuntimeException(this.getMessage("insert.region.field.not.null", new Object[]{layerName, layerRegion.getRegionField()}));
            }
        }
        return this.spatialDao.insert(layerName, columns, dataSource);
    }

    public String insert(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        try {
            if (geo instanceof FeatureCollection) {
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    columns = this.geometryService.simpleFeature2Map(feature);
                    for (Map.Entry entry : columns.entrySet()) {
                        if (!(entry.getValue() instanceof Geometry)) continue;
                        Geometry geometry = (Geometry)entry.getValue();
                        if (layerCRS != null && sourceCRS != null) {
                            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                        }
                        columns.put("SHAPE", geometry.toText());
                        columns.remove(entry.getKey());
                    }
                    if (featureIterator.hasNext()) {
                        this.insert(layerName, columns, dataSource);
                        continue;
                    }
                    return this.insert(layerName, columns, dataSource);
                }
            }
        }
        catch (Exception e) {
            this.logger.info(this.getMessage("insert.sde.false", new Object[0]), (Object)e.getLocalizedMessage());
        }
        return this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public String insert2(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
            resultFc.put("type", "FeatureCollection");
            ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                if (this.isNull((Object)sourceCRS)) {
                    sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                }
                columns = this.geometryService.simpleFeature2Map(feature);
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                    break;
                }
                String objectId = this.insert(layerName, columns, dataSource);
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                properties.put("OBJECTID", (Object)objectId);
                resultFeatures.add(featureMap);
            }
            resultFc.put("features", resultFeatures);
            return JSON.toJSONString(resultFc);
        }
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
            JSONObject properties = (JSONObject)featureMap.get("properties");
            String objectId = this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
            properties.put("OBJECTID", (Object)objectId);
            return JSON.toJSONString((Object)featureMap);
        }
        return null;
    }

    public String insert2(String layerName, String geoJSON, boolean check, String dataSource) {
        if (check) {
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof FeatureCollection) {
                LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
                resultFc.put("type", "FeatureCollection");
                ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    List list = this.query(layerName, feature, null, dataSource);
                    if (list.size() > 0) {
                        this.logger.error("\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!\u3010{}\u3011", (Object)this.geometryService.toFeatureJSON((Object)feature).toString());
                        if (featureIterator.hasNext()) continue;
                        throw new GISDaoException(GISDaoException.Method.INSERT, "\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!", GISDaoException.Type.ARC_SDE);
                    }
                    this.logger.info("[insert-- start getting sourceCRS...]");
                    CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    }
                    if (this.isNull((Object)sourceCRS)) {
                        this.logger.info("[insert sourceCRS:]null");
                    } else {
                        this.logger.info("[insert sourceCRS:]" + sourceCRS.toWKT());
                    }
                    columns = this.geometryService.simpleFeature2Map(feature);
                    try {
                        for (String key : columns.keySet()) {
                            if (!(columns.get(key) instanceof Geometry)) continue;
                            Geometry geometry = (Geometry)columns.get(key);
                            if (layerCRS != null && sourceCRS != null) {
                                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                            }
                            columns.put("SHAPE", geometry.toText());
                            columns.remove(key);
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                    String objectId = this.insert(layerName, columns, dataSource);
                    LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                    JSONObject properties = (JSONObject)featureMap.get("properties");
                    properties.put("OBJECTID", (Object)objectId);
                    resultFeatures.add(featureMap);
                }
                resultFc.put("features", resultFeatures);
                return JSON.toJSONString(resultFc);
            }
            if (geo instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)geo;
                List list = this.query(layerName, feature, null, dataSource);
                if (list.size() > 0) {
                    this.logger.error("\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!\u3010{}\u3011", (Object)geoJSON);
                    throw new GISDaoException(GISDaoException.Method.INSERT, "\u56fe\u5f62\u5df2\u5728\u6b64\u56fe\u5c42\u4e2d\u5b58\u5728,\u63d2\u5165\u5931\u8d25!", GISDaoException.Type.ARC_SDE);
                }
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                String objectId = this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
                properties.put("OBJECTID", (Object)objectId);
                return JSON.toJSONString((Object)featureMap);
            }
        } else {
            return this.insert2(layerName, geoJSON, dataSource);
        }
        return null;
    }

    public String insert3(String layerName, String geoJSON, boolean createAt, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
            resultFc.put("type", "FeatureCollection");
            ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                if (this.isNull((Object)sourceCRS)) {
                    sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                }
                columns = this.geometryService.simpleFeature2Map(feature);
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                    break;
                }
                if (createAt) {
                    if (this.isNull((Object)this.createDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.createDateField, new Date());
                }
                String objectId = this.insert(layerName, columns, dataSource);
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                properties.put("OBJECTID", (Object)objectId);
                resultFeatures.add(featureMap);
            }
            resultFc.put("features", resultFeatures);
            return JSON.toJSONString(resultFc);
        }
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
            JSONObject properties = (JSONObject)featureMap.get("properties");
            Map columns = this.geoJSON2Map(geoJSON, layerCRS);
            if (createAt) {
                if (this.isNull((Object)this.createDateField)) {
                    this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                    throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                }
                columns.put(this.createDateField, new Date());
            }
            String objectId = this.insert(layerName, columns, dataSource);
            properties.put("OBJECTID", (Object)objectId);
            return JSON.toJSONString((Object)featureMap);
        }
        return null;
    }

    public String insert3(String layerName, String geoJSON, boolean check, boolean createAt, String dataSource) {
        if (this.isNull((Object)check)) {
            check = false;
        }
        if (this.isNull((Object)createAt)) {
            createAt = false;
        }
        if (check) {
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof FeatureCollection) {
                LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
                resultFc.put("type", "FeatureCollection");
                ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    List list = this.query(layerName, feature, null, dataSource);
                    if (list.size() > 0) {
                        this.logger.error(this.getMessage("insert.check.fail", new Object[]{this.geometryService.toFeatureJSON((Object)feature).toString()}));
                        if (featureIterator.hasNext()) continue;
                        throw new GISDaoException(GISDaoException.Method.INSERT, "insert.check.fail", GISDaoException.Type.ARC_SDE);
                    }
                    CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    }
                    if (this.isNull((Object)sourceCRS)) {
                        this.logger.info("[insert sourceCRS:]null");
                    }
                    columns = this.geometryService.simpleFeature2Map(feature);
                    try {
                        for (String key : columns.keySet()) {
                            if (!(columns.get(key) instanceof Geometry)) continue;
                            Geometry geometry = (Geometry)columns.get(key);
                            if (layerCRS != null && sourceCRS != null) {
                                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                            }
                            columns.put("SHAPE", geometry.toText());
                            columns.remove(key);
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(this.getMessage("insert.shape.error", new Object[]{e.getLocalizedMessage()}));
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                    if (createAt) {
                        if (this.isNull((Object)this.createDateField)) {
                            this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                            throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                        }
                        columns.put(this.createDateField, new Date());
                    }
                    String objectId = this.insert(layerName, columns, dataSource);
                    LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                    JSONObject properties = (JSONObject)featureMap.get("properties");
                    properties.put("OBJECTID", (Object)objectId);
                    resultFeatures.add(featureMap);
                }
                resultFc.put("features", resultFeatures);
                return JSON.toJSONString(resultFc);
            }
            if (geo instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)geo;
                List list = this.query(layerName, feature, null, dataSource);
                if (list.size() > 0) {
                    this.logger.error("insert.check.fail", (Object)geoJSON);
                    throw new GISDaoException(GISDaoException.Method.INSERT, "insert.check.fail", GISDaoException.Type.ARC_SDE);
                }
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                Map columns = this.geoJSON2Map(geoJSON, layerCRS);
                if (createAt) {
                    if (this.isNull((Object)this.createDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.createDateField, new Date());
                }
                String objectId = this.insert(layerName, columns, dataSource);
                properties.put("OBJECTID", (Object)objectId);
                return JSON.toJSONString((Object)featureMap);
            }
        } else {
            return this.insert3(layerName, geoJSON, createAt, dataSource);
        }
        return null;
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dataSource) {
        return this.spatialDao.update(layerName, primaryKey, columns, dataSource);
    }

    public boolean update(String layerName, String primaryKey, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        return this.update(layerName, primaryKey, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public boolean delete(String layerName, String primaryKey, String dataSource) {
        return this.spatialDao.delete(layerName, primaryKey, dataSource);
    }

    public Map tdlyxzAnalysis(String dltbLayerName, String xzdwLayerName, String geometry, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        HashMap<String, Double> analysisResult = new HashMap<String, Double>();
        HashMap<String, Double> analysisTemp = new HashMap<String, Double>();
        String[] dltbOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "ZLDWDM", "TBBH"});
        List results = this.intersectByGeoJSON(dltbLayerName, geometry, dltbOutFields, dataSource);
        for (Map result : results) {
            String dlmc;
            Double area = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(area > 0.4)) continue;
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc = String.valueOf(result.get("DLMC"))) ? (Double)analysisResult.get(dlmc) : 0.0) + area);
            analysisTemp.put(String.valueOf(result.get("ZLDWDM")) + String.valueOf(result.get("TBBH")), area);
        }
        String[] xzdwOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "KD", "KCTBDWDM2", "KCTBDWDM1", "KCTBBH1", "KCTBBH2"});
        List xzResults = this.intersectByGeoJSON(xzdwLayerName, geometry, xzdwOutFields, dataSource);
        for (Map result : xzResults) {
            Double length = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(length > 0.08)) continue;
            String dlmc = String.valueOf(result.get("DLMC"));
            Double kd = Double.parseDouble(String.valueOf(result.get("KD")));
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc) ? (Double)analysisResult.get(dlmc) : 0.0) + length * kd);
            String where = "ZLDWDM='" + result.get("KCTBDWDM1") + "' and TBBH='" + result.get("KCTBBH1") + "'";
            List temps = new ArrayList();
            try {
                temps = this.query(dltbLayerName, where, ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC"}), true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
            }
            String kctb1Key = String.valueOf(result.get("KCTBDWDM1")) + String.valueOf(result.get("KCTBBH1"));
            if (StringUtils.isBlank((String)((String)result.get("KCTBDWDM2")))) {
                for (Map temp : temps) {
                    String tmpDlmc = String.valueOf(temp.get("DLMC"));
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length * kd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - length * kd);
                }
                continue;
            }
            Tag tag = Tag.NO;
            String tmpDlmc = "";
            String tmpDlmc1 = "";
            Double tmpXzdwKd = 0.0;
            String tmpXzdwKctbdwdm1 = "";
            String tmpXzdwKctbbh1 = "";
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb1Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb1Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        tmpXzdwKd = length / 2.0 * kd;
                        tmpDlmc1 = tmpDlmc;
                        tmpXzdwKctbbh1 = String.valueOf(result.get("KCTBBH1"));
                        tmpXzdwKctbdwdm1 = String.valueOf(result.get("KCTBDWDM1"));
                        analysisTemp.put(tmpXzdwKctbdwdm1 + tmpXzdwKctbbh1, tmpValue - length / 2.0 * kd);
                        continue;
                    }
                    tag = Tag.YES;
                    continue;
                }
                tag = Tag.YES;
            }
            where = "ZLDWDM='" + result.get("KCTBDWDM2") + "' and TBBH='" + result.get("KCTBBH2") + "'";
            try {
                temps = this.query(dltbLayerName, where, new String[]{"DLMC"}, true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                temps.clear();
            }
            String kctb2Key = String.valueOf(result.get("KCTBDWDM2")) + String.valueOf(result.get("KCTBBH2"));
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb2Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb2Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        if (!Tag.YES.equals((Object)tag)) {
                            analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                            analysisTemp.put(kctb2Key, tmpValue - length * kd);
                            continue;
                        }
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        analysisTemp.put(kctb2Key, tmpValue - length * kd);
                        continue;
                    }
                    tmpDlmc = tmpDlmc1;
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
                    continue;
                }
                tmpDlmc = tmpDlmc1;
                analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
            }
        }
        return analysisResult;
    }

    public Map tdlyxzAnalysis(String regionCode, String geometry, String dataSource) {
        regionCode = Utils.formatRegionCode((String)regionCode);
        String dltb = TDXZ.DLTB.name().concat("_H_").concat(regionCode);
        String xzdw = TDXZ.XZDW.name().concat("_H_").concat(regionCode);
        return this.tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
    }

    public Map tdlyxzAnalysis2(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        Map<String, String> detailValue;
        if (StringUtils.isBlank((String)dltbLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)xzdwLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u7ebf\u72b6\u5730\u7269\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)geometry)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5206\u6790\u5730\u5757\u5750\u6807\u4e3a\u7a7a\uff01"}));
        }
        HashMap<String, Double> dlMap = new HashMap<String, Double>();
        HashMap<String, Double> bhMap = new HashMap<String, Double>();
        MultiKeyMap analysisDetailMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
        String[] columns = new String[]{"DLMC"};
        List xzdwDltbResult = new ArrayList();
        List dltbAnalysisResult = new ArrayList();
        List xzdwAnalysisResult = new ArrayList();
        try {
            dltbAnalysisResult = this.intersect3(dltbLayerName, geometry, "DLMC;ZLDWDM;TBBH;ZLDWMC;QSXZ;DLBM;TBMJ;QSDWDM;QSDWMC".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (dltbAnalysisResult.size() > 0) {
            for (int i = 0; i < dltbAnalysisResult.size(); ++i) {
                Double tmpArea = Double.parseDouble(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (!(tmpArea > 0.4)) continue;
                if (dlMap.containsKey(((Map)dltbAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(((Map)dltbAnalysisResult.get(i)).get("DLMC")) + tmpArea);
                } else {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), tmpArea);
                }
                bhMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")) + String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")), tmpArea);
                if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")))) {
                    detailValue = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue.get("CCMJ"))) + tmpArea)));
                    continue;
                }
                detailValue = new HashMap<String, String>();
                detailValue.put("ZLDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")));
                detailValue.put("ZLDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWMC")));
                detailValue.put("TBBH", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                detailValue.put("QSXZ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSXZ")));
                detailValue.put("DLMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")));
                detailValue.put("DLBM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLBM")));
                detailValue.put("TBMJ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBMJ")));
                detailValue.put("QSDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWDM")));
                detailValue.put("QSDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWMC")));
                detailValue.put("CCMJ", (String)((Object)tmpArea));
                analysisDetailMap.put((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")), detailValue);
            }
        }
        try {
            xzdwAnalysisResult = this.intersect3(xzdwLayerName, geometry, "DLMC;KD;KCTBDWDM2;KCTBDWDM1;KCTBBH1;KCTBBH2;QSDWDM1;XZDWBH;QSXZ;DLBM;XZDWMJ;QSDWMC1".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (xzdwAnalysisResult.size() > 0) {
            for (int i = 0; i < xzdwAnalysisResult.size(); ++i) {
                HashMap<String, Double> detailValue2;
                Map<String, Double> detailValue3;
                Double tmpValue;
                String tmpDlmcKey;
                Double tmpLength = Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (!(tmpLength > 0.08)) continue;
                if (dlMap.containsKey(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                } else {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                }
                if (analysisDetailMap.containsKey((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")))) {
                    detailValue = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue.get("CCMJ"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                } else {
                    detailValue = new HashMap();
                    detailValue.put("ZLDWDM", String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))));
                    detailValue.put("ZLDWMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("")));
                    detailValue.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue.put("QSXZ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSXZ")));
                    detailValue.put("DLMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")));
                    detailValue.put("DLBM", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")));
                    detailValue.put("TBMJ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ")));
                    detailValue.put("QSDWDM1", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")));
                    detailValue.put("QSDWMC1", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWMC1")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                    analysisDetailMap.put((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), detailValue);
                }
                if (StringUtils.isBlank((String)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))) || String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")).equalsIgnoreCase("null")) {
                    String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                    try {
                        xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                    }
                    catch (Exception e) {
                        this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                    }
                    String tmpKey = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                    if (xzdwDltbResult.size() <= 0 || !bhMap.containsKey(tmpKey)) continue;
                    for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                        HashMap<String, Double> detailValue4;
                        dlMap.put(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        bhMap.put(tmpKey, (Double)bhMap.get(tmpKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                            detailValue4 = (HashMap<String, Double>)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                            detailValue4.put("CCMJ", Double.valueOf(String.valueOf(detailValue4.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            continue;
                        }
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"ERROR", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        detailValue4 = new HashMap<String, Double>();
                        detailValue4.put("ZLDWDM", (Double)((Object)("error" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                        detailValue4.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                        analysisDetailMap.put((Object)("error" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue4);
                    }
                    continue;
                }
                String kouchuTag = "no";
                double kouchuMj = 0.0;
                String kouchuDlmc = "";
                String kouchuZldwdm = "";
                String kouchuTbbh = "";
                String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (xzdwDltbResult.size() > 0) {
                    for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                        tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                        if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                            tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                            if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                kouchuMj = tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")));
                                kouchuDlmc = tmpDlmcKey;
                                kouchuZldwdm = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"));
                                kouchuTbbh = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                                detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - kouchuMj);
                                continue;
                            }
                            kouchuTag = "yes";
                            detailValue3 = new HashMap<String, Object>();
                            detailValue3.put("ZLDWDM", (Double)((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                            detailValue3.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                            detailValue3.put("TBMJ", tmpValue);
                            detailValue3.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue3);
                            continue;
                        }
                        kouchuTag = "yes";
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        detailValue2 = new HashMap<String, Double>();
                        detailValue2.put("ZLDWDM", (Double)((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                        detailValue2.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                        analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue2);
                    }
                    if (xzdwDltbResult.size() == 0) {
                        kouchuTag = "yes";
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u627e\u5230", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        HashMap<String, String> detailValue5 = new HashMap<String, String>();
                        detailValue5.put("ZLDWDM", "error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                        detailValue5.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                        analysisDetailMap.put((Object)("error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue5);
                    }
                } else {
                    kouchuTag = "yes";
                    this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u627e\u5230", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    HashMap<String, String> detailValue6 = new HashMap<String, String>();
                    detailValue6.put("ZLDWDM", "error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                    detailValue6.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                    analysisDetailMap.put((Object)("error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue6);
                }
                tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (xzdwDltbResult.size() <= 0) continue;
                for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                    tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                    if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")))) {
                        tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                            if (!kouchuTag.equals("yes")) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                                detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                continue;
                            }
                            dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            detailValue3 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                            detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            continue;
                        }
                        try {
                            tmpDlmcKey = kouchuDlmc;
                            dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u9762\u79ef\u6263\u9664\u9519\u8bef\uff0c\u51fa\u73b0\u65e0\u6cd5\u6263\u9664\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\uff0c\u8bf7\u7528\u5b9e\u5730\u52d8\u6d4b\u5750\u6807\u53e0\u52a0\u5230\u56fe\u5f62\u4e0a\uff01!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        }
                        bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                        detailValue3 = (Map)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                        detailValue3.put("CCMJ", Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) - kouchuMj);
                        HashMap<String, Object> detailValue1 = new HashMap<String, Object>();
                        detailValue1.put("ZLDWDM", "error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                        detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        detailValue1.put("TBMJ", tmpValue);
                        detailValue1.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                        continue;
                    }
                    try {
                        tmpDlmcKey = kouchuDlmc;
                        dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u571f\u5730\u5229\u7528\u73b0\u72b6\u5e95\u56fe\u4e2d\u73b0\u72b6\u5730\u7269\u6263\u9664\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    }
                    bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                    detailValue2 = (HashMap<String, Double>)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                    detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - kouchuMj);
                    this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    HashMap<String, String> detailValue1 = new HashMap<String, String>();
                    detailValue1.put("ZLDWDM", "error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                    detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                    analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                }
            }
        }
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        resultMap.put("analysisArea", dlMap);
        ArrayList<Object> resultDetailList = new ArrayList<Object>();
        for (Object tmpKey : analysisDetailMap.keySet()) {
            resultDetailList.add(analysisDetailMap.get(tmpKey));
        }
        resultMap.put("analysisAreaDetail", resultDetailList);
        return resultMap;
    }

    public List<?> tdghscAnalysis(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        if (StringUtils.isBlank((String)layerType)) {
            throw new RuntimeException(this.getMessage("layer.type.notnull", new Object[0]));
        }
        String layerName = layerType.concat("_E_").concat(Utils.formatRegionCode((String)regionCode));
        return this.intersect3(layerName, geometry, outFields, dataSource);
    }

    public Map tdghscAnalysis(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, List> result = new HashMap<String, List>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$000((GHSC)item), this.tdghscAnalysis(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public String tdghscAnalysis2(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        List result = this.tdghscAnalysis(layerType, regionCode, geometry, outFields, dataSource);
        FeatureCollection collection = this.geometryService.list2FeatureCollection(result, null, null);
        return this.geometryService.toFeatureJSON((Object)collection);
    }

    public Map tdghscAnalysis2(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$000((GHSC)item), this.tdghscAnalysis2(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public Map tdghscResult(Map analysisResult) {
        HashMap resultMap = new HashMap();
        try {
            for (GHSC item : GHSC.values()) {
                ArrayList list = new ArrayList();
                HashMap<String, Object> total = new HashMap<String, Object>();
                HashMap ghMap = new HashMap();
                double totalArea = 0.0;
                JSONObject singleObj = JSON.parseObject((String)analysisResult.get(GHSC.access$000((GHSC)item)).toString());
                JSONArray features = JSON.parseArray((String)singleObj.get((Object)"features").toString());
                totalArea = this.getTotalArea(features);
                total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
                total.put("AREA", totalArea);
                list.add(total);
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$000((GHSC)item), ghMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public Map tdghscResult(String layerType, String analysisResult) {
        HashMap resultMap = new HashMap();
        try {
            JSONObject fc = JSON.parseObject((String)analysisResult);
            JSONArray features = (JSONArray)fc.get((Object)"features");
            ArrayList list = new ArrayList();
            HashMap<String, Object> total = new HashMap<String, Object>();
            HashMap ghMap = new HashMap();
            double totalArea = 0.0;
            totalArea = this.getTotalArea(features);
            total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
            total.put("AREA", totalArea);
            list.add(total);
            for (GHSC item : GHSC.values()) {
                if (!item.name().equals(layerType)) continue;
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new HashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm());
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.info(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$000((GHSC)item), ghMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public LinkedHashMap tdghscExcelData(Map result) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : result.keySet()) {
            ArrayList list = new ArrayList();
            List keyList = (List)((Map)result.get(key)).get("info");
            for (int i = 1; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.add(temp.get("LXMC"));
                tempList.add(Math.round(Double.valueOf(temp.get("AREA").toString())));
                list.add(tempList);
            }
            map.put(key, list);
        }
        return map;
    }

    public List<Map> tdlyxzResult(Map analysisResult, String tpl) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        try {
            List detailList = (List)analysisResult.get("analysisAreaDetail");
            ArrayList dwdmList = new ArrayList();
            for (int i = 0; i < detailList.size(); ++i) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                ArrayList<Map> list = new ArrayList<Map>();
                boolean tag = false;
                Map map = (Map)detailList.get(i);
                String xzqdm = map.get("ZLDWDM").toString().substring(0, 6);
                if (xzqdm.indexOf("error") > -1) continue;
                list.add(map);
                temp.put("xzqdm", xzqdm);
                temp.put("detail", list);
                if (dwdmList.size() > 0) {
                    for (Map map2 : dwdmList) {
                        if (!map2.get("xzqdm").toString().equals(xzqdm)) continue;
                        List tempList = (List)map2.get("detail");
                        tempList.add(map);
                        map2.put("detail", tempList);
                        tag = true;
                    }
                }
                if (tag) continue;
                dwdmList.add(temp);
            }
            for (int j = 0; j < dwdmList.size(); ++j) {
                List groupList = this.getTdlyxzDictList(tpl);
                HashMap temp = new HashMap();
                Map map = (Map)dwdmList.get(j);
                List list = (List)map.get("detail");
                for (Map detailMap : list) {
                    String string = detailMap.get("DLBM").toString();
                    double area = MapUtils.getDoubleValue((Map)detailMap, (Object)"CCMJ", (double)0.0);
                    for (Map groupMap : groupList) {
                        List childList = new ArrayList();
                        if (groupMap.containsKey("detail")) {
                            childList = (List)groupMap.get("detail");
                        }
                        if (!groupMap.get("dlbm").toString().equals(string.substring(0, 2))) continue;
                        double newArea = MapUtils.getDoubleValue((Map)groupMap, (Object)"area", (double)0.0) + area;
                        groupMap.put("area", newArea);
                        childList = this.add2List(childList, detailMap);
                        groupMap.put("detail", childList);
                    }
                }
                temp.put("xzqdm", map.get("xzqdm"));
                temp.put("sumArea", this.getSumArea(groupList));
                temp.put("categoryA", groupList);
                temp.put("categoryB", this.getCategory(groupList));
                resultList.add(temp);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultList;
    }

    public LinkedHashMap tdlyxzExcelData(List<Map> result) {
        LinkedHashMap map = new LinkedHashMap();
        if (result.size() > 0) {
            Object value;
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            map.put("\u4e00\u7ea7\u5206\u7c7b", list1);
            map.put("\u4e8c\u7ea7\u5206\u7c7b", list2);
            for (Map item : result) {
                ArrayList temp1 = new ArrayList();
                ArrayList<Object> temp2 = new ArrayList<Object>();
                temp1.add(item.get("xzqdm"));
                temp2.add(item.get("xzqdm"));
                temp2.add(item.get("sumArea"));
                List categoryA = (List)item.get("categoryA");
                Map categoryB = (Map)item.get("categoryB");
                for (Map tempMap : categoryA) {
                    temp1.add(tempMap.get("area"));
                }
                temp2.add(this.isNull(categoryB.get("01")) ? Integer.valueOf(0) : categoryB.get("01"));
                temp2.add(this.isNull(categoryB.get("011")) ? Integer.valueOf(0) : categoryB.get("011"));
                temp2.add(this.isNull(categoryB.get("012")) ? Integer.valueOf(0) : categoryB.get("012"));
                temp2.add(this.isNull(categoryB.get("013")) ? Integer.valueOf(0) : categoryB.get("013"));
                temp2.add(this.isNull(categoryB.get("02")) ? Integer.valueOf(0) : categoryB.get("02"));
                temp2.add(this.isNull(categoryB.get("021")) ? Integer.valueOf(0) : categoryB.get("021"));
                temp2.add(this.isNull(categoryB.get("022")) ? Integer.valueOf(0) : categoryB.get("022"));
                temp2.add(this.isNull(categoryB.get("023")) ? Integer.valueOf(0) : categoryB.get("023"));
                temp2.add(this.isNull(categoryB.get("03")) ? Integer.valueOf(0) : categoryB.get("03"));
                temp2.add(this.isNull(categoryB.get("031")) ? Integer.valueOf(0) : categoryB.get("031"));
                temp2.add(this.isNull(categoryB.get("032")) ? Integer.valueOf(0) : categoryB.get("032"));
                temp2.add(this.isNull(categoryB.get("033")) ? Integer.valueOf(0) : categoryB.get("033"));
                temp2.add(this.isNull(categoryB.get("04")) ? Integer.valueOf(0) : categoryB.get("04"));
                temp2.add(this.isNull(categoryB.get("041")) ? Integer.valueOf(0) : categoryB.get("041"));
                temp2.add(this.isNull(categoryB.get("042")) ? Integer.valueOf(0) : categoryB.get("042"));
                temp2.add(this.isNull(categoryB.get("043")) ? Integer.valueOf(0) : categoryB.get("043"));
                temp2.add(this.isNull(categoryB.get("20")) ? Integer.valueOf(0) : categoryB.get("20"));
                temp2.add(this.isNull(categoryB.get("201")) ? Integer.valueOf(0) : categoryB.get("201"));
                temp2.add(this.isNull(categoryB.get("202")) ? Integer.valueOf(0) : categoryB.get("202"));
                temp2.add(this.isNull(categoryB.get("203")) ? Integer.valueOf(0) : categoryB.get("203"));
                temp2.add(this.isNull(categoryB.get("204")) ? Integer.valueOf(0) : categoryB.get("204"));
                temp2.add(this.isNull(categoryB.get("205")) ? Integer.valueOf(0) : categoryB.get("205"));
                temp2.add(this.isNull(categoryB.get("10")) ? Integer.valueOf(0) : categoryB.get("10"));
                temp2.add(this.isNull(categoryB.get("101")) ? Integer.valueOf(0) : categoryB.get("101"));
                temp2.add(this.isNull(categoryB.get("102")) ? Integer.valueOf(0) : categoryB.get("102"));
                temp2.add(this.isNull(categoryB.get("104")) ? Integer.valueOf(0) : categoryB.get("104"));
                temp2.add(this.isNull(categoryB.get("105")) ? Integer.valueOf(0) : categoryB.get("105"));
                temp2.add(this.isNull(categoryB.get("106")) ? Integer.valueOf(0) : categoryB.get("106"));
                temp2.add(this.isNull(categoryB.get("107")) ? Integer.valueOf(0) : categoryB.get("107"));
                temp2.add(this.isNull(categoryB.get("11")) ? Integer.valueOf(0) : categoryB.get("11"));
                temp2.add(this.isNull(categoryB.get("111")) ? Integer.valueOf(0) : categoryB.get("111"));
                temp2.add(this.isNull(categoryB.get("112")) ? Integer.valueOf(0) : categoryB.get("112"));
                temp2.add(this.isNull(categoryB.get("113")) ? Integer.valueOf(0) : categoryB.get("113"));
                temp2.add(this.isNull(categoryB.get("114")) ? Integer.valueOf(0) : categoryB.get("114"));
                temp2.add(this.isNull(categoryB.get("115")) ? Integer.valueOf(0) : categoryB.get("115"));
                temp2.add(this.isNull(categoryB.get("116")) ? Integer.valueOf(0) : categoryB.get("116"));
                temp2.add(this.isNull(categoryB.get("117")) ? Integer.valueOf(0) : categoryB.get("117"));
                temp2.add(this.isNull(categoryB.get("118")) ? Integer.valueOf(0) : categoryB.get("118"));
                temp2.add(this.isNull(categoryB.get("119")) ? Integer.valueOf(0) : categoryB.get("119"));
                temp2.add(this.isNull(categoryB.get("12")) ? Integer.valueOf(0) : categoryB.get("12"));
                temp2.add(this.isNull(categoryB.get("122")) ? Integer.valueOf(0) : categoryB.get("122"));
                temp2.add(this.isNull(categoryB.get("123")) ? Integer.valueOf(0) : categoryB.get("123"));
                temp2.add(this.isNull(categoryB.get("124")) ? Integer.valueOf(0) : categoryB.get("124"));
                temp2.add(this.isNull(categoryB.get("125")) ? Integer.valueOf(0) : categoryB.get("125"));
                temp2.add(this.isNull(categoryB.get("126")) ? Integer.valueOf(0) : categoryB.get("126"));
                temp2.add(this.isNull(categoryB.get("127")) ? Integer.valueOf(0) : categoryB.get("127"));
                list1.add(temp1);
                list2.add(temp2);
            }
            ArrayList temp = new ArrayList();
            temp = (ArrayList)list1.get(0);
            for (int i = 0; i < temp.size(); ++i) {
                value = temp.get(i);
                if (!(value instanceof Double)) continue;
                temp.remove(i);
                value = (double)Math.round((Double)value * 100.0) / 100.0;
                temp.add(i, value);
            }
            temp = (ArrayList)list2.get(0);
            for (int j = 0; j < temp.size(); ++j) {
                value = temp.get(j);
                if (!(value instanceof Double)) continue;
                temp.remove(j);
                value = (double)Math.round((Double)value * 100.0) / 100.0;
                temp.add(j, value);
            }
        }
        return map;
    }

    public List<LinkedHashMap> analysisExcelData(List list) {
        ArrayList<LinkedHashMap> result = new ArrayList<LinkedHashMap>();
        for (int i = 0; i < list.size(); ++i) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            ArrayList<Object> headerList = new ArrayList<Object>();
            ArrayList dataList = new ArrayList();
            JSONObject obj = (JSONObject)list.get(i);
            JSONArray children = (JSONArray)obj.get((Object)"children");
            for (int j = 0; j < children.size(); ++j) {
                JSONArray child = (JSONArray)children.get(j);
                ArrayList<Object> temp = new ArrayList<Object>();
                for (int m = 0; m < child.size(); ++m) {
                    JSONObject field = (JSONObject)child.get(m);
                    if (j == 0) {
                        headerList.add(field.get((Object)"alias") == null ? field.get((Object)"name") : field.get((Object)"alias"));
                    }
                    if (field.get((Object)"value") instanceof BigDecimal) {
                        temp.add(this.processValue(Double.valueOf(((BigDecimal)field.get((Object)"value")).doubleValue()), 3));
                        continue;
                    }
                    temp.add(field.get((Object)"value"));
                }
                dataList.add(temp);
            }
            map.put("name", obj.get((Object)"alias"));
            map.put("header", headerList);
            map.put("data", dataList);
            result.add(map);
        }
        return result;
    }

    public List<Map> gzqydExcelData(List list) {
        try {
            ArrayList<Map> result = new ArrayList<Map>();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                ArrayList tempList = new ArrayList();
                Map item = (Map)list.get(0);
                List values = (List)item.get("value");
                for (Map value : values) {
                    ArrayList<Object> temp = new ArrayList<Object>(8);
                    temp.add(0, String.valueOf(value.get("OG_PRO_XZQMC")));
                    temp.add(1, String.valueOf(value.get("OG_PRO_REGIONCODE")));
                    temp.add(2, String.valueOf(value.get("OG_PRO_PRONAME")));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("011"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("012"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("020"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("030"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("040"))));
                    tempList.add(temp);
                }
                tempMap.put("value", tempList);
                tempMap.put("type", (String)item.get("type"));
                result.add(tempMap);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    public Map<String, Object> dtExcelData(Map<String, Object> data) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.isNull(data)) {
            return null;
        }
        try {
            for (String key : data.keySet()) {
                Map map = (Map)data.get(key);
                if (this.isNull((Object)map)) {
                    return result;
                }
                List info = new ArrayList();
                List detail = new ArrayList();
                HashMap sheet = new HashMap();
                if (key.equals("xz")) {
                    if (!this.isNull(map.get("detail"))) {
                        detail = (List)map.get("detail");
                        ArrayList xzList = new ArrayList();
                        for (Map xzMap : detail) {
                            ArrayList<String> xzTmpList = new ArrayList<String>();
                            xzTmpList.add(this.isNull(xzMap.get("qsmc")) ? "" : xzMap.get("qsmc"));
                            xzTmpList.add(this.isNull(xzMap.get("nydZmj")) ? "" : xzMap.get("nydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("gdMj")) ? "" : xzMap.get("gdMj"));
                            xzTmpList.add(this.isNull(xzMap.get("011")) ? "" : xzMap.get("011"));
                            xzTmpList.add(this.isNull(xzMap.get("012")) ? "" : xzMap.get("012"));
                            xzTmpList.add(this.isNull(xzMap.get("013")) ? "" : xzMap.get("013"));
                            xzTmpList.add(this.isNull(xzMap.get("021")) ? "" : xzMap.get("021"));
                            xzTmpList.add(this.isNull(xzMap.get("022")) ? "" : xzMap.get("022"));
                            xzTmpList.add(this.isNull(xzMap.get("023")) ? "" : xzMap.get("023"));
                            xzTmpList.add(this.isNull(xzMap.get("031")) ? "" : xzMap.get("031"));
                            xzTmpList.add(this.isNull(xzMap.get("032")) ? "" : xzMap.get("032"));
                            xzTmpList.add(this.isNull(xzMap.get("033")) ? "" : xzMap.get("033"));
                            xzTmpList.add(this.isNull(xzMap.get("041")) ? "" : xzMap.get("041"));
                            xzTmpList.add(this.isNull(xzMap.get("042")) ? "" : xzMap.get("042"));
                            xzTmpList.add(this.isNull(xzMap.get("122")) ? "" : xzMap.get("122"));
                            xzTmpList.add(this.isNull(xzMap.get("104")) ? "" : xzMap.get("104"));
                            xzTmpList.add(this.isNull(xzMap.get("114")) ? "" : xzMap.get("114"));
                            xzTmpList.add(this.isNull(xzMap.get("117")) ? "" : xzMap.get("117"));
                            xzTmpList.add(this.isNull(xzMap.get("123")) ? "" : xzMap.get("123"));
                            xzTmpList.add(this.isNull(xzMap.get("jsydZmj")) ? "" : xzMap.get("jsydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("201")) ? "" : xzMap.get("123"));
                            xzTmpList.add(this.isNull(xzMap.get("202")) ? "" : xzMap.get("202"));
                            xzTmpList.add(this.isNull(xzMap.get("203")) ? "" : xzMap.get("203"));
                            xzTmpList.add(this.isNull(xzMap.get("204")) ? "" : xzMap.get("204"));
                            xzTmpList.add(this.isNull(xzMap.get("205")) ? "" : xzMap.get("205"));
                            xzTmpList.add(this.isNull(xzMap.get("101")) ? "" : xzMap.get("101"));
                            xzTmpList.add(this.isNull(xzMap.get("102")) ? "" : xzMap.get("102"));
                            xzTmpList.add(this.isNull(xzMap.get("105")) ? "" : xzMap.get("105"));
                            xzTmpList.add(this.isNull(xzMap.get("106")) ? "" : xzMap.get("106"));
                            xzTmpList.add(this.isNull(xzMap.get("107")) ? "" : xzMap.get("107"));
                            xzTmpList.add(this.isNull(xzMap.get("113")) ? "" : xzMap.get("113"));
                            xzTmpList.add(this.isNull(xzMap.get("118")) ? "" : xzMap.get("118"));
                            xzTmpList.add(this.isNull(xzMap.get("wlydZmj")) ? "" : xzMap.get("wlydZmj"));
                            xzTmpList.add(this.isNull(xzMap.get("043")) ? "" : xzMap.get("043"));
                            xzTmpList.add(this.isNull(xzMap.get("124")) ? "" : xzMap.get("124"));
                            xzTmpList.add(this.isNull(xzMap.get("125")) ? "" : xzMap.get("125"));
                            xzTmpList.add(this.isNull(xzMap.get("126")) ? "" : xzMap.get("126"));
                            xzTmpList.add(this.isNull(xzMap.get("127")) ? "" : xzMap.get("127"));
                            xzTmpList.add(this.isNull(xzMap.get("121")) ? "" : xzMap.get("121"));
                            xzTmpList.add(this.isNull(xzMap.get("111")) ? "" : xzMap.get("111"));
                            xzTmpList.add(this.isNull(xzMap.get("112")) ? "" : xzMap.get("112"));
                            xzTmpList.add(this.isNull(xzMap.get("115")) ? "" : xzMap.get("115"));
                            xzTmpList.add(this.isNull(xzMap.get("116")) ? "" : xzMap.get("116"));
                            xzTmpList.add(this.isNull(xzMap.get("119")) ? "" : xzMap.get("119"));
                            xzTmpList.add(this.isNull(xzMap.get("zmj")) ? "" : xzMap.get("zmj"));
                            xzList.add(xzTmpList);
                        }
                        if (xzList.size() > 0) {
                            sheet.put("Sheet1", xzList);
                        }
                    }
                    result.put(String.valueOf(key), sheet);
                    continue;
                }
                if (key.equals("bp")) {
                    ArrayList list1 = new ArrayList();
                    ArrayList list2 = new ArrayList();
                    if (!this.isNull(map.get("info"))) {
                        info = (List)map.get("info");
                    }
                    if (!this.isNull(map.get("detail"))) {
                        detail = (List)map.get("detail");
                    }
                    if (info.size() > 0 && detail.size() > 0) {
                        for (Map temp : info) {
                            ArrayList tempList = new ArrayList();
                            tempList.add(temp.get("label"));
                            tempList.add(temp.get("area_pfm"));
                            tempList.add(temp.get("area_gq"));
                            tempList.add(temp.get("area_m"));
                            list1.add(tempList);
                        }
                        ArrayList<String> keyList = new ArrayList<String>();
                        for (Object detailKey : ((Map)detail.get(0)).keySet()) {
                            keyList.add(String.valueOf(detailKey));
                        }
                        list2.add(keyList);
                        for (Map detailTmp : detail) {
                            ArrayList tempList = new ArrayList();
                            for (String key1 : keyList) {
                                tempList.add(detailTmp.get(key1));
                            }
                            list2.add(tempList);
                        }
                        sheet.put("\u62a5\u6279\u6c47\u603b", list1);
                        sheet.put("\u62a5\u6279\u8be6\u60c5", list2);
                    }
                    result.put(String.valueOf(key), sheet);
                    continue;
                }
                ArrayList list = new ArrayList();
                ArrayList bpList = new ArrayList();
                if (!this.isNull(map.get("detail"))) {
                    detail = (List)map.get("detail");
                    ArrayList<String> firstRow = new ArrayList<String>();
                    ArrayList<String> secondRow = new ArrayList<String>();
                    firstRow.add("\u7528\u9014");
                    secondRow.add("\u9762\u79ef");
                    for (Map ghMap : detail) {
                        firstRow.add((String)ghMap.get("label"));
                        secondRow.add((String)ghMap.get("area"));
                    }
                    bpList.add(secondRow);
                    sheet.put("header", firstRow);
                    sheet.put("data", bpList);
                    list.add(sheet);
                }
                result.put(String.valueOf(key), list);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public double processValue(Double value, int precision) {
        switch (precision) {
            case 1: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 2: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 3: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
        }
        return Math.round(value * 100.0) / 100L;
    }

    public double getSumArea(List<Map> list) {
        double area = 0.0;
        for (Map map : list) {
            area += MapUtils.getDouble((Map)map, (Object)"area", (Double)0.0).doubleValue();
        }
        return area;
    }

    public Map getCategory(List<Map> list) {
        HashMap result = new HashMap();
        try {
            for (Map map : list) {
                result.put(map.get("dlbm"), map.get("area"));
                if (!map.containsKey("detail")) continue;
                List detailList = (List)map.get("detail");
                for (Map detail : detailList) {
                    result.put(detail.get("dlbm"), detail.get("area"));
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public List<Map> add2List(List<Map> list, Map map) {
        boolean tag = false;
        String dlbm = map.get("DLBM").toString();
        double area = MapUtils.getDoubleValue((Map)map, (Object)"CCMJ", (double)0.0);
        HashMap<String, Object> temp = new HashMap<String, Object>();
        try {
            for (Map item : list) {
                if (!item.get("dlbm").equals(dlbm)) continue;
                double newArea = MapUtils.getDoubleValue((Map)item, (Object)"area", (double)0.0) + area;
                item.put("area", newArea);
                tag = true;
            }
            if (!tag) {
                temp.put("area", area);
                temp.put("dlbm", dlbm);
                list.add(temp);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return list;
    }

    public List<Map> tdlyxzResult2(Map analysisResult, String tpl) {
        double area;
        ArrayList<Map> resultList = new ArrayList<Map>();
        List list = (List)analysisResult.get("analysisAreaDetail");
        List groupList = this.getTdlyxzDictList(tpl);
        for (Map map : list) {
            String dlbm = map.get("DLBM").toString();
            area = Double.valueOf(map.get("CCMJ").toString());
            for (Map groupMap : groupList) {
                if (!groupMap.get("dlbm").toString().equals(dlbm.substring(0, 2))) continue;
                double newArea = Double.valueOf(groupMap.get("area").toString()) + area;
                ((List)groupMap.get("detail")).add(map);
                groupMap.put("area", newArea);
            }
        }
        for (int i = 0; i < groupList.size(); ++i) {
            Map map;
            map = (Map)groupList.get(i);
            HashMap temp = new HashMap();
            area = Double.valueOf(map.get("area").toString());
            if (!(area > 0.0)) continue;
            temp.put("dlmc", map.get("dlmc"));
            temp.put("area", map.get("area"));
            temp.put("detail", map.get("detail"));
            resultList.add(temp);
        }
        return resultList;
    }

    public List search(String value, boolean returnGeometry) {
        if (this.searchConfig == null) {
            throw new RuntimeException(this.getMessage("search.config.not.found", new Object[0]));
        }
        ArrayList result = new ArrayList();
        List layers = (List)this.searchConfig.get("layers");
        for (Map layer : layers) {
            String name = (String)layer.get("layer");
            String[] fields = ((String)layer.get("fields")).split(",");
            String where = this.getWhereClause(fields, value);
            result.addAll(this.spatialDao.query(name, where, fields, returnGeometry, 10, null));
        }
        return result;
    }

    public InputStream exportMap(String where, String mapScale, int width, int height, String type) {
        ByteArrayInputStream inputStream;
        Graphics2D graphics2D;
        if (this.exportConfig == null) {
            this.logger.info("\u65e0\u914d\u7f6e\u4fe1\u606f");
            return null;
        }
        int bgWidth = width + 10;
        int bgHeight = height + 10;
        String imageSize = width + "," + height;
        double scale = 0.0;
        if (StringUtils.isNotBlank((String)mapScale)) {
            scale = Double.valueOf(mapScale);
        }
        ArrayList<BufferedImage> baseImages = new ArrayList<BufferedImage>();
        BufferedImage topImage = null;
        BufferedImage resultImage = new BufferedImage(width, height, 4);
        ReferencedEnvelope envelope = null;
        Map operaLayer = (Map)this.exportConfig.get("operaLayer");
        List ghLayers = (List)this.exportConfig.get("ghLayers");
        List xzLayers = (List)this.exportConfig.get("xzLayers");
        String layerName = (String)operaLayer.get("layerName");
        String dataSource = (String)operaLayer.get("dataSource");
        String url = (String)operaLayer.get("url");
        List list = this.query(layerName, where, null, true, dataSource);
        if (list.size() > 0) {
            BufferedImage tempImage2;
            FeatureCollection featureCollection = this.geometryService.list2FeatureCollection(list, null, null);
            envelope = featureCollection.getBounds();
            topImage = this.getExportImage((Envelope)envelope, url, imageSize, scale);
            if (type.equals("gh")) {
                for (Map item : ghLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else if (type.equals("xz")) {
                for (Map item : xzLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else {
                this.logger.error("type is not found");
            }
            graphics2D = resultImage.createGraphics();
            resultImage = graphics2D.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            graphics2D.dispose();
            graphics2D = resultImage.createGraphics();
            if (baseImages.size() > 0) {
                for (BufferedImage tempImage2 : baseImages) {
                    graphics2D.drawImage(tempImage2, 0, 0, tempImage2.getWidth(), tempImage2.getHeight(), null);
                }
            }
        } else {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u5730\u5757!");
            return null;
        }
        graphics2D.drawImage(topImage, 0, 0, topImage.getWidth(), topImage.getHeight(), null);
        graphics2D.dispose();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resultImage, "png", out);
            inputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return inputStream;
    }

    public List jctbExcelData(List<Map> list) {
        ArrayList result = null;
        if (this.isNull(list)) {
            return null;
        }
        result = new ArrayList();
        for (Map item : list) {
            ArrayList<Object> temp = new ArrayList<Object>();
            temp.add(list.indexOf(item) + 1);
            temp.add(item.get("OG_PRO_JCBH"));
            temp.add(item.get("OG_PRO_TBLX"));
            temp.add(item.get("OG_PRO_BSM"));
            temp.add(item.get("OG_PRO_XZMC"));
            temp.add(item.get("OG_PRO_XMMC"));
            temp.add(item.get("OG_PRO_JSDW"));
            temp.add(item.get("OG_PRO_JCMJ"));
            temp.add(item.get("JC_GD_AREA"));
            temp.add(item.get(JTag.BP_AREA.name()));
            temp.add(item.get(JTag.BP_GD_AREA.name()));
            temp.add(item.get(JTag.YG_AREA.name()));
            temp.add(item.get(JTag.WG_AREA.name()));
            temp.add(item.get(JTag.WPYJ_AREA.name()));
            temp.add(item.get(JTag.WPYJ_GD_AREA.name()));
            temp.add(item.get(JTag.YXJSQ_AREA.name()));
            temp.add(item.get(JTag.JBNT_AREA.name()));
            temp.add(item.get(JTag.YBNTQ_AREA.name()));
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            temp.add(item.get(JTag.PCMC.name()));
            temp.add(item.get(JTag.NZYPW.name()));
            temp.add(item.get(JTag.GDBH.name()));
            temp.add(" ");
            temp.add(" ");
            temp.add(" ");
            result.add(temp);
        }
        return result;
    }

    public Map ghscxgData(List<Map> data, List<Map> fields) {
        HashMap result = new HashMap();
        ArrayList<Map> showResult = new ArrayList<Map>();
        HashMap excelResult = new HashMap();
        ArrayList sheet = new ArrayList();
        try {
            ArrayList<Object> headerList = new ArrayList<Object>();
            ArrayList dataList = new ArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                headerList.add(fields.get(i).get("alias"));
            }
            for (Map map : data) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Map f : fields) {
                    String type;
                    if (f.containsKey("type") && (type = (String)f.get("type")).toLowerCase().equals("date")) {
                        map.put(f.get("name"), DateFormat.getDateInstance().format(map.get(f.get("name"))));
                    }
                    list.add(this.isNull(map.get(f.get("name"))) ? "" : map.get(f.get("name")));
                }
                list.add(0, data.indexOf(map) + 1);
                double area = MapUtils.getDouble((Map)map, (Object)"SHAPE_AREA");
                list.add(area);
                list.add(area * 1.0E-4);
                showResult.add(map);
                dataList.add(list);
            }
            headerList.add(0, "ID");
            headerList.add("\u91cd\u53e0\u9762\u79ef\uff08\u5e73\u65b9\u7c73\uff09");
            headerList.add("\u91cd\u53e0\u9762\u79ef\uff08\u516c\u9877\uff09");
            excelResult.put("header", headerList);
            excelResult.put("data", dataList);
            sheet.add(excelResult);
            result.put("excel", sheet);
            result.put("result", showResult);
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getLayerCRS(String layerName, String dataSource) {
        try {
            return this.spatialDao.getLayerCRS(layerName, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    public List<Map> jctbAnalysis(String geometry, List analysisLayers, String dataSource) {
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        ArrayList<Map> results = null;
        try {
            Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
            if (geo instanceof FeatureCollection) {
                results = new ArrayList<Map>();
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Map map = this.singleAnalysisOfJctb(feature, analysisLayers, dataSource);
                    results.add(map);
                }
            }
        }
        catch (GeometryServiceException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return results;
    }

    public Map singleAnalysisOfJctb(SimpleFeature feature, List analysisLayers, String dataSource) {
        HashMap<String, Object> result = null;
        HashMap<String, List> analysisMap = new HashMap<String, List>();
        try {
            for (int i = 0; i < analysisLayers.size(); ++i) {
                Map layer = (Map)analysisLayers.get(i);
                String lyrId = layer.get("id").toString();
                String lyrName = (String)layer.get("layerName");
                String outFields = layer.get("fields").toString();
                String[] fields = "*".equals(outFields) ? null : outFields.split(",");
                List analysisList = this.intersectBySimpleFeature(lyrName, feature, fields, dataSource);
                analysisMap.put(lyrId.toUpperCase(), analysisList);
            }
            List bpList = (List)analysisMap.get(JCTB.BPDK.name());
            List gdList = (List)analysisMap.get(JCTB.GDDK.name());
            List dltbList = (List)analysisMap.get(JCTB.DLTB.name());
            List xzdwList = (List)analysisMap.get(JCTB.XZDW.name());
            List jsydgzqList = (List)analysisMap.get(JCTB.JSYDGZQ.name());
            List tdytqList = (List)analysisMap.get(JCTB.TDYTQ.name());
            double geoArea = this.getAreaByFeature(feature, 0.0015);
            double dltb_gd_area = this.getAreaByField(dltbList, "DLBM", "011", 1.0) + this.getAreaByField(dltbList, "DLBM", "012", 1.0) + this.getAreaByField(dltbList, "DLBM", "013", 1.0);
            double xzdw_gd_area = this.getXzdwAreaByField(xzdwList, "DLBM", "011", 1.0) + this.getXzdwAreaByField(xzdwList, "DLBM", "012", 1.0) + this.getXzdwAreaByField(xzdwList, "DLBM", "013", 1.0);
            result = new HashMap<String, Object>();
            result.put(JTag.JC_GD_AREA.name(), dltb_gd_area - xzdw_gd_area < 0.0 ? 0.0 : (dltb_gd_area - xzdw_gd_area) * 0.0015);
            result.put(JTag.BP_AREA.name(), this.getAreaByList(bpList, 0.0015));
            result.put(JTag.BP_GD_AREA.name(), this.getDouValueByField(bpList, "GD"));
            result.put(JTag.YG_AREA.name(), this.getAreaByList(gdList, 0.0015));
            result.put(JTag.WG_AREA.name(), geoArea - (Double)result.get(JTag.YG_AREA.name()) < 0.0 ? 0.0 : geoArea - (Double)result.get(JTag.YG_AREA.name()));
            result.put(JTag.WPYJ_AREA.name(), geoArea - (Double)result.get(JTag.BP_AREA.name()) < 0.0 ? 0.0 : geoArea - (Double)result.get(JTag.BP_AREA.name()));
            result.put(JTag.WPYJ_GD_AREA.name(), (Double)result.get(JTag.JC_GD_AREA.name()) - (Double)result.get(JTag.BP_GD_AREA.name()) < 0.0 ? 0.0 : (Double)result.get(JTag.JC_GD_AREA.name()) - (Double)result.get(JTag.BP_GD_AREA.name()));
            result.put(JTag.YXJSQ_AREA.name(), this.getAreaByField(jsydgzqList, "GZQLXDM", "010", 0.0015));
            result.put(JTag.JBNT_AREA.name(), this.getAreaByField(tdytqList, "TDYTQLXDM", "010", 0.0015));
            result.put(JTag.YBNTQ_AREA.name(), this.getAreaByField(tdytqList, "TDYTQLXDM", "020", 0.0015));
            result.put(JTag.PCMC.name(), this.getStrValueByField(bpList, "PCJC"));
            result.put(JTag.NZYPW.name(), this.getStrValueByField(bpList, "PZWH"));
            result.put(JTag.GDBH.name(), this.getStrValueByField(gdList, "XMBH"));
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry") || p.getName().getLocalPart().equals("crs")) continue;
                result.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public double getAreaByList(List<Map> list, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        for (Map map : list) {
            double value = (Double)map.get("SHAPE_AREA");
            area += value;
        }
        return area * conv;
    }

    public double getAreaByFeature(SimpleFeature feature, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        try {
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            CoordinateReferenceSystem targetCrs = this.geometryService.parseUndefineSR("2364");
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (sourceCRS != null && sourceCRS instanceof GeographicCRS) {
                geometry = this.geometryService.project((Geometry)feature.getDefaultGeometry(), sourceCRS, targetCrs);
            }
            area = this.isPolygon(geometry) ? geometry.getArea() : geometry.getLength();
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area * conv;
    }

    public double getAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        for (Map map : list) {
            if (!value.equals(map.get(field))) continue;
            area += ((Double)map.get("SHAPE_AREA")).doubleValue();
        }
        return area * conv;
    }

    public String getStrValueByField(List<Map> list, String field) {
        StringBuilder sb = new StringBuilder();
        assert (field != null);
        for (Map map : list) {
            if (!map.containsKey(field)) continue;
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            if (this.isNull(map.get(field))) continue;
            sb.append(map.get(field));
        }
        return sb.toString();
    }

    public double getDouValueByField(List<Map> list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Map map : list) {
            if (this.isNull(map.get(field))) continue;
            value += Double.valueOf(map.get(field).toString()).doubleValue();
        }
        return value;
    }

    public double getXzdwAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        for (Map map : list) {
            if (!value.equals(map.get(field)) || this.isNull(map.get("XZDWMJ"))) continue;
            area += Double.valueOf(map.get("XZDWMJ").toString()).doubleValue();
        }
        return area * conv;
    }

    private BufferedImage getExportImage(Envelope envelope, String url, String imageSize, double mapScale) {
        BufferedImage image = null;
        String bbox = "bbox=" + envelope.getMinX() + "," + envelope.getMinY() + "," + envelope.getMaxX() + "," + envelope.getMaxY();
        String size = "size=" + imageSize;
        StringBuilder exportUrl = new StringBuilder();
        exportUrl.append(url);
        exportUrl.append("/export?");
        exportUrl.append(bbox);
        exportUrl.append("&");
        exportUrl.append(size);
        exportUrl.append("&");
        exportUrl.append("&");
        if (mapScale > 0.0) {
            exportUrl.append("mapScale=" + mapScale);
        }
        exportUrl.append("&");
        exportUrl.append("transparent=true&");
        exportUrl.append("format=png&");
        exportUrl.append("f=image");
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(exportUrl.toString());
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(getMethod.getResponseBody());
            if (((InputStream)inputStream).available() > 0) {
                image = ImageIO.read(inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return image;
    }

    private double getTotalArea(JSONArray features) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private double getAreaByLxdm(String field, JSONArray features, String lxdm) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            if (property.get((Object)field) == null) {
                return 0.0;
            }
            if (!property.get((Object)field).equals(lxdm)) continue;
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private String getWhereClause(String[] fields, String keyword) {
        String or = " or ";
        StringBuilder b = new StringBuilder();
        for (String field : fields) {
            b.append(field);
            b.append(" like '");
            b.append(keyword);
            b.append("%'");
            b.append(or);
        }
        b.delete(b.length() - or.length(), b.length());
        return b.toString();
    }

    private Map<String, Object> geoJSON2Map(String geoJSON, CoordinateReferenceSystem targetCRS) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        Map<String, Object> columns = null;
        if (geo instanceof Geometry) {
            columns = new HashMap<String, Object>();
            columns.put("SHAPE", ((Geometry)geo).toText());
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            if (this.isNull((Object)sourceCRS)) {
                sourceCRS = this.geometryService.readFeatureJSONCRS(geoJSON);
            }
            columns = this.geometryService.simpleFeature2Map(feature);
            try {
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (targetCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, targetCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
                throw new RuntimeException(e.getLocalizedMessage());
            }
        } else {
            if (geo instanceof GeometryCollection) {
                throw new RuntimeException("current omp version don't support GeometryCollection ");
            }
            if (geo instanceof FeatureCollection) {
                throw new RuntimeException("current omp version don't support FeatureCollection ");
            }
            throw new RuntimeException(this.getMessage("geometry.undefined", new Object[0]));
        }
        return columns;
    }

    private Geometry setFeaturePros2Geo(SimpleFeature feature, Geometry geometry) {
        HashMap<String, Object> map = null;
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geo = geometry.getGeometryN(i);
                map = new HashMap();
                for (Property p : feature.getProperties()) {
                    if (p.getName().equals((Object)"geometry")) continue;
                    map.put(p.getName().getLocalPart(), p.getValue());
                }
                geo.setUserData(map);
            }
        } else {
            map = new HashMap<String, Object>();
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry")) continue;
                map.put(p.getName().getLocalPart(), p.getValue());
            }
            geometry.setUserData(map);
        }
        return geometry;
    }

    private List<?> addGeoProperty2List(List<Map<String, Object>> list, Geometry geometry) {
        if (geometry.getUserData() == null) {
            return list;
        }
        for (Map<String, Object> item : list) {
            Map pros = (Map)geometry.getUserData();
            for (Map.Entry entry : pros.entrySet()) {
                item.put("G_".concat((String)entry.getKey()), entry.getValue());
            }
        }
        return list;
    }

    private List<Map> getTdlyxzDictList(String tpl) {
        ArrayList<Map> groupList = new ArrayList<Map>();
        Configuration configuration = this.webMapService.getConfig(tpl);
        List dicts = configuration.getDicts();
        for (Dict dict : dicts) {
            if (!dict.getName().toString().equals("tdlyxz")) continue;
            List dictItems = dict.getDictItems();
            for (Item item : dictItems) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("dlbm", item.getName());
                temp.put("dlmc", item.getTitle());
                temp.put("area", 0);
                groupList.add(temp);
            }
        }
        if (groupList.size() == 0) {
            throw new RuntimeException(this.getMessage("get.dict.error", new Object[]{tpl}));
        }
        return groupList;
    }

    private boolean checkFieldInLayer(String field, String layerName, String dataSource) {
        return ArrayUtils.contains((String[])this.spatialDao.getLayerColumns(layerName, dataSource), (String)field, (boolean)true);
    }

    private boolean isPolygon(Geometry geometry) {
        String geometryType = geometry.getGeometryType();
        if (geometryType.equals(Geometries.POLYGON.getName()) || geometryType.equals(Geometries.MULTIPOLYGON.getName())) {
            return true;
        }
        if (geometryType.equals(Geometries.LINESTRING.getName()) || geometryType.equals(Geometries.MULTILINESTRING.getName())) {
            return false;
        }
        if (geometryType.equals(Geometries.GEOMETRYCOLLECTION.getName())) {
            return geometry.getArea() > 0.0;
        }
        return false;
    }
}

