/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service;

import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import com.esri.sde.sdk.client.SeLayer;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public interface GeometryService {
    public static final String EPSG = "EPSG";
    public static final String SHAPE = "SHAPE";
    public static final String GEOMETRY = "geometry";
    public static final String FEATURE_CRS = "crs";
    public static final String FEATURE = "feature";

    public Geometry readWKT(String var1) throws GeometryServiceException;

    public Geometry readGeoJSON(String var1) throws GeometryServiceException;

    public GeometryCollection readGeoCollectionJSON(String var1) throws GeometryServiceException;

    public SimpleFeature readFeatureJSON(String var1) throws GeometryServiceException;

    public FeatureCollection readFeatureCollectionJSON(String var1) throws GeometryServiceException;

    public Object readUnTypeGeoJSON(String var1) throws GeometryServiceException;

    public CoordinateReferenceSystem readFeatureJSONCRS(String var1);

    public Geometry project(Geometry var1, CoordinateReferenceSystem var2, CoordinateReferenceSystem var3) throws GeometryServiceException;

    public Object project(Object var1, CoordinateReferenceSystem var2, CoordinateReferenceSystem var3) throws GeometryServiceException;

    public Geometry projectByAGS(Geometry var1, CoordinateReferenceSystem var2, CoordinateReferenceSystem var3);

    public Geometry simplify(Geometry var1, double var2);

    public Geometry forceSimplify(Geometry var1, double var2);

    public Geometry densify(Geometry var1, double var2);

    public CoordinateReferenceSystem getCRSByWKTString(String var1);

    public CoordinateReferenceSystem getCRSByCommnonString(String var1);

    public CoordinateReferenceSystem getCRSBySRID(String var1);

    public CoordinateReferenceSystem getSeLayerCRS(SeLayer var1);

    public CoordinateReferenceSystem getLayerCRS(String var1, String var2);

    public SimpleFeatureType getFeatureType(Map<String, Object> var1);

    public SimpleFeature map2SimpleFeature(Map<String, Object> var1, CoordinateReferenceSystem var2, CoordinateReferenceSystem var3);

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> var1, CoordinateReferenceSystem var2, CoordinateReferenceSystem var3);

    public String toFeatureJSON(Object var1);

    public String toGeoJSON(Geometry var1);

    public Map<String, Object> simpleFeature2Map(SimpleFeature var1);

    public CoordinateReferenceSystem parseUndefineSR(String var1);

    public TopologyValidationError validGeometry(Geometry var1);

    public CoordinateReferenceSystem getCRSByRegionCode(String var1);

    public LayerRegion getLayerRegion(String var1);

    public boolean containsRegionValue(String var1);

    public double readGeometryAera(String var1);

    public double getSimplifyTolerance();

    public Map getBJCoordinates(InputStream var1) throws Exception;

    public String getExcelCoordinates(InputStream var1) throws Exception;

    public String getShpCoordinates(InputStream var1) throws Exception;

    public String getShpCoordinates(File var1) throws Exception;

    public String getShpCoordinates(File var1, String var2) throws Exception;

    public String getShpCoordinatesSingle(InputStream var1) throws Exception;

    public File exportToShp(String var1) throws Exception;

    public File exportToShp(String var1, String var2, String var3, String[] var4, String var5) throws Exception;

    public CoordinateReferenceSystem getCrsByCoordXD(double var1);

    public String renderAnalysisContent(Map var1, String var2);
}

