/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal2;

import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.model.Service;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.entity.FwqInfo;
import cn.gtmap.onemap.platform.entity.MetaData;
import cn.gtmap.onemap.platform.entity.TableSpaceInfo;
import cn.gtmap.onemap.platform.entity.YGJC;
import cn.gtmap.onemap.platform.entity.YSJ;
import cn.gtmap.onemap.platform.service.DbResService;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/portal2"})
public class RescenterController {
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private DbResService dbResService;
    private static String SERVER_DB = "\u6570\u636e\u5e93\u670d\u52a1\u5668";
    private static String SERVER_FILE = "\u6587\u4ef6\u670d\u52a1\u5668";
    private static String FILE_YX = "\u5f71\u50cf\u6570\u636e";
    private static String FILE_TILE = "\u5207\u7247\u6570\u636e";

    @RequestMapping(value={"/rescenter/{name}"})
    public String resCenter(@PathVariable(value="name") String name, Model model) throws Exception {
        List groups = this.metadataService.getChildrenMapGroups(null, true);
        ArrayList dbList = new ArrayList();
        List servers = this.dbResService.getFwqInfoAll();
        List serverTypes = this.dbResService.getFwqLx();
        for (String type : serverTypes) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            List fwqInfos = this.dbResService.getFwqInfoByLx(type);
            if (type.equals("0")) {
                map.put("name", SERVER_DB);
                map.put("type", type);
                map.put("id", "dbServer");
                ArrayList jjfalist = new ArrayList();
                for (FwqInfo fwqInfo : fwqInfos) {
                    List metaDatas = this.dbResService.getMetaDataByIpbm(fwqInfo.getId());
                    for (MetaData metaData : metaDatas) {
                        HashMap<String, Object> map1 = new HashMap<String, Object>();
                        String ywlx = metaData.getYwlx();
                        String ywlxmc = this.dbResService.getYwlxmc(ywlx);
                        map1.put("ywlx", ywlx);
                        map1.put("ywlxmc", ywlxmc);
                        map1.put("ipbm", fwqInfo.getId());
                        map1.put("parentId", "dbServer");
                        ArrayList<MetaData> list1 = new ArrayList<MetaData>();
                        list1.add(metaData);
                        map1.put("metadatas", list1);
                        if (this.dbResService.getDataIndex(ywlx, jjfalist) > -1) {
                            HashMap temp = (HashMap)jjfalist.get(this.dbResService.getDataIndex(ywlx, jjfalist));
                            List metadatas = (List)temp.get("metadatas");
                            metadatas.add(metaData);
                            Collections.sort(metadatas);
                            temp.put("metadatas", metadatas);
                            continue;
                        }
                        jjfalist.add(map1);
                    }
                }
                map.put("children", jjfalist);
            } else {
                map.put("name", SERVER_FILE);
                map.put("id", "fileServer");
                map.put("type", type);
                ArrayList fileList = new ArrayList();
                HashMap<String, Object> yxMap = new HashMap<String, Object>();
                HashMap<String, Object> tileMap = new HashMap<String, Object>();
                yxMap.put("type", FILE_YX);
                yxMap.put("id", "yxFile");
                yxMap.put("parentId", map.get("id"));
                tileMap.put("type", FILE_TILE);
                tileMap.put("id", "tileFile");
                tileMap.put("parentId", map.get("id"));
                for (FwqInfo fwqInfo : fwqInfos) {
                    List fileTypes = this.dbResService.getYgjcLxByFwqbm(fwqInfo.getId());
                    for (String fileType : fileTypes) {
                        HashMap map1;
                        List children;
                        List ygjcList = this.dbResService.getYgjcByLxAndFwqbm(fileType, fwqInfo.getId());
                        Collections.sort(ygjcList);
                        List ygjcNfs = this.dbResService.getYgjcNf(fileType, fwqInfo.getId());
                        ArrayList list = new ArrayList();
                        for (String nf : ygjcNfs) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("name", nf);
                            ArrayList<YGJC> temp = new ArrayList<YGJC>();
                            for (YGJC ygjc : ygjcList) {
                                if (!ygjc.getNf().equals(nf)) continue;
                                temp.add(ygjc);
                            }
                            hashMap.put("value", temp);
                            list.add(hashMap);
                        }
                        if (fileType.equals("0")) {
                            if (tileMap.containsKey("children")) {
                                children = (List)tileMap.get("children");
                                block7: for (int i = 0; i < list.size(); ++i) {
                                    HashMap hashMap = (HashMap)list.get(i);
                                    for (int j = 0; j < children.size(); ++j) {
                                        map1 = (HashMap)children.get(j);
                                        if (!map1.get("name").equals(hashMap.get("name"))) continue;
                                        children.add(hashMap);
                                        list.remove(hashMap);
                                        continue block7;
                                    }
                                }
                                for (Object e : list) {
                                    children.add(list.indexOf(e), e);
                                }
                                tileMap.put("children", children);
                                continue;
                            }
                            tileMap.put("children", list);
                            continue;
                        }
                        if (yxMap.containsKey("children")) {
                            children = (List)yxMap.get("children");
                            block10: for (int i = 0; i < list.size(); ++i) {
                                HashMap hashMap = (HashMap)list.get(i);
                                for (int j = 0; j < children.size(); ++j) {
                                    map1 = (HashMap)children.get(j);
                                    if (!map1.get("name").equals(hashMap.get("name"))) continue;
                                    children.add(hashMap);
                                    list.remove(hashMap);
                                    continue block10;
                                }
                            }
                            for (Object e : list) {
                                children.add(list.indexOf(e), e);
                            }
                            yxMap.put("children", children);
                            continue;
                        }
                        yxMap.put("children", list);
                    }
                }
                Collections.sort((List)tileMap.get("children"), new /* Unavailable Anonymous Inner Class!! */);
                Collections.sort((List)yxMap.get("children"), new /* Unavailable Anonymous Inner Class!! */);
                fileList.add(tileMap);
                fileList.add(yxMap);
                map.put("children", fileList);
            }
            dbList.add(map);
        }
        model.addAttribute("groups", (Object)groups);
        model.addAttribute("dbList", dbList);
        return "portal2/rescenter/" + name;
    }

    @RequestMapping(value={"/ajax/fetchMapGroup"})
    public String fetchMapGroup(@RequestParam(value="parentId") String parentId, MapQuery mapQuery, Model model, Pageable pagin) {
        mapQuery.setGroupId(parentId);
        Page page = this.metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin);
        List groups = this.metadataService.getChildrenMapGroups(parentId, true);
        model.addAttribute("groups", (Object)groups);
        model.addAttribute("page", (Object)page);
        return "portal2/rescenter/services_item";
    }

    @RequestMapping(value={"/ajax/fetchDbInfo/{fid}"})
    public String dbInfo(@PathVariable String fid, Model model) {
        return "portal2/rescenter/db_item";
    }

    @RequestMapping(value={"/ajax/fetchOverview/{type}"})
    public String overview(@PathVariable String type, Model model) {
        List capacity = this.dbResService.getDbCapacity();
        Object[] objects = (Object[])capacity.get(0);
        double zdx = Double.valueOf((String)objects[0]);
        model.addAttribute("dbZdx", (Object)zdx);
        model.addAttribute("dbYydx", (Object)Double.valueOf((String)objects[1]));
        model.addAttribute("dbSydx", (Object)Double.valueOf((String)objects[2]));
        model.addAttribute("yxdx", (Object)Double.valueOf(this.dbResService.getWjdxByLx("1")));
        model.addAttribute("qpdx", (Object)Double.valueOf(this.dbResService.getWjdxByLx("0")));
        if (type.indexOf("db") > -1) {
            HashMap<String, Object> map;
            List usernames = this.dbResService.getDbUsername();
            ArrayList dblist = new ArrayList();
            for (int i = 0; i < usernames.size(); ++i) {
                Object[] item = (Object[])usernames.get(i);
                String ywlx = this.dbResService.getYwlxByUsername(String.valueOf(item[0]));
                String yydx = this.dbResService.getCapacityByUserName(String.valueOf(item[0]));
                map = new HashMap<String, Object>();
                map.put("name", String.valueOf(item[0]));
                map.put("ywlx", ywlx);
                map.put("ywlxmc", this.dbResService.getYwlxmc(ywlx));
                map.put("yydx", Double.valueOf(yydx));
                dblist.add(map);
            }
            model.addAttribute("dbList", dblist);
            List tableSpaceInfoList = this.dbResService.getTableSpaceAll();
            ArrayList list = new ArrayList();
            for (TableSpaceInfo tableSpaceInfo : tableSpaceInfoList) {
                map = new HashMap();
                map.put("bkjmc", tableSpaceInfo.getBkjmc());
                map.put("bkjzdx", Double.valueOf(tableSpaceInfo.getBkjzdx()));
                map.put("bkjyydx", Double.valueOf(tableSpaceInfo.getBkjyydx()));
                map.put("bkjsydx", Double.valueOf(tableSpaceInfo.getBkjsydx()));
                map.put("bkjwjlj", tableSpaceInfo.getBkjwjlj());
                list.add(map);
            }
            model.addAttribute("tableData", list);
        } else if (type.indexOf("file") > -1) {
            double wjzdx = Double.valueOf(this.dbResService.getWjdxByLx("1")) + Double.valueOf(this.dbResService.getWjdxByLx("0"));
            model.addAttribute("wjzdx", (Object)wjzdx);
            List ygjcList = this.dbResService.getYgjcAll();
            Collections.sort(ygjcList);
            ArrayList list = new ArrayList();
            for (YGJC ygjc : ygjcList) {
                HashMap<String, Object> ygjcMap = new HashMap<String, Object>();
                boolean tag = false;
                String lx = ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                double sjdx = Double.valueOf(ygjc.getWjdx());
                String wz = this.dbResService.getIpdzByID(ygjc.getFwqbm());
                for (int i = 0; i < list.size(); ++i) {
                    HashMap map = (HashMap)list.get(i);
                    if (!map.get("lx").equals(lx) || !map.get("nf").equals(ygjc.getNf()) || !map.get("wz").equals(wz)) continue;
                    map.put("wjdx", Double.valueOf(map.get("wjdx").toString()) + sjdx);
                    tag = true;
                }
                if (tag) continue;
                ygjcMap.put("lx", lx);
                ygjcMap.put("nf", ygjc.getNf());
                ygjcMap.put("wjdx", sjdx);
                ygjcMap.put("wz", wz);
                list.add(ygjcMap);
            }
            model.addAttribute("tableData", list);
        } else if (type.indexOf("yzt") > -1) {
            HashMap map;
            int i;
            String wz;
            double sjdx;
            String lx;
            boolean tag;
            List jjfalist = this.dbResService.getMetaDataAll();
            List ygjcList = this.dbResService.getYgjcAll();
            Collections.sort(ygjcList);
            ArrayList yztList = new ArrayList();
            for (MetaData metaData : jjfalist) {
                HashMap<String, Object> jjfaMap = new HashMap<String, Object>();
                tag = false;
                lx = this.dbResService.getYwlxmc(metaData.getYwlx());
                sjdx = Double.valueOf(metaData.getBkjyydx());
                wz = this.dbResService.getIpdzByID(metaData.getIpbm());
                for (i = 0; i < yztList.size(); ++i) {
                    map = (HashMap)yztList.get(i);
                    if (!map.get("lx").equals(lx) || !map.get("nf").equals(metaData.getNd()) || !map.get("wz").equals(wz)) continue;
                    map.put("sjdx", Double.valueOf(map.get("sjdx").toString()) + sjdx);
                    tag = true;
                }
                if (tag) continue;
                jjfaMap.put("lx", lx);
                jjfaMap.put("nf", metaData.getNd());
                jjfaMap.put("sjdx", sjdx);
                jjfaMap.put("wz", wz);
                yztList.add(jjfaMap);
            }
            int dbSize = yztList.size();
            for (YGJC ygjc : ygjcList) {
                HashMap<String, Object> ygjcMap = new HashMap<String, Object>();
                tag = false;
                lx = ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                sjdx = Double.valueOf(ygjc.getWjdx());
                wz = this.dbResService.getIpdzByID(ygjc.getFwqbm());
                for (i = 0; i < yztList.size(); ++i) {
                    map = (HashMap)yztList.get(i);
                    if (!map.get("lx").equals(lx) || !map.get("nf").equals(ygjc.getNf()) || !map.get("wz").equals(wz)) continue;
                    map.put("sjdx", Double.valueOf(map.get("sjdx").toString()) + sjdx);
                    tag = true;
                }
                if (tag) continue;
                ygjcMap.put("lx", lx);
                ygjcMap.put("nf", ygjc.getNf());
                ygjcMap.put("sjdx", sjdx);
                ygjcMap.put("wz", wz);
                yztList.add(ygjcMap);
            }
            int fileSize = yztList.size() - dbSize;
            model.addAttribute("tableData", yztList);
            model.addAttribute("dbSize", (Object)(dbSize + 1));
            model.addAttribute("fileSize", (Object)fileSize);
        } else {
            String nf = type.split("_")[0];
            double wjzdx = Double.valueOf(this.dbResService.getWjdxBylxAndNf("1", nf)) + Double.valueOf(this.dbResService.getWjdxBylxAndNf("0", nf));
            model.addAttribute("wjzdx", (Object)wjzdx);
            model.addAttribute("ndyxdx", (Object)Double.valueOf(this.dbResService.getWjdxBylxAndNf("1", nf)));
            model.addAttribute("ndqpdx", (Object)Double.valueOf(this.dbResService.getWjdxBylxAndNf("0", nf)));
            model.addAttribute("nf", (Object)nf);
            ArrayList list = new ArrayList();
            List ygjcList = type.indexOf(FILE_YX) > -1 ? this.dbResService.getYgjcByNfAndLx(nf, "1") : this.dbResService.getYgjcByNfAndLx(nf, "0");
            for (YGJC ygjc : ygjcList) {
                HashMap<String, Object> ygjcMap = new HashMap<String, Object>();
                boolean tag = false;
                String lx = ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                double sjdx = Double.valueOf(ygjc.getWjdx());
                String wz = this.dbResService.getIpdzByID(ygjc.getFwqbm());
                for (int i = 0; i < list.size(); ++i) {
                    HashMap map = (HashMap)list.get(i);
                    if (!map.get("lx").equals(lx) || !map.get("nf").equals(ygjc.getNf()) || !map.get("wz").equals(wz)) continue;
                    map.put("wjdx", Double.valueOf(map.get("wjdx").toString()) + sjdx);
                    tag = true;
                }
                if (tag) continue;
                ygjcMap.put("lx", lx);
                ygjcMap.put("nf", ygjc.getNf());
                ygjcMap.put("wjdx", sjdx);
                ygjcMap.put("wz", wz);
                list.add(ygjcMap);
            }
            model.addAttribute("tableData", list);
        }
        model.addAttribute("type", (Object)type);
        return "portal2/rescenter/db_overview";
    }

    @RequestMapping(value={"/ajax/fetchDetail/{id}"})
    public String detail(@PathVariable String id, Model model) {
        MetaData metaData = this.dbResService.getMetaDataById(id);
        if (metaData != null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            long sum = this.dbResService.getSumByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            long xzqNum = this.dbResService.getXzqByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            List maps = this.dbResService.getSjzsByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            ArrayList<Object> xzdmList = new ArrayList<Object>();
            ArrayList<Integer> sjzsList = new ArrayList<Integer>();
            for (int i = 0; i < maps.size(); ++i) {
                Object[] obj = (Object[])maps.get(i);
                xzdmList.add(obj[0]);
                sjzsList.add(Integer.parseInt(obj[1].toString()));
            }
            String ywlxmc = this.dbResService.getYwlxmc(metaData.getYwlx());
            if (StringUtils.isNotBlank((String)ywlxmc)) {
                metaData.setYwlx(ywlxmc);
            }
            data.put("id", metaData.getId());
            data.put("nd", metaData.getNd());
            data.put("ywlx", metaData.getYwlx());
            data.put("bkjmc", metaData.getBkjmc());
            data.put("zt", metaData.getZt());
            data.put("bkjzdx", Double.valueOf(metaData.getBkjzdx()));
            data.put("bkjyydx", Double.valueOf(metaData.getBkjyydx()));
            data.put("bkjsydx", Double.valueOf(metaData.getBkjsydx()));
            data.put("bkjwjlj", metaData.getBkjwjlj());
            model.addAttribute("metaData", data);
            model.addAttribute("xzdm", (Object)JSON.toJSONString((Object)xzdmList.toArray()));
            model.addAttribute("sjzs", (Object)JSON.toJSONString((Object)sjzsList.toArray()));
            model.addAttribute("sum", (Object)sum);
            model.addAttribute("xzqNum", (Object)xzqNum);
        } else {
            model.addAttribute("metaData", null);
        }
        return "portal2/rescenter/db_detail";
    }

    @RequestMapping(value={"/metaInfo/{id}"})
    public String metaInfo(@PathVariable String id, Model model) {
        List ysjList = this.dbResService.getMetaInfo(id);
        MetaData dbMetaData = this.dbResService.getMetaDataById(id);
        if (ysjList != null && ysjList.size() > 0) {
            byte[] bytes = ((YSJ)ysjList.get(0)).getMeta();
            model.addAttribute("xml", (Object)new String(bytes, Charset.forName("gbk")));
            model.addAttribute("metaDataTitle", (Object)(dbMetaData.getUserName() + "_" + dbMetaData.getNd()));
        }
        return "portal2/rescenter/metadataInfo";
    }

    @RequestMapping(value={"/service/{id}"}, method={RequestMethod.GET})
    public String serviceView(@PathVariable String id, Model model) {
        String serviceUrl = "";
        String serviceType = "";
        model.addAttribute("id", (Object)id);
        model.addAttribute("map", (Object)this.metadataService.getMap(id));
        model.addAttribute("layers", (Object)this.metadataService.getLayers(id));
        Map types = this.metadataService.getServices(id);
        if (types != null) {
            if (types.containsKey(ServiceType.ARCGIS_TILE)) {
                Service service = (Service)types.get(ServiceType.ARCGIS_TILE);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_TILE.getValue();
            } else if (types.containsKey(ServiceType.ARCGIS_REST)) {
                Service service = (Service)types.get(ServiceType.ARCGIS_REST);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_REST.getValue();
            } else {
                Iterator i$ = types.keySet().iterator();
                if (i$.hasNext()) {
                    ServiceType temp = (ServiceType)i$.next();
                    serviceUrl = ((Service)types.get(temp)).getUrl();
                    serviceType = temp.getValue();
                }
            }
        }
        model.addAttribute("serviceUrl", (Object)serviceUrl);
        model.addAttribute("serviceType", (Object)serviceType);
        return "portal2/rescenter/service_overview";
    }
}

