/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal2;

import cn.gtmap.onemap.platform.service.TemplateService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/portal2"})
public class PagesController {
    @Autowired
    private TemplateService templateService;
    private String URL_PREFIX = "http://";

    @RequestMapping(value={""})
    public String page() {
        return "portal2/home";
    }

    @RequestMapping(value={"/api/{page}"})
    public String api(@PathVariable String page, @RequestParam(value="type", required=false) String type, Model model) {
        model.addAttribute("type", (Object)type);
        return "portal2/api/api_" + page;
    }

    @RequestMapping(value={"/onemap"})
    public String map() {
        return "portal2/map";
    }

    @RequestMapping(value={"/statistic"})
    public String statistic(Model model, HttpServletRequest request) {
        String content = this.templateService.getTemplate("statistic.json");
        HashMap nodesMap = (HashMap)JSON.parseObject((String)content, HashMap.class);
        List parentList = (List)nodesMap.get("nodes");
        ArrayList list = new ArrayList();
        for (int i = 0; i < parentList.size(); ++i) {
            JSONObject object = (JSONObject)parentList.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            String url = "";
            if (StringUtils.isNotBlank((String)object.get((Object)"url").toString())) {
                url = this.URL_PREFIX + request.getServerName() + ":" + request.getServerPort() + object.get((Object)"url");
            }
            map.put("id", object.get((Object)"id"));
            map.put("name", object.get((Object)"name"));
            map.put("url", url);
            map.put("children", this.getChildren(object, request));
            list.add(map);
        }
        model.addAttribute("nodes", list);
        return "portal2/statisReports";
    }

    @RequestMapping(value={"/forbidden"})
    public String unAuthorize() {
        return "portal2/forbidden";
    }

    private List getChildren(JSONObject parent, HttpServletRequest request) {
        ArrayList list = new ArrayList();
        List children = (List)parent.get((Object)"children");
        if (children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                JSONObject child = (JSONObject)children.get(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                String url = "";
                if (StringUtils.isNotBlank((String)child.get((Object)"url").toString())) {
                    url = this.URL_PREFIX + request.getServerName() + ":" + request.getServerPort() + child.get((Object)"url");
                }
                map.put("id", child.get((Object)"id"));
                map.put("name", child.get((Object)"name"));
                map.put("url", url);
                map.put("parentId", child.get((Object)"parentId"));
                map.put("children", this.getChildren(child, request));
                list.add(map);
            }
        }
        return list;
    }
}

