/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal;

import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/portal"})
public class ServicesController {
    @Autowired
    private MetadataService metadataService;

    @RequestMapping(value={"/maps"})
    public String serviceList(Pageable pagin, MapQuery mapQuery, Model model) throws Exception {
        model.addAttribute("page", (Object)this.metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin));
        List groups = this.metadataService.getChildrenMapGroups(null, true);
        model.addAttribute("groups", (Object)groups);
        model.addAttribute("omsurl", (Object)System.getProperty("oms.url"));
        return "portal/services/index";
    }

    @RequestMapping(value={"/ajax/fetchMapGroup"})
    public String fetchMapGroup(@RequestParam(value="parentId") String parentId, Model model) {
        List groups = this.metadataService.getChildrenMapGroups(parentId, true);
        model.addAttribute("groups", (Object)groups);
        return "portal/services/item";
    }

    @RequestMapping(value={"/ajax/fetchMaps"})
    public String fetchMapsByGroupId(MapQuery mapQuery, Model model, Pageable pagin) {
        mapQuery.setWithGroupChildren(false);
        model.addAttribute("page", (Object)this.metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin));
        if (mapQuery.getGroupId() != null) {
            model.addAttribute("group", (Object)this.metadataService.getMapGroup(mapQuery.getGroupId()));
        }
        return "portal/services/maps";
    }
}

