/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.ConfigService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.security.IdentityService;
import cn.gtmap.onemap.security.ex.SecurityException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/mobile"})
public class MobileController
extends BaseController {
    @Autowired
    private IdentityService identityService;
    @Autowired
    private WebMapService webMapService;
    @Autowired
    private ConfigService configService;

    @RequestMapping(value={"/login"})
    @ResponseBody
    public Map login(@RequestParam(value="username") String userName, @RequestParam(value="password") String passWord) {
        try {
            return this.result((Object)this.identityService.login(userName, passWord));
        }
        catch (SecurityException ex) {
            throw new JSONMessageException(this.getMessage("login.error.code." + ex.getCode(), new Object[]{userName}));
        }
        catch (Exception ex) {
            throw new JSONMessageException(this.getMessage("login.error", new Object[]{ex.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/logout"})
    @ResponseBody
    public Map logout(@RequestParam(value="token") String token) {
        try {
            this.identityService.logout(token);
            return this.result((Object)true);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("logout.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/map/tpls"})
    @ResponseBody
    public Map getMapTpls() {
        try {
            return this.result((Object)this.configService.getThumbTplInfos());
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.list.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/map/{tpl}/config"})
    @ResponseBody
    public Map getMapConfig(@PathVariable(value="tpl") String tplName) {
        try {
            return this.result((Object)this.webMapService.getConfig(tplName));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.config.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }
}

