package cn.gtmap.onemap.platform.utils;

/**
 * 枚举(土地规划分析)
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-08-09 下午2:15
 * @version: 1.0
 */
public final class EnumUtils {

    public  enum TDYTQ {

        基本农田保护区("010"),
        一般农地区("020"),
        城镇建设用地区("030"),
        村镇建设用地区("040"),
        独立工矿用地区("050"),
        风景旅游用地区("060"),
        生态环境安全控制区("070"),
        自然与文化遗产保护区("080"),
        林业用地区("090"),
        牧业用地区("100"),
        其他用地区("990");

        private String lxdm;

        private TDYTQ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum JSYDGZQ {

        允许建设用地区("010"),
        有条件建设用地区("020"),
        限制建设用地区("030"),
        禁止建设用地区("040");

        private String lxdm;

        private JSYDGZQ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum GHJBNTTZ {

        保留基本农田("00"),
        调入基本农田("01"),
        调出基本农田("02");

        private String lxdm;

        private GHJBNTTZ(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }

    public enum MZZDJSXM {

        能源("01"),
        交通("02"),
        水利("03"),
        电力("04"),
        环保("05"),
        其他("99");

        private String lxdm;

        private MZZDJSXM(String value) {
            this.lxdm = value;
        }

        public String getLxdm() {
            return lxdm;
        }
    }
}
