package cn.gtmap.onemap.platform.utils;

import org.apache.commons.lang.StringUtils;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-12-20 下午5:48
 */
public final class ArrayUtils {

    /**
     * 判断当前数组是否为空
     *
     * @param values
     * @return
     */
    public static final boolean empty(String[] values) {
        if (values == null) return true;
        for (String value : values) {
            if (StringUtils.isNotBlank(value)) return false;
        }
        return true;
    }

    /**
     * 查看数组中是否包含目标字符串
     *
     * @param src
     * @param des
     * @param ignoreCase
     * @return
     */
    public static final boolean contains(String[] src, String des, boolean ignoreCase) {
        for (String item : src) {
            if (StringUtils.isNotBlank(item) && StringUtils.isNotBlank(des)) {
                if (ignoreCase) if (item.equalsIgnoreCase(des)) return true;
                else if (item.equals(des)) return true;
            }
        }
        return false;
    }

    /**
     * 向目标数组中拷贝新数据
     *
     * @param des
     * @param src
     * @return
     */
    public static final String[] add2Arrays(String[] des, String src) {
        if (des == null) return new String[]{src};
        String[] tmp = new String[des.length + 1];
        System.arraycopy(des, 0, tmp, 0, des.length);
        tmp[des.length] = src;
        return tmp;
    }

    /**
     * 向目标数组中拷贝新数组
     *
     * @param des
     * @param src
     * @return
     */
    public static final String[] add2Arrays(String[] des, String[] src) {
        if (des == null) return src;
        if (src == null) return des;
        String[] tmp = new String[des.length + src.length];
        System.arraycopy(src, 0, tmp, 0, src.length);
        System.arraycopy(des, 0, tmp, src.length, des.length);
        return tmp;
    }

}
