package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.service.QueryService;
import cn.gtmap.onemap.platform.utils.HttpRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 13-4-19
 * Time: 下午2:27
 * To change this template use File | Settings | File Templates.
 */
@Service
public class QueryServiceImpl implements QueryService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    private String URL_PREFIX = "http://";

    /**
     * ArcGIS Server 的方式查询
     *
     * @param url
     * @param postString
     * @return
     */
    public String executeAgsQuery(String url, String postString,HttpServletRequest request) {
        try {
            if (!StringUtils.startsWith(url, URL_PREFIX))
                url = URL_PREFIX + request.getServerName() + ":" + request.getServerPort() + url;
            return HttpRequest.sendRequest2(url, postString);
        } catch (Exception e) {
            logger.error("ArcGIS Server 查询异常[{}]", e.getLocalizedMessage());
            return e.getLocalizedMessage();
        }
    }

    /**
     * GTMap server 方式查询
     *
     * @param url
     * @param postString
     * @return
     */
    public String executeGtMapQuery(String url, String postString) {
        return null;
    }


}
