package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import com.esri.core.geometry.*;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

import java.io.*;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * 基于ESRI Geometry Api的Geometry Service
 * Created by shenjian on 2014-05-20.
 */
@Service
public class AgsGeometryServiceImpl implements AgsGeoemtryService {
    @Override
    public String intersection(String inputGeometry, String intersector, String sr) {
        Geometry tmpGeo1 = GeometryEngine.geometryFromWkt(inputGeometry, WktImportFlags.wktImportDefaults, Geometry.Type.Unknown);
        Geometry tmpGeo2 = GeometryEngine.geometryFromWkt(intersector,WktImportFlags.wktImportDefaults,Geometry.Type.Unknown);
        SpatialReference spatialReference = SpatialReference.create(sr);

        OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
        OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
        if(!operatorSimplify.isSimpleAsFeature(tmpGeo1,spatialReference,null));
            tmpGeo1 = GeometryEngine.simplify(tmpGeo1,spatialReference);
        if(!operatorSimplify.isSimpleAsFeature(tmpGeo2,spatialReference,null))
            tmpGeo2 = GeometryEngine.simplify(tmpGeo2,spatialReference);
        Geometry resultGeoemtry = GeometryEngine.intersect(tmpGeo1,tmpGeo2,spatialReference);
        return resultGeoemtry!=null?GeometryEngine.geometryToWkt(resultGeoemtry,WktExportFlags.wktExportDefaults):"";
    }

    @Override
    public Double getGeometryArea(String wkt) {
        Geometry geometry = GeometryEngine.geometryFromWkt(wkt,WktImportFlags.wktImportDefaults,Geometry.Type.Unknown);
        if(geometry!=null){
            if(geometry.getType().compareTo(Geometry.Type.Polygon)==0){
                return geometry.calculateArea2D();
            }else{
                return geometry.calculateLength2D();
            }
        }
        return 0.0;
    }

    /**
     * 验证图形是否有效
     * @param wktGeometry
     * @param sr  wkt的crs
     * @return
     */
    public boolean validGeometry(String wktGeometry,String sr){
        try {
            Geometry geo =  GeometryEngine.geometryFromWkt(wktGeometry,WktImportFlags.wktImportDefaults, Geometry.Type.Unknown);
            OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
            OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
            return operatorSimplify.isSimpleAsFeature(geo,SpatialReference.create(sr),null);
        } catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /**
     *
     * @param shpFile
     * @return
     */
    public String importShape(File shpFile){

        FileInputStream fileInputStream = null;
        ByteBuffer shapeBuffer = null;
        OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
        OperatorExportToGeoJson operatorExportToGeoJson = (OperatorExportToGeoJson) factory.getOperator(Operator.Type.ExportToGeoJson);
        try {
            fileInputStream = new FileInputStream(shpFile);
            byte[] bytes  =   IOUtils.toByteArray(shpFile.toURI());
            OperatorImportFromESRIShape operatorImportFromESRIShape = (OperatorImportFromESRIShape) factory.getOperator(Operator.Type.ImportFromESRIShape);
            Geometry geometry= operatorImportFromESRIShape.execute(ShapeImportFlags.ShapeImportDefaults,Geometry.Type.Unknown,ByteBuffer.wrap(bytes).order(
                    ByteOrder.BIG_ENDIAN));
            return geometry==null?null:operatorExportToGeoJson.execute(geometry);
        }
        catch (FileNotFoundException e) {
           throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        } catch (Exception e){
           throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}
