package cn.gtmap.onemap.platform.service;

import cn.gtmap.onemap.platform.entity.BMark;

import java.io.InputStream;
import java.util.List;

/**
 * .界址点导入/勘测定界
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-8-13 上午10:08
 */
public interface BMarkService {

    enum Type {
        xls, xlsx, txt;

        public static Type getType(String value) {
            for (Type type : Type.values()) {
                if (type.name().equals(value)) return type;
            }
            return null;
        }
    }

    /**
     * get all
     *
     * @return
     */
    List<BMark> findAll();

    /**
     * find one
     *
     * @param id
     * @return
     */
    BMark find(String id);

    /**
     * insert
     *
     * @param bMark
     * @return
     */
    BMark insert(BMark bMark);

    /**
     * insert bMarks
     *
     * @param bMarks
     * @return
     */
    List<BMark> insert(List<BMark> bMarks);

    /**
     * 界址点导入
     *
     * @param id
     * @param coords
     * @param type
     * @return
     */
    boolean insert(String id, List coords, String type);

    /**
     * 根据文件流获取 坐标
     *
     * @param inputStream
     * @param type
     * @return
     */
    List getCoordsByFile(InputStream inputStream, Type type);

    /**
     * 关键字快速查找
     *
     * @param key
     * @return
     */
    List query(String key, String type);


}
