package cn.gtmap.onemap.platform.entity;

import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.utils.UUIDGenerator;

import java.util.ArrayList;
import java.util.List;

/**
 * . 配置
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-10-27 下午3:41
 */
public final class Configuration {

    private String name;
    private boolean logoVisible; //logo可见性
    private boolean coordinateVisible;  //坐标可见性
    private String title;
    private String logo;
    private GeometryService geometryService;
    private Map map;
    private List<Widget> widgets;
    private WidgetContainer widgetContainer;
    private List<Dict> dicts;

    private String defaultYear;

    private PrintService printService;

    private String defaultRegionCode;

    private String createAt;

    private String description;

    private String thematicMap;



    @Deprecated
    private String typeId;


    public String getThematicMap() {
        return thematicMap;
    }

    public void setThematicMap(String thematicMap) {
        this.thematicMap = thematicMap;
    }

    public String getTypeId() {
        return typeId;
    }
    /**
     * no longer used
     *
     * @param typeId
     */
    @Deprecated
    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public GeometryService getGeometryService() {
        return geometryService;
    }

    public void setGeometryService(GeometryService geometryService) {
        this.geometryService = geometryService;
    }

    public PrintService getPrintService() {
        return printService;
    }

    public void setPrintService(PrintService printService) {
        this.printService = printService;
    }

    public boolean isLogoVisible() {
        return logoVisible;
    }

    public void setLogoVisible(boolean logoVisible) {
        this.logoVisible = logoVisible;
    }

    public boolean isCoordinateVisible() {
        return coordinateVisible;
    }

    public void setCoordinateVisible(boolean coordinateVisible) {
        this.coordinateVisible = coordinateVisible;
    }

    public String getDefaultYear() {
        return defaultYear;
    }

    public void setDefaultYear(String defaultYear) {
        this.defaultYear = defaultYear;
    }

    public Map getMap() {
        return map;
    }

    public void setMap(Map map) {
        this.map = map;
    }

    public List<Widget> getWidgets() {
        return widgets;
    }

    public void setWidgets(List<Widget> widgets) {
        this.widgets = widgets;
    }

    public WidgetContainer getWidgetContainer() {
        return widgetContainer;
    }

    public void setWidgetContainer(WidgetContainer widgetContainer) {
        this.widgetContainer = widgetContainer;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreateAt() {
        return createAt;
    }

    public void setCreateAt(String createAt) {
        this.createAt = createAt;
    }

    public List<Dict> getDicts() {
        return dicts;
    }

    public String getDefaultRegionCode() {
        return defaultRegionCode;
    }

    public void setDefaultRegionCode(String defaultRegionCode) {
        this.defaultRegionCode = defaultRegionCode;
    }

    public void setDicts(List<Dict> dicts) {
        this.dicts = dicts;
    }

    public static final class Map {

        private java.util.Map initExtent;
        private List<Object> lods;
        private List<Service> baseLayers;
        private List<Service> operationalLayers;
        private double defaultScale;

        public Map() {
            baseLayers = new ArrayList<Service>();
            operationalLayers = new ArrayList<Service>();
        }

        public List<Service> getBaseLayers() {
            return baseLayers;
        }

        public void setBaseLayers(List<Service> baseLayers) {
            this.baseLayers = baseLayers;
        }

        public List<Service> getOperationalLayers() {
            return operationalLayers;
        }

        public void setOperationalLayers(List<Service> operationalLayers) {
            this.operationalLayers = operationalLayers;
        }

        public List<Object> getLods() {
            return lods;
        }

        public void setLods(List<Object> lods) {
            this.lods = lods;
        }

        public java.util.Map getInitExtent() {
            return initExtent;
        }

        public void setInitExtent(java.util.Map initExtent) {
            this.initExtent = initExtent;
        }
        public double getDefaultScale() {
            return defaultScale;
        }

        public void setDefaultScale(double defaultScale) {
            this.defaultScale = defaultScale;
        }

    }

    public static final class PrintService {

        private String url;
        private String title;
        private String author;
        private String copyright;

        public PrintService() {
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAuthor() {
            return author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getCopyright() {
            return copyright;
        }

        public void setCopyright(String copyright) {
            this.copyright = copyright;
        }
    }

    public static final class GeometryService {
        private String url;

        public GeometryService() {
        }

        public GeometryService(String url) {
            this.url = url;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static final class Widget implements Comparable<Widget> {
        private String id;
        private String label;
        private String icon;
        private String url;
        private String left;
        private String top;
        private String right;
        private String bottom;

        private String group;
        private boolean open;

        private java.util.Map config;

        private String desc;

        private int weight;



        public Widget() {
//            this.id = UUIDGenerator.generate();
        }

        public Widget(String id, String label, String url) {
            this.id = id;
            this.label = label;
            this.url = url;
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getIcon() {
            return icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLeft() {
            return left;
        }

        public void setLeft(String left) {
            this.left = left;
        }

        public String getTop() {
            return top;
        }

        public void setTop(String top) {
            this.top = top;
        }

        public String getRight() {
            return right;
        }

        public void setRight(String right) {
            this.right = right;
        }

        public String getBottom() {
            return bottom;
        }

        public void setBottom(String bottom) {
            this.bottom = bottom;
        }

        public String getGroup() {
            return group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public boolean isOpen() {
            return open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public java.util.Map getConfig() {
            return config;
        }

        public void setConfig(java.util.Map config) {
            this.config = config;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public int getWeight() {
            return weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        /**
         * Compares this object with the specified object for order.  Returns a
         * negative integer, zero, or a positive integer as this object is less
         * than, equal to, or greater than the specified object.
         * <p/>
         * <p>The implementor must ensure <tt>sgn(x.compareTo(y)) ==
         * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
         * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
         * <tt>y.compareTo(x)</tt> throws an exception.)
         * <p/>
         * <p>The implementor must also ensure that the relation is transitive:
         * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
         * <tt>x.compareTo(z)&gt;0</tt>.
         * <p/>
         * <p>Finally, the implementor must ensure that <tt>x.compareTo(y)==0</tt>
         * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
         * all <tt>z</tt>.
         * <p/>
         * <p>It is strongly recommended, but <i>not</i> strictly required that
         * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
         * class that implements the <tt>Comparable</tt> interface and violates
         * this condition should clearly indicate this fact.  The recommended
         * language is "Note: this class has a natural ordering that is
         * inconsistent with equals."
         * <p/>
         * <p>In the foregoing description, the notation
         * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
         * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
         * <tt>0</tt>, or <tt>1</tt> according to whether the value of
         * <i>expression</i> is negative, zero or positive.
         *
         * @param o the object to be compared.
         * @return a negative integer, zero, or a positive integer as this object
         *         is less than, equal to, or greater than the specified object.
         * @throws ClassCastException if the specified object's type prevents it
         *                            from being compared to this object.
         */
        @Override
        public int compareTo(Widget o) {
            return this.getWeight() - o.getWeight();
        }
    }

    public static final class WidgetContainer {
        private List<Widget> widgets;
        private List<WidgetsGroup> widgetsGroup;

        public List<Widget> getWidgets() {
            return widgets;
        }

        public void setWidgets(List<Widget> widgets) {
            this.widgets = widgets;
        }

        public List<WidgetsGroup> getWidgetsGroup() {
            return widgetsGroup;
        }

        public void setWidgetsGroup(List<WidgetsGroup> widgetsGroup) {
            this.widgetsGroup = widgetsGroup;
        }
    }

    public static final class WidgetsGroup implements Comparable<WidgetsGroup> {
        private String id;
        private String label;
        private String icon;
        private int type;
        private String url;
        private List<Widget> widgets;
        private int weight;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getIcon() {
            return icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public List<Widget> getWidgets() {
            return widgets;
        }

        public void setWidgets(List<Widget> widgets) {
            this.widgets = widgets;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public int getWeight() {
            return weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        /**
         * Compares this object with the specified object for order.  Returns a
         * negative integer, zero, or a positive integer as this object is less
         * than, equal to, or greater than the specified object.
         * <p/>
         * <p>The implementor must ensure <tt>sgn(x.compareTo(y)) ==
         * -sgn(y.compareTo(x))</tt> for all <tt>x</tt> and <tt>y</tt>.  (This
         * implies that <tt>x.compareTo(y)</tt> must throw an exception iff
         * <tt>y.compareTo(x)</tt> throws an exception.)
         * <p/>
         * <p>The implementor must also ensure that the relation is transitive:
         * <tt>(x.compareTo(y)&gt;0 &amp;&amp; y.compareTo(z)&gt;0)</tt> implies
         * <tt>x.compareTo(z)&gt;0</tt>.
         * <p/>
         * <p>Finally, the implementor must ensure that <tt>x.compareTo(y)==0</tt>
         * implies that <tt>sgn(x.compareTo(z)) == sgn(y.compareTo(z))</tt>, for
         * all <tt>z</tt>.
         * <p/>
         * <p>It is strongly recommended, but <i>not</i> strictly required that
         * <tt>(x.compareTo(y)==0) == (x.equals(y))</tt>.  Generally speaking, any
         * class that implements the <tt>Comparable</tt> interface and violates
         * this condition should clearly indicate this fact.  The recommended
         * language is "Note: this class has a natural ordering that is
         * inconsistent with equals."
         * <p/>
         * <p>In the foregoing description, the notation
         * <tt>sgn(</tt><i>expression</i><tt>)</tt> designates the mathematical
         * <i>signum</i> function, which is defined to return one of <tt>-1</tt>,
         * <tt>0</tt>, or <tt>1</tt> according to whether the value of
         * <i>expression</i> is negative, zero or positive.
         *
         * @param o the object to be compared.
         * @return a negative integer, zero, or a positive integer as this object
         *         is less than, equal to, or greater than the specified object.
         * @throws ClassCastException if the specified object's type prevents it
         *                            from being compared to this object.
         */
        @Override
        public int compareTo(WidgetsGroup o) {
            return this.getWeight() - o.getWeight();
        }
    }


}
