/*
 * Project:  onemap
 * Module:   onemap-platform
 * File:     ResCenterController.java
 * Modifier: Ray Zhang
 * Modified: 2013-7-22 下午6:37:14
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package cn.gtmap.onemap.platform.controller.portal2;


import java.nio.charset.Charset;
import java.util.*;

import cn.gtmap.onemap.platform.entity.*;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.model.Service;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.service.DbResService;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;

import com.alibaba.fastjson.JSON;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:rayzy1991@163.com">zhangyang</a>
 * @version V1.0, 2013-7-22 下午6:37:14
 */
@Controller
@RequestMapping("/portal2")
public class RescenterController {

    @Autowired
    private MetadataService metadataService;

    @Autowired
    private DbResService dbResService;

    private static String SERVER_DB = "数据库服务器";

    private static String SERVER_FILE = "文件服务器";

    private static String FILE_YX = "影像数据";

    private static String FILE_TILE = "切片数据";

    /**
     * 资源中心页面
     *
     * @param name
     * @return
     */
    @RequestMapping("/rescenter/{name}")
    public String resCenter(@PathVariable("name") String name, Model model) throws Exception {
        List<MapGroup> groups = metadataService.getChildrenMapGroups(null, true);
        List<HashMap> dbList = new ArrayList<HashMap>();
        List<FwqInfo> servers = dbResService.getFwqInfoAll();
        List<String> serverTypes = dbResService.getFwqLx();

        for (String type : serverTypes) {
            HashMap map = new HashMap();
            List<FwqInfo> fwqInfos = dbResService.getFwqInfoByLx(type);
            if (type.equals("0")) {
                map.put("name", SERVER_DB);
                map.put("type", type);
                map.put("id", "dbServer");
                List<HashMap> jjfalist = new ArrayList<HashMap>();
                for (FwqInfo fwqInfo : fwqInfos) {
                    List<MetaData> metaDatas = dbResService.getMetaDataByIpbm(fwqInfo.getId());
                    for (MetaData metaData : metaDatas) {
                        HashMap map1 = new HashMap();
                        String ywlx = metaData.getYwlx();
                        String ywlxmc = dbResService.getYwlxmc(ywlx);
                        map1.put("ywlx", ywlx);
                        map1.put("ywlxmc", ywlxmc);
                        map1.put("ipbm", fwqInfo.getId());
                        map1.put("parentId", "dbServer");
                        List<MetaData> list1 = new ArrayList<MetaData>();
                        list1.add(metaData);
                        map1.put("metadatas", list1);
                        if (dbResService.getDataIndex(ywlx, jjfalist) > -1) {
                            HashMap temp = jjfalist.get(dbResService.getDataIndex(ywlx, jjfalist));
                            List<MetaData> metadatas = (List<MetaData>) temp.get("metadatas");
                            metadatas.add(metaData);
                            Collections.sort(metadatas);
                            temp.put("metadatas", metadatas);

                        } else {
                            jjfalist.add(map1);
                        }

                    }
                }
                map.put("children", jjfalist);
            } else {
                map.put("name", SERVER_FILE);
                map.put("id", "fileServer");
                map.put("type", type);
                List<HashMap> fileList = new ArrayList<HashMap>();
                HashMap yxMap = new HashMap();
                HashMap tileMap = new HashMap();
                yxMap.put("type", FILE_YX);
                yxMap.put("id", "yxFile");
                yxMap.put("parentId", map.get("id"));
                tileMap.put("type", FILE_TILE);
                tileMap.put("id", "tileFile");
                tileMap.put("parentId", map.get("id"));
                for (FwqInfo fwqInfo : fwqInfos) {
                    List<String> fileTypes = dbResService.getYgjcLxByFwqbm(fwqInfo.getId());
                    for (String fileType : fileTypes) {
                        List<YGJC> ygjcList = dbResService.getYgjcByLxAndFwqbm(fileType, fwqInfo.getId());
                        Collections.sort(ygjcList);
                        List<String> ygjcNfs = dbResService.getYgjcNf(fileType, fwqInfo.getId());
                        List list = new ArrayList();
                        for (String nf : ygjcNfs) {
                            HashMap nfMap = new HashMap();
                            nfMap.put("name", nf);
                            List<YGJC> temp = new ArrayList<YGJC>();
                            for (YGJC ygjc : ygjcList) {
                                if (ygjc.getNf().equals(nf)) {
                                    temp.add(ygjc);
                                }
                            }
                            nfMap.put("value", temp);
                            list.add(nfMap);
                        }
                        if (fileType.equals("0")) {
                            if (tileMap.containsKey("children")) {
                                List children = (List) tileMap.get("children");
                                for (int i = 0; i < list.size(); i++) {
                                    HashMap hashMap = (HashMap) list.get(i);
                                    for (int j = 0; j < children.size(); j++) {
                                        HashMap map1 = (HashMap) children.get(j);
                                        if (map1.get("name").equals(hashMap.get("name"))) {
                                            children.add(hashMap);
                                            list.remove(hashMap);
                                            break;
                                        }
                                    }
                                }
                                for (Object obj : list) {
                                    children.add(list.indexOf(obj), obj);
                                }
                                tileMap.put("children", children);
                            } else
                                tileMap.put("children", list);

                        } else {
                            if (yxMap.containsKey("children")) {
                                List children = (List) yxMap.get("children");
                                for (int i = 0; i < list.size(); i++) {
                                    HashMap hashMap = (HashMap) list.get(i);
                                    for (int j = 0; j < children.size(); j++) {
                                        HashMap map1 = (HashMap) children.get(j);
                                        if (map1.get("name").equals(hashMap.get("name"))) {
                                            children.add(hashMap);
                                            list.remove(hashMap);
                                            break;
                                        }
                                    }
                                }
                                for (Object obj : list) {
                                    children.add(list.indexOf(obj), obj);
                                }
                                yxMap.put("children", children);
                            } else
                                yxMap.put("children", list);
                        }

                    }
                }
                Collections.sort((List<HashMap>) tileMap.get("children"),new Comparator<HashMap>(){
                    public int compare(HashMap arg0, HashMap arg1) {
                        return Integer.valueOf(arg0.get("name").toString()).compareTo(Integer.valueOf(arg1.get("name").toString()));
                    }
                });
                Collections.sort((List<HashMap>) yxMap.get("children"),new Comparator<HashMap>(){
                    public int compare(HashMap arg0, HashMap arg1) {
                        return Integer.valueOf(arg0.get("name").toString()).compareTo(Integer.valueOf(arg1.get("name").toString()));
                    }
                });
                fileList.add(tileMap);
                fileList.add(yxMap);
                map.put("children", fileList);

            }
            dbList.add(map);

        }
        model.addAttribute("groups", groups);
        model.addAttribute("dbList", dbList);

        return "portal2/rescenter/" + name;
    }

    /**
     * 获取服务组的信息
     *
     * @param parentId
     * @param mapQuery
     * @param model
     * @param pagin
     * @return
     */
    @RequestMapping(value = "/ajax/fetchMapGroup")
    public String fetchMapGroup(@RequestParam("parentId") String parentId
            , MapQuery mapQuery
            , Model model
            , Pageable pagin) {
        mapQuery.setGroupId(parentId);
        Page<Map> page = metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin);
        List<MapGroup> groups = metadataService.getChildrenMapGroups(parentId, true);
        model.addAttribute("groups", groups);
        model.addAttribute("page", page);
        return "portal2/rescenter/services_item";
    }

    /**
     * 获取数据库实例以及其解决方案信息
     *
     * @param fid
     * @param model
     * @return
     */
    @RequestMapping(value = "/ajax/fetchDbInfo/{fid}")
    public String dbInfo(@PathVariable String fid, Model model) {

        return "portal2/rescenter/db_item";

    }

    /**
     * @param model
     * @return
     */
    @RequestMapping(value = "/ajax/fetchOverview/{type}")
    public String overview(@PathVariable String type, Model model) {

        List<Object> capacity = dbResService.getDbCapacity();
        Object[] objects = (Object[]) capacity.get(0);
        double zdx = Double.valueOf((String) objects[0]);
        model.addAttribute("dbZdx", zdx);
        model.addAttribute("dbYydx", Double.valueOf((String) objects[1]));
        model.addAttribute("dbSydx", Double.valueOf((String) objects[2]));
        model.addAttribute("yxdx", Double.valueOf(dbResService.getWjdxByLx("1")));
        model.addAttribute("qpdx", Double.valueOf(dbResService.getWjdxByLx("0")));

        if (type.indexOf("db") > -1) {

            List<Object> usernames = dbResService.getDbUsername();
            List dblist = new ArrayList();
            for (int i=0;i<usernames.size();i++) {
                Object[] item = (Object[]) usernames.get(i);
                String ywlx = dbResService.getYwlxByUsername(String.valueOf(item[0]));
                String yydx = dbResService.getCapacityByUserName(String.valueOf(item[0]));
                HashMap map = new HashMap();
                map.put("name", String.valueOf(item[0]));
                map.put("ywlx", ywlx);
                map.put("ywlxmc", dbResService.getYwlxmc(ywlx));
                map.put("yydx", Double.valueOf(yydx));
                dblist.add(map);
            }
            model.addAttribute("dbList", dblist);
            List<TableSpaceInfo> tableSpaceInfoList = dbResService.getTableSpaceAll();
            List list = new ArrayList();
            for (TableSpaceInfo tableSpaceInfo : tableSpaceInfoList) {
                HashMap map = new HashMap();
                map.put("bkjmc", tableSpaceInfo.getBkjmc());
                map.put("bkjzdx", Double.valueOf(tableSpaceInfo.getBkjzdx()));
                map.put("bkjyydx", Double.valueOf(tableSpaceInfo.getBkjyydx()));
                map.put("bkjsydx", Double.valueOf(tableSpaceInfo.getBkjsydx()));
                map.put("bkjwjlj", tableSpaceInfo.getBkjwjlj());
                list.add(map);

            }
            model.addAttribute("tableData", list);

        } else if (type.indexOf("file") > -1) {

            double wjzdx = Double.valueOf(dbResService.getWjdxByLx("1")) + Double.valueOf(dbResService.getWjdxByLx("0"));
            model.addAttribute("wjzdx", wjzdx);
            List<YGJC> ygjcList = dbResService.getYgjcAll();
            Collections.sort(ygjcList);
            List list = new ArrayList();
            for (YGJC ygjc : ygjcList) {
                HashMap ygjcMap = new HashMap();
                int tag=0;
                String lx= ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                double sjdx = Double.valueOf(ygjc.getWjdx());
                String wz=dbResService.getIpdzByID(ygjc.getFwqbm());
                for(int i=0;i<list.size();i++){
                    HashMap map = (HashMap) list.get(i);
                    if(map.get("lx").equals(lx)&&map.get("nf").equals(ygjc.getNf())&&map.get("wz").equals(wz))
                    {
                        map.put("wjdx",Double.valueOf(map.get("wjdx").toString())+sjdx);
                        tag=1;
                    }
                }
                if(tag==0)
                {
                    ygjcMap.put("lx",lx);
                    ygjcMap.put("nf", ygjc.getNf());
                    ygjcMap.put("wjdx",sjdx);
                    ygjcMap.put("wz", wz);
                    list.add(ygjcMap);
                }
            }
            model.addAttribute("tableData", list);

        } else if (type.indexOf("yzt") > -1) {
            List<MetaData> jjfalist = dbResService.getMetaDataAll();
            List<YGJC> ygjcList = dbResService.getYgjcAll();
            Collections.sort(ygjcList);
            List yztList = new ArrayList();
            int dbSize;
            int fileSize;
            for (MetaData metaData : jjfalist) {
                HashMap jjfaMap = new HashMap();
                int tag=0;
                String lx = dbResService.getYwlxmc(metaData.getYwlx());
                double sjdx = Double.valueOf(metaData.getBkjyydx());
                String wz = dbResService.getIpdzByID(metaData.getIpbm());
                for(int i=0;i<yztList.size();i++){
                    HashMap map = (HashMap) yztList.get(i);
                    if(map.get("lx").equals(lx)&&map.get("nf").equals(metaData.getNd())&&map.get("wz").equals(wz))
                    {
                        map.put("sjdx",Double.valueOf(map.get("sjdx").toString())+sjdx);
                        tag=1;
                    }
                }
                if(tag==0)
                {
                    jjfaMap.put("lx", lx);
                    jjfaMap.put("nf", metaData.getNd());
                    jjfaMap.put("sjdx", sjdx);
                    jjfaMap.put("wz", wz);
                    yztList.add(jjfaMap);
                }
            }
            dbSize = yztList.size();
            for (YGJC ygjc : ygjcList) {
                HashMap ygjcMap = new HashMap();
                int tag=0;
                String lx= ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                double sjdx = Double.valueOf(ygjc.getWjdx());
                String wz=dbResService.getIpdzByID(ygjc.getFwqbm());
                for(int i=0;i<yztList.size();i++){
                    HashMap map = (HashMap) yztList.get(i);
                    if(map.get("lx").equals(lx)&&map.get("nf").equals(ygjc.getNf())&&map.get("wz").equals(wz))
                    {
                        map.put("sjdx",Double.valueOf(map.get("sjdx").toString())+sjdx);
                        tag=1;
                    }
                }
                if(tag==0)
                {
                    ygjcMap.put("lx",lx);
                    ygjcMap.put("nf", ygjc.getNf());
                    ygjcMap.put("sjdx",sjdx);
                    ygjcMap.put("wz", wz);
                    yztList.add(ygjcMap);
                }
            }
            fileSize = yztList.size()-dbSize;
            model.addAttribute("tableData", yztList);
            model.addAttribute("dbSize",dbSize+1);
            model.addAttribute("fileSize",fileSize);

        } else {

            String nf = type.split("_")[0];
            double wjzdx = Double.valueOf(dbResService.getWjdxBylxAndNf("1", nf)) + Double.valueOf(dbResService.getWjdxBylxAndNf("0", nf));
            model.addAttribute("wjzdx", wjzdx);
            model.addAttribute("ndyxdx", Double.valueOf(dbResService.getWjdxBylxAndNf("1", nf)));
            model.addAttribute("ndqpdx", Double.valueOf(dbResService.getWjdxBylxAndNf("0", nf)));
            model.addAttribute("nf", nf);
            List<YGJC> ygjcList;
            List list = new ArrayList();
            if (type.indexOf(FILE_YX) > -1)
                ygjcList = dbResService.getYgjcByNfAndLx(nf, "1");
            else
                ygjcList = dbResService.getYgjcByNfAndLx(nf, "0");
            for (YGJC ygjc:ygjcList)
            {
                HashMap ygjcMap = new HashMap();
                int tag=0;
                String lx= ygjc.getLx().equals("0") ? FILE_TILE : FILE_YX;
                double sjdx = Double.valueOf(ygjc.getWjdx());
                String wz=dbResService.getIpdzByID(ygjc.getFwqbm());
                for(int i=0;i<list.size();i++){
                    HashMap map = (HashMap) list.get(i);
                    if(map.get("lx").equals(lx)&&map.get("nf").equals(ygjc.getNf())&&map.get("wz").equals(wz))
                    {
                        map.put("wjdx",Double.valueOf(map.get("wjdx").toString())+sjdx);
                        tag=1;
                    }
                }
                if(tag==0)
                {
                    ygjcMap.put("lx",lx);
                    ygjcMap.put("nf", ygjc.getNf());
                    ygjcMap.put("wjdx",sjdx);
                    ygjcMap.put("wz", wz);
                    list.add(ygjcMap);
                }
            }
            model.addAttribute("tableData",list);
        }

        model.addAttribute("type", type);

        return "portal2/rescenter/db_overview";

    }

    /**
     * 获取表空间信息
     *
     * @param id
     * @param model
     * @return
     */
    @RequestMapping(value = "/ajax/fetchDetail/{id}")
    public String detail(@PathVariable String id, Model model) {
        MetaData metaData = dbResService.getMetaDataById(id);
        if (metaData != null) {
            HashMap data = new HashMap();
            long sum = dbResService.getSumByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            long xzqNum = dbResService.getXzqByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            List<Object> maps = dbResService.getSjzsByNdAndYwlx(metaData.getNd(), metaData.getYwlx());
            List xzdmList = new ArrayList();
            List sjzsList = new ArrayList();
            for (int i = 0; i < maps.size(); i++) {
                Object[] obj = (Object[]) maps.get(i);
                xzdmList.add(obj[0]);
                sjzsList.add(Integer.parseInt(obj[1].toString()));

            }
            String ywlxmc = dbResService.getYwlxmc(metaData.getYwlx());
            if (StringUtils.isNotBlank(ywlxmc))
                metaData.setYwlx(ywlxmc);
            data.put("id",metaData.getId());
            data.put("nd",metaData.getNd());
            data.put("ywlx",metaData.getYwlx());
            data.put("bkjmc",metaData.getBkjmc());
            data.put("zt",metaData.getZt());
            data.put("bkjzdx",Double.valueOf(metaData.getBkjzdx()));
            data.put("bkjyydx",Double.valueOf(metaData.getBkjyydx()));
            data.put("bkjsydx",Double.valueOf(metaData.getBkjsydx()));
            data.put("bkjwjlj",metaData.getBkjwjlj());
            model.addAttribute("metaData", data);
            model.addAttribute("xzdm", JSON.toJSONString(xzdmList.toArray()));
            model.addAttribute("sjzs", JSON.toJSONString(sjzsList.toArray()));
            model.addAttribute("sum", sum);
            model.addAttribute("xzqNum", xzqNum);
        } else
            model.addAttribute("metaData", null);
        return "portal2/rescenter/db_detail";
    }

    /**
     * 元数据信息
     *
     * @param id
     * @param model
     * @return
     */
    @RequestMapping(value = "/metaInfo/{id}")
    public String metaInfo(@PathVariable String id, Model model) {

        List<YSJ> ysjList = dbResService.getMetaInfo(id);
        MetaData dbMetaData = dbResService.getMetaDataById(id);
        if (ysjList != null && ysjList.size() > 0) {
            byte[] bytes = ysjList.get(0).getMeta();
            model.addAttribute("xml", (new String(bytes, Charset.forName("gbk"))));
            model.addAttribute("metaDataTitle", dbMetaData.getUserName() + "_" + dbMetaData.getNd());
        }
        return "portal2/rescenter/metadataInfo";
    }


    /**
     * 服务预览页面
     *
     * @param id
     * @param model
     * @return
     */
    @RequestMapping(value = "/service/{id}", method = RequestMethod.GET)
    public String serviceView(@PathVariable String id, Model model) {
        String serviceUrl = "";
        String serviceType = "";
        model.addAttribute("id", id);
        model.addAttribute("map", metadataService.getMap(id));
        model.addAttribute("layers", metadataService.getLayers(id));
        java.util.Map<ServiceType, Service> types = metadataService.getServices(id);
        if (types != null) {
            if (types.containsKey(ServiceType.ARCGIS_TILE)) {
                Service service = types.get(ServiceType.ARCGIS_TILE);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_TILE.getValue();
            } else if (types.containsKey(ServiceType.ARCGIS_REST)) {
                Service service = types.get(ServiceType.ARCGIS_REST);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_REST.getValue();
            } else {
                for (ServiceType temp : types.keySet()) {
                    serviceUrl = types.get(temp).getUrl();
                    serviceType = temp.getValue();
                    break;
                }
            }
        }
        model.addAttribute("serviceUrl", serviceUrl);
        model.addAttribute("serviceType", serviceType);
        return "portal2/rescenter/service_overview";
    }

}
