/*
 * Project:  onemap
 * Module:   onemap-platform
 * File:     ServicesController.java
 * Modifier: Ray Zhang
 * Modified: 2013-7-5 下午4:19:22
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package cn.gtmap.onemap.platform.controller.portal;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:rayzy1991@163.com">zhangyang</a>
 * @version V1.0, 2013-7-5 下午4:19:22
 */
@Controller
@RequestMapping("/portal")
public class ServicesController {
	
	@Autowired
    private MetadataService metadataService;
	
	@RequestMapping(value = "/maps")
    public String serviceList(Pageable pagin
    		, MapQuery mapQuery
    		, Model model) throws Exception {
        model.addAttribute("page", metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin));
        List<MapGroup> groups = metadataService.getChildrenMapGroups(null, true);
        model.addAttribute("groups", groups);
        model.addAttribute("omsurl",System.getProperty("oms.url"));
        return "portal/services/index";
    }
    
    @RequestMapping(value = "/ajax/fetchMapGroup")
    public String fetchMapGroup(@RequestParam("parentId") String parentId
    		, Model model){
    	List<MapGroup> groups = metadataService.getChildrenMapGroups(parentId, true);
        model.addAttribute("groups", groups);
        return "portal/services/item";
    }
	
    @RequestMapping(value = "/ajax/fetchMaps")
    public String fetchMapsByGroupId(MapQuery mapQuery
    		, Model model
    		, Pageable pagin){
    	mapQuery.setWithGroupChildren(false);
    	model.addAttribute("page", metadataService.findMaps(SecHelper.getUserId(), mapQuery, pagin));
    	if( mapQuery.getGroupId() != null )
    		model.addAttribute("group", metadataService.getMapGroup(mapQuery.getGroupId()));
    	return "portal/services/maps";
    }
}