package cn.gtmap.onemap.platform.controller.portal;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.model.Service;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.service.MetadataService;

/**
 * @author <a href="mailto:rayzy1991@163.com">Ray Zhang</a>
 * @version V1.0, 13-4-26 下午2:14
 */
@Controller
@RequestMapping("/portal")
public class PageController extends BaseController {
	
	@Autowired
	private TplTypeService tplTypeService;
	
    @Autowired
    private MetadataService metadataService;

    @Autowired
    private MapService mapService;

    @RequestMapping(method = RequestMethod.GET)
    public String home(Model model, MapQuery mapQuery) {
        Pageable pageable = new PageRequest(0, 7);
        Page<Map> maps = metadataService.findMaps(SecHelper.getUserId(), mapQuery, pageable);
//        Page<Map> maps = metadataService.getMaps(null, null);
        model.addAttribute("tpls", mapService.getTplsByCount(3));
        model.addAttribute("maps", maps.getContent());
        model.addAttribute("omsurl",System.getProperty("oms.url"));
        return "portal/home";
    }
    
    @RequestMapping("/{document}/{page}")
    public String index(@PathVariable("document") String doc,@PathVariable("page") String page){
    	return "portal/" + doc + "/" + page;
    }
    
    @RequestMapping("/login")
    public String login(@RequestParam(value="next", required = false) String next){
    	if(next != null){
    		return "redirect:" + next;
    	}
    	return "portal/login";
    }
    
    @RequestMapping("/api/{name}")
    public String api(@PathVariable("name") String name){
         return "portal/api/" + name;
    }

    @RequestMapping(value = "/service/{id}", method = RequestMethod.GET)
    public String serviceView(@PathVariable String id, Model model) {
        String serviceUrl = "";
        String serviceType = "";
        model.addAttribute("id", id);
        model.addAttribute("map",metadataService.getMap(id));
        model.addAttribute("layers",metadataService.getLayers(id));
        java.util.Map<ServiceType, Service> types = metadataService.getServices(id);
        if (types != null) {
            if(types.containsKey(ServiceType.ARCGIS_TILE)){
                Service service = types.get(ServiceType.ARCGIS_TILE);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_TILE.getValue();
            }else if(types.containsKey(ServiceType.ARCGIS_REST)){
                Service service = types.get(ServiceType.ARCGIS_REST);
                serviceUrl = service.getUrl();
                serviceType = ServiceType.ARCGIS_REST.getValue();
            }else{
                for (ServiceType temp : types.keySet()) {
                    serviceUrl = types.get(temp).getUrl();
                    serviceType = temp.getValue();
                    break;
                }
            }
        }
        model.addAttribute("serviceUrl", serviceUrl);
        model.addAttribute("serviceType",serviceType);
        return "portal/service/service_overview";
    }
    
    @RequestMapping(value = "/map/{mapId}", method = RequestMethod.GET)
    public String map(@PathVariable String mapId, Model model) {
        model.addAttribute("map", metadataService.getMap(mapId));
        return "portal/map";
    }

    @RequestMapping(value = "/tpls", method = RequestMethod.GET)
    public String tplList(Model model, @RequestParam(value="typeId", required = false) String typeId) {
    	model.addAttribute("types", tplTypeService.queryAllTplType());
    	if(StringUtils.isEmpty(typeId)){
    		model.addAttribute("tpls", tplTypeService.getTplByType(null));
    	}else{
    		model.addAttribute("tpls", tplTypeService.getTplByType(typeId));
    		model.addAttribute("selectedType", tplTypeService.getTplType(typeId));
    	}
        return "portal/tpls";
    }

}