define(['esri/map'], function( Map ) {
  
  var $mapCtn = $('#mapCtn'),
	  $serviceTree = $('#mapTypesTree'),
	  layersMaps = {};
	  
  function isLayerAdded( layerId ){
	for ( var k in layersMaps ){
		if ( k === layerId && layersMaps[k] !== 0 ){
			layersMaps[layerId].destroy();
			layersMaps[layerId] = 0;
			return true;
		}
	}
	return false;
  }
  
  function removeSplitMap( layerId ){
	
	$mapCtn.find('[data-id='+ layerId +']').remove();
  }
  
  function renderScreen(){
	var mapsSize = $mapCtn.find('.map-item').length;
	switch( mapsSize ){
		case 1:
			$mapCtn.children().css({'width':'99.9%','height':'100%'});
			break;
		case 2:
			$mapCtn.children().css({'width':'49.8%','height':'100%'});
			break;
		case 3:
			$mapCtn.children().css({'width':'33.1%', 'height':'100%'});
			break;
	}
	map.resize();
  }
  
  function createSplitMap( layerId ) {
	
	if( isLayerAdded( layerId ) ){
		removeSplitMap( layerId );
		renderScreen();
		return true;
	}
	
	var mapsSize = $mapCtn.find('.map-item').length ,
		$newmap = $('<div/>');
	$newmap.addClass('map-item');
	$newmap.attr({ 'data-id' : layerId });
	
	if( mapsSize <=3 ){
		switch (mapsSize){
			case 1:
				$mapCtn.append($newmap);
				$mapCtn.children().css('width','49.8%');
				break;
			case 2:
				$mapCtn.append($newmap);
				$mapCtn.children().css('width','33.1%');
				break;
			case 3:
				$mapCtn.append($newmap);
				$mapCtn.children().css({'width':'49.8%', 'height':'50%'});
				break;
		}
		var map2 = new Map($newmap[0], { logo : false });
		var layer2 = new esri.layers.ArcGISTiledMapServiceLayer(map.getLayer(layerId).url);
		map2.addLayer( layer2 );
		layersMaps[layerId] = map2;
		map.resize();
	}else{
		$.infopane.animate('图层太多，请先关闭', 'error');
		return false;
	}
	return true;
  }

  return {
	'layerCompare' : function() {
      var $self = $(this);
      createSplitMap( $self.attr('data-id') ) && $self[ $self.hasClass('active') ? 'removeClass' : 'addClass' ]('active');
	  console.debug( layersMaps );
    },
	
    'layerShowHide' : function() {
	  
	  var $self = $(this) ,
		  isChecked = $self.is(':checked'),
		  id = $self.attr('data-id'),
		  children = $serviceTree.find('[data-parent=' + id + ']');
		  console.debug(isChecked);
	  if( children.length ){
		children.find('input[type=checkbox]').each(function(){
			($(this).is(':checked') !== isChecked) && $(this).click();
		});
	  }else{
		var layer = map.getLayer(id);
		layer && layer[ isChecked ? 'show' : 'hide' ]();
	  }
    },
	
	'syncMaps' : function(){
		function syncMaps(){
			for( var k in layersMaps ){
				if( layersMaps[k] != 0 ){
					console.debug(layersMaps);
					layersMaps[k].setScale( map.getScale() );
					layersMaps[k].setExtent( map.extent );
				}
			}
		}
		dojo.connect(map, 'onExtentChange', syncMaps);
	}
  }
});