/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import com.esri.sde.sdk.pe.PeCSTransformations;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeFactory;
import com.esri.sde.sdk.pe.PeFactoryCodelist;
import com.esri.sde.sdk.pe.PeGTTransformations;
import com.esri.sde.sdk.pe.PeGeogTransformations;
import com.esri.sde.sdk.pe.PeGeographicCS;
import com.esri.sde.sdk.pe.PeProjectedCS;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.esri.sde.sdk.pe.PeString;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SRTransformations {
    private static final Logger logger = LoggerFactory.getLogger(SRTransformations.class);
    private static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();
    private static Map<String, PeGeogTransformations> geoTranSet = new HashMap();
    private static List<String> notAvailTrans = new ArrayList();

    public static PeCoordinateSystem getCoordinateSystem(int srid) throws PeProjectionException {
        return PeFactory.coordsys((int)srid);
    }

    public static PeCoordinateSystem getCoordinateSystem(String wkt) throws PeProjectionException {
        return PeCoordinateSystem.fromString((String)wkt);
    }

    public static Geometry project(Geometry geometry, String from, String to) throws PeProjectionException {
        PeCoordinateSystem fromCS = SRTransformations.getCoordinateSystem((String)from);
        PeCoordinateSystem toCS = SRTransformations.getCoordinateSystem((String)to);
        if (geometry instanceof Point) {
            return SRTransformations.project((Point)((Point)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof MultiPoint) {
            return SRTransformations.project((MultiPoint)((MultiPoint)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof LineString) {
            return SRTransformations.project((LineString)((LineString)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof MultiLineString) {
            return SRTransformations.project((MultiLineString)((MultiLineString)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof Polygon) {
            return SRTransformations.project((Polygon)((Polygon)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof MultiPolygon) {
            return SRTransformations.project((MultiPolygon)((MultiPolygon)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        if (geometry instanceof GeometryCollection) {
            return SRTransformations.project((GeometryCollection)((GeometryCollection)geometry), (PeCoordinateSystem)fromCS, (PeCoordinateSystem)toCS);
        }
        throw new RuntimeException("current geometry don't supported");
    }

    private static Point project(Point point, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.project((double[])new double[]{point.getX(), point.getY()}, (int)1, (PeCoordinateSystem)from, (PeCoordinateSystem)to);
        return factory.createPoint(new Coordinate(coords[0], coords[1]));
    }

    private static MultiPoint project(MultiPoint multiPoint, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.getCoordinates((Coordinate[])multiPoint.getCoordinates());
        Coordinate[] coordinates = SRTransformations.array2Coords((double[])SRTransformations.project((double[])coords, (int)(coords.length / 2), (PeCoordinateSystem)from, (PeCoordinateSystem)to));
        return factory.createMultiPoint(coordinates);
    }

    private static LineString project(LineString lineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        double[] coords = SRTransformations.getCoordinates((Coordinate[])lineString.getCoordinates());
        Coordinate[] coordinates = SRTransformations.array2Coords((double[])SRTransformations.project((double[])coords, (int)(coords.length / 2), (PeCoordinateSystem)from, (PeCoordinateSystem)to));
        return factory.createLineString(coordinates);
    }

    private static MultiLineString project(MultiLineString multiLineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        LineString[] lineStrings = new LineString[multiLineString.getNumGeometries()];
        for (int i = 0; i < lineStrings.length; ++i) {
            lineStrings[i] = SRTransformations.project((LineString)((LineString)multiLineString.getGeometryN(i)), (PeCoordinateSystem)from, (PeCoordinateSystem)to);
        }
        return factory.createMultiLineString(lineStrings);
    }

    private static Polygon project(Polygon polygon, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        LinearRing shell = SRTransformations.lineString2LinearRing((LineString)polygon.getExteriorRing(), (PeCoordinateSystem)from, (PeCoordinateSystem)to);
        LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
        if (holes.length > 0) {
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                holes[i] = SRTransformations.lineString2LinearRing((LineString)polygon.getInteriorRingN(i), (PeCoordinateSystem)from, (PeCoordinateSystem)to);
            }
        }
        return factory.createPolygon(shell, holes);
    }

    private static MultiPolygon project(MultiPolygon multiPolygon, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        Polygon[] polygons = new Polygon[multiPolygon.getNumGeometries()];
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            polygons[i] = SRTransformations.project((Polygon)((Polygon)multiPolygon.getGeometryN(i)), (PeCoordinateSystem)from, (PeCoordinateSystem)to);
        }
        return factory.createMultiPolygon(polygons);
    }

    private static GeometryCollection project(GeometryCollection geometryCollection, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        Geometry[] geometries = new Geometry[geometryCollection.getNumGeometries()];
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            geometries[i] = SRTransformations.project((Geometry)geometryCollection.getGeometryN(i), (String)from.toString(), (String)to.toString());
        }
        return factory.createGeometryCollection(geometries);
    }

    private static LinearRing lineString2LinearRing(LineString lineString, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        return SRTransformations.createLinearRing((Coordinate[])SRTransformations.project((LineString)lineString, (PeCoordinateSystem)from, (PeCoordinateSystem)to).getCoordinates());
    }

    private static LinearRing createLinearRing(Coordinate[] coordinates) {
        return factory.createLinearRing(coordinates);
    }

    private static Coordinate[] array2Coords(double[] coords) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < coords.length; i += 2) {
            Coordinate coordinate = new Coordinate(coords[i], coords[i + 1]);
            coordinates.add(coordinate);
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    private static double[] getCoordinates(Coordinate[] coordinates) {
        ArrayList<Double> coords = new ArrayList<Double>();
        for (Coordinate c : coordinates) {
            coords.add(c.x);
            coords.add(c.y);
        }
        return ArrayUtils.toPrimitive((Double[])coords.toArray(new Double[0]));
    }

    public static double[] project(double[] coords, int count, PeCoordinateSystem from, PeCoordinateSystem to) throws PeProjectionException {
        PeProjectedCS pt;
        if (from.isEqual(to)) {
            return coords;
        }
        PeGeographicCS gf = from instanceof PeGeographicCS ? (PeGeographicCS)from : null;
        PeGeographicCS gt = to instanceof PeGeographicCS ? (PeGeographicCS)to : null;
        PeProjectedCS pf = from instanceof PeProjectedCS ? (PeProjectedCS)from : null;
        PeProjectedCS peProjectedCS = pt = to instanceof PeProjectedCS ? (PeProjectedCS)to : null;
        if (gf != null && gt != null) {
            return SRTransformations.projectGCS((double[])coords, (int)count, (PeGeographicCS)gf, (PeGeographicCS)gt);
        }
        if (gf != null && pt != null) {
            SRTransformations.projectGCS((double[])coords, (int)count, (PeGeographicCS)gf, (PeGeographicCS)pt.getGeogCoordSys());
            PeCSTransformations.geogToProj((PeProjectedCS)pt, (int)count, (double[])coords);
            return coords;
        }
        if (pf != null && gt != null) {
            PeCSTransformations.projToGeog((PeProjectedCS)pf, (int)count, (double[])coords);
            SRTransformations.projectGCS((double[])coords, (int)count, (PeGeographicCS)pf.getGeogCoordSys(), (PeGeographicCS)gt);
            return coords;
        }
        if (pf != null && pt != null) {
            PeCSTransformations.projToGeog((PeProjectedCS)pf, (int)count, (double[])coords);
            SRTransformations.projectGCS((double[])coords, (int)count, (PeGeographicCS)pf.getGeogCoordSys(), (PeGeographicCS)pt.getGeogCoordSys());
            PeCSTransformations.geogToProj((PeProjectedCS)pt, (int)count, (double[])coords);
            return coords;
        }
        return coords;
    }

    private static double[] projectGCS(double[] coords, int count, PeGeographicCS from, PeGeographicCS to) throws PeProjectionException {
        if (from.isEqual(to)) {
            return coords;
        }
        String key = from.getName().concat(to.getName());
        PeGeogTransformations gt = (PeGeogTransformations)geoTranSet.get(key);
        if (gt == null) {
            if (notAvailTrans.contains(key)) {
                logger.info("GCS trans not found [" + from + " ## " + to + "]");
                return coords;
            }
            gt = SRTransformations.findGeogTran((PeGeographicCS)from, (PeGeographicCS)to);
            if (gt == null) {
                notAvailTrans.add(key);
            }
        } else {
            geoTranSet.put(key, gt);
        }
        if (gt != null) {
            if (from.isEqual(gt.getGeogCS1())) {
                PeGTTransformations.geog1ToGeog2((PeGeogTransformations)gt, (int)count, (double[])coords, null);
            } else {
                PeGTTransformations.geog2ToGeog1((PeGeogTransformations)gt, (int)count, (double[])coords, null);
            }
        }
        return coords;
    }

    private static PeGeogTransformations findGeogTran(PeGeographicCS gcs1, PeGeographicCS gcs2) throws PeProjectionException {
        int[] codes = PeFactoryCodelist.geogtran();
        PeGeogTransformations imatch = null;
        for (int i = 0; i < codes.length; ++i) {
            PeGeogTransformations gt = PeFactory.geogtran((int)codes[i]);
            if (gt == null) continue;
            SRTransformations.isEqual((PeGeographicCS)gt.getGeogCS1(), (PeGeographicCS)gcs1);
            if (gt.getGeogCS1().isEqual(gcs1) && gt.getGeogCS2().isEqual(gcs2)) {
                return gt;
            }
            if (!gt.getGeogCS1().isEqual(gcs2) || !gt.getGeogCS2().isEqual(gcs1)) continue;
            imatch = gt;
        }
        return imatch;
    }

    private static boolean isEqual(PeGeographicCS gcs1, PeGeographicCS gcs2) {
        return gcs1 != null && gcs2 != null && PeString.equals((String)gcs1.getName(), (String)gcs2.getName()) && gcs1.getDatum().isEqual(gcs2.getDatum()) && gcs1.getPrimeM().isEqual(gcs2.getPrimeM()) && gcs1.getUnit().isEqual(gcs2.getUnit());
    }
}

