/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.fm;

import cn.gtmap.onemap.model.Operation;
import cn.gtmap.onemap.model.Privilege;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import cn.gtmap.onemap.security.AuthorizationService;
import cn.gtmap.onemap.security.IdentityService;
import cn.gtmap.onemap.security.Role;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.security.User;
import freemarker.template.TemplateModelException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class EnvContext
extends BaseLogger {
    private static final String DEFAULT_TPL = "YZT";
    private static final String BLANK_TPL = "YZT_DEFAULT";
    private static final String TPL_RESOURCE = "omp-functions:tpl";
    private static final String ZT_RESOURCE = "omp-functions:zt";
    private static final String STATISTIC_RESOURCE = "omp-functions:statistic";
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private IdentityService identityService;

    public Object getMainTpl() throws TemplateModelException {
        if (SecHelper.isAdmin()) {
            return DEFAULT_TPL;
        }
        User user = SecHelper.getUser();
        try {
            if (user != null) {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), TPL_RESOURCE);
                for (Privilege privilege : privileges) {
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return privilege.getResource();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("tpl.om.selector.error", new Object[]{e.getLocalizedMessage()}));
        }
        return BLANK_TPL;
    }

    public boolean hasZtAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return true;
        }
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), ZT_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getResource().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("user.zt.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return false;
    }

    public boolean hasStatisAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return true;
        }
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), STATISTIC_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getTitle().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("user.zt.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return false;
    }

    public Object getEnv(String key) {
        return AppPropertyUtils.getAppEnv((String)key);
    }

    public String getRegionCode() {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return null;
        }
        User user = SecHelper.getUser();
        if (user == null) {
            return null;
        }
        Set roles = this.identityService.getUserRoles(user.getId());
        if (roles.size() > 0) {
            for (Role role : roles) {
                if (role.getRegionCode() == null) continue;
                return role.getRegionCode();
            }
        }
        return null;
    }
}

