/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.dao.GTPLDao;
import cn.gtmap.onemap.platform.dao.TplTypeDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.service.TplTypeService;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TplTypeServiceImpl
implements TplTypeService {
    private String typeFolderLocation;
    @Autowired
    private TplTypeDao tplTypeDao;
    @Autowired
    private GTPLDao gtplDao;
    private static final String CATEGORY_PREFIX = "category_";

    public String getTypeFolderLocation() {
        return this.typeFolderLocation;
    }

    public void setTypeFolderLocation(String typeFolderLocation) {
        this.typeFolderLocation = typeFolderLocation;
    }

    public List<TplType> queryAllTplType() {
        return this.tplTypeDao.findAll();
    }

    public TplType getTplType(String id) {
        return (TplType)this.tplTypeDao.findOne((Serializable)((Object)id));
    }

    public List<HashMap<String, Object>> getTplByType(String id) {
        List namedTpls = this.gtplDao.getAllTpl();
        ArrayList<HashMap<String, Object>> back = new ArrayList<HashMap<String, Object>>();
        if (!StringUtils.isEmpty((String)id) && namedTpls != null) {
            TplType tplType = (TplType)this.tplTypeDao.findOne((Serializable)((Object)id));
            List fileNames = (List)tplType.getAttribute("tpls", List.class, new ArrayList());
            HashMap<String, Integer> filenameIdxMap = new HashMap<String, Integer>();
            for (int i = 0; i < namedTpls.size(); ++i) {
                Map.Entry first = ((HashMap)namedTpls.get(i)).entrySet().iterator().next();
                filenameIdxMap.put((String)first.getValue(), i);
            }
            Set all = filenameIdxMap.keySet();
            for (String fileName : fileNames) {
                if (!all.contains(fileName)) continue;
                back.add((HashMap<String, Object>)namedTpls.get((Integer)filenameIdxMap.get(fileName)));
            }
            return back;
        }
        return namedTpls == null ? new ArrayList() : namedTpls;
    }

    @Transactional
    public TplType saveTplType(TplType tplType) {
        tplType.setCreateAt(new Date());
        return (TplType)this.tplTypeDao.save((Object)tplType);
    }

    private boolean createFolder(String locationAndName) {
        File f = new File(locationAndName);
        return f.mkdirs();
    }

    @Transactional
    public boolean updateTplAndTypeRelationShip(String oldTypeId, String newId, String tplName) {
        if (StringUtils.isEmpty((String)oldTypeId)) {
            TplType newType = this.getTplType(newId);
            List newTpls = (List)newType.getAttribute("tpls", List.class, new ArrayList());
            newTpls.add(tplName);
            newType.setAttribute("tpls", (Object)newTpls);
            this.tplTypeDao.save((Object)newType);
        } else {
            if (oldTypeId.equals(newId)) {
                return true;
            }
            TplType oldType = this.getTplType(oldTypeId);
            List oldTpls = (List)oldType.getAttribute("tpls", List.class, new ArrayList());
            ArrayList<String> exTpls = new ArrayList<String>();
            for (String tpl : oldTpls) {
                if (tpl.equals(tplName)) continue;
                exTpls.add(tpl);
            }
            oldType.setAttribute("tpls", exTpls);
            TplType newType = this.getTplType(newId);
            List newTpls = (List)newType.getAttribute("tpls", List.class, new ArrayList());
            newTpls.add(tplName);
            newType.setAttribute("tpls", (Object)newTpls);
            this.tplTypeDao.save((Object)oldType);
            this.tplTypeDao.save((Object)newType);
        }
        return true;
    }

    public List getSpecialServices(String tplName) {
        ArrayList groupList = new ArrayList();
        Configuration configuration = this.gtplDao.getConfigByTpl(tplName);
        List dictList = configuration.getDicts();
        for (Dict dict : dictList) {
            if (!dict.getName().toString().equals(CATEGORY_PREFIX + tplName)) continue;
            List dictItems = dict.getDictItems();
            for (Item item : dictItems) {
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put("name", item.getName());
                temp.put("title", item.getTitle());
                temp.put("value", item.getValue());
                groupList.add(temp);
            }
        }
        return groupList;
    }

    public List<TplType> queryAllEnabledType() {
        return this.tplTypeDao.findEnabledTplTypes();
    }
}

