/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GeometryServiceImpl;
import cn.gtmap.onemap.platform.utils.GeometryUtils;
import cn.gtmap.onemap.platform.utils.SRTransformations;
import cn.gtmap.onemap.platform.utils.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class GeometryServiceImpl
extends BaseLogger
implements GeometryService {
    public static final String TYPE = "type";
    public static final String FEATURE = "Feature";
    public static final String FEATURE_COLLECTION = "FeatureCollection";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String WKID = "wkid";
    private static final String WKT = "wkt";
    private static final String REGION_FIELD = "regionLayers";
    private static final String REGION_MAP = "regionMap";
    private static final String DEFAULT_CRS = "defaultCrs";
    private static final String COORDINATE_DM = "coordinatesDM";
    private static final String UNDEFINE = "UNDEFINE";
    private static final String EPSG_PERFIX = "EPSG:";
    private static final String BJ_FILE_NAME = "gt.xml";
    private static final String DEFAULT_LAYER_REGION_FIELD = "DEFAULTLAYER";
    private static final String TEMP_PIX = "TMP_";
    private static final String BJ_TITLE = "title";
    private static final String BJ_FEATURE = "feature";
    private static final String BJ_AREA = "area";
    private static final String XLS_COORD_TAG = "@";
    private static final String PROJCS = "PROJCS";
    private static final String GEOGCS = "GEOGCS";
    private static final String SHP_FILE_SUFFIX = "shp";
    private static final String SHX_FILE_SUFFIX = "shx";
    private static final String DBF_FILE_SUFFIX = "dbf";
    private static final String PRJ_FILE_SUFFIX = "prj";
    private static final String DOTS = ".";
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private WKTReader wktReader;
    private double simplifyTolerance;
    private Map<String, String> regionLayers;
    private Map regionSet;
    private CoordinateReferenceSystem defaultCrs;
    private Map<String, Object> coordinateDM;
    @Autowired
    private DocumentService documentService;

    public Geometry readWKT(String wkt) throws GeometryServiceException {
        try {
            return new WKTReader(this.geometryFactory).read(wkt);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.WKT_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry readGeoJSON(String geoJSON) throws GeometryServiceException {
        try {
            GeometryJSON geometryJSON = new GeometryJSON();
            return geometryJSON.read((Object)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public GeometryCollection readGeoCollectionJSON(String geoJSON) throws GeometryServiceException {
        try {
            GeometryJSON geometryJSON = new GeometryJSON();
            return geometryJSON.readGeometryCollection((Object)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public SimpleFeature readFeatureJSON(String featureJSON) throws GeometryServiceException {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readFeature((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public FeatureCollection readFeatureCollectionJSON(String featureJSON) throws GeometryServiceException {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readFeatureCollection((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Object readUnTypeGeoJSON(String geoJSON) throws GeometryServiceException {
        try {
            return GeometryUtils.parseGeoJSON((String)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem readFeatureJSONCRS(String featureJSON) {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readCRS((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry project(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        return this.projectByAGS(geometry, sourceCRS, targetCRS);
    }

    public SimpleFeature project(SimpleFeature feature, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        return null;
    }

    public Geometry projectByAGS(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        try {
            return SRTransformations.project((Geometry)geometry, (String)sourceCRS.toWKT(), (String)targetCRS.toWKT());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry simplify(Geometry geometry, double tolerance) {
        return geometry.isValid() && geometry.isSimple() ? geometry : DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public Geometry forceSimplify(Geometry geometry, double tolerance) {
        return DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public Geometry densify(Geometry geometry, double tolerance) {
        return Densifier.densify((Geometry)geometry, (double)tolerance);
    }

    public CoordinateReferenceSystem getCRSByWKTString(String wktCRS) {
        try {
            return CRS.parseWKT((String)SRTransformations.getCoordinateSystem((String)wktCRS).toString());
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSByCommnonString(String crs) {
        try {
            return CRS.decode((String)crs, (boolean)true);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSBySRID(String srid) {
        try {
            return this.getCRSByWKTString(SRTransformations.getCoordinateSystem((int)Integer.valueOf(srid)).toString());
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getSeLayerCRS(SeLayer layer) {
        return this.getCRSByWKTString(layer.getCoordRef().getCoordSysDescription());
    }

    public SimpleFeatureType getFeatureType(Map<String, Object> value) {
        String[] keys;
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(FEATURE);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                typeBuilder.add("geometry", Geometry.class);
                continue;
            }
            if ("crs".equals(key)) {
                typeBuilder.add("crs", String.class, (CoordinateReferenceSystem)value.get(key));
                continue;
            }
            typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
        }
        return typeBuilder.buildFeatureType();
    }

    public SimpleFeature map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        String[] keys;
        Geometry geometry;
        Geometry geometry2 = geometry = value.containsKey("SHAPE") ? this.readWKT((String)value.get("SHAPE")) : null;
        if (geometry != null && srcCRS != null && destCRS != null) {
            geometry = this.project(geometry, srcCRS, destCRS);
        }
        SimpleFeatureType featureType = this.getFeatureType(value);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                featureBuilder.add((Object)geometry);
                continue;
            }
            if ("crs".equals(key)) {
                featureBuilder.add(value.get("crs"));
                continue;
            }
            featureBuilder.add(value.get(key) != null ? value.get(key) : "");
        }
        return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
    }

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (Map<String, Object> item : value) {
            collection.add(this.map2SimpleFeature(item, srcCRS, destCRS));
        }
        return collection;
    }

    public String toFeatureJSON(Object feature) {
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature)feature).getBounds() != null);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature)feature).getFeatureType().getCoordinateReferenceSystem() != null);
                featureJSON.writeFeature((SimpleFeature)feature, (Object)out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection)feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getBounds() != null);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getFeatureType().getCoordinateReferenceSystem() != null);
                }
                featureJSON.writeFeatureCollection((FeatureCollection)feature, (Object)out);
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.FEATURE_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public String toGeoJSON(Geometry geometry) {
        try {
            GeometryJSON geometryJSON = new GeometryJSON(14);
            StringWriter out = new StringWriter();
            geometryJSON.write(geometry, (Object)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Map<String, Object> simpleFeature2Map(SimpleFeature feature) {
        Assert.notNull((Object)feature, (String)"feature can't be null");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Property property : feature.getProperties()) {
            if (property.getValue() == null || !StringUtils.isNotBlank((String)String.valueOf(property.getValue()))) continue;
            result.put(property.getName().getLocalPart(), property.getValue());
        }
        return result;
    }

    public CoordinateReferenceSystem parseUndefineSR(String value) {
        try {
            int srid = Integer.parseInt(value);
            if (srid != 0) {
                return this.getCRSBySRID(value);
            }
        }
        catch (NumberFormatException e) {
            if (value.indexOf("EPSG") == 0) {
                return this.getCRSBySRID(value.substring("EPSG".length() + 1, value.length()));
            }
            return this.getCRSByWKTString(value);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, value);
    }

    public TopologyValidationError validGeometry(Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.getValidationError();
    }

    public CoordinateReferenceSystem getCRSByRegionCode(String regionCode) {
        if (StringUtils.isBlank((String)regionCode)) {
            throw new RuntimeException(this.getMessage("region.code.not.null", new Object[0]));
        }
        return this.parseUndefineSR(String.valueOf(this.regionSet.get(regionCode)));
    }

    public LayerRegion getLayerRegion(String layerName) {
        for (Map.Entry entry : this.regionLayers.entrySet()) {
            if (!Pattern.compile((String)entry.getKey()).matcher(layerName.toUpperCase()).matches()) continue;
            String value = (String)entry.getValue();
            try {
                return new LayerRegion(layerName, this.parseUndefineSR(value));
            }
            catch (Exception e) {
                return new LayerRegion(layerName, value);
            }
        }
        if (this.regionLayers.containsKey(DEFAULT_LAYER_REGION_FIELD)) {
            String defaultField = (String)this.regionLayers.get(DEFAULT_LAYER_REGION_FIELD);
            this.logger.info(this.getMessage("layer.regioncode.default", new Object[]{layerName, defaultField}));
            return new LayerRegion(layerName, defaultField);
        }
        throw new RuntimeException(this.getMessage("layer.regioncode.not.set", new Object[]{layerName}));
    }

    public boolean containsRegionValue(String regionCode) {
        return this.regionSet.containsKey(regionCode);
    }

    public double readGeometryAera(String geoJSON) {
        try {
            Object geo = this.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof Geometry) {
                return ((Geometry)geo).getArea();
            }
            if (geo instanceof SimpleFeature) {
                return ((Geometry)((SimpleFeature)geo).getDefaultGeometry()).getArea();
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return 0.0;
    }

    public double getSimplifyTolerance() {
        return this.simplifyTolerance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBJCoordinates(InputStream in) throws Exception {
        List documents = this.documentService.readZip(in);
        if (documents.size() == 0) {
            File tmp = new File(System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)0L, (long)in.available(), (byte[])new byte[in.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                documents = this.documentService.readZipFile(tmp);
                if (documents.size() == 0) {
                    throw new RuntimeException(this.getMessage("bj.zip.format.error", new Object[0]));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        for (Document document : documents) {
            if (!document.getFileName().equals(BJ_FILE_NAME)) continue;
            return this.parseBjXml(document.getContent());
        }
        throw new RuntimeException(this.getMessage("bj.gt.xml.not.found", new Object[0]));
    }

    public CoordinateReferenceSystem getCrsByCoordXD(double x) {
        Object crs = null;
        String s = String.valueOf(Math.round(x));
        if (s.length() == 8) {
            String p = s.substring(0, 2);
            if (this.coordinateDM.containsKey(p)) {
                return (CoordinateReferenceSystem)this.coordinateDM.get(p);
            }
            throw new RuntimeException(this.getMessage("bj.coords.dm.not.set", new Object[]{p}));
        }
        if (s.length() == 6) {
            return (CoordinateReferenceSystem)this.coordinateDM.get(UNDEFINE);
        }
        throw new RuntimeException(this.getMessage("bj.coords.type.not.support", new Object[]{x}));
    }

    public String getExcelCoordinates(InputStream in) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            Sheet sheet = workbook.getSheetAt(0);
            List features = new ArrayList();
            CoordinateReferenceSystem sourceCrs = null;
            for (Row row : sheet) {
                String crs;
                String info = row.getCell(0).getStringCellValue();
                if (row.getCell(7) != null && row.getCell(7).getCellType() == 1 && ((crs = row.getCell(7).getStringCellValue()).startsWith(PROJCS) || crs.startsWith(GEOGCS))) {
                    sourceCrs = this.getCRSByWKTString(crs);
                }
                if (!info.endsWith(XLS_COORD_TAG)) continue;
                features = this.excel2List(row.getRowNum() + 1, sheet, sourceCrs);
                break;
            }
            if (features.size() > 0) {
                for (Map feature : features) {
                    if (sourceCrs == null) {
                        sourceCrs = (CoordinateReferenceSystem)feature.get("crs");
                    }
                    feature.remove("crs");
                }
            } else {
                throw new RuntimeException(this.getMessage("excel.coords.not.found", new Object[0]));
            }
            return this.toFeatureJSON((Object)this.list2FeatureCollection(features, sourceCrs, this.defaultCrs));
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bj.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(InputStream in) throws Exception {
        String result;
        String filePath;
        File folderFile;
        List documents = this.documentService.readZip(in);
        if (documents.size() == 0) {
            File tmp = new File(System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)0L, (long)in.available(), (byte[])new byte[in.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                documents = this.documentService.readZipFile(tmp);
                if (documents.size() == 0) {
                    throw new RuntimeException(this.getMessage("bj.zip.format.error", new Object[0]));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        if (!(folderFile = new File(filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()))).exists()) {
            folderFile.mkdir();
        }
        for (Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(DBF_FILE_SUFFIX)) continue;
                    dbfFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(DBF_FILE_SUFFIX)) continue;
                    dbfFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file, String properties) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        Map propertyMap = (Map)JSON.parseObject((String)properties, Map.class);
        if (this.isNull((Object)propertyMap)) {
            this.logger.info("properties is null");
            return this.getShpCoordinates(file);
        }
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(DBF_FILE_SUFFIX)) continue;
                    dbfFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, propertyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    private String parseShapefile(File shpFile, File dbfFile, Map properties) throws Exception {
        assert (shpFile != null) : this.getMessage("shp.shapefile.not.found", new Object[0]);
        assert (dbfFile != null) : this.getMessage("shp.dbffile.not.found", new Object[0]);
        ArrayList featureList = new ArrayList();
        ShapefileDataStore shapefileDataStore = null;
        SimpleFeatureSource featureSource = null;
        DbaseFileReader reader = null;
        try {
            shapefileDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shapefileDataStore.setStringCharset(Charset.forName("GBK"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        try {
            featureSource = shapefileDataStore.getFeatureSource();
            FeatureCollection featureCollection = featureSource.getFeatures();
            if (featureCollection.size() > 0) {
                FeatureIterator iterator = featureCollection.features();
                while (iterator.hasNext()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geo = (Geometry)feature.getDefaultGeometry();
                    TopologyValidationError validationError = this.validGeometry(geo);
                    if (!this.isNull((Object)validationError)) {
                        throw new RuntimeException(this.getMessage("shp.tp.check.error", new Object[]{validationError.getMessage()}));
                    }
                    map.put("SHAPE", geo.toText());
                    if (properties != null) {
                        map.putAll(properties);
                    }
                    featureList.add(map);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        try {
            reader = new DbaseFileReader((ReadableByteChannel)new FileInputStream(dbfFile).getChannel(), false, Charset.forName("GBK"));
            DbaseFileHeader header = reader.getHeader();
            int fieldsNum = header.getNumFields();
            int recordIndex = 0;
            while (reader.hasNext()) {
                DbaseFileReader.Row row = reader.readRow();
                for (int i = 0; i < fieldsNum; ++i) {
                    String fieldName = header.getFieldName(i);
                    Object value = row.read(i);
                    Map map = (Map)featureList.get(recordIndex);
                    if (map.containsKey(fieldName.toLowerCase()) || map.containsKey(fieldName.toUpperCase())) continue;
                    map.put(fieldName, value);
                }
                ++recordIndex;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return this.toFeatureJSON((Object)this.list2FeatureCollection(featureList, null, null));
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> excel2List(int startRowNum, Sheet sheet, CoordinateReferenceSystem crs) {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList coordList = new ArrayList();
        for (int i = startRowNum; i < sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (this.isNull((Object)row.getCell(0))) continue;
            if (row.getCell(0).getStringCellValue().endsWith(XLS_COORD_TAG)) {
                features.addAll(this.excel2List(i + 1, sheet, crs));
                continue;
            }
            HashMap<String, Object> coordMap = new HashMap<String, Object>();
            coordMap.put(BJ_TAG.PNT_SERIAL.name(), row.getCell(0).getStringCellValue());
            coordMap.put(BJ_TAG.SHAPE_GROUP.name(), row.getCell(1).getCellType() == 0 ? Double.valueOf(row.getCell(1).getNumericCellValue()) : row.getCell(1).getStringCellValue());
            coordMap.put(BJ_TAG.Y_COORD.name(), row.getCell(2).getCellType() == 0 ? Double.valueOf(row.getCell(2).getNumericCellValue()) : row.getCell(2).getStringCellValue());
            coordMap.put(BJ_TAG.X_COORD.name(), row.getCell(3).getCellType() == 0 ? Double.valueOf(row.getCell(3).getNumericCellValue()) : row.getCell(3).getStringCellValue());
            coordList.add(coordMap);
        }
        LinkedHashMap rings = new LinkedHashMap();
        CoordinateReferenceSystem fearureCrs = crs;
        try {
            for (Map map : coordList) {
                String ringNo = String.valueOf(map.get(BJ_TAG.SHAPE_GROUP.name()));
                double x = Double.parseDouble(String.valueOf(map.get(BJ_TAG.X_COORD.name())));
                double y = Double.parseDouble(String.valueOf(map.get(BJ_TAG.Y_COORD.name())));
                if (rings.containsKey(ringNo)) {
                    ((List)rings.get(ringNo)).add(new Coordinate(x, y));
                } else {
                    ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
                    ring.add(new Coordinate(x, y));
                    rings.put(ringNo, ring);
                }
                if (fearureCrs != null) continue;
                fearureCrs = this.getCrsByCoordXD(x);
            }
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(this.getMessage("bj.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
        LinearRing shell = null;
        Object var9_12 = null;
        Collection coords = rings.values();
        for (List coordinates : coords) {
            Coordinate first = (Coordinate)coordinates.get(0);
            Coordinate last = (Coordinate)coordinates.get(coordinates.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        HashMap<String, String> feature = new HashMap<String, String>();
        try {
            void var9_13;
            for (List coordinates : coords) {
                if (shell == null) {
                    shell = this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0]));
                    continue;
                }
                if (var9_13 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var9_13.add(this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0])));
            }
            polygon = this.geometryFactory.createPolygon(shell, var9_13 != null ? var9_13.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("bj.parse.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("bj.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
        Row titleRow = sheet.getRow(startRowNum - 1);
        String titleValue = titleRow.getCell(0).getStringCellValue().replaceAll("\\s*", "");
        titleValue = titleValue.replaceAll("\uff0c", ",");
        List<String> infoList = Arrays.asList(titleValue.split(","));
        String plotName = infoList.get(3);
        feature.put("SHAPE", polygon.toText());
        feature.put("crs", (String)fearureCrs);
        feature.put(BJ_TAG.PL_NAME.name(), plotName);
        features.add(feature);
        return features;
    }

    private Map parseBjXml(byte[] bytes) {
        org.dom4j.Document document = null;
        HashMap<String, String> result = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (DocumentException e) {
            throw new RuntimeException(this.getMessage("doc.read.xml.error", new Object[]{e.getLocalizedMessage()}));
        }
        if (document != null) {
            ArrayList<Map> features = new ArrayList<Map>();
            Element root = document.getRootElement();
            Node blName = root.selectSingleNode("DATA[@DATANAME='BL_PROJ_BUILD']").selectSingleNode("ROWDATA/ROW");
            Node blArea = root.selectSingleNode("DATA[@DATANAME='BL_BUILD_PROJ_LAND']").selectSingleNode("ROWDATA/ROW");
            if (blName instanceof Element) {
                result.put(BJ_TITLE, ((Element)blName).attributeValue(BJ_TAG.PROJ_NAME.name()));
            }
            if (blArea instanceof Element) {
                result.put(BJ_AREA, ((Element)blArea).attributeValue(BJ_TAG.SUM_TOT.name()));
            }
            Node blPlot = root.selectSingleNode("DATA[@DATANAME='BL_PLOT']");
            Node blPntCoords = root.selectSingleNode("DATA[@DATANAME='BL_PNT_COORD']");
            List rows = blPlot.selectNodes("ROWDATA/ROW");
            CoordinateReferenceSystem sourceCrs = null;
            for (Object item : rows) {
                if (!(item instanceof Element)) continue;
                Element row = (Element)item;
                String id = row.attributeValue(BJ_TAG.PL_ID.name());
                String name = row.attributeValue(BJ_TAG.PL_NAME.name());
                Map feature = this.getFeature(id, name, blPntCoords);
                if (sourceCrs == null) {
                    sourceCrs = (CoordinateReferenceSystem)feature.get("crs");
                }
                feature.remove("crs");
                features.add(feature);
            }
            result.put(BJ_FEATURE, this.toFeatureJSON((Object)this.list2FeatureCollection(features, sourceCrs, this.defaultCrs)));
            return result;
        }
        throw new RuntimeException(this.getMessage("bj.parse.error", new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    private Map getFeature(String id, String name, Node node) {
        HashMap<String, String> feature = new HashMap<String, String>();
        CoordinateReferenceSystem fearureCrs = null;
        feature.put(BJ_TAG.ID.name(), id);
        feature.put(BJ_TAG.NAME.name(), name);
        LinkedHashMap rings = new LinkedHashMap();
        List rows = node.selectNodes("ROWDATA/ROW[@PL_PL_ID='" + id + "']");
        ArrayList sortRows = new ArrayList();
        for (Object e : rows) {
            if (!(e instanceof Element)) continue;
            Element row = (Element)e;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(BJ_TAG.SHAPE_GROUP.name(), row.attributeValue(BJ_TAG.SHAPE_GROUP.name()));
            map.put(BJ_TAG.PNT_SERIAL.name(), row.attributeValue(BJ_TAG.PNT_SERIAL.name()));
            map.put(BJ_TAG.Y_COORD.name(), row.attributeValue(BJ_TAG.Y_COORD.name()));
            map.put(BJ_TAG.X_COORD.name(), row.attributeValue(BJ_TAG.X_COORD.name()));
            sortRows.add(map);
        }
        Collections.sort(sortRows, new /* Unavailable Anonymous Inner Class!! */);
        for (HashMap hashMap : sortRows) {
            String ringNo = String.valueOf(hashMap.get(BJ_TAG.SHAPE_GROUP.name()));
            double x = Double.valueOf((String)hashMap.get(BJ_TAG.Y_COORD.name()));
            double y = Double.valueOf((String)hashMap.get(BJ_TAG.X_COORD.name()));
            if (rings.containsKey(ringNo)) {
                ((List)rings.get(ringNo)).add(new Coordinate(x, y));
            } else {
                ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
                ring.add(new Coordinate(x, y));
                rings.put(ringNo, ring);
            }
            if (fearureCrs != null) continue;
            fearureCrs = this.getCrsByCoordXD(x);
        }
        LinearRing shell = null;
        Object var10_13 = null;
        Collection coords = rings.values();
        for (List coordinates : coords) {
            Coordinate first = (Coordinate)coordinates.get(0);
            Coordinate last = (Coordinate)coordinates.get(coordinates.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        try {
            void var10_14;
            for (List coordinates : coords) {
                if (shell == null) {
                    shell = this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0]));
                    continue;
                }
                if (var10_14 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var10_14.add(this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0])));
            }
            polygon = this.geometryFactory.createPolygon(shell, var10_14 != null ? var10_14.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bj.polygon.coords.error", new Object[]{name, e.getLocalizedMessage()}));
        }
        feature.put("SHAPE", polygon.toText());
        feature.put("crs", (String)fearureCrs);
        return feature;
    }

    private synchronized WKTReader getWktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTReader(this.geometryFactory);
        }
        return this.wktReader;
    }

    public void setRegionSet(Resource location) {
        try {
            Map values = (Map)JSON.parseObject((String)IOUtils.toString((URI)location.getURI()), Map.class);
            this.simplifyTolerance = Double.valueOf(String.valueOf(values.get("simplifyTolerance")));
            this.regionLayers = (Map)values.get(REGION_FIELD);
            this.regionSet = (Map)values.get(REGION_MAP);
            if (values.containsKey(DEFAULT_CRS)) {
                this.defaultCrs = this.parseUndefineSR(String.valueOf(values.get(DEFAULT_CRS)));
            }
            if (values.containsKey(COORDINATE_DM)) {
                this.coordinateDM = (Map)values.get(COORDINATE_DM);
                for (Map.Entry entry : this.coordinateDM.entrySet()) {
                    entry.setValue(this.parseUndefineSR((String)entry.getValue()));
                }
            }
        }
        catch (IOException e) {
            this.logger.error(" region set file not found ");
        }
    }
}

