package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.FileStore;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.FileStoreService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-3-28 上午9:06
 */
@Controller
@RequestMapping(value = "/file")
public class FileStoreController extends BaseController {

    @Autowired
    private FileStoreService fileStoreService;

    /**
     * 文件上传
     *
     * @param parentId
     * @param request
     * @return
     */
    @RequestMapping(value = "/upload/{parentId}", method = RequestMethod.POST)
    @ResponseBody
    public String upload(@PathVariable String parentId, HttpServletRequest request) {
        try {
            FileStore fs = fileStoreService.save(request, parentId);
            if (fs != null) return fs.getId();
            throw new RuntimeException("未获取上传数据");
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("file.upload.error", e.getLocalizedMessage()));
        }
    }

    /**
     * upload file ,parse by CommonsMultipartResolver
     *
     * @param parentId
     * @param request
     * @return
     */
    @RequestMapping(value = "/upload2/{parentId}", method = RequestMethod.POST)
    @ResponseBody
    public String upload2(@PathVariable String parentId, MultipartHttpServletRequest request) {
        try {
            FileStore fs = fileStoreService.save2(request, parentId);
            if (fs != null) return fs.getParentId();
            throw new RuntimeException("未获取上传数据");
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("file.upload.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 获取ids
     *
     * @param parentId
     * @return
     */
    @RequestMapping(value = "/ids/{parentId}")
    @ResponseBody
    public String[] ids(@PathVariable String parentId) {
        try {
            Assert.notNull(parentId, getMessage("file.parentId.notnull"));
            return fileStoreService.getFileIds(parentId);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("file.ids.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 文件下载
     *
     * @param id
     * @param response
     */
    @RequestMapping(value = "/download/{id}")
    public void download(@PathVariable String id, HttpServletResponse response) {
        try {
            Assert.notNull(id, getMessage("id.notnull"));
            File file = fileStoreService.getFile(id);
            sendFile(new FileInputStream(file), response,file.getName());
        } catch (IOException e) {
            throw new JSONMessageException(getMessage("file.download.error", id, e.getLocalizedMessage()));
        }
    }

    /**
     * 缩略图
     *
     * @param id
     * @param response
     * @throws IOException
     */
    @RequestMapping(value = "/thumb/{id}")
    public void thumb(@PathVariable String id, HttpServletResponse response) {
        try {
            Assert.notNull(id, getMessage("id.notnull"));
            sendFile(fileStoreService.getThumb(id), response);
        } catch (IOException e) {
            throw new JSONMessageException(getMessage("file.thumb.error", id, e.getLocalizedMessage()));
        }
    }

    /**
     * 删除文件
     *
     * @param id
     */
    @RequestMapping(value = "/delete/{id}")
    @ResponseBody
    public void delete(@PathVariable String id) {
        try {
            Assert.notNull(id, getMessage("id.notnull"));
            fileStoreService.delete(id);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("file.delete.error", id, e.getLocalizedMessage()));
        }

    }


}
