package cn.gtmap.onemap.platform.utils;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-1-22 上午9:21
 */
public final class FilesUtils {

    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_BMP = "bmp";
    public static final String IMAGE_GIF = "gif";
    public static final String IMAGE_TIF = "tif";

    static List<String> images = new ArrayList<String>();

    static {
        images.add(IMAGE_PNG);
        images.add(IMAGE_JPG);
        images.add(IMAGE_BMP);
        images.add(IMAGE_GIF);
        images.add(IMAGE_TIF);
    }

    /**
     * 判别文件是否为图片
     *
     * @param file
     * @return
     */
    public static final boolean isImage(File file) {
        Assert.notNull(file, "文件不可为空");
        String suffix = file.getPath().substring(file.getPath().lastIndexOf(".") + 1, file.getPath().length());
        if (StringUtils.isBlank(suffix)) return false;
        if (images.contains(suffix.toLowerCase())) return true;
        return false;
    }

    /**
     * 删除文件或者文件夹
     *
     * @param path
     * @return
     * @throws IOException
     */
    public static final boolean delFileOrDirectory(String path) throws IOException {
        boolean result = false;
        try {
            File file = new File(path);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; i++) {
                        files[i].delete();
                    }
                    result = file.delete();
                    return result;
                } else {
                    result = file.delete();
                    return result;
                }
            }
            return result;
        } catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /***
     * 由byte数组生成file
     * @param bytes
     * @param filePath   生成文件的文件目录
     * @param fileName   生成的文件名
     */
    public static void generateFile(byte[] bytes, String filePath, String fileName) {
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && !dir.isDirectory()) {//判断文件目录是否存在
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

}
