package cn.gtmap.onemap.platform.utils;

import org.apache.commons.lang.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 12-11-1 上午10:41
 */
public final class DateUtils {

    public static final String DEFAULT_TIME_FORMATE = "yyyy-MM-dd HH:mm:ss";

    /**
     * 当前年份
     *
     * @return
     */
    public static final String getCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return String.valueOf(calendar.get(Calendar.YEAR));
    }

    /**
     * 格式化当前时间
     *
     * @param formate yyyyMMdd HHmmss
     * @return
     */
    public static final String getCurrentTime(String formate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(StringUtils.isNotBlank(formate) ? formate : DEFAULT_TIME_FORMATE);
        return dateFormat.format(new Date());
    }
}
