package cn.gtmap.onemap.platform.dao;

import cn.gtmap.onemap.platform.entity.YGJC;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * User: Administrator
 * Date: 13-9-13  Time: 上午11:20
 * Version: v1.0
 */
public interface YGJCDao extends JpaRepository<YGJC,String> {


    List<YGJC> findByFwqbm(String fwqbm);

    List<YGJC> findByNfAndLx(String nf,String lx);
    @Query("select t from YGJC t order by t.lx")
    List<YGJC> getAllOrderByLX();

    @Query("select t.lx from YGJC t where t.fwqbm=?1 group by t.lx order by t.lx")
    List<String> getYgjcLxByFwqbm(String fwqbm);
    @Query("select t.nf from YGJC t where t.lx=?1 and t.fwqbm=?2 group by t.nf order by t.nf")
    List<String> getYgjcNf(String lx,String fwqbm);

    List<YGJC> findByLxAndFwqbm(String lx,String fwqbm);
    @Query("select sum(t.wjdx) from YGJC t where t.lx=?1")
    String getWjdxByLx(String lx);

    @Query("select sum(t.wjdx) from YGJC t where t.lx=?1 and t.nf=?2")
    String getWjdxByLxAndNf(String lx,String nf);
}
