package cn.gtmap.onemap.platform.dao;

import cn.gtmap.onemap.platform.entity.SJGL;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-07-09 上午9:05
 * @version: 1.0
 */
@SuppressWarnings("JpaQlInspection")
public interface SJGLDao extends JpaRepository<SJGL,String> {
    @Query(value = "select substr(t.xzdm,0,4) as xzdm, sum(cast(t.sjzs as long)) as sjzs from SJGL as t where t.nd = ?1 and t.ywlx = ?2 group by substr(t.xzdm,0,4) order by substr(t.xzdm,0,4) asc")
    List<Object> getSjzsByNdAndYwlx(String nd,String ywlx);

    @Query(value = "select substr(t.xzdm,0,4) as xzdm, sum(cast(t.sjzs as long)) as sjzs from SJGL as t where t.ywlx = ?1 group by substr(t.xzdm,0,4) order by substr(t.xzdm,0,4) asc")
    List<Object> getSjzsByYwlx(String ywlx);

    @Query(value = "select  sum(cast(t.sjzs as long)) from SJGL as t where t.nd = ?1 and t.ywlx = ?2")
    long getSumByNdAndYwlx(String nd,String ywlx);

    @Query(value = "select  sum(cast(t.sjzs as long)) from SJGL as t where  t.ywlx = ?1")
    long getSumByYwlx(String ywlx);

    @Query(value = "select count (distinct t.xzdm) from SJGL as t where t.nd = ?1 and t.ywlx = ?2")
    long getXzqByNdAndYwlx(String nd,String ywlx);

    @Query(value = "select count (distinct t.xzdm) from SJGL as t where t.ywlx = ?1")
    long getXzqByYwlx(String ywlx);

    @Query("select distinct t.ywlxmc from SJGL t where t.ywlx = ?1")
    String getYwlxmcByYwlx(String ywlx);

}
